/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.ui;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class WidgetFactory {
    public static final String COLOR_WHITE = "COLOR_WHITE";
    public static final String COLOR_GREEN = "COLOR_GREEN";
    public static final String COLOR_GREEN_LIGHT = "COLOR_GREEN_LIGHT";
    public static final String COLOR_RED = "COLOR_RED";
    public static final String COLOR_RED_LIGHT = "COLOR_RED_LIGHT";
    public static final String COLOR_YELLO = "COLOR_YELLO";
    public static final String COLOR_GRAY = "COLOR_GRAY";
    public static final String COLOR_BLACK = "COLOR_BLACK";
    public static final String FONT_8_NORMAL = "FONT_8_NORMAL";
    public static final String FONT_8_BOLD = "FONT_8_BOLD";
    public static final String FONT_9_NORMAL = "FONT_9_NORMAL";
    public static final String FONT_9_BOLD = "FONT_9_BOLD";
    public static final String FONT_10_NORMAL = "FONT_10_NORMAL";
    public static final String FONT_10_BOLD = "FONT_10_BOLD";
    public static final String FONT_9_UNDERLINE = "FONT_9_UNDERLINE";
    public static final String FONT_18_BOLD = "FONT_18_BOLD";
    public static final String FONT_36_BOLD = "FONT_36_BOLD";
    public static final String FONT_24_BOLD = "FONT_24_BOLD";
    public static final String FONT_24_NORMAL = "FONT_24_NORMAL";
    public static final String FONT_16_NORMAL = "FONT_16_NORMAL";
    public static FontRegistry font_registry = JFaceResources.getFontRegistry();
    public static ColorRegistry color_registry = JFaceResources.getColorRegistry();
    public static Cursor cursorWait = new Cursor((Device)Display.getDefault(), 1);
    public static Cursor cursorNormal = new Cursor((Device)Display.getDefault(), 0);
    private static FormToolkit toolkit;

    static {
        color_registry.put(COLOR_WHITE, Display.getDefault().getSystemColor(1).getRGB());
        color_registry.put(COLOR_BLACK, Display.getDefault().getSystemColor(2).getRGB());
        color_registry.put(COLOR_GRAY, Display.getDefault().getSystemColor(22).getRGB());
        color_registry.put(COLOR_RED, new Color((Device)Display.getDefault(), 255, 0, 0).getRGB());
        color_registry.put(COLOR_GREEN, new Color((Device)Display.getDefault(), 0, 200, 0).getRGB());
        color_registry.put(COLOR_RED_LIGHT, new Color((Device)Display.getDefault(), 255, 157, 157).getRGB());
        color_registry.put(COLOR_GREEN_LIGHT, new Color((Device)Display.getDefault(), 176, 255, 176).getRGB());
        color_registry.put(COLOR_YELLO, Display.getDefault().getSystemColor(7).getRGB());
        font_registry.put(FONT_8_NORMAL, new Font((Device)Display.getDefault(), "Arial", 8, 0).getFontData());
        font_registry.put(FONT_8_BOLD, new Font((Device)Display.getDefault(), "Arial", 8, 1).getFontData());
        font_registry.put(FONT_9_NORMAL, new Font((Device)Display.getDefault(), "Arial", 9, 0).getFontData());
        font_registry.put(FONT_9_BOLD, new Font((Device)Display.getDefault(), "Arial", 9, 1).getFontData());
        font_registry.put(FONT_10_NORMAL, new Font((Device)Display.getDefault(), "Arial", 10, 0).getFontData());
        font_registry.put(FONT_10_BOLD, new Font((Device)Display.getDefault(), "Arial", 10, 1).getFontData());
        font_registry.put(FONT_18_BOLD, new Font((Device)Display.getDefault(), "Arial", 18, 1).getFontData());
        font_registry.put(FONT_36_BOLD, new Font((Device)Display.getDefault(), "serif", 36, 0).getFontData());
        font_registry.put(FONT_24_BOLD, new Font((Device)Display.getDefault(), "Arial Rounded MT Bold", 24, 1).getFontData());
        font_registry.put(FONT_24_NORMAL, new Font((Device)Display.getDefault(), "serif", 24, 0).getFontData());
        font_registry.put(FONT_16_NORMAL, new Font((Device)Display.getDefault(), "Arial Rounded MT Bold", 16, 0).getFontData());
        font_registry.put(FONT_9_UNDERLINE, new Font((Device)Display.getDefault(), "Arial", 9, 1).getFontData());
    }

    public static void setFormToolkit(FormToolkit toolkit, ScrolledForm form) {
        WidgetFactory.toolkit = toolkit;
        toolkit.paintBordersFor(form.getBody());
        toolkit.setBackground(Display.getDefault().getSystemColor(22));
        toolkit.setBorderStyle(2048);
    }

    public static TabFolder buildBasicTabFolder(Composite parent) {
        return new TabFolder(parent, 0x800800);
    }

    public static Table buildTable(Composite parent, int style) {
        Table table = toolkit.createTable(parent, style);
        return table;
    }

    public static Composite createComposite(Composite parent) {
        return toolkit.createComposite(parent);
    }

    public static Composite createComposite(Composite parent, int style) {
        return toolkit.createComposite(parent, style);
    }

    public static Text createText(Composite parent) {
        Text txt = toolkit.createText(parent, "", 0);
        txt.setBackground(color_registry.get(COLOR_WHITE));
        return txt;
    }

    public static FormText createFormText(Composite contents) {
        FormText txt = new FormText(contents, 524288);
        txt.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    e.doit = false;
                } else if (e.detail == 8) {
                    e.doit = false;
                }
            }
        });
        if (toolkit != null) {
            toolkit.adapt(contents);
        }
        return txt;
    }

    public static Button createButton(Composite parent, String text, int style) {
        return toolkit.createButton(parent, text, style);
    }

    public static void adapt(Composite parent, String color_name) {
        Composite composite = parent;
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setBackground(color_registry.get(color_name));
            ++n2;
        }
    }

    public static void adapt(Composite composite) {
        toolkit.paintBordersFor(composite);
        toolkit.adapt(composite);
    }

    public static void adapt(Control parent, Color color) {
        if (parent != null) {
            Control[] c;
            parent.setBackground(color);
            if (parent instanceof Composite && (c = ((Composite)parent).getChildren()) != null && c.length > 0) {
                Control[] controlArray = c;
                int n = c.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    WidgetFactory.adapt(child, color);
                    ++n2;
                }
            }
        }
    }
}

