/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.transfers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.WatchlistItem;

public class WatchlistItemTransfer
extends ByteArrayTransfer {
    private static final String TYPENAME = WatchlistItem.class.getName();
    private static final int TYPEID = WatchlistItemTransfer.registerType((String)TYPENAME);
    private static WatchlistItemTransfer _instance = new WatchlistItemTransfer();

    private WatchlistItemTransfer() {
    }

    public static WatchlistItemTransfer getInstance() {
        return _instance;
    }

    protected String[] getTypeNames() {
        return new String[]{TYPENAME};
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (!this.checkMyType(object) || !this.isSupportedType(transferData)) {
            DND.error((int)2003);
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream writeOut = new ObjectOutputStream(out);
            if (object instanceof WatchlistItem) {
                writeOut.writeInt(1);
                writeOut.writeObject(((WatchlistItem)object).getSecurity().getId());
                writeOut.writeObject(((WatchlistItem)object).getPosition());
                writeOut.writeObject(((WatchlistItem)object).getPurchasePrice());
            } else if (object instanceof WatchlistItem[]) {
                WatchlistItem[] array = (WatchlistItem[])object;
                writeOut.writeInt(array.length);
                int i = 0;
                while (i < array.length) {
                    writeOut.writeObject(array[i].getSecurity().getId());
                    writeOut.writeObject(array[i].getPosition());
                    writeOut.writeObject(array[i].getPurchasePrice());
                    ++i;
                }
            }
            byte[] buffer = out.toByteArray();
            writeOut.close();
            super.javaToNative((Object)buffer, transferData);
        }
        catch (IOException e) {
            CorePlugin.logException(e);
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            byte[] buffer = (byte[])super.nativeToJava(transferData);
            if (buffer == null) {
                return null;
            }
            ByteArrayInputStream in = new ByteArrayInputStream(buffer);
            ObjectInputStream readIn = new ObjectInputStream(in);
            int length = 0;
            try {
                length = readIn.readInt();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            try {
                WatchlistItem[] items = new WatchlistItem[length];
                int i = 0;
                while (i < length) {
                    items[i] = new WatchlistItem();
                    items[i].setSecurity((Security)CorePlugin.getRepository().load(Security.class, (String)readIn.readObject()));
                    items[i].setPosition((Integer)readIn.readObject());
                    items[i].setPaidPrice((Double)readIn.readObject());
                    ++i;
                }
                readIn.close();
                return items;
            }
            catch (Exception e) {
                CorePlugin.logException(e);
            }
        }
        return null;
    }

    private boolean checkMyType(Object object) {
        return object instanceof WatchlistItem || object instanceof WatchlistItem[];
    }
}

