/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.link;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import pk.com.softech.tradingterminal.core.util.FIFOQueue;
import pk.com.softech.util.Utility;

public class UDPLink
implements Runnable {
    private static final int RECEIVE_MSG_SIZE = 300;
    private DatagramSocket socket;
    private DatagramPacket packetReceived;
    private Thread thrd;
    private boolean readFlag = true;
    private FIFOQueue queue;
    private String host = "";
    private int hostPort = -1;
    private int clientPort = Utility.clientPort;

    public UDPLink(FIFOQueue q, String host, int port) {
        this.queue = q;
        this.host = host;
        this.hostPort = port;
        try {
            this.socket = new DatagramSocket(this.clientPort);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        this.startFeed();
        this.thrd = new Thread(this);
        this.thrd.start();
    }

    public void startFeed() {
        String sendMsg = "ABC";
        try {
            this.socket.send(new DatagramPacket(sendMsg.getBytes(), sendMsg.length(), InetAddress.getByName(this.host), this.hostPort));
            System.out.println("UDP - First Packet Sent");
        }
        catch (SocketException ex) {
            System.err.println(ex);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Override
    public void run() {
        try {
            while (this.readFlag) {
                this.packetReceived = new DatagramPacket(new byte[300], 300);
                this.socket.receive(this.packetReceived);
                this.queue.add(new String(this.packetReceived.getData()));
            }
        }
        catch (Exception exception) {
            this.stopUDPThread();
            this.closeUDPLink();
        }
    }

    public void closeUDPLink() {
        try {
            this.socket.close();
            System.out.println("UDP Feed Link Closed");
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public void stopUDPThread() {
        this.readFlag = false;
    }
}

