/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.link;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pk.com.softech.messages.FeedData;
import pk.com.softech.parser.FeedParser;
import pk.com.softech.parser.Parser;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.util.FIFOQueue;

public class UDPFeedLink
implements Runnable {
    private static final long RECONNECT_INTERVAL = 60000L;
    private static final int MAX_FEED_MSG_SIZE = 9999;
    private Log log = LogFactory.getLog(this.getClass());
    private DatagramSocket feedSocket = null;
    private FIFOQueue queue = null;
    private String port = null;
    private boolean bConnected = false;
    private boolean reconnect = true;
    private Parser parser = null;

    public UDPFeedLink(FIFOQueue q, String p, Parser pr) {
        this.queue = q;
        this.port = p;
        this.parser = pr;
        this.connect();
        new Thread(this).start();
    }

    @Override
    public void run() {
        if (!this.isConnected() && this.doReconnect()) {
            this.keepConnecting();
        }
        DatagramPacket packet = null;
        while (this.isConnected()) {
            byte[] msg = new byte[9999];
            packet = new DatagramPacket(msg, msg.length);
            try {
                if (this.feedSocket == null) continue;
                this.feedSocket.receive(packet);
                String msgStr = new String(packet.getData());
                msgStr = msgStr.trim();
                FeedData[] feedData = ((FeedParser)this.parser).parseAllFeed(msgStr);
                if (feedData != null) {
                    this.log.trace((Object)("Local feed rec : " + msgStr));
                    int i = 0;
                    while (i < feedData.length) {
                        this.queue.add(feedData[i]);
                        ++i;
                    }
                }
                msgStr = null;
                packet.setData(msg, 0, 9999);
            }
            catch (Exception ex) {
                this.log.error((Object)"", (Throwable)ex);
                ex.printStackTrace();
                if (!this.doReconnect()) continue;
                this.stopUDPFeedThread();
                this.closeUDPFeedLink(true);
                this.keepConnecting();
            }
        }
        if (this.queue != null && this.queue.size() > 1024) {
            this.queue.clear();
            this.log.info((Object)"Discarding unsent feed from local ports");
        }
    }

    private synchronized void keepConnecting() {
        while (!this.isConnected()) {
            try {
                Thread.sleep(60000L);
                this.connect();
            }
            catch (Exception exception) {}
        }
    }

    private void connect() {
        if (Resources.tcpLink) {
            this.initFeedLink(Integer.parseInt(this.port));
        }
    }

    protected boolean initFeedLink(int port) {
        try {
            this.feedSocket = new DatagramSocket(port);
            this.setConnected(true);
            Resources.udpLinkConnected = true;
            this.updateStatus(true);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.updateStatus(false);
            return false;
        }
    }

    public void closeUDPFeedLink(boolean rec) {
        try {
            this.closeUDPSocket();
            this.setReconnect(rec);
            this.updateStatus(false);
        }
        catch (Exception exception) {}
    }

    private void closeUDPSocket() {
        try {
            this.feedSocket.close();
            this.feedSocket = null;
        }
        catch (Exception exception) {}
    }

    public void stopUDPFeedThread() {
        this.setConnected(false);
    }

    private void updateStatus(boolean connected) {
        if (connected) {
            this.log.info((Object)("UDP Feed Link Established at port " + this.port));
            CorePlugin.updateStausBar("FS", "Local Feed Connected");
        } else {
            this.log.info((Object)("UDP Feed Link NOT Established at port " + this.port));
            CorePlugin.updateStausBar("FS", "Local Feed Not Connected");
        }
    }

    private void setConnected(boolean connected) {
        this.bConnected = connected;
    }

    public boolean isConnected() {
        return this.bConnected;
    }

    private void setReconnect(boolean rec) {
        this.reconnect = rec;
    }

    private boolean doReconnect() {
        return this.reconnect;
    }
}

