/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.link;

import java.net.Socket;
import java.util.Random;
import pk.com.softech.messages.LoginMessage;
import pk.com.softech.messages.PingMessage;
import pk.com.softech.messages.SupportServerData;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.io.InStream;
import pk.com.softech.tradingterminal.core.io.MessageInputStream;
import pk.com.softech.tradingterminal.core.io.MessageOutputStream;
import pk.com.softech.tradingterminal.core.io.OutStream;
import pk.com.softech.tradingterminal.core.util.FIFOQueue;
import pk.com.softech.util.Utility;

public class TCPSupportLink
implements Runnable {
    private static final long RECONNECT_INTERVAL = 60000L;
    private static final int MAX_FEED_MSG_SIZE = 65536;
    private static final int PING_INTERVAL = 10000;
    private static final String STREAM_DELIMITER = "<END>";
    private static final String FEED_MSG_DELIMITER = "END_MESSEGE,";
    private Socket clientSocket = null;
    private FIFOQueue queue = null;
    private InStream inStream = null;
    private OutStream outStream = null;
    private String linkName = null;
    private String host = null;
    private String port = null;
    private boolean bConnected = false;
    private boolean reconnect = true;
    private boolean changeIP = false;

    public TCPSupportLink(String linkName, FIFOQueue q, String h, String p) {
        this.linkName = linkName;
        this.queue = q;
        this.host = h;
        this.port = p;
        this.connect();
        new Thread(this).start();
    }

    @Override
    public void run() {
        if (!this.isConnected() && this.doReconnect()) {
            this.keepConnecting();
        }
        while (this.isConnected()) {
            try {
                Object obj = this.inStream.readObject();
                this.queue.add(obj);
            }
            catch (Exception ex) {
                System.out.println(String.valueOf(this.linkName) + " disconnected " + ex.getMessage());
                if (!this.doReconnect()) continue;
                this.stopTCPFeedThread();
                this.closeTCPFeedLink(true);
                this.sendLogoffMessage();
                if (!Resources.loginStatus) continue;
                this.keepConnecting();
            }
        }
    }

    private synchronized void keepConnecting() {
        while (!this.isConnected()) {
            try {
                Thread.sleep(60000L);
                this.connect();
            }
            catch (Exception exception) {}
        }
    }

    private void connect() {
        if (Resources.tcpLink) {
            String[] hosts = Utility.getTokens(this.host, ",");
            String[] ports = Utility.getTokens(this.port, ",");
            boolean connectStatus = false;
            Random random = new Random();
            int i = 0;
            while (i < hosts.length) {
                int portIndex = random.nextInt(ports.length);
                this.changeIP = false;
                int j = 0;
                while (j < ports.length) {
                    connectStatus = this.initSupportLink(hosts[i], Integer.parseInt(ports[portIndex]));
                    if (connectStatus) {
                        this.sendLoginMessage();
                    }
                    if (connectStatus || this.changeIP) break;
                    if (++portIndex == ports.length) {
                        portIndex = 0;
                    }
                    ++j;
                }
                if (connectStatus) {
                    System.out.println("Support Link connected.");
                    break;
                }
                ++i;
            }
        }
    }

    protected boolean initSupportLink(String host, int port) {
        try {
            this.clientSocket = new Socket(host, port);
            this.outStream = new MessageOutputStream(this.clientSocket.getOutputStream());
            this.inStream = new MessageInputStream(this.clientSocket.getInputStream());
            new PingThread().start();
            this.setConnected(true);
            System.out.println(String.valueOf(this.linkName) + " Established with host " + host + " and at port " + port);
            return true;
        }
        catch (Exception ex) {
            System.out.println(String.valueOf(this.linkName) + " not established with host " + host + " and at port " + port);
            System.out.println("Exception : " + ex.getMessage());
            if (ex.getMessage().indexOf("Connection timed out") != -1) {
                this.changeIP = true;
            }
            return false;
        }
    }

    public void closeTCPFeedLink(boolean rec) {
        try {
            this.inStream.close();
            this.outStream.close();
            this.clientSocket.close();
            this.setReconnect(rec);
            System.out.println(String.valueOf(this.linkName) + " Closed");
        }
        catch (Exception exception) {}
    }

    public void closeTCPSocket() {
        try {
            this.clientSocket.close();
        }
        catch (Exception exception) {}
    }

    public void stopTCPFeedThread() {
        this.setConnected(false);
    }

    private void setConnected(boolean connected) {
        this.bConnected = connected;
    }

    public boolean isConnected() {
        return this.bConnected;
    }

    private void setReconnect(boolean rec) {
        this.reconnect = rec;
    }

    private boolean doReconnect() {
        return this.reconnect;
    }

    private void ping() throws Exception {
        this.outStream.write("ping".getBytes(), 0, 4);
    }

    public void sleepPing() {
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {}
    }

    public void sendLogoffMessage() {
        SupportServerData data = new SupportServerData(SupportServerData.CALL_TERMINATION, "", "", "");
        this.queue.add(data);
    }

    public void sendLoginMessage() {
        LoginMessage login = new LoginMessage(Resources.userId, "", "", -1, true, LoginMessage.ECLIPSE_TERMINAL);
        login.setEclipseVersion(Resources.eclipseVersion);
        this.writeData(login);
    }

    public boolean writeData(Object obj) {
        boolean bValue = false;
        if (this.bConnected) {
            try {
                this.outStream.writeObject(obj);
                this.outStream.flush();
                bValue = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                bValue = false;
            }
        }
        return bValue;
    }

    public class PingThread
    extends Thread {
        @Override
        public void run() {
            while (TCPSupportLink.this.isConnected()) {
                try {
                    TCPSupportLink.this.sleepPing();
                    TCPSupportLink.this.writeData(new PingMessage());
                }
                catch (Exception exception) {}
            }
        }
    }
}

