/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.link;

import com.sun.net.ssl.internal.ssl.Provider;
import java.security.Security;
import java.util.Random;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import pk.com.softech.messages.LoginMessage;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;
import pk.com.softech.tradingterminal.core.io.InStream;
import pk.com.softech.tradingterminal.core.io.MessageInputStream;
import pk.com.softech.tradingterminal.core.io.MessageOutputStream;
import pk.com.softech.tradingterminal.core.io.OutStream;
import pk.com.softech.tradingterminal.core.link.PingThread;
import pk.com.softech.tradingterminal.core.util.FIFOQueue;

public class TCPLink
implements Runnable {
    private static final long RECONNECT_INTERVAL = 7500L;
    private static final String STREAM_DELIMITER = "<END>";
    private static final String[] ENABLED_CIPHER_SUITES = new String[]{"SSL_DH_anon_WITH_RC4_128_MD5"};
    private InStream inStream = null;
    private OutStream outStream = null;
    private SSLSocket clientSocket = null;
    private SSLSocketFactory socketFactory = null;
    private FIFOQueue queue = null;
    private String host = null;
    private String port = null;
    private boolean objectStream = false;
    private boolean bConnected = false;
    private boolean changeIP = false;
    public static boolean alredyConnected = false;
    private String name = "MS Link";

    public TCPLink(FIFOQueue q) {
        this.queue = q;
        System.setProperty("javax.net.ssl.trustStore", String.valueOf(Platform.getLocation().toPortableString()) + "/config/client.keystore");
        System.setProperty("javax.net.ssl.keyStore", String.valueOf(Platform.getLocation().toPortableString()) + "/config/client.keystore");
        System.setProperty("javax.net.ssl.keyStorePassword", "kamran");
        Security.addProvider((java.security.Provider)new Provider());
        this.socketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    public boolean initTcpLink(String host, String port) {
        this.host = host;
        this.port = port;
        this.connect();
        if (this.bConnected) {
            new Thread(this).start();
            new PingThread(this).start();
        }
        return this.bConnected;
    }

    private boolean initLink(String host, int port) {
        try {
            this.clientSocket = (SSLSocket)this.socketFactory.createSocket(host, port);
            this.outStream = new MessageOutputStream(this.clientSocket.getOutputStream());
            this.inStream = new MessageInputStream(this.clientSocket.getInputStream());
            this.bConnected = true;
            System.out.println("MS Link Established with host " + host + " and at Port " + port);
            Resources.tcpLink = true;
            this.objectStream = true;
            return true;
        }
        catch (Exception ex) {
            System.out.println("MS Link not established with host " + host + " and at Port " + port);
            System.out.println("Exception : " + ex.getMessage());
            if (ex.getMessage().indexOf("Connection timed out") != -1) {
                this.changeIP = true;
            }
            return false;
        }
    }

    private void connect() {
        String[] hosts = Utility.getTokens(this.host, ",");
        String[] ports = Utility.getTokens(this.port, ",");
        Random random = new Random();
        int portIndex = random.nextInt(ports.length);
        int i = 0;
        while (i < hosts.length) {
            int j = 0;
            while (j < ports.length) {
                this.changeIP = false;
                try {
                    if (alredyConnected) {
                        return;
                    }
                    if (this.initLink(hosts[i], Integer.parseInt(ports[portIndex])) || this.changeIP) {
                        break;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                if (++portIndex == ports.length) {
                    portIndex = 0;
                }
                ++j;
            }
            if (this.bConnected) break;
            ++i;
        }
    }

    @Override
    public void run() {
        while (this.bConnected) {
            try {
                Object obj = this.inStream.readObject();
                this.queue.add(obj);
            }
            catch (Exception exception) {
                this.stopTCPThread();
                this.closeTCPLink();
                try {
                    IPreferenceStore prefs = CorePlugin.getDefault().getPreferenceStore();
                    prefs.setValue(CorePlugin.USER_STATUS, false);
                }
                catch (Exception exception2) {}
                if (Resources.loginStatus || Resources.logoutStatus) continue;
                this.keepConnecting();
                LoginMessage login = new LoginMessage(Resources.userId, Resources.password, "", -1, true, LoginMessage.ECLIPSE_TERMINAL);
                login.setEclipseVersion(Resources.eclipseVersion);
                Resources.isReconnecting = Boolean.TRUE;
                Resources.tradeLink.writeData(login);
            }
        }
    }

    private void keepConnecting() {
        while (!this.bConnected) {
            try {
                Thread.sleep(7500L);
                this.connect();
            }
            catch (Exception exception) {}
        }
    }

    public boolean writeData(Object obj) {
        boolean bValue = false;
        if (this.bConnected) {
            try {
                this.outStream.writeObject(obj);
                this.outStream.flush();
                bValue = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                bValue = false;
            }
        }
        return bValue;
    }

    public void closeTCPLink() {
        try {
            this.outStream.close();
        }
        catch (Exception exception) {}
        try {
            this.inStream.close();
        }
        catch (Exception exception) {}
        try {
            this.clientSocket.close();
        }
        catch (Exception exception) {}
        try {
            Resources.tcpLink = false;
            Resources.loginStatus = false;
            alredyConnected = false;
        }
        catch (Exception exception) {}
    }

    public String toString() {
        return "TCPLink : " + this.name;
    }

    public void stopTCPThread() {
        this.bConnected = false;
    }

    public boolean isConnected() {
        return this.bConnected;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

