/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.link;

import java.io.IOException;
import java.net.Socket;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;
import pk.com.softech.tradingterminal.core.io.DelimitedInputStream;
import pk.com.softech.tradingterminal.core.io.DelimitedOutputStream;
import pk.com.softech.tradingterminal.core.io.MessageOutputStream;
import pk.com.softech.tradingterminal.core.io.OutStream;
import pk.com.softech.tradingterminal.core.util.FIFOQueue;
import pk.com.softech.util.Zipper;

public class TCPFeedLink
implements Runnable {
    private static final long RECONNECT_INTERVAL = 7000L;
    private static final int MAX_FEED_MSG_SIZE = 65536;
    private static final int PING_INTERVAL = 10000;
    private static final String STREAM_DELIMITER = "<END>";
    private static final String FEED_MSG_DELIMITER = "END_MESSEGE,";
    public static final int LINK_FEED = 0;
    public static final int LINK_LEVEL2 = 1;
    public static final String FEED_LOGIN_IDENTIFIER = "FLGN";
    public static final String MBO_FEED_IDENTIFIER = "MBO";
    public static final String MBP_FEED_IDENTIFIER = "MBP";
    public static final char BAR = '|';
    public static final char COMMA = ',';
    public static final String DELIMITER = "<END>";
    private OutStream outObjectStream = null;
    public static final String SPLITTER_COLON_IDENTIFIER = ":";
    public static final String SYMBOL_SUBSCRIBE_IDENTIFIER = "SUB";
    public static final String SYMBOL_UNSUBSCRIBE_IDENTIFIER = "UNSUB";
    private Socket feedSocket = null;
    private int linkType = 0;
    private FIFOQueue queue = null;
    private DelimitedInputStream inStream = null;
    private DelimitedOutputStream outStream = null;
    private String host = null;
    private String port = null;
    private String cHost = "";
    private int cPort = 0;
    private boolean bConnected = false;
    private boolean reconnect = true;
    private Log log = LogFactory.getLog(this.getClass());

    public TCPFeedLink(FIFOQueue q, String h, String p, int linkType) {
        this.queue = q;
        this.host = h;
        this.port = p;
        this.linkType = linkType;
        this.connect();
        new Thread(this).start();
    }

    @Override
    public void run() {
        if (!this.isConnected() && this.doReconnect()) {
            this.keepConnecting();
        }
        int actualSize = -1;
        while (this.isConnected()) {
            byte[] feedBuffer = new byte[65536];
            try {
                actualSize = this.inStream.read(feedBuffer, 0, 65536);
                feedBuffer = Zipper.unzip(feedBuffer, 0, actualSize);
                CorePlugin.updateStausBar("FS", "Feed Connected");
                this.parseFeedMessage(new String(feedBuffer));
                if (this.queue == null || this.queue.size() <= 1024) continue;
                this.queue.clear();
                this.log.debug((Object)("Discarding unsent " + (this.linkType == 0 ? " Feed" : "Level 2 Feed")));
            }
            catch (Exception ex) {
                this.log.error((Object)("Exception in Feed Connection : " + ex));
                if (!this.doReconnect()) continue;
                this.stopTCPFeedThread();
                this.closeTCPFeedLink(true);
                this.keepConnecting();
            }
        }
    }

    private void parseFeedMessage(String feedStr) {
        int offset = 0;
        int index = feedStr.indexOf(FEED_MSG_DELIMITER, offset);
        while (index >= 0) {
            this.queue.add(feedStr.substring(offset, index));
            offset = index + FEED_MSG_DELIMITER.length();
            index = feedStr.indexOf(FEED_MSG_DELIMITER, offset);
        }
    }

    private synchronized void keepConnecting() {
        while (!this.isConnected()) {
            try {
                Thread.sleep(7000L);
                this.connect();
            }
            catch (Exception exception) {
                this.log.error((Object)"Keep Connecting Exception");
            }
        }
    }

    private void connect() {
        if (Resources.tcpLink) {
            String[] hosts = Utility.getTokens(this.host, ",");
            String[] ports = Utility.getTokens(this.port, ",");
            boolean connectStatus = false;
            Random random = new Random();
            int i = 0;
            while (i < hosts.length) {
                int portIndex = random.nextInt(ports.length);
                int j = 0;
                while (j < ports.length) {
                    connectStatus = this.initFeedLink(hosts[i], Integer.parseInt(ports[portIndex]));
                    this.updateStatus();
                    if (connectStatus) break;
                    if (++portIndex == ports.length) {
                        portIndex = 0;
                    }
                    ++j;
                }
                if (connectStatus) break;
                ++i;
            }
        }
    }

    protected boolean initFeedLink(String host, int port) {
        try {
            this.cHost = host;
            this.cPort = port;
            this.feedSocket = new Socket(host, port);
            this.inStream = new DelimitedInputStream();
            this.inStream.setInputStream(this.feedSocket.getInputStream());
            this.inStream.setDelimiter("<END>");
            this.outStream = new DelimitedOutputStream();
            this.outStream.setOutputStream(this.feedSocket.getOutputStream());
            this.outStream.setDelimiter("<END>");
            if (Resources.isProfilingEnabled) {
                this.outObjectStream = new MessageOutputStream(this.feedSocket.getOutputStream());
            }
            new PingThread().start();
            this.setConnected(true);
            return true;
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception : " + ex.getMessage()));
            return false;
        }
    }

    public void closeTCPFeedLink(boolean rec) {
        try {
            this.closeTCPSocket();
            this.setReconnect(rec);
            this.updateStatus();
        }
        catch (Exception exception) {}
    }

    private void closeTCPSocket() {
        try {
            if (this.outStream != null) {
                this.outStream.flush();
                this.outStream.close();
            }
        }
        catch (Exception exception) {}
        try {
            this.inStream.close();
        }
        catch (Exception exception) {}
        try {
            this.outStream.close();
        }
        catch (Exception exception) {}
        try {
            this.feedSocket.shutdownOutput();
        }
        catch (Exception exception) {}
        try {
            this.feedSocket.close();
        }
        catch (Exception exception) {}
    }

    private void updateStatus() {
        if (this.bConnected) {
            if (this.linkType == 0) {
                this.log.info((Object)("Feed Link Established with host " + this.cHost + " and at port " + this.cPort));
                CorePlugin.updateStausBar("FS", "Feed Connected");
                if (Resources.isProfilingEnabled) {
                    this.subscribeAll();
                }
            } else if (this.linkType == 1) {
                this.log.info((Object)("Level2Feed Link Established with host " + this.cHost + " and at port " + this.cPort));
                CorePlugin.updateStausBar("SFS", "Level2Feed Connected");
                this.sendLoginMessage();
            }
        } else if (this.linkType == 0) {
            this.log.info((Object)("Feed Link not established with host " + this.cHost + " and at port " + this.cPort));
            CorePlugin.updateStausBar("FS", "Connecting Feed ...");
        } else if (this.linkType == 1) {
            CorePlugin.updateStausBar("SFS", "Connecting Level2Feed...");
        }
    }

    public void stopTCPFeedThread() {
        this.setConnected(false);
    }

    private void setConnected(boolean connected) {
        this.bConnected = connected;
    }

    public boolean isConnected() {
        return this.bConnected;
    }

    public boolean isFeedConnected() {
        if (!(this.bConnected && this.feedSocket != null && this.feedSocket.isConnected() && this.feedSocket.isBound())) {
            return false;
        }
        return this.bConnected;
    }

    private void setReconnect(boolean rec) {
        this.reconnect = rec;
    }

    private boolean doReconnect() {
        return this.reconnect;
    }

    private void ping() throws Exception {
        this.outStream.write("ping".getBytes(), 0, 4);
    }

    public void subscribeSymbol(Set<String> profilingSet) {
        if (this.bConnected) {
            StringBuffer req = new StringBuffer("SUB:");
            for (String symbols : profilingSet) {
                req.append(String.valueOf(symbols) + '|');
            }
            req.append("<END>");
            this.sendMessage(req.toString());
            this.log.info((Object)("Feed Subscribed for " + req.toString()));
        }
    }

    public void subscribeSymbol(String subscribe) {
        StringBuffer req = new StringBuffer("SUB:");
        req.append(String.valueOf(subscribe) + '|');
        req.append("<END>");
        System.out.println("Subscription Request : " + req.toString());
        this.sendMessage(req.toString());
        this.log.info((Object)("Feed Subscribed for " + req.toString()));
    }

    public void unSubscribeSymbol(String ubsubscribe) {
        StringBuffer req = new StringBuffer("UNSUB:");
        req.append(String.valueOf(ubsubscribe) + '|');
        req.append("<END>");
        System.out.println("UnSubscription Request : " + req.toString());
        this.sendMessage(req.toString());
        this.log.info((Object)("Feed Subscribed for " + req.toString()));
    }

    public void subscribeAll() {
        if (!Resources.profilingSet.isEmpty()) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    TCPFeedLink.this.subscribeSymbol(Resources.profilingSet);
                }
            }, 1000L);
        }
    }

    public boolean writeData(Object obj) {
        boolean bValue = false;
        if (this.bConnected) {
            try {
                if (this.outObjectStream != null) {
                    this.outObjectStream.writeObject(obj);
                    this.outObjectStream.flush();
                    bValue = true;
                } else {
                    this.log.info((Object)"May Be Profiling Not Enabled");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                bValue = false;
            }
        }
        return bValue;
    }

    public void sendLoginMessage() {
        String message = "FLGN|" + Resources.userId + '|' + "<END>";
        this.sendMessage(message);
    }

    public void sendSubLevel2FeedServerMBOReq(String exchange, String market, String symbol) {
        String mboMsg = "MBO|" + exchange + ',' + market + ',' + symbol + '|' + "<END>";
        this.sendMessage(mboMsg);
    }

    public void sendSubLevel2FeedServerMBPReq(String exchange, String market, String symbol) {
        String mbpMsg = "MBP|" + exchange + ',' + market + ',' + symbol + '|' + "<END>";
        this.sendMessage(mbpMsg);
    }

    public void sendMessage(String message) {
        if (this.bConnected) {
            try {
                this.outStream.write(message.getBytes(), 0, message.length());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public class PingThread
    extends Thread {
        private boolean pingConnect = true;

        @Override
        public void run() {
            while (this.pingConnect) {
                try {
                    PingThread.sleep(10000L);
                    TCPFeedLink.this.ping();
                }
                catch (Exception exception) {
                    TCPFeedLink.this.closeTCPSocket();
                    this.pingConnect = false;
                }
            }
        }
    }
}

