/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.link;

import java.io.IOException;
import java.net.Socket;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;
import pk.com.softech.tradingterminal.core.io.DelimitedInputStream;
import pk.com.softech.tradingterminal.core.io.DelimitedOutputStream;
import pk.com.softech.tradingterminal.core.io.OutStream;
import pk.com.softech.tradingterminal.core.util.FIFOQueue;
import pk.com.softech.util.Zipper;

public class TCPFeedLevel2Link
implements Runnable {
    private static final long RECONNECT_INTERVAL = 7000L;
    private static final int MAX_FEED_MSG_SIZE = 65536;
    private static final int PING_INTERVAL = 5000;
    private static final String STREAM_DELIMITER = "<END>";
    private static final String FEED_MSG_DELIMITER = "END_MESSEGE,";
    public static final int LINK_FEED = 0;
    public static final int LINK_LEVEL2 = 1;
    public static final String FEED_LOGIN_IDENTIFIER = "FLGN";
    public static final String MBO_FEED_IDENTIFIER = "MBO";
    public static final String MBP_FEED_IDENTIFIER = "MBP";
    public static final char BAR = '|';
    public static final char COMMA = ',';
    public static final String DELIMITER = "<END>";
    private OutStream outObjectStream = null;
    public static final String SPLITTER_COLON_IDENTIFIER = ":";
    public static final String SYMBOL_SUBSCRIBE_IDENTIFIER = "SUB";
    public static final String SYMBOL_UNSUBSCRIBE_IDENTIFIER = "UNSUB";
    private Socket feedSocket = null;
    private int linkType = 0;
    private FIFOQueue queue = null;
    private DelimitedInputStream inStream = null;
    private DelimitedOutputStream outStream = null;
    private String host = null;
    private String port = null;
    private String cHost = "";
    private int cPort = 0;
    public boolean isSendMBOMBPRequest = false;
    public boolean isSocketEstablished = false;
    public String curentMBOMBPRequestMsg = "";
    private boolean bConnected = false;
    private boolean reconnect = true;
    private boolean parseThread = true;
    private Thread feedParseThread = null;
    private Log log = LogFactory.getLog(this.getClass());
    private boolean pingConnect = true;

    public TCPFeedLevel2Link(FIFOQueue q, String h, String p, int linkType) {
        this.queue = q;
        this.host = h;
        this.port = p;
        this.linkType = linkType;
        this.connect();
        new Thread(this).start();
    }

    @Override
    public void run() {
        if (!this.isConnected() && this.doReconnect()) {
            this.keepConnecting();
        }
    }

    private void parseFeedMessage(String feedStr) {
        int offset = 0;
        int index = feedStr.indexOf(FEED_MSG_DELIMITER, offset);
        if (this.isSendMBOMBPRequest && !this.isSocketEstablished) {
            this.isSocketEstablished = true;
            this.isSendMBOMBPRequest = false;
            this.log.info((Object)"Terminate Socket Recreate");
            this.updateStatus();
        }
        while (index >= 0) {
            this.queue.add(feedStr.substring(offset, index));
            this.log.info((Object)("TCPFEEDLEVEL@ Feed" + feedStr));
            offset = index + FEED_MSG_DELIMITER.length();
            index = feedStr.indexOf(FEED_MSG_DELIMITER, offset);
        }
    }

    private synchronized void keepConnecting() {
        while (!this.isConnected()) {
            try {
                Thread.sleep(7000L);
                this.connect();
            }
            catch (Exception exception) {}
        }
    }

    private void connect() {
        if (Resources.tcpLink) {
            String[] hosts = Utility.getTokens(this.host, ",");
            String[] ports = Utility.getTokens(this.port, ",");
            boolean connectStatus = false;
            Random random = new Random();
            int i = 0;
            while (i < hosts.length) {
                int portIndex = random.nextInt(ports.length);
                int j = 0;
                while (j < ports.length) {
                    int port = Integer.parseInt(ports[portIndex]);
                    this.log.info((Object)("Level II Trying Port: " + port));
                    connectStatus = this.initFeedLink(hosts[i], port);
                    if (connectStatus) {
                        this.log.info((Object)("Level II Establish On Port: " + port));
                        break;
                    }
                    if (++portIndex == ports.length) {
                        portIndex = 0;
                    }
                    ++j;
                }
                if (connectStatus) break;
                ++i;
            }
        }
    }

    protected boolean initFeedLink(String host, int port) {
        try {
            this.cHost = host;
            this.cPort = port;
            this.feedSocket = new Socket(host, port);
            this.inStream = new DelimitedInputStream();
            this.inStream.setInputStream(this.feedSocket.getInputStream());
            this.inStream.setDelimiter("<END>");
            this.outStream = new DelimitedOutputStream();
            this.outStream.setOutputStream(this.feedSocket.getOutputStream());
            this.outStream.setDelimiter("<END>");
            this.pingConnect = true;
            new PingThread().start();
            this.log.info((Object)("Send Message : " + this.curentMBOMBPRequestMsg));
            this.sendMessage(this.curentMBOMBPRequestMsg);
            this.setConnected(true);
            return true;
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception : " + ex.getMessage()));
            return false;
        }
    }

    private void reEstablishFeedLink() {
        try {
            this.connect();
        }
        catch (Exception ex) {
            this.log.error((Object)("ReEstablish Exception :  " + ex.getMessage()));
        }
    }

    public void closeTCPFeedLink(boolean rec) {
        try {
            this.closeTCPSocket();
            this.setReconnect(rec);
            this.updateStatus();
        }
        catch (Exception exception) {}
    }

    private void closeTCPSocket() {
        this.parseThread = true;
        if (this.feedParseThread != null) {
            this.feedParseThread.interrupt();
        }
        this.pingConnect = false;
        try {
            if (this.outStream != null) {
                this.outStream.flush();
                this.outStream.close();
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Exception: " + e.getMessage()));
        }
        try {
            this.inStream.close();
        }
        catch (Exception e) {
            this.log.error((Object)("Exception: " + e.getMessage()));
        }
        try {
            this.outStream.close();
        }
        catch (Exception e) {
            this.log.error((Object)("Exception: " + e.getMessage()));
        }
        try {
            this.feedSocket.shutdownOutput();
        }
        catch (Exception e) {
            this.log.error((Object)("Exception: " + e.getMessage()));
        }
        try {
            this.feedSocket.close();
        }
        catch (Exception e) {
            this.log.error((Object)("Exception: " + e.getMessage()));
        }
    }

    private void updateStatus() {
        if (this.bConnected) {
            if (this.linkType == 0) {
                this.log.info((Object)("Feed Link Established with host " + this.cHost + " and at port " + this.cPort));
                CorePlugin.updateStausBar("FS", "Feed Connected");
            } else if (this.linkType == 1) {
                this.log.info((Object)("Level2Feed Link Established with host " + this.cHost + " and at port " + this.cPort));
                CorePlugin.updateStausBar("SFS", "Level2Feed Connected");
                this.sendLoginMessage();
            }
        } else if (this.linkType == 0) {
            this.log.info((Object)("Feed Link not established with host " + this.cHost + " and at port " + this.cPort));
            CorePlugin.updateStausBar("FS", "Connecting Feed ...");
        } else if (this.linkType == 1) {
            CorePlugin.updateStausBar("SFS", "Connecting Level2Feed...");
        }
    }

    public void stopTCPFeedThread() {
        this.setConnected(false);
    }

    private void setConnected(boolean connected) {
        this.bConnected = connected;
    }

    public boolean isConnected() {
        return this.bConnected;
    }

    public boolean isFeedConnected() {
        if (!(this.bConnected && this.feedSocket != null && this.feedSocket.isConnected() && this.feedSocket.isBound())) {
            return false;
        }
        return this.bConnected;
    }

    private void setReconnect(boolean rec) {
        this.reconnect = rec;
    }

    private boolean doReconnect() {
        return this.reconnect;
    }

    private void ping() throws Exception {
        this.outStream.write("ping".getBytes(), 0, 4);
    }

    public void subscribeSymbol(Set<String> profilingSet) {
        if (this.bConnected) {
            StringBuffer req = new StringBuffer("SUB:");
            for (String symbols : profilingSet) {
                req.append(String.valueOf(symbols) + '|');
            }
            req.append("<END>");
            this.sendMessage(req.toString());
            this.log.info((Object)("Feed Subscribed for " + req.toString()));
        }
    }

    public void subscribeSymbol(String subscribe) {
        StringBuffer req = new StringBuffer("SUB:");
        req.append(String.valueOf(subscribe) + '|');
        req.append("<END>");
        System.out.println("Subscription Request : " + req.toString());
        this.sendMessage(req.toString());
        this.log.info((Object)("Feed Subscribed for " + req.toString()));
    }

    public void unSubscribeSymbol(String ubsubscribe) {
        StringBuffer req = new StringBuffer("UNSUB:");
        req.append(String.valueOf(ubsubscribe) + '|');
        req.append("<END>");
        System.out.println("UnSubscription Request : " + req.toString());
        this.sendMessage(req.toString());
        this.log.info((Object)("Feed Subscribed for " + req.toString()));
    }

    public boolean writeData(Object obj) {
        boolean bValue = false;
        if (this.bConnected) {
            try {
                if (this.outObjectStream != null) {
                    this.outObjectStream.writeObject(obj);
                    this.outObjectStream.flush();
                    bValue = true;
                } else {
                    this.log.info((Object)"May Be Profiling Not Enabled");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                bValue = false;
            }
        }
        return bValue;
    }

    public void sendLoginMessage() {
        String message = "FLGN|" + Resources.userId + '|' + "<END>";
        this.sendMessage(message);
    }

    public void sendSubLevel2FeedServerMBOReq(String exchange, String market, String symbol) {
        String mboMsg = "MBO|" + exchange + ',' + market + ',' + symbol + '|' + "<END>";
        this.isSendMBOMBPRequest = true;
        this.curentMBOMBPRequestMsg = mboMsg;
        this.log.info((Object)("FEED MBORDER SEND FOR " + mboMsg));
        this.sendMessage(mboMsg);
    }

    public void sendSubLevel2FeedServerMBPReq(String exchange, String market, String symbol) {
        String mbpMsg = "MBP|" + exchange + ',' + market + ',' + symbol + '|' + "<END>";
        this.isSendMBOMBPRequest = true;
        this.curentMBOMBPRequestMsg = mbpMsg;
        this.log.info((Object)("FEED MBPRICE SEND FOR " + mbpMsg));
        this.sendMessage(mbpMsg);
    }

    public void sendMessage(String message) {
        if (this.bConnected) {
            try {
                this.outStream.write(message.getBytes(), 0, message.length());
            }
            catch (IOException e) {
                this.log.error((Object)("Exception: " + e.getMessage()));
            }
        }
    }

    public class ConnectEstablishThread
    extends Thread {
        @Override
        public void run() {
            while (!TCPFeedLevel2Link.this.isSocketEstablished) {
                try {
                    ConnectEstablishThread.sleep(7000L);
                    if (TCPFeedLevel2Link.this.isSocketEstablished || !TCPFeedLevel2Link.this.isSendMBOMBPRequest || TCPFeedLevel2Link.this.isSocketEstablished || "".equalsIgnoreCase(TCPFeedLevel2Link.this.curentMBOMBPRequestMsg)) continue;
                    TCPFeedLevel2Link.this.log.info((Object)("ConnectEstablish Thread Ping Connect: " + TCPFeedLevel2Link.this.pingConnect));
                    TCPFeedLevel2Link.this.closeTCPSocket();
                    TCPFeedLevel2Link.this.reEstablishFeedLink();
                    ConnectEstablishThread.sleep(5000L);
                }
                catch (Exception exception) {
                    TCPFeedLevel2Link.this.closeTCPSocket();
                }
            }
        }
    }

    public class PingThread
    extends Thread {
        @Override
        public void run() {
            while (TCPFeedLevel2Link.this.pingConnect) {
                try {
                    TCPFeedLevel2Link.this.log.info((Object)"PingThread");
                    PingThread.sleep(2000L);
                    TCPFeedLevel2Link.this.ping();
                    PingThread.sleep(2000L);
                    if (!TCPFeedLevel2Link.this.parseThread) continue;
                    byte[] feedBuffer = new byte[65536];
                    try {
                        int actualSize = -1;
                        actualSize = TCPFeedLevel2Link.this.inStream.read(feedBuffer, 0, 65536);
                        if (actualSize <= 0 || !TCPFeedLevel2Link.this.parseThread) continue;
                        TCPFeedLevel2Link.this.parseThread = false;
                        TCPFeedLevel2Link.this.feedParseThread = new feedParseThread();
                        TCPFeedLevel2Link.this.feedParseThread.start();
                    }
                    catch (IOException iOException) {
                        TCPFeedLevel2Link.this.log.error((Object)"Exception Buffer Still Empty");
                    }
                }
                catch (Exception e) {
                    TCPFeedLevel2Link.this.closeTCPSocket();
                    TCPFeedLevel2Link.this.log.error((Object)("Exception Ping: " + e.getMessage()));
                }
            }
            this.interrupt();
        }
    }

    public class feedParseThread
    extends Thread {
        @Override
        public void run() {
            int actualSize = -1;
            while (TCPFeedLevel2Link.this.isConnected()) {
                byte[] feedBuffer = new byte[65536];
                try {
                    actualSize = TCPFeedLevel2Link.this.inStream.read(feedBuffer, 0, 65536);
                    feedBuffer = Zipper.unzip(feedBuffer, 0, actualSize);
                    CorePlugin.updateStausBar("FS", "Feed Connected");
                    TCPFeedLevel2Link.this.parseFeedMessage(new String(feedBuffer));
                    TCPFeedLevel2Link.this.log.info((Object)"FeedParse Thread");
                    if (TCPFeedLevel2Link.this.queue == null || TCPFeedLevel2Link.this.queue.size() <= 1024) continue;
                    TCPFeedLevel2Link.this.queue.clear();
                    TCPFeedLevel2Link.this.log.debug((Object)("Discarding unsent " + (TCPFeedLevel2Link.this.linkType == 0 ? " Feed" : "Level 2 Feed")));
                }
                catch (Exception ex) {
                    TCPFeedLevel2Link.this.log.error((Object)("Exception in Feed Connection : " + ex.getMessage()));
                    if (!TCPFeedLevel2Link.this.doReconnect() || !TCPFeedLevel2Link.this.isSocketEstablished) continue;
                    TCPFeedLevel2Link.this.stopTCPFeedThread();
                    TCPFeedLevel2Link.this.closeTCPFeedLink(true);
                    TCPFeedLevel2Link.this.keepConnecting();
                }
            }
        }
    }
}

