/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.io;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import pk.com.softech.tradingterminal.core.io.OutStream;

public class MessageOutputStream
implements OutStream {
    protected int resetThreshold = 5;
    protected int resetCounter = 0;
    protected ObjectOutputStream stream;

    public MessageOutputStream() {
    }

    public MessageOutputStream(OutputStream out) throws IOException {
        this();
        this.setOutputStream(out);
    }

    public MessageOutputStream(OutputStream out, int threshold) throws IOException {
        this();
        this.setResetThreshold(threshold);
        this.setOutputStream(out);
    }

    public void setResetThreshold(int threshold) {
        this.resetThreshold = threshold;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    @Override
    public void setOutputStream(OutputStream out) throws IOException {
        this.stream = new ObjectOutputStream(out);
    }

    @Override
    public void write(byte[] buffer, int position, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeObject(Object object) throws IOException {
        this.stream.writeObject(object);
        this.flush();
        ++this.resetCounter;
        if (this.resetCounter >= this.resetThreshold) {
            this.stream.reset();
            this.resetCounter = 0;
        }
    }

    @Override
    public void setProperties(Properties fileProps) {
    }
}

