/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import pk.com.softech.tradingterminal.core.io.DelimitedStream;
import pk.com.softech.tradingterminal.core.io.OutStream;

public class DelimitedOutputStream
extends DelimitedStream
implements OutStream {
    protected BufferedOutputStream stream;

    public DelimitedOutputStream() {
    }

    public DelimitedOutputStream(OutputStream out, Properties properties) {
        this.setProperties(properties);
        this.setOutputStream(out);
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    @Override
    public void setOutputStream(OutputStream out) {
        this.stream = new BufferedOutputStream(out);
    }

    @Override
    public void write(byte[] buffer, int position, int length) throws IOException {
        if (buffer.length < length + position || length < 1) {
            throw new IOException("Buffer underflow");
        }
        this.stream.write(buffer, position, length);
        byte[] delim = this.delimiter.getBytes();
        this.stream.write(delim, 0, delim.length);
        this.flush();
    }

    @Override
    public void writeObject(Object object) throws IOException {
        throw new UnsupportedOperationException();
    }
}

