/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import pk.com.softech.tradingterminal.core.io.DelimitedStream;
import pk.com.softech.tradingterminal.core.io.InStream;

public class DelimitedInputStream
extends DelimitedStream
implements InStream {
    protected BufferedInputStream stream;

    public DelimitedInputStream() {
    }

    public DelimitedInputStream(InputStream in, Properties properties) throws IOException {
        this.setInputStream(in);
        this.setProperties(properties);
    }

    @Override
    public int available() throws IOException {
        return this.stream.available();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public int read(byte[] buffer, int position, int length) throws IOException {
        byte[] delim = this.delimiter.getBytes();
        int index = 0;
        int size = 0;
        try {
            index = 0;
            size = 0;
            while (index < delim.length) {
                this.stream.read(buffer, position, 1);
                index = buffer[position] == delim[index] ? ++index : 0;
                ++size;
                ++position;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException("Buffer overflow");
        }
        return size - index;
    }

    @Override
    public Object readObject() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInputStream(InputStream in) throws IOException {
        this.stream = new BufferedInputStream(in);
    }

    @Override
    public void seek(long pos) throws IOException {
        throw new UnsupportedOperationException();
    }
}

