/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.internal;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections.map.ReferenceIdentityMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Platform;
import org.mapdb20.BTreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import pk.com.softech.messages.SymbolStatisticsData;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Repository;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.Account;
import pk.com.softech.tradingterminal.core.db.AccountGroup;
import pk.com.softech.tradingterminal.core.db.Alert;
import pk.com.softech.tradingterminal.core.db.AnnouncementItem;
import pk.com.softech.tradingterminal.core.db.Bar;
import pk.com.softech.tradingterminal.core.db.Chart;
import pk.com.softech.tradingterminal.core.db.ChartIndicator;
import pk.com.softech.tradingterminal.core.db.ChartObject;
import pk.com.softech.tradingterminal.core.db.ChartRow;
import pk.com.softech.tradingterminal.core.db.ChartTab;
import pk.com.softech.tradingterminal.core.db.Dividend;
import pk.com.softech.tradingterminal.core.db.Event;
import pk.com.softech.tradingterminal.core.db.History;
import pk.com.softech.tradingterminal.core.db.IntradayHistory;
import pk.com.softech.tradingterminal.core.db.NewsItem;
import pk.com.softech.tradingterminal.core.db.Order;
import pk.com.softech.tradingterminal.core.db.OrderRoute;
import pk.com.softech.tradingterminal.core.db.OrderSide;
import pk.com.softech.tradingterminal.core.db.OrderStatus;
import pk.com.softech.tradingterminal.core.db.OrderType;
import pk.com.softech.tradingterminal.core.db.OrderValidity;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.PersistentPreferenceStore;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.SecurityGroup;
import pk.com.softech.tradingterminal.core.db.Split;
import pk.com.softech.tradingterminal.core.db.Transaction;
import pk.com.softech.tradingterminal.core.db.Watchlist;
import pk.com.softech.tradingterminal.core.db.WatchlistColumn;
import pk.com.softech.tradingterminal.core.db.WatchlistItem;
import pk.com.softech.tradingterminal.core.db.feed.FeedSource;
import pk.com.softech.tradingterminal.core.db.feed.Quote;
import pk.com.softech.tradingterminal.core.db.feed.TradeSource;
import pk.com.softech.tradingterminal.core.db.mapdb.MapDb;
import pk.com.softech.tradingterminal.core.db.trading.TradingSystem;
import pk.com.softech.tradingterminal.core.db.trading.TradingSystemGroup;
import pk.com.softech.tradingterminal.core.internal.TradingSystemRepository;
import pk.com.softech.tradingterminal.core.util.ProductNames;

public class XMLRepository
extends Repository {
    private Map<String, Security> allSecuritiesMap = new HashMap<String, Security>();
    Integer securitiesNextId = new Integer(1);
    Integer securitiesGroupNextId = new Integer(1);
    Integer chartsNextId = new Integer(1);
    Map chartsMap = new HashMap();
    Integer watchlistsNextId = new Integer(1);
    Map watchlistsMap = new HashMap();
    Integer accountGroupNextId = new Integer(1);
    Map accountGroupMap = new HashMap();
    Integer accountNextId = new Integer(1);
    Map accountMap = new HashMap();
    Integer eventNextId = new Integer(1);
    TradingSystemRepository tradingRepository;
    Integer orderNextId = new Integer(1);
    Integer alertNextId = new Integer(1);
    ReferenceIdentityMap historyMap = new ReferenceIdentityMap();
    ReferenceIdentityMap intradayHistoryMap = new ReferenceIdentityMap();
    SimpleDateFormat dateTimeFormat = CorePlugin.getDateTimeFormat();
    SimpleDateFormat dateFormat = CorePlugin.getDateFormat();
    private Log log = LogFactory.getLog(this.getClass());
    static HashMap<WokspaceFilesEnum, UUID> WokspaceFilesUUID = new HashMap();
    private ErrorHandler errorHandler = new ErrorHandler(){

        @Override
        public void error(SAXParseException exception) throws SAXException {
            XMLRepository.this.log.error((Object)exception, (Throwable)exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            XMLRepository.this.log.fatal((Object)exception, (Throwable)exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            XMLRepository.this.log.warn((Object)exception, (Throwable)exception);
        }
    };

    static {
        try {
            WokspaceFilesEnum[] wokspaceFilesEnumArray = WokspaceFilesEnum.values();
            int n = wokspaceFilesEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                WokspaceFilesEnum item = wokspaceFilesEnumArray[n2];
                String source = item.toString();
                byte[] bytes = source.getBytes("UTF-8");
                UUID uuid = UUID.nameUUIDFromBytes(bytes);
                WokspaceFilesUUID.put(item, uuid);
                ++n2;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public XMLRepository() {
        if (Resources.isMapDbEnabled) {
            UUID uuid = WokspaceFilesUUID.get((Object)WokspaceFilesEnum.SEC);
            if (MapDb.ensureFilesPresent(uuid)) {
                this.loadSecuritiesMapDb(uuid);
            } else {
                this.loadSecurities();
            }
            uuid = WokspaceFilesUUID.get((Object)WokspaceFilesEnum.SYS_WATCH_LIST);
            if (MapDb.ensureFilesPresent(uuid)) {
                this.loadWatchListsMapDb(1, uuid);
            } else {
                this.loadWatchlists(1);
            }
            uuid = WokspaceFilesUUID.get((Object)WokspaceFilesEnum.WATCH_LIST);
            if (MapDb.ensureFilesPresent(uuid)) {
                this.loadWatchListsMapDb(0, uuid);
            } else {
                this.loadWatchlists(0);
            }
            uuid = WokspaceFilesUUID.get((Object)WokspaceFilesEnum.ALERTS);
            if (MapDb.ensureFilesPresent(uuid)) {
                this.loadAlertsMapDb(uuid);
            } else {
                this.loadAlerts();
            }
            uuid = WokspaceFilesUUID.get((Object)WokspaceFilesEnum.NEWS);
            if (MapDb.ensureFilesPresent(uuid)) {
                this.loadNewsMapDb(uuid);
            } else {
                this.loadNews();
            }
        } else {
            this.loadSecurities();
            this.loadWatchlists(0);
            this.loadWatchlists(1);
            this.loadAlerts();
        }
        this.loadAnnouncements();
        this.loadEvents();
        this.tradingRepository = new TradingSystemRepository(this);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public void loadSecuritiesMapDb(UUID uuid) {
        try {
            Gson gson = new Gson();
            MapDb instance = new MapDb(uuid, true);
            instance.init();
            BTreeMap ds = instance.getDataSet();
            String str = (String)ds.get((Object)uuid);
            if (str != null) {
                JsonObject json = (JsonObject)gson.fromJson(str, JsonObject.class);
                try {
                    try {
                        this.securitiesNextId = json.get("nextId").getAsInt();
                    }
                    catch (Exception exception) {}
                    try {
                        this.securitiesGroupNextId = json.get("nextGroupId").getAsInt();
                    }
                    catch (Exception exception) {}
                    JsonArray securities = json.get("securities").getAsJsonArray();
                    if (securities != null && securities.size() > 0) {
                        for (JsonElement jsonElemt : securities) {
                            JsonObject security = jsonElemt.getAsJsonObject();
                            if (security == null) continue;
                            Security obj = this.loadSecurityFromJSON(security);
                            obj.setRepository(this);
                            this.allSecuritiesMap.put(obj.getId(), obj);
                            this.allSecurities().add(obj);
                        }
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            instance.close();
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage());
        }
    }

    public void loadSecurities() {
        block11: {
            try {
                File file = new File(Platform.getLocation().toFile(), "securities.xml");
                if (!file.exists()) break block11;
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setValidating(false);
                    factory.setExpandEntityReferences(false);
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    builder.setErrorHandler(this.errorHandler);
                    Document document = builder.parse(file);
                    Node firstNode = document.getFirstChild();
                    this.securitiesNextId = new Integer(firstNode.getAttributes().getNamedItem("nextId").getNodeValue());
                    if (firstNode.getAttributes().getNamedItem("nextGroupId") != null) {
                        this.securitiesGroupNextId = new Integer(firstNode.getAttributes().getNamedItem("nextGroupId").getNodeValue());
                    }
                    NodeList childNodes = firstNode.getChildNodes();
                    int i = 0;
                    while (i < childNodes.getLength()) {
                        PersistentObject obj;
                        Node item = childNodes.item(i);
                        String nodeName = item.getNodeName();
                        if (nodeName.equalsIgnoreCase("security")) {
                            try {
                                obj = this.loadSecurity(item.getChildNodes());
                                obj.setRepository(this);
                                this.allSecuritiesMap.put(obj.getId(), (Security)obj);
                                this.allSecurities().add(obj);
                            }
                            catch (Exception e) {
                                this.log.error((Object)e.getMessage(), (Throwable)e);
                            }
                        } else if (nodeName.equalsIgnoreCase("group")) {
                            obj = this.loadSecurityGroup(item.getChildNodes());
                            obj.setRepository(this);
                            this.allSecurityGroups().add(obj);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)e.toString(), (Throwable)e);
                }
            }
            catch (Exception e1) {
                this.log.error((Object)e1.getMessage());
            }
        }
    }

    public void addSecurity(Security security) {
        security.setRepository(this);
        this.allSecuritiesMap.put(security.getId(), security);
        this.allSecurities().add(security);
    }

    public void loadWatchListsMapDb(int watchType, UUID uuid) {
        try {
            Gson gson = new Gson();
            MapDb instance = new MapDb(uuid, true);
            instance.init();
            BTreeMap ds = instance.getDataSet();
            String str = (String)ds.get((Object)uuid);
            if (str != null && !"".equalsIgnoreCase(str)) {
                JsonObject json = (JsonObject)gson.fromJson(str, JsonObject.class);
                try {
                    this.loadWatchlistFromJSON(json, watchType);
                }
                catch (Exception e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            instance.close();
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception: " + ex.getMessage()));
        }
    }

    public void loadWatchlists(int watchType) {
        File file = new File(Platform.getLocation().toFile(), "watchlists.xml");
        if (watchType == 1) {
            file = new File(Platform.getLocation().toFile(), "syswatchlists.xml");
        }
        if (file.exists()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setErrorHandler(this.errorHandler);
                this.removeExtraSpaces(file);
                Document document = builder.parse(file);
                Node firstNode = document.getFirstChild();
                this.watchlistsNextId = new Integer(firstNode.getAttributes().getNamedItem("nextId").getNodeValue());
                NodeList childNodes = firstNode.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node item = childNodes.item(i);
                    String nodeName = item.getNodeName();
                    if (nodeName.equalsIgnoreCase("watchlist")) {
                        Watchlist obj = this.loadWatchlist(item.getChildNodes());
                        Resources.isDefaultCurrency = obj.isUseDefaultCurrency();
                        obj.setRepository(this);
                        this.watchlistsMap.put(obj.getId(), obj);
                        if (watchType == 1) {
                            this.allSystemWatchlists().add(obj);
                        } else {
                            this.allWatchlists().add(obj);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                this.log.error((Object)e.toString(), (Throwable)e);
            }
        }
    }

    private void loadNewsFromJson(JsonObject obj) {
        JsonArray list = obj.get("data").getAsJsonArray();
        if (list != null && list.size() > 0) {
            Calendar limit = Calendar.getInstance();
            for (JsonElement jsonElemt : list) {
                try {
                    JsonObject elem = jsonElemt.getAsJsonObject();
                    JsonObject newsElem = elem.get("news").getAsJsonObject();
                    NewsItem news = new NewsItem();
                    try {
                        String dateStr = newsElem.get("date").getAsString();
                        Date date = this.dateTimeFormat.parse(dateStr);
                        if (date.before(limit.getTime())) continue;
                        news.setDate(date);
                    }
                    catch (Exception exception) {}
                    try {
                        String description = newsElem.get("description").getAsString();
                        news.setTitle(description);
                    }
                    catch (Exception exception) {}
                    try {
                        String source = newsElem.get("source").getAsString();
                        news.setSource(source);
                    }
                    catch (Exception exception) {}
                    try {
                        String url = newsElem.get("url").getAsString();
                        news.setUrl(url);
                    }
                    catch (Exception exception) {}
                    try {
                        JsonArray paramList = newsElem.get("securities").getAsJsonArray();
                        if (paramList != null && paramList.size() > 0) {
                            for (JsonElement paramElem : paramList) {
                                JsonObject param = paramElem.getAsJsonObject();
                                try {
                                    String key = param.get("security").getAsString();
                                    Security security = this.getSecurity(key);
                                    if (security == null) continue;
                                    news.addSecurity(security);
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                    catch (Exception exception) {}
                    news.setRepository(this);
                    this.allNews().add(news);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void loadNewsMapDb(UUID uuid) {
        if (Resources.isMapDbEnabled) {
            try {
                Gson gson = new Gson();
                MapDb instance = new MapDb(uuid, true);
                instance.init();
                BTreeMap ds = instance.getDataSet();
                String str = (String)ds.get((Object)uuid);
                if (str != null && !"".equalsIgnoreCase(str)) {
                    JsonObject json = (JsonObject)gson.fromJson(str, JsonObject.class);
                    try {
                        this.loadNewsFromJson(json);
                    }
                    catch (Exception e) {
                        this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                instance.close();
            }
            catch (Exception exception) {}
        }
    }

    public void loadNews() {
        File file = new File(Platform.getLocation().toFile(), "news.xml");
        if (file.exists()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setErrorHandler(this.errorHandler);
                Document document = builder.parse(file);
                Calendar limit = Calendar.getInstance();
                limit.add(5, CorePlugin.getDefault().getPreferenceStore().getInt("PREFS_NEWS_DATE_RANGE"));
                Node firstNode = document.getFirstChild();
                NodeList childNodes = firstNode.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    NewsItem obj;
                    Node item = childNodes.item(i);
                    String nodeName = item.getNodeName();
                    if (nodeName.equalsIgnoreCase("news") && !(obj = this.loadNews(item.getChildNodes())).getDate().before(limit.getTime())) {
                        obj.setRepository(this);
                        this.allNews().add(obj);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage());
            }
        }
    }

    public void loadAlertsMapDb(UUID uuid) {
        if (Resources.isMapDbEnabled) {
            try {
                Gson gson = new Gson();
                MapDb instance = new MapDb(uuid, true);
                instance.init();
                BTreeMap ds = instance.getDataSet();
                String str = (String)ds.get((Object)uuid);
                JsonObject json = (JsonObject)gson.fromJson(str, JsonObject.class);
                this.loadAlertFromJson(json);
                instance.close();
            }
            catch (Exception exception) {}
        }
    }

    public void loadAlerts() {
        File file = new File(Platform.getLocation().toFile(), "alerts.xml");
        if (file.exists()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setErrorHandler(this.errorHandler);
                Document document = builder.parse(file);
                Node firstNode = document.getFirstChild();
                NodeList childNodes = firstNode.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node item = childNodes.item(i);
                    String nodeName = item.getNodeName();
                    if (nodeName.equalsIgnoreCase("alert")) {
                        Alert obj = this.loadAlertStub(item);
                        obj.setRepository(this);
                        this.allAlerts().add(obj);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                this.log.error((Object)e.toString(), (Throwable)e);
            }
        }
    }

    private Alert loadAlertStub(Node items) {
        NodeList node = items.getChildNodes();
        Alert alert = new Alert();
        int i = 0;
        while (i < node.getLength()) {
            Node item = node.item(i);
            String nodeName = item.getNodeName();
            Node value = item.getFirstChild();
            alert.setPluginId(items.getAttributes().getNamedItem("pluginId").getNodeValue());
            if (nodeName.equalsIgnoreCase("lastSeen")) {
                try {
                    if (value.getNodeValue() != null) {
                        alert.setLastSeen(this.dateTimeFormat.parse(value.getNodeValue()));
                    }
                }
                catch (Exception exception) {}
            } else if (nodeName.equalsIgnoreCase("popup")) {
                if (value.getNodeValue().equals("true")) {
                    alert.setPopup(true);
                } else {
                    alert.setPopup(false);
                }
            } else if (nodeName.equalsIgnoreCase("hilight")) {
                if (value.getNodeValue().equals("true")) {
                    alert.setHilight(true);
                } else {
                    alert.setHilight(false);
                }
            }
            if (nodeName.equalsIgnoreCase("security")) {
                Security sec = this.getSecurityById(value.getNodeValue());
                alert.setSecurity(sec);
            }
            if (nodeName.equalsIgnoreCase("param")) {
                String key = item.getAttributes().getNamedItem("key").getNodeValue();
                alert.getParameters().put(key, value.getNodeValue());
            }
            ++i;
        }
        alert.clearChanged();
        return alert;
    }

    private void loadAlertFromJson(JsonObject obj) {
        JsonArray list = obj.get("data").getAsJsonArray();
        if (list != null && list.size() > 0) {
            for (JsonElement jsonElemt : list) {
                Alert alert = new Alert();
                JsonObject elem = jsonElemt.getAsJsonObject();
                elem.get("id").getAsString();
                try {
                    String pluginId = elem.get("pluginId").getAsString();
                    alert.setPluginId(pluginId);
                }
                catch (Exception exception) {}
                try {
                    String lastSeen = elem.get("lastSeen").getAsString();
                    alert.setLastSeen(this.dateTimeFormat.parse(lastSeen));
                }
                catch (Exception exception) {}
                try {
                    boolean isPop = elem.get("popup").getAsBoolean();
                    alert.setPopup(isPop);
                }
                catch (Exception exception) {}
                try {
                    boolean isHighlight = elem.get("hilight").getAsBoolean();
                    alert.setHilight(isHighlight);
                }
                catch (Exception exception) {}
                try {
                    String secID = elem.get("security").getAsString();
                    Security sec = this.getSecurityById(secID);
                    alert.setSecurity(sec);
                }
                catch (Exception exception) {}
                try {
                    JsonArray paramList = elem.get("parmas").getAsJsonArray();
                    if (paramList != null && paramList.size() > 0) {
                        for (JsonElement paramElem : paramList) {
                            JsonObject param = paramElem.getAsJsonObject();
                            try {
                                String key = param.get("key").getAsString();
                                String value = param.get("value").getAsString();
                                alert.getParameters().put(key, value);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                catch (Exception exception) {}
                alert.clearChanged();
                alert.setRepository(this);
                this.allAlerts().add(alert);
            }
        }
    }

    public void loadAnnouncements() {
        File file = new File(Platform.getLocation().toFile(), "announcements.xml");
        if (file.exists()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setErrorHandler(this.errorHandler);
                Document document = builder.parse(file);
                Calendar limit = Calendar.getInstance();
                limit.set(11, 0);
                limit.set(12, 0);
                limit.set(14, 0);
                Node firstNode = document.getFirstChild();
                NodeList childNodes = firstNode.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    AnnouncementItem obj;
                    Node item = childNodes.item(i);
                    String nodeName = item.getNodeName();
                    if (nodeName.equalsIgnoreCase("announcement") && !(obj = this.loadAnnouncement(item.getChildNodes())).getDate().before(limit.getTime())) {
                        obj.setRepository(this);
                        this.allAnnouncements().add(obj);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                this.log.error((Object)e.toString(), (Throwable)e);
            }
        }
    }

    public void loadAccounts() {
        File file = new File(Platform.getLocation().toFile(), "accounts.xml");
        if (file.exists()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setErrorHandler(this.errorHandler);
                Document document = builder.parse(file);
                Node firstNode = document.getFirstChild();
                this.accountNextId = new Integer(firstNode.getAttributes().getNamedItem("nextId").getNodeValue());
                this.accountGroupNextId = new Integer(firstNode.getAttributes().getNamedItem("nextGroupId").getNodeValue());
                NodeList childNodes = firstNode.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    PersistentObject obj;
                    Node item = childNodes.item(i);
                    String nodeName = item.getNodeName();
                    if (nodeName.equalsIgnoreCase("account")) {
                        obj = this.loadAccount(item.getChildNodes(), null);
                        if (obj != null) {
                            obj.setRepository(this);
                            this.accountMap.put(obj.getId(), obj);
                            this.allAccounts().add(obj);
                        }
                    } else if (nodeName.equalsIgnoreCase("group")) {
                        obj = this.loadAccountGroup(item.getChildNodes(), null);
                        obj.setRepository(this);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                this.log.error((Object)e.toString(), (Throwable)e);
            }
        }
    }

    public void loadEvents() {
        File file = new File(Platform.getLocation().toFile(), "events.xml");
        if (file.exists()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setErrorHandler(this.errorHandler);
                Document document = builder.parse(file);
                Node firstNode = document.getFirstChild();
                NodeList childNodes = firstNode.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node item = childNodes.item(i);
                    String nodeName = item.getNodeName();
                    if (nodeName.equalsIgnoreCase("event")) {
                        Calendar today = Calendar.getInstance();
                        today.set(11, 0);
                        today.set(12, 0);
                        today.set(13, 0);
                        today.set(14, 0);
                        Event obj = this.loadEvent(item.getChildNodes());
                        if (obj.getDate().after(today.getTime())) {
                            obj.setRepository(this);
                            this.save(obj);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                this.log.error((Object)e.toString(), (Throwable)e);
            }
        }
    }

    public void loadOrders() {
        File file = new File(Platform.getLocation().toFile(), "orders.xml");
        if (file.exists()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setErrorHandler(this.errorHandler);
                Document document = builder.parse(file);
                Node firstNode = document.getFirstChild();
                this.orderNextId = new Integer(firstNode.getAttributes().getNamedItem("nextId").getNodeValue());
                NodeList childNodes = firstNode.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node item = childNodes.item(i);
                    String nodeName = item.getNodeName();
                    if (nodeName.equalsIgnoreCase("order")) {
                        Order obj = this.loadOrder(item.getChildNodes());
                        obj.setRepository(this);
                        this.allOrders().add(obj);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                this.log.error((Object)e.toString(), (Throwable)e);
            }
        }
    }

    @Override
    public void clear() {
        File file = new File(Platform.getLocation().toFile(), "securities.xml");
        if (file.exists()) {
            file.delete();
        }
        if ((file = new File(Platform.getLocation().toFile(), "watchlists.xml")).exists()) {
            file.delete();
        }
        if ((file = new File(Platform.getLocation().toFile(), "intradayCharts.xml")).exists()) {
            file.delete();
        }
        if ((file = new File(Platform.getLocation().toFile(), "historyCharts.xml")).exists()) {
            file.delete();
        }
        if ((file = new File(Platform.getLocation().toFile(), "news.xml")).exists()) {
            file.delete();
        }
        if ((file = new File(Platform.getLocation().toFile(), "accounts.xml")).exists()) {
            file.delete();
        }
        if ((file = new File(Platform.getLocation().toFile(), "events.xml")).exists()) {
            file.delete();
        }
        if ((file = new File(Platform.getLocation().toFile(), "orders.xml")).exists()) {
            file.delete();
        }
        for (Security security : this.allSecurities()) {
            file = new File(Platform.getLocation().toFile(), "history/" + String.valueOf(security.getId()) + ".xml");
            if (file.exists()) {
                file.delete();
            }
            if (!(file = new File(Platform.getLocation().toFile(), "intraday/" + String.valueOf(security.getId()) + ".xml")).exists()) continue;
            file.delete();
        }
        this.securitiesNextId = new Integer(1);
        this.securitiesGroupNextId = new Integer(1);
        this.allSecuritiesMap = new HashMap<String, Security>();
        this.chartsNextId = new Integer(1);
        this.chartsMap = new HashMap();
        this.watchlistsNextId = new Integer(1);
        this.watchlistsMap = new HashMap();
        this.accountGroupNextId = new Integer(1);
        this.accountGroupMap = new HashMap();
        this.accountNextId = new Integer(1);
        this.accountMap = new HashMap();
        this.eventNextId = new Integer(1);
        this.orderNextId = new Integer(1);
        this.tradingRepository.clear();
        this.historyMap = new ReferenceIdentityMap();
        this.intradayHistoryMap = new ReferenceIdentityMap();
        super.clear();
    }

    @Override
    public PersistentObject load(Class clazz, String id) {
        PersistentObject obj = null;
        if (clazz.equals(Security.class)) {
            for (Security security : this.allSecurities()) {
                if (!security.getId().equalsIgnoreCase(id)) continue;
                obj = security;
            }
        } else if (clazz.equals(IntradayHistory.class)) {
            obj = (IntradayHistory)this.intradayHistoryMap.get((Object)id);
            if (obj == null) {
                obj = this.loadHistory(id, 1);
                this.intradayHistoryMap.put((Object)id, (Object)obj);
            }
        } else if (clazz.equals(History.class)) {
            obj = (PersistentObject)this.historyMap.get((Object)id);
            if (obj == null) {
                obj = this.loadHistory(id, 0);
                this.historyMap.put((Object)id, (Object)obj);
            }
        } else if (clazz.equals(Chart.class)) {
            obj = (PersistentObject)this.chartsMap.get(id);
        } else if (clazz.equals(Watchlist.class)) {
            obj = (PersistentObject)this.watchlistsMap.get(id);
        } else if (clazz.equals(Account.class)) {
            obj = (PersistentObject)this.accountMap.get(id);
        } else if (clazz.equals(AccountGroup.class)) {
            obj = (PersistentObject)this.accountGroupMap.get(id);
        } else if (clazz.equals(TradingSystem.class)) {
            obj = (PersistentObject)this.tradingRepository.tsMap.get(id);
        } else if (clazz.equals(TradingSystemGroup.class)) {
            obj = (PersistentObject)this.tradingRepository.tsGroupMap.get(id);
        }
        if (obj != null && !clazz.isInstance(obj)) {
            return null;
        }
        if (obj != null) {
            obj.setRepository(this);
        }
        return obj;
    }

    @Override
    public void save(PersistentObject obj) {
        if (obj instanceof Event) {
            if (obj.getId() == null) {
                obj.setId(this.eventNextId.toString());
                this.eventNextId = this.getNextId(this.eventNextId);
            }
        } else if (obj instanceof Security) {
            Security sec = (Security)obj;
            if (obj.getId() == null) {
                obj.setId(this.securitiesNextId.toString());
                this.securitiesNextId = this.getNextId(this.securitiesNextId);
            }
            this.allSecuritiesMap.put(obj.getId(), sec);
        } else if (obj instanceof SecurityGroup) {
            if (obj.getId() == null) {
                obj.setId(this.securitiesGroupNextId.toString());
                this.securitiesGroupNextId = this.getNextId(this.securitiesGroupNextId);
            }
        } else if (obj instanceof IntradayHistory) {
            this.saveIntradayHistory((IntradayHistory)obj);
        } else if (obj instanceof History) {
            this.saveHistory((History)obj);
        } else if (obj instanceof Chart) {
            if (obj.getId() == null) {
                obj.setId(this.chartsNextId.toString());
                this.chartsNextId = this.getNextId(this.chartsNextId);
            }
            Chart chart = (Chart)obj;
            int r = 0;
            while (r < chart.getRows().size()) {
                ChartRow row = (ChartRow)chart.getRows().get(r);
                row.setId(new Integer(r).toString());
                row.setParent(chart);
                row.setRepository(this);
                int t = 0;
                while (t < row.getTabs().size()) {
                    ChartTab tab = (ChartTab)row.getTabs().get(t);
                    tab.setId(new Integer(t).toString());
                    tab.setParent(row);
                    tab.setRepository(this);
                    int i = 0;
                    while (i < tab.getIndicators().size()) {
                        ChartIndicator indicator = (ChartIndicator)tab.getIndicators().get(i);
                        indicator.setId(new Integer(i).toString());
                        indicator.setParent(tab);
                        indicator.setRepository(this);
                        ++i;
                    }
                    i = 0;
                    while (i < tab.getObjects().size()) {
                        ChartObject object = (ChartObject)tab.getObjects().get(i);
                        object.setId(new Integer(i).toString());
                        object.setParent(tab);
                        object.setRepository(this);
                        ++i;
                    }
                    ++t;
                }
                ++r;
            }
            this.chartsMap.put(obj.getId(), obj);
        } else if (obj instanceof Watchlist) {
            try {
                Watchlist save;
                if (obj.getId() == null) {
                    obj.setId(this.watchlistsNextId.toString());
                    this.watchlistsNextId = this.getNextId(this.watchlistsNextId);
                }
                if ((save = (Watchlist)this.watchlistsMap.put(obj.getId(), obj)) == null) {
                    return;
                }
            }
            catch (Exception exception) {
                System.out.println("adfa");
            }
        } else if (obj instanceof Account) {
            if (obj.getId() == null) {
                obj.setId(this.accountNextId.toString());
                this.accountNextId = this.getNextId(this.accountNextId);
            }
            this.accountMap.put(obj.getId(), obj);
        } else if (obj instanceof AccountGroup) {
            if (obj.getId() == null) {
                obj.setId(this.accountGroupNextId.toString());
                this.accountGroupNextId = this.getNextId(this.accountGroupNextId);
            }
            this.accountGroupMap.put(obj.getId(), obj);
        } else if (obj instanceof TradingSystem) {
            this.tradingRepository.save((TradingSystem)obj);
        } else if (obj instanceof TradingSystemGroup) {
            this.tradingRepository.save((TradingSystemGroup)obj);
        } else if (obj instanceof Order) {
            if (obj.getId() == null) {
                obj.setId(this.orderNextId.toString());
                this.orderNextId = this.getNextId(this.orderNextId);
            }
        } else if (obj instanceof Alert && obj.getId() == null) {
            obj.setId(this.alertNextId.toString());
            this.alertNextId = this.getNextId(this.alertNextId);
        }
        super.save(obj);
    }

    @Override
    public void delete(PersistentObject obj) {
        super.delete(obj);
        if (obj instanceof Security) {
            this.historyMap.remove((Object)obj.getId());
            this.intradayHistoryMap.remove((Object)obj.getId());
            this.chartsMap.remove(obj.getId());
            File file = new File(Platform.getLocation().toFile(), "history/" + String.valueOf(obj.getId()) + ".xml");
            if (file.exists()) {
                file.delete();
            }
            if ((file = new File(Platform.getLocation().toFile(), "intraday/" + String.valueOf(obj.getId()) + ".xml")).exists()) {
                file.delete();
            }
        } else if (obj instanceof IntradayHistory) {
            this.intradayHistoryMap.remove((Object)obj.getId());
            File file = new File(Platform.getLocation().toFile(), "intraday/" + String.valueOf(obj.getId()) + ".xml");
            if (file.exists()) {
                file.delete();
            }
        } else if (obj instanceof History) {
            this.historyMap.remove((Object)obj.getId());
            File file = new File(Platform.getLocation().toFile(), "history/" + String.valueOf(obj.getId()) + ".xml");
            if (file.exists()) {
                file.delete();
            }
        } else if (obj instanceof Watchlist) {
            this.watchlistsMap.remove(obj.getId());
        } else if (obj instanceof Chart) {
            this.chartsMap.remove(obj.getId());
        } else if (obj instanceof Account) {
            this.accountMap.remove(obj.getId());
        } else if (obj instanceof AccountGroup) {
            this.accountGroupMap.remove(obj.getId());
        } else if (obj instanceof TradingSystem) {
            TradingSystem system = (TradingSystem)obj;
            if (system.getGroup() != null) {
                system.getGroup().getTradingSystems().remove(obj);
            }
            this.getTradingSystems().remove(obj);
            this.tradingRepository.tsMap.remove(obj.getId());
        } else if (obj instanceof TradingSystemGroup) {
            TradingSystemGroup group = (TradingSystemGroup)obj;
            if (group.getParent() != null) {
                group.getParent().getGroups().remove(obj);
            }
            this.getTradingSystemGroups().remove(obj);
            Object[] members = group.getTradingSystems().toArray();
            int i = 0;
            while (i < members.length) {
                this.delete((PersistentObject)members[i]);
                ++i;
            }
            members = group.getGroups().toArray();
            i = 0;
            while (i < members.length) {
                this.delete((PersistentObject)members[i]);
                ++i;
            }
            this.tradingRepository.tsGroupMap.remove(obj.getId());
        }
    }

    private Integer getNextId(Integer id) {
        return new Integer(id + 1);
    }

    private History loadHistory(String id, int chartType) {
        File file = null;
        History barData = null;
        if (chartType == 1) {
            barData = new IntradayHistory(id);
            file = new File(Platform.getLocation().toFile(), "intraday/" + id + ".xml");
        } else {
            barData = new History(id);
            file = new File(Platform.getLocation().toFile(), "history/" + id + ".xml");
        }
        if (file.exists()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setErrorHandler(this.errorHandler);
                Document document = builder.parse(file);
                barData.addAll(this.decodeBarData(document.getFirstChild().getChildNodes(), chartType));
            }
            catch (Exception e) {
                this.log.error((Object)e.toString(), (Throwable)e);
            }
        }
        barData.clearChanged();
        return barData;
    }

    private List decodeBarData(NodeList node, int chartType) {
        Integer id = new Integer(0);
        ArrayList<Bar> barData = new ArrayList<Bar>();
        int i = 0;
        while (i < node.getLength()) {
            try {
                Node dataNode = node.item(i);
                if (dataNode.getNodeName().equalsIgnoreCase("data")) {
                    id = new Integer(id + 1);
                    Bar bar = new Bar(id.toString());
                    NodeList valuesNode = dataNode.getChildNodes();
                    int ii = 0;
                    while (ii < valuesNode.getLength()) {
                        Node item = valuesNode.item(ii);
                        Node value = item.getFirstChild();
                        if (value != null) {
                            String nodeName = item.getNodeName();
                            if (nodeName.equalsIgnoreCase("open")) {
                                bar.setOpen(Double.parseDouble(value.getNodeValue()));
                            } else if (nodeName.equalsIgnoreCase("high")) {
                                bar.setHigh(Double.parseDouble(value.getNodeValue()));
                            } else if (nodeName.equalsIgnoreCase("low")) {
                                bar.setLow(Double.parseDouble(value.getNodeValue()));
                            } else if (nodeName.equalsIgnoreCase("close")) {
                                bar.setClose(Double.parseDouble(value.getNodeValue()));
                            } else if (nodeName.equalsIgnoreCase("volume")) {
                                bar.setVolume(Long.parseLong(value.getNodeValue()));
                            } else if (nodeName.equalsIgnoreCase("date")) {
                                bar.setDate(this.dateTimeFormat.parse(value.getNodeValue()));
                            }
                        }
                        ++ii;
                    }
                    Calendar today = Calendar.getInstance();
                    today.set(11, 9);
                    today.set(12, 0);
                    today.set(13, 0);
                    today.set(14, 0);
                    if (chartType == 1 && bar.getDate().after(today.getTime())) {
                        barData.add(bar);
                    } else if (chartType == 0) {
                        barData.add(bar);
                    }
                }
            }
            catch (Exception e) {
                this.log.warn((Object)e);
                e.printStackTrace();
            }
            ++i;
        }
        return barData;
    }

    private void saveHistory(History list) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setErrorHandler(this.errorHandler);
            Document document = builder.getDOMImplementation().createDocument(null, "history", null);
            Element root = document.getDocumentElement();
            this.encodeBarData(list.getList(), root, document);
            this.saveDocument(document, "history", String.valueOf(String.valueOf(list.getId())) + ".xml");
        }
        catch (Exception e) {
            this.log.error((Object)e.toString(), (Throwable)e);
        }
    }

    private void saveIntradayHistory(IntradayHistory list) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setErrorHandler(this.errorHandler);
            Document document = builder.getDOMImplementation().createDocument(null, "history", null);
            Element root = document.getDocumentElement();
            this.encodeBarData(list.getList(), root, document);
            this.saveDocument(document, "intraday", String.valueOf(String.valueOf(list.getId())) + ".xml");
        }
        catch (Exception e) {
            this.log.error((Object)e.toString(), (Throwable)e);
        }
    }

    private void encodeBarData(List list, Element root, Document document) {
        if (list != null) {
            for (Bar bar : list) {
                Element element = document.createElement("data");
                root.appendChild(element);
                Element node = document.createElement("open");
                node.appendChild(document.createTextNode(String.valueOf(bar.getOpen())));
                element.appendChild(node);
                node = document.createElement("high");
                node.appendChild(document.createTextNode(String.valueOf(bar.getHigh())));
                element.appendChild(node);
                node = document.createElement("low");
                node.appendChild(document.createTextNode(String.valueOf(bar.getLow())));
                element.appendChild(node);
                node = document.createElement("close");
                node.appendChild(document.createTextNode(String.valueOf(bar.getClose())));
                element.appendChild(node);
                node = document.createElement("volume");
                node.appendChild(document.createTextNode(String.valueOf(bar.getVolume())));
                element.appendChild(node);
                if (bar.getDate() == null) continue;
                node = document.createElement("date");
                node.appendChild(document.createTextNode(this.dateTimeFormat.format(bar.getDate())));
                element.appendChild(node);
            }
        }
    }

    private SecurityGroup loadSecurityGroup(NodeList node) {
        SecurityGroup group = new SecurityGroup(((Node)((Object)node)).getAttributes().getNamedItem("id").getNodeValue());
        int i = 0;
        while (i < node.getLength()) {
            PersistentObject obj;
            Node item = node.item(i);
            String nodeName = item.getNodeName();
            Node value = item.getFirstChild();
            if (value != null) {
                if (nodeName.equals("code")) {
                    group.setSymbol(value.getNodeValue());
                } else if (nodeName.equals("description")) {
                    group.setDescription(value.getNodeValue());
                } else if (nodeName.equals("currency")) {
                    group.setCurrency(Currency.getInstance(value.getNodeValue()));
                }
            }
            if (nodeName.equals("security")) {
                obj = this.loadSecurity(item.getChildNodes());
                ((Security)obj).setGroup(group);
                obj.setRepository(this);
                obj.clearChanged();
                this.allSecuritiesMap.put(obj.getId(), (Security)obj);
                this.allSecurities().add(obj);
                group.getSecurities().add(obj);
            } else if (nodeName.equals("group")) {
                obj = this.loadSecurityGroup(item.getChildNodes());
                ((SecurityGroup)obj).setGroup(group);
                obj.setRepository(this);
                obj.clearChanged();
                group.getGroups().add(obj);
                this.allSecurityGroups().add(obj);
            }
            ++i;
        }
        group.clearChanged();
        return group;
    }

    private Security loadSecurity(NodeList node) {
        Security security = new Security(((Node)((Object)node)).getAttributes().getNamedItem("id").getNodeValue());
        int i = 0;
        while (i < node.getLength()) {
            NamedNodeMap attributes;
            NodeList nodeList;
            Node item = node.item(i);
            String nodeName = item.getNodeName();
            Node value = item.getFirstChild();
            if (value != null) {
                if (nodeName.equals("symbol")) {
                    security.setSymbol(value.getNodeValue());
                } else if (nodeName.equals("description")) {
                    security.setDescription(value.getNodeValue());
                } else if (nodeName.equals("exchange")) {
                    security.setExchange(value.getNodeValue());
                } else if (nodeName.equals("market")) {
                    security.setMarket(value.getNodeValue());
                } else if (nodeName.equals("currency")) {
                    security.setCurrency(Currency.getInstance(value.getNodeValue()));
                } else if (nodeName.equals("sector")) {
                    security.setSector(value.getNodeValue());
                } else if (nodeName.equals("comment")) {
                    security.setComment(value.getNodeValue());
                }
            }
            if (nodeName.equals("dataCollector")) {
                security.setEnableDataCollector(new Boolean(item.getAttributes().getNamedItem("enable").getNodeValue()));
                nodeList = item.getChildNodes();
                int q = 0;
                while (q < nodeList.getLength()) {
                    String[] s;
                    item = nodeList.item(q);
                    nodeName = item.getNodeName();
                    value = item.getFirstChild();
                    if (nodeName.equals("begin")) {
                        s = value.getNodeValue().split(":");
                        security.setBeginTime(Integer.parseInt(s[0]) * 60 + Integer.parseInt(s[1]));
                    } else if (nodeName.equals("end")) {
                        s = value.getNodeValue().split(":");
                        security.setEndTime(Integer.parseInt(s[0]) * 60 + Integer.parseInt(s[1]));
                    } else if (nodeName.equals("weekdays")) {
                        security.setWeekDays(Integer.parseInt(value.getNodeValue()));
                    } else if (nodeName.equals("keepdays")) {
                        security.setKeepDays(Integer.parseInt(value.getNodeValue()));
                    }
                    ++q;
                }
            } else if (nodeName.equalsIgnoreCase("feeds")) {
                nodeList = item.getChildNodes();
                int q = 0;
                while (q < nodeList.getLength()) {
                    Node attribute;
                    FeedSource feed;
                    item = nodeList.item(q);
                    nodeName = item.getNodeName();
                    value = item.getFirstChild();
                    if (nodeName.equals("quote")) {
                        feed = new FeedSource();
                        feed.setId(item.getAttributes().getNamedItem("id").getNodeValue());
                        attribute = item.getAttributes().getNamedItem("exchange");
                        if (attribute != null) {
                            feed.setExchange(attribute.getNodeValue());
                        }
                        if (value != null) {
                            feed.setSymbol(value.getNodeValue());
                        }
                        security.setQuoteFeed(feed);
                    } else if (nodeName.equals("level2")) {
                        feed = new FeedSource();
                        feed.setId(item.getAttributes().getNamedItem("id").getNodeValue());
                        attribute = item.getAttributes().getNamedItem("exchange");
                        if (attribute != null) {
                            feed.setExchange(attribute.getNodeValue());
                        }
                        if (value != null) {
                            feed.setSymbol(value.getNodeValue());
                        }
                        security.setLevel2Feed(feed);
                    } else if (nodeName.equals("history")) {
                        feed = new FeedSource();
                        feed.setId(item.getAttributes().getNamedItem("id").getNodeValue());
                        attribute = item.getAttributes().getNamedItem("exchange");
                        if (attribute != null) {
                            feed.setExchange(attribute.getNodeValue());
                        }
                        if (value != null) {
                            feed.setSymbol(value.getNodeValue());
                        }
                        security.setHistoryFeed(feed);
                    }
                    ++q;
                }
            } else if (nodeName.equalsIgnoreCase("tradeSource")) {
                TradeSource source = new TradeSource();
                source.setTradingProviderId(item.getAttributes().getNamedItem("id").getNodeValue());
                Node attribute = item.getAttributes().getNamedItem("exchange");
                if (attribute != null) {
                    source.setExchange(attribute.getNodeValue());
                }
                NodeList quoteList = item.getChildNodes();
                int q = 0;
                while (q < quoteList.getLength()) {
                    item = quoteList.item(q);
                    nodeName = item.getNodeName();
                    value = item.getFirstChild();
                    if (value != null) {
                        if (nodeName.equalsIgnoreCase("symbol")) {
                            source.setSymbol(value.getNodeValue());
                        } else if (nodeName.equalsIgnoreCase("account")) {
                            source.setAccountId(new Integer(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("quantity")) {
                            source.setQuantity(Integer.parseInt(value.getNodeValue()));
                        }
                    }
                    ++q;
                }
                security.setTradeSource(source);
            } else if (nodeName.equalsIgnoreCase("quote")) {
                Quote quote = new Quote();
                NodeList quoteList = item.getChildNodes();
                int q = 0;
                while (q < quoteList.getLength()) {
                    item = quoteList.item(q);
                    nodeName = item.getNodeName();
                    value = item.getFirstChild();
                    if (value != null) {
                        if (nodeName.equalsIgnoreCase("date")) {
                            try {
                                quote.setDate(this.dateTimeFormat.parse(value.getNodeValue()));
                            }
                            catch (Exception e) {
                                this.log.warn((Object)e.toString());
                            }
                        } else if (nodeName.equalsIgnoreCase("last")) {
                            quote.setLast(Double.parseDouble(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("bid")) {
                            quote.setBid(Double.parseDouble(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("ask")) {
                            quote.setAsk(Double.parseDouble(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("bidSize")) {
                            quote.setBidSize(Integer.parseInt(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("askSize")) {
                            quote.setAskSize(Integer.parseInt(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("volume")) {
                            quote.setVolume(Long.parseLong(value.getNodeValue()));
                        }
                    }
                    ++q;
                }
                security.setQuote(quote);
            } else if (nodeName.equalsIgnoreCase("data")) {
                NodeList dataList = item.getChildNodes();
                int q = 0;
                while (q < dataList.getLength()) {
                    item = dataList.item(q);
                    nodeName = item.getNodeName();
                    value = item.getFirstChild();
                    if (value != null) {
                        if (nodeName.equalsIgnoreCase("open")) {
                            security.setOpen(new Double(Double.parseDouble(value.getNodeValue())));
                        } else if (nodeName.equalsIgnoreCase("high")) {
                            security.setHigh(new Double(Double.parseDouble(value.getNodeValue())));
                        } else if (nodeName.equalsIgnoreCase("low")) {
                            security.setLow(new Double(Double.parseDouble(value.getNodeValue())));
                        } else if (nodeName.equalsIgnoreCase("close")) {
                            security.setClose(new Double(Double.parseDouble(value.getNodeValue())));
                        } else if (nodeName.equalsIgnoreCase("currentIndex")) {
                            security.setCurrentIndex(new Double(Double.parseDouble(value.getNodeValue())));
                        } else if (nodeName.equalsIgnoreCase("up")) {
                            security.setUp(Integer.parseInt(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("down")) {
                            security.setDown(Integer.parseInt(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("equal")) {
                            security.setEqual(Integer.parseInt(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("totalTrades")) {
                            security.setTotalTrades(Integer.parseInt(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("monetaryValue")) {
                            security.setMonetaryValue(Long.parseLong(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("totalTurnover")) {
                            security.setTotalTurnover(Integer.parseInt(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("lotSize")) {
                            security.setLotSize(Integer.parseInt(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("maximumVolume")) {
                            security.setMaximumVolume(Integer.parseInt(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("maximumValue")) {
                            security.setMaximumValue(Double.parseDouble(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("change")) {
                            security.setChange(Double.parseDouble(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("changePercent")) {
                            security.setChangePerc(Double.parseDouble(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("spot")) {
                            security.setSpot(value.getNodeValue());
                        } else if (nodeName.equalsIgnoreCase("spotFrom")) {
                            try {
                                security.setSpotFrom(this.dateFormat.parse(value.getNodeValue()));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else if (nodeName.equalsIgnoreCase("spotTo")) {
                            try {
                                security.setSpotTo(this.dateFormat.parse(value.getNodeValue()));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else if (nodeName.equalsIgnoreCase("average")) {
                            security.setAverage(Float.parseFloat(value.getNodeValue()));
                        }
                    }
                    ++q;
                }
            } else if (nodeName.equalsIgnoreCase("SymbolStats")) {
                SymbolStatisticsData stats = new SymbolStatisticsData(security.getSymbol());
                NodeList dataList = item.getChildNodes();
                int l = 0;
                while (l < dataList.getLength()) {
                    item = dataList.item(l);
                    nodeName = item.getNodeName();
                    value = item.getFirstChild();
                    if (value != null && value != null) {
                        if (nodeName.equalsIgnoreCase("LastPricePrev")) {
                            stats.setPrevClose(Double.parseDouble(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("TurnOverPrev")) {
                            stats.setPrevTurnover(Long.parseLong(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("ChangePrev")) {
                            stats.setPrevChange(Double.parseDouble(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("LowPrev")) {
                            stats.setPrevLow(Double.parseDouble(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("HighPrev")) {
                            stats.setPrevHigh(Double.parseDouble(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("DatePrev")) {
                            try {
                                stats.setPrevDate(this.dateFormat.parse(value.getNodeValue()));
                            }
                            catch (Exception exception) {}
                        } else if (nodeName.equalsIgnoreCase("Low1Month")) {
                            stats.setLow1Month(Float.parseFloat(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("High1Month")) {
                            stats.setHigh1Month(Float.parseFloat(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("Low3Month")) {
                            stats.setLow3Month(Float.parseFloat(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("High3Month")) {
                            stats.setHigh3Month(Float.parseFloat(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("Low6Month")) {
                            stats.setLow6Month(Float.parseFloat(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("High6Month")) {
                            stats.setHigh6Month(Float.parseFloat(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("Low12Month")) {
                            stats.setLow12Month(Float.parseFloat(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("High12Month")) {
                            stats.setHigh12Month(Float.parseFloat(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("AvgPrice1Month")) {
                            stats.setAvgPrice1Month(Float.parseFloat(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("AvgPrice3Month")) {
                            stats.setAvgPrice3Month(Float.parseFloat(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("AvgPrice6Month")) {
                            stats.setAvgPrice6Month(Float.parseFloat(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("AvgPrice12Month")) {
                            stats.setAvgPrice12Month(Float.parseFloat(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("AvgVol1Month")) {
                            stats.setAvgVol1Month(Float.parseFloat(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("AvgVol3Month")) {
                            stats.setAvgVol3Month(Float.parseFloat(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("AvgVol6Month")) {
                            stats.setAvgVol6Month(Float.parseFloat(value.getNodeValue()));
                        } else if (nodeName.equalsIgnoreCase("AvgVol12Month")) {
                            stats.setAvgVol12Month(Float.parseFloat(value.getNodeValue()));
                        }
                    }
                    ++l;
                }
                security.setSymbolStatistics(stats);
            } else if (nodeName.equalsIgnoreCase("split")) {
                attributes = item.getAttributes();
                Split split = new Split();
                try {
                    split.setDate(this.dateTimeFormat.parse(attributes.getNamedItem("date").getNodeValue()));
                    split.setFromQuantity(Integer.parseInt(attributes.getNamedItem("fromQuantity").getNodeValue()));
                    split.setToQuantity(Integer.parseInt(attributes.getNamedItem("toQuantity").getNodeValue()));
                    security.getSplits().add(split);
                }
                catch (Exception e) {
                    this.log.error((Object)e.toString());
                }
            } else if (nodeName.equalsIgnoreCase("dividend")) {
                attributes = item.getAttributes();
                Dividend dividend = new Dividend();
                try {
                    dividend.setDate(this.dateTimeFormat.parse(attributes.getNamedItem("date").getNodeValue()));
                    dividend.setValue(new Double(Double.parseDouble(attributes.getNamedItem("value").getNodeValue())));
                    security.getDividends().add(dividend);
                }
                catch (Exception e) {
                    this.log.error((Object)e.toString());
                }
            }
            ++i;
        }
        security.clearChanged();
        security.getQuoteMonitor().clearChanged();
        security.getLevel2Monitor().clearChanged();
        return security;
    }

    private Security loadSecurityFromJSON(JsonObject item) {
        String id = item.get("id").getAsString();
        Security security = new Security(id);
        String symbol = item.get("symbol").getAsString();
        if (symbol != null && !"".equalsIgnoreCase(symbol)) {
            block209: {
                block208: {
                    block207: {
                        block206: {
                            block205: {
                                block204: {
                                    block201: {
                                        block200: {
                                            security.setSymbol(symbol);
                                            try {
                                                String description = item.get("description").getAsString();
                                                security.setDescription(description);
                                            }
                                            catch (Exception exception) {}
                                            try {
                                                String exchange = item.get("exchange").getAsString();
                                                security.setExchange(exchange);
                                            }
                                            catch (Exception exception) {}
                                            try {
                                                String market = item.get("market").getAsString();
                                                security.setMarket(market);
                                            }
                                            catch (Exception exception) {}
                                            try {
                                                String currency = item.get("currency").getAsString();
                                                if (currency != null && !"".equalsIgnoreCase(currency)) {
                                                    security.setCurrency(Currency.getInstance(currency));
                                                }
                                            }
                                            catch (Exception exception) {}
                                            try {
                                                String sector = item.get("sector").getAsString();
                                                security.setSector(sector);
                                            }
                                            catch (Exception exception) {}
                                            try {
                                                String comment = item.get("comment").getAsString();
                                                security.setComment(comment);
                                            }
                                            catch (Exception exception) {}
                                            try {
                                                String[] s;
                                                JsonObject jsonCollector = item.getAsJsonObject("dataCollector");
                                                if (jsonCollector == null) break block200;
                                                try {
                                                    boolean enable = jsonCollector.get("enable").getAsBoolean();
                                                    security.setEnableDataCollector(enable);
                                                }
                                                catch (Exception exception) {}
                                                try {
                                                    String begin = jsonCollector.get("begin").getAsString();
                                                    if (begin != null && !"".equalsIgnoreCase(begin)) {
                                                        s = begin.split(":");
                                                        security.setBeginTime(Integer.parseInt(s[0]) * 60 + Integer.parseInt(s[1]));
                                                    }
                                                }
                                                catch (Exception exception) {}
                                                try {
                                                    String end = jsonCollector.get("end").getAsString();
                                                    if (end != null && !"".equalsIgnoreCase(end)) {
                                                        s = end.split(":");
                                                        security.setEndTime(Integer.parseInt(s[0]) * 60 + Integer.parseInt(s[1]));
                                                    }
                                                }
                                                catch (Exception exception) {}
                                                try {
                                                    int weekdays = jsonCollector.get("weekdays").getAsInt();
                                                    security.setWeekDays(weekdays);
                                                }
                                                catch (Exception exception) {}
                                                try {
                                                    int keepdays = jsonCollector.get("keepdays").getAsInt();
                                                    security.setKeepDays(keepdays);
                                                }
                                                catch (Exception exception) {}
                                            }
                                            catch (Exception exception) {}
                                        }
                                        try {
                                            FeedSource feed;
                                            JsonObject jsonFeeds;
                                            block203: {
                                                block202: {
                                                    jsonFeeds = item.getAsJsonObject("feeds");
                                                    if (jsonFeeds == null) break block201;
                                                    try {
                                                        JsonObject jsonQuote = jsonFeeds.getAsJsonObject("quote");
                                                        if (jsonQuote == null) break block202;
                                                        feed = new FeedSource();
                                                        try {
                                                            String idQuote = jsonQuote.get("id").getAsString();
                                                            feed.setId(idQuote);
                                                        }
                                                        catch (Exception exception) {}
                                                        try {
                                                            String exchQuote = jsonQuote.get("exchange").getAsString();
                                                            feed.setExchange(exchQuote);
                                                        }
                                                        catch (Exception exception) {}
                                                        try {
                                                            String symbolQuote = jsonQuote.get("symbol").getAsString();
                                                            feed.setSymbol(symbolQuote);
                                                        }
                                                        catch (Exception exception) {}
                                                        security.setQuoteFeed(feed);
                                                    }
                                                    catch (Exception exception) {}
                                                }
                                                try {
                                                    JsonObject jsonLevel2 = jsonFeeds.getAsJsonObject("level2");
                                                    if (jsonLevel2 == null) break block203;
                                                    feed = new FeedSource();
                                                    try {
                                                        String idl2 = jsonLevel2.get("id").getAsString();
                                                        feed.setId(idl2);
                                                    }
                                                    catch (Exception exception) {}
                                                    try {
                                                        String exchl2 = jsonLevel2.get("exchange").getAsString();
                                                        feed.setExchange(exchl2);
                                                    }
                                                    catch (Exception exception) {}
                                                    try {
                                                        String symboll2 = jsonLevel2.get("symbol").getAsString();
                                                        feed.setSymbol(symboll2);
                                                    }
                                                    catch (Exception exception) {}
                                                    security.setLevel2Feed(feed);
                                                }
                                                catch (Exception exception) {}
                                            }
                                            try {
                                                JsonObject jsonHistory = jsonFeeds.getAsJsonObject("history");
                                                if (jsonHistory == null) break block201;
                                                feed = new FeedSource();
                                                try {
                                                    String idHist = jsonHistory.get("id").getAsString();
                                                    feed.setId(idHist);
                                                }
                                                catch (Exception exception) {}
                                                try {
                                                    String exchHist = jsonHistory.get("exchange").getAsString();
                                                    feed.setExchange(exchHist);
                                                }
                                                catch (Exception exception) {}
                                                try {
                                                    String symbolHist = jsonHistory.get("symbol").getAsString();
                                                    feed.setSymbol(symbolHist);
                                                }
                                                catch (Exception exception) {}
                                                security.setHistoryFeed(feed);
                                            }
                                            catch (Exception exception) {}
                                        }
                                        catch (Exception exception) {}
                                    }
                                    try {
                                        JsonObject jsonTradeSource = item.getAsJsonObject("tradeSource");
                                        if (jsonTradeSource == null) break block204;
                                        TradeSource source = new TradeSource();
                                        try {
                                            String idTrade = jsonTradeSource.get("id").getAsString();
                                            source.setTradingProviderId(idTrade);
                                        }
                                        catch (Exception exception) {}
                                        try {
                                            String exchTrade = jsonTradeSource.get("exchange").getAsString();
                                            source.setExchange(exchTrade);
                                        }
                                        catch (Exception exception) {}
                                        try {
                                            String symbolTrade = jsonTradeSource.get("symbol").getAsString();
                                            source.setSymbol(symbolTrade);
                                        }
                                        catch (Exception exception) {}
                                        try {
                                            int accountTrade = jsonTradeSource.get("account").getAsInt();
                                            source.setAccountId(accountTrade);
                                        }
                                        catch (Exception exception) {}
                                        try {
                                            int quantityTrade = jsonTradeSource.get("quantity").getAsInt();
                                            source.setQuantity(quantityTrade);
                                        }
                                        catch (Exception exception) {}
                                        security.setTradeSource(source);
                                    }
                                    catch (Exception exception) {}
                                }
                                try {
                                    JsonObject jsonQuote = item.getAsJsonObject("quote");
                                    if (jsonQuote == null) break block205;
                                    Quote quote = new Quote();
                                    try {
                                        String dateQuote = jsonQuote.get("date").getAsString();
                                        if (dateQuote != null && !"".equalsIgnoreCase(dateQuote)) {
                                            try {
                                                quote.setDate(this.dateTimeFormat.parse(dateQuote));
                                            }
                                            catch (ParseException parseException) {}
                                        }
                                    }
                                    catch (Exception exception) {}
                                    try {
                                        double bidQuote = jsonQuote.get("bid").getAsDouble();
                                        quote.setBid(bidQuote);
                                    }
                                    catch (Exception exception) {}
                                    try {
                                        double askQuote = jsonQuote.get("ask").getAsDouble();
                                        quote.setAsk(askQuote);
                                    }
                                    catch (Exception exception) {}
                                    try {
                                        int bidSizeQuote = jsonQuote.get("bidSize").getAsInt();
                                        quote.setBidSize(bidSizeQuote);
                                    }
                                    catch (Exception exception) {}
                                    try {
                                        double askSizeQuote = jsonQuote.get("askSize").getAsInt();
                                        quote.setBid(askSizeQuote);
                                    }
                                    catch (Exception exception) {}
                                    try {
                                        Long volumeQuote = jsonQuote.get("volume").getAsLong();
                                        quote.setBid(volumeQuote.longValue());
                                    }
                                    catch (Exception exception) {}
                                    security.setQuote(quote);
                                }
                                catch (Exception exception) {}
                            }
                            try {
                                JsonObject jsonData = item.getAsJsonObject("data");
                                if (jsonData == null) break block206;
                                try {
                                    double openData = jsonData.get("open").getAsDouble();
                                    security.setOpen(openData);
                                }
                                catch (Exception exception) {}
                                try {
                                    double highData = jsonData.get("high").getAsDouble();
                                    security.setHigh(highData);
                                }
                                catch (Exception exception) {}
                                try {
                                    double lowData = jsonData.get("low").getAsDouble();
                                    security.setLow(lowData);
                                }
                                catch (Exception exception) {}
                                try {
                                    double closeData = jsonData.get("close").getAsDouble();
                                    security.setClose(closeData);
                                }
                                catch (Exception exception) {}
                                try {
                                    double currentIndexData = jsonData.get("currentIndex").getAsDouble();
                                    security.setCurrentIndex(currentIndexData);
                                }
                                catch (Exception exception) {}
                                try {
                                    Long upData = jsonData.get("up").getAsLong();
                                    security.setUp(upData);
                                }
                                catch (Exception exception) {}
                                try {
                                    Long downData = jsonData.get("down").getAsLong();
                                    security.setDown(downData);
                                }
                                catch (Exception exception) {}
                                try {
                                    int equalData = jsonData.get("equal").getAsInt();
                                    security.setEqual(equalData);
                                }
                                catch (Exception exception) {}
                                try {
                                    int totalTradesData = jsonData.get("totalTrades").getAsInt();
                                    security.setTotalTrades(totalTradesData);
                                }
                                catch (Exception exception) {}
                                try {
                                    int monetaryData = jsonData.get("monetaryValue").getAsInt();
                                    security.setMonetaryValue(monetaryData);
                                }
                                catch (Exception exception) {}
                                try {
                                    int totalTurnoverData = jsonData.get("totalTurnover").getAsInt();
                                    security.setTotalTurnover(totalTurnoverData);
                                }
                                catch (Exception exception) {}
                                try {
                                    int lotSizeData = jsonData.get("lotSize").getAsInt();
                                    security.setLotSize(lotSizeData);
                                }
                                catch (Exception exception) {}
                                try {
                                    int maximumVolumeData = jsonData.get("maximumVolume").getAsInt();
                                    security.setMaximumVolume(maximumVolumeData);
                                }
                                catch (Exception exception) {}
                                try {
                                    Double changeData = jsonData.get("change").getAsDouble();
                                    security.setChange(changeData);
                                }
                                catch (Exception exception) {}
                                try {
                                    Double changePercentData = jsonData.get("changePercent").getAsDouble();
                                    security.setChangePerc(changePercentData);
                                }
                                catch (Exception exception) {}
                                try {
                                    String spotData = jsonData.get("spot").getAsString();
                                    security.setSpot(spotData);
                                }
                                catch (Exception exception) {}
                                try {
                                    String spotFromData = jsonData.get("spotFrom").getAsString();
                                    if (spotFromData != null && !"".equalsIgnoreCase(spotFromData)) {
                                        try {
                                            security.setSpotFrom(this.dateFormat.parse(spotFromData));
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                                catch (Exception exception) {}
                                try {
                                    String spotToData = jsonData.get("spotTo").getAsString();
                                    if (spotToData != null && !"".equalsIgnoreCase(spotToData)) {
                                        try {
                                            security.setSpotTo(this.dateFormat.parse(spotToData));
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                                catch (Exception exception) {}
                                try {
                                    float averageData = jsonData.get("average").getAsFloat();
                                    security.setAverage(averageData);
                                }
                                catch (Exception exception) {}
                            }
                            catch (Exception exception) {}
                        }
                        try {
                            JsonObject jsonSymbolStats = item.getAsJsonObject("SymbolStats");
                            if (jsonSymbolStats == null) break block207;
                            SymbolStatisticsData stats = new SymbolStatisticsData(security.getSymbol());
                            try {
                                double LastPricePrevStats = jsonSymbolStats.get("LastPricePrev").getAsDouble();
                                stats.setPrevClose(LastPricePrevStats);
                            }
                            catch (Exception exception) {}
                            try {
                                long TurnOverPrevStats = jsonSymbolStats.get("TurnOverPrev").getAsLong();
                                stats.setPrevTurnover(TurnOverPrevStats);
                            }
                            catch (Exception exception) {}
                            try {
                                double ChangePrevStats = jsonSymbolStats.get("ChangePrev").getAsDouble();
                                stats.setPrevChange(ChangePrevStats);
                            }
                            catch (Exception exception) {}
                            try {
                                double LowPrevStats = jsonSymbolStats.get("LowPrev").getAsDouble();
                                stats.setPrevLow(LowPrevStats);
                            }
                            catch (Exception exception) {}
                            try {
                                double HighPrevStats = jsonSymbolStats.get("HighPrev").getAsDouble();
                                stats.setPrevHigh(HighPrevStats);
                            }
                            catch (Exception exception) {}
                            try {
                                String DatePrevData = jsonSymbolStats.get("DatePrev").getAsString();
                                if (DatePrevData != null && !"".equalsIgnoreCase(DatePrevData)) {
                                    try {
                                        stats.setPrevDate(this.dateFormat.parse(DatePrevData));
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                            catch (Exception exception) {}
                            try {
                                float Low1MonthStats = jsonSymbolStats.get("Low1Month").getAsFloat();
                                stats.setLow1Month(Low1MonthStats);
                            }
                            catch (Exception exception) {}
                            try {
                                float High1MonthStats = jsonSymbolStats.get("High1Month").getAsFloat();
                                stats.setHigh1Month(High1MonthStats);
                            }
                            catch (Exception exception) {}
                            try {
                                float Low3MonthStats = jsonSymbolStats.get("Low3Month").getAsFloat();
                                stats.setLow3Month(Low3MonthStats);
                            }
                            catch (Exception exception) {}
                            try {
                                float High3MonthStats = jsonSymbolStats.get("High3Month").getAsFloat();
                                stats.setHigh3Month(High3MonthStats);
                            }
                            catch (Exception exception) {}
                            try {
                                float Low6MonthStats = jsonSymbolStats.get("Low6Month").getAsFloat();
                                stats.setLow6Month(Low6MonthStats);
                            }
                            catch (Exception exception) {}
                            try {
                                float High6MonthStats = jsonSymbolStats.get("High6Month").getAsFloat();
                                stats.setHigh6Month(High6MonthStats);
                            }
                            catch (Exception exception) {}
                            try {
                                float Low12MonthStats = jsonSymbolStats.get("Low12Month").getAsFloat();
                                stats.setLow12Month(Low12MonthStats);
                            }
                            catch (Exception exception) {}
                            try {
                                float High12MonthStats = jsonSymbolStats.get("High12Month").getAsFloat();
                                stats.setHigh12Month(High12MonthStats);
                            }
                            catch (Exception exception) {}
                            try {
                                float AvgPrice1MonthStats = jsonSymbolStats.get("AvgPrice1Month").getAsFloat();
                                stats.setAvgPrice1Month(AvgPrice1MonthStats);
                            }
                            catch (Exception exception) {}
                            try {
                                float AvgPrice3MonthStats = jsonSymbolStats.get("AvgPrice3Month").getAsFloat();
                                stats.setAvgPrice3Month(AvgPrice3MonthStats);
                            }
                            catch (Exception exception) {}
                            try {
                                float AvgPrice6MonthStats = jsonSymbolStats.get("AvgPrice6Month").getAsFloat();
                                stats.setAvgPrice6Month(AvgPrice6MonthStats);
                            }
                            catch (Exception exception) {}
                            try {
                                float AvgPrice12MonthStats = jsonSymbolStats.get("AvgPrice12Month").getAsFloat();
                                stats.setAvgPrice12Month(AvgPrice12MonthStats);
                            }
                            catch (Exception exception) {}
                            try {
                                float AvgVol1MonthStats = jsonSymbolStats.get("AvgVol1Month").getAsFloat();
                                stats.setAvgVol1Month(AvgVol1MonthStats);
                            }
                            catch (Exception exception) {}
                            try {
                                float AvgVol3MonthStats = jsonSymbolStats.get("AvgVol3Month").getAsFloat();
                                stats.setAvgVol3Month(AvgVol3MonthStats);
                            }
                            catch (Exception exception) {}
                            try {
                                float AvgVol6MonthStats = jsonSymbolStats.get("AvgVol6Month").getAsFloat();
                                stats.setAvgVol6Month(AvgVol6MonthStats);
                            }
                            catch (Exception exception) {}
                            try {
                                float AvgVol12MonthStats = jsonSymbolStats.get("AvgVol12Month").getAsFloat();
                                stats.setAvgVol12Month(AvgVol12MonthStats);
                            }
                            catch (Exception exception) {}
                            try {
                                security.setSymbolStatistics(stats);
                            }
                            catch (Exception exception) {}
                        }
                        catch (Exception exception) {}
                    }
                    try {
                        JsonObject jsonSplit = item.getAsJsonObject("split");
                        if (jsonSplit == null) break block208;
                        Split split = new Split();
                        try {
                            String dateSplit = jsonSplit.get("date").getAsString();
                            if (dateSplit != null && !"".equalsIgnoreCase(dateSplit)) {
                                try {
                                    split.setDate(this.dateFormat.parse(dateSplit));
                                }
                                catch (Exception exception) {}
                            }
                        }
                        catch (Exception exception) {}
                        try {
                            int fromQuantitySplit = jsonSplit.get("fromQuantity").getAsInt();
                            split.setFromQuantity(fromQuantitySplit);
                        }
                        catch (Exception exception) {}
                        try {
                            int toQuantitySplit = jsonSplit.get("toQuantity").getAsInt();
                            split.setToQuantity(toQuantitySplit);
                        }
                        catch (Exception exception) {}
                        security.getSplits().add(split);
                    }
                    catch (Exception exception) {}
                }
                try {
                    JsonObject jsondDividend = item.getAsJsonObject("dividend");
                    if (jsondDividend == null) break block209;
                    Dividend dividend = new Dividend();
                    try {
                        String dateDividend = jsondDividend.get("date").getAsString();
                        if (dateDividend != null && !"".equalsIgnoreCase(dateDividend)) {
                            try {
                                dividend.setDate(this.dateFormat.parse(dateDividend));
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        Double valueDividend = jsondDividend.get("value").getAsDouble();
                        dividend.setValue(valueDividend);
                        security.getDividends().add(dividend);
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {}
            }
            security.clearChanged();
            security.getQuoteMonitor().clearChanged();
            security.getLevel2Monitor().clearChanged();
            return security;
        }
        return null;
    }

    private void saveSecurityGroup(SecurityGroup group, Document document, Element root) {
        Element element = document.createElement("group");
        element.setAttribute("id", String.valueOf(group.getId()));
        root.appendChild(element);
        Element node = document.createElement("code");
        node.appendChild(document.createTextNode(group.getSymbol()));
        element.appendChild(node);
        node = document.createElement("description");
        node.appendChild(document.createTextNode(group.getDescription()));
        element.appendChild(node);
        if (group.getCurrency() != null) {
            node = document.createElement("currency");
            node.appendChild(document.createTextNode(group.getCurrency().getCurrencyCode()));
            element.appendChild(node);
        }
        Iterator iter = group.getSecurities().iterator();
        while (iter.hasNext()) {
            this.saveSecurity((Security)iter.next(), document, element);
        }
        iter = group.getGroups().iterator();
        while (iter.hasNext()) {
            this.saveSecurityGroup((SecurityGroup)iter.next(), document, element);
        }
    }

    private void saveSecurity(Security security, Document document, Element root) {
        Element element1;
        Element element = document.createElement("security");
        element.setAttribute("id", String.valueOf(security.getId()));
        root.appendChild(element);
        if (security.getExchange() != null) {
            element1 = document.createElement("exchange");
            element1.appendChild(document.createTextNode(security.getExchange()));
            element.appendChild(element1);
        }
        if (security.getSymbol() != null) {
            element1 = document.createElement("symbol");
            element1.appendChild(document.createTextNode(security.getSymbol()));
            element.appendChild(element1);
        }
        if (security.getMarket() != null) {
            element1 = document.createElement("market");
            element1.appendChild(document.createTextNode(security.getMarket()));
            element.appendChild(element1);
        }
        if (security.getDescription() != null) {
            element1 = document.createElement("description");
            element1.appendChild(document.createTextNode(security.getDescription()));
            element.appendChild(element1);
        }
        if (security.getCurrency() != null) {
            element1 = document.createElement("currency");
            element1.appendChild(document.createTextNode(security.getCurrency().getCurrencyCode()));
            element.appendChild(element1);
        }
        if (security.getSector() != null) {
            element1 = document.createElement("sector");
            element1.appendChild(document.createTextNode(security.getSector()));
            element.appendChild(element1);
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMinimumIntegerDigits(2);
        nf.setMinimumFractionDigits(0);
        nf.setMaximumFractionDigits(0);
        Element collectorNode = document.createElement("dataCollector");
        collectorNode.setAttribute("enable", String.valueOf(security.isEnableDataCollector()));
        element.appendChild(collectorNode);
        Element node = document.createElement("begin");
        node.appendChild(document.createTextNode(String.valueOf(String.valueOf(nf.format(security.getBeginTime() / 60))) + ":" + nf.format(security.getBeginTime() % 60)));
        collectorNode.appendChild(node);
        node = document.createElement("end");
        node.appendChild(document.createTextNode(String.valueOf(String.valueOf(nf.format(security.getEndTime() / 60))) + ":" + nf.format(security.getEndTime() % 60)));
        collectorNode.appendChild(node);
        node = document.createElement("weekdays");
        node.appendChild(document.createTextNode(String.valueOf(security.getWeekDays())));
        collectorNode.appendChild(node);
        node = document.createElement("keepdays");
        node.appendChild(document.createTextNode(String.valueOf(security.getKeepDays())));
        collectorNode.appendChild(node);
        if (security.getQuoteFeed() != null || security.getLevel2Feed() != null || security.getHistoryFeed() != null) {
            Element feedsNode = document.createElement("feeds");
            element.appendChild(feedsNode);
            if (security.getQuoteFeed() != null) {
                node = document.createElement("quote");
                node.setAttribute("id", security.getQuoteFeed().getId());
                if (security.getQuoteFeed().getExchange() != null) {
                    node.setAttribute("exchange", security.getQuoteFeed().getExchange());
                }
                node.appendChild(document.createTextNode(security.getQuoteFeed().getSymbol()));
                feedsNode.appendChild(node);
            }
            if (security.getLevel2Feed() != null) {
                node = document.createElement("level2");
                node.setAttribute("id", security.getLevel2Feed().getId());
                if (security.getLevel2Feed().getExchange() != null) {
                    node.setAttribute("exchange", security.getLevel2Feed().getExchange());
                }
                node.appendChild(document.createTextNode(security.getLevel2Feed().getSymbol()));
                feedsNode.appendChild(node);
            }
            if (security.getHistoryFeed() != null) {
                node = document.createElement("history");
                node.setAttribute("id", security.getHistoryFeed().getId());
                if (security.getHistoryFeed().getExchange() != null) {
                    node.setAttribute("exchange", security.getHistoryFeed().getExchange());
                }
                node.appendChild(document.createTextNode(security.getHistoryFeed().getSymbol()));
                feedsNode.appendChild(node);
            }
        }
        if (security.getTradeSource() != null) {
            TradeSource source = security.getTradeSource();
            Element feedsNode = document.createElement("tradeSource");
            feedsNode.setAttribute("id", source.getTradingProviderId());
            if (source.getExchange() != null) {
                feedsNode.setAttribute("exchange", source.getExchange());
            }
            element.appendChild(feedsNode);
            if (!source.getSymbol().equals("")) {
                node = document.createElement("symbol");
                node.appendChild(document.createTextNode(source.getSymbol()));
                feedsNode.appendChild(node);
            }
            if (source.getAccountId() != null) {
                node = document.createElement("account");
                node.appendChild(document.createTextNode(String.valueOf(source.getAccountId())));
                feedsNode.appendChild(node);
            }
            node = document.createElement("quantity");
            node.appendChild(document.createTextNode(String.valueOf(source.getQuantity())));
            feedsNode.appendChild(node);
        }
        if (security.getQuote() != null) {
            Quote quote = security.getQuote();
            Element quoteNode = document.createElement("quote");
            if (quote.getDate() != null) {
                node = document.createElement("date");
                node.appendChild(document.createTextNode(this.dateTimeFormat.format(quote.getDate())));
                quoteNode.appendChild(node);
            }
            node = document.createElement("last");
            node.appendChild(document.createTextNode(String.valueOf(quote.getLast())));
            quoteNode.appendChild(node);
            node = document.createElement("bid");
            node.appendChild(document.createTextNode(String.valueOf(quote.getBid())));
            quoteNode.appendChild(node);
            node = document.createElement("ask");
            node.appendChild(document.createTextNode(String.valueOf(quote.getAsk())));
            quoteNode.appendChild(node);
            node = document.createElement("bidSize");
            node.appendChild(document.createTextNode(String.valueOf(quote.getBidSize())));
            quoteNode.appendChild(node);
            node = document.createElement("askSize");
            node.appendChild(document.createTextNode(String.valueOf(quote.getAskSize())));
            quoteNode.appendChild(node);
            node = document.createElement("volume");
            node.appendChild(document.createTextNode(String.valueOf(quote.getVolume())));
            quoteNode.appendChild(node);
            element.appendChild(quoteNode);
        }
        Element dataNode = document.createElement("data");
        element.appendChild(dataNode);
        if (security.getOpen() != null) {
            node = document.createElement("open");
            node.appendChild(document.createTextNode(String.valueOf(security.getOpen())));
            dataNode.appendChild(node);
        }
        if (security.getHigh() != null) {
            node = document.createElement("high");
            node.appendChild(document.createTextNode(String.valueOf(security.getHigh())));
            dataNode.appendChild(node);
        }
        if (security.getLow() != null) {
            node = document.createElement("low");
            node.appendChild(document.createTextNode(String.valueOf(security.getLow())));
            dataNode.appendChild(node);
        }
        if (security.getClose() != null) {
            node = document.createElement("close");
            node.appendChild(document.createTextNode(String.valueOf(security.getClose())));
            dataNode.appendChild(node);
        }
        if (security.getCurrentIndex() != null) {
            node = document.createElement("currentIndex");
            node.appendChild(document.createTextNode(String.valueOf(security.getCurrentIndex())));
            dataNode.appendChild(node);
        }
        node = document.createElement("up");
        node.appendChild(document.createTextNode(String.valueOf(security.getUp())));
        dataNode.appendChild(node);
        node = document.createElement("down");
        node.appendChild(document.createTextNode(String.valueOf(security.getDown())));
        dataNode.appendChild(node);
        node = document.createElement("equal");
        node.appendChild(document.createTextNode(String.valueOf(security.getEqual())));
        dataNode.appendChild(node);
        node = document.createElement("totalTrades");
        node.appendChild(document.createTextNode(String.valueOf(security.getTotalTrades())));
        dataNode.appendChild(node);
        node = document.createElement("totalTurnover");
        node.appendChild(document.createTextNode(String.valueOf(security.getTotalTurnover())));
        dataNode.appendChild(node);
        node = document.createElement("monetaryValue");
        node.appendChild(document.createTextNode(String.valueOf(security.getMonetaryValue())));
        dataNode.appendChild(node);
        node = document.createElement("lotSize");
        node.appendChild(document.createTextNode(String.valueOf(security.getLotSize())));
        dataNode.appendChild(node);
        node = document.createElement("maximumVolume");
        node.appendChild(document.createTextNode(String.valueOf(security.getMaximumVolume())));
        dataNode.appendChild(node);
        node = document.createElement("maximumValue");
        node.appendChild(document.createTextNode(String.valueOf(security.getMaximumValue())));
        dataNode.appendChild(node);
        node = document.createElement("change");
        node.appendChild(document.createTextNode(String.valueOf(security.getChange())));
        dataNode.appendChild(node);
        node = document.createElement("changePercent");
        node.appendChild(document.createTextNode(String.valueOf(security.getChangePerc())));
        dataNode.appendChild(node);
        node = document.createElement("spot");
        node.appendChild(document.createTextNode(XMLRepository.getValueOrDefaultString(security.getSpot(), "0")));
        dataNode.appendChild(node);
        if (security.getSpotFrom() != null) {
            node = document.createElement("spotFrom");
            node.appendChild(document.createTextNode(this.dateFormat.format(security.getSpotFrom())));
            dataNode.appendChild(node);
        }
        if (security.getSpotTo() != null) {
            node = document.createElement("spotTo");
            node.appendChild(document.createTextNode(this.dateFormat.format(security.getSpotTo())));
            dataNode.appendChild(node);
        }
        node = document.createElement("average");
        node.appendChild(document.createTextNode(String.valueOf(security.getAverage())));
        dataNode.appendChild(node);
        if (security.getComment() != null) {
            node = document.createElement("comment");
            node.appendChild(document.createTextNode(security.getComment()));
            element.appendChild(node);
        }
        Element statsNode = document.createElement("SymbolStats");
        element.appendChild(statsNode);
        if (security.getSymbolStatistics() != null) {
            SymbolStatisticsData stats = security.getSymbolStatistics();
            node = document.createElement("LastPricePrev");
            node.appendChild(document.createTextNode(String.valueOf(stats.getPrevClose())));
            statsNode.appendChild(node);
            node = document.createElement("ChangePrev");
            node.appendChild(document.createTextNode(String.valueOf(stats.getPrevChange())));
            statsNode.appendChild(node);
            node = document.createElement("TurnOverPrev");
            node.appendChild(document.createTextNode(String.valueOf(stats.getPrevTurnover())));
            statsNode.appendChild(node);
            node = document.createElement("LowPrev");
            node.appendChild(document.createTextNode(String.valueOf(stats.getPrevLow())));
            statsNode.appendChild(node);
            node = document.createElement("HighPrev");
            node.appendChild(document.createTextNode(String.valueOf(stats.getPrevHigh())));
            statsNode.appendChild(node);
            node = document.createElement("DatePrev");
            if (stats.getPrevDate() != null) {
                node.appendChild(document.createTextNode(this.dateFormat.format(stats.getPrevDate())));
                statsNode.appendChild(node);
            }
            node = document.createElement("Low1Month");
            node.appendChild(document.createTextNode(String.valueOf(stats.getLow1Month())));
            statsNode.appendChild(node);
            node = document.createElement("High1Month");
            node.appendChild(document.createTextNode(String.valueOf(stats.getHigh1Month())));
            statsNode.appendChild(node);
            node = document.createElement("Low3Month");
            node.appendChild(document.createTextNode(String.valueOf(stats.getLow3Month())));
            statsNode.appendChild(node);
            node = document.createElement("High3Month");
            node.appendChild(document.createTextNode(String.valueOf(stats.getHigh3Month())));
            statsNode.appendChild(node);
            node = document.createElement("Low6Month");
            node.appendChild(document.createTextNode(String.valueOf(stats.getLow6Month())));
            statsNode.appendChild(node);
            node = document.createElement("High6Month");
            node.appendChild(document.createTextNode(String.valueOf(stats.getHigh6Month())));
            statsNode.appendChild(node);
            node = document.createElement("Low12Month");
            node.appendChild(document.createTextNode(String.valueOf(stats.getLow12Month())));
            statsNode.appendChild(node);
            node = document.createElement("High12Month");
            node.appendChild(document.createTextNode(String.valueOf(stats.getHigh12Month())));
            statsNode.appendChild(node);
            node = document.createElement("AvgPrice1Month");
            node.appendChild(document.createTextNode(String.valueOf(stats.getAvgPrice1Month())));
            statsNode.appendChild(node);
            node = document.createElement("AvgPrice3Month");
            node.appendChild(document.createTextNode(String.valueOf(stats.getAvgPrice3Month())));
            statsNode.appendChild(node);
            node = document.createElement("AvgPrice6Month");
            node.appendChild(document.createTextNode(String.valueOf(stats.getAvgPrice6Month())));
            statsNode.appendChild(node);
            node = document.createElement("AvgPrice12Month");
            node.appendChild(document.createTextNode(String.valueOf(stats.getAvgPrice12Month())));
            statsNode.appendChild(node);
            node = document.createElement("AvgVol1Month");
            node.appendChild(document.createTextNode(String.valueOf(stats.getAvgVol1Month())));
            statsNode.appendChild(node);
            node = document.createElement("AvgVol3Month");
            node.appendChild(document.createTextNode(String.valueOf(stats.getAvgVol3Month())));
            statsNode.appendChild(node);
            node = document.createElement("AvgVol6Month");
            node.appendChild(document.createTextNode(String.valueOf(stats.getAvgVol6Month())));
            statsNode.appendChild(node);
            node = document.createElement("AvgVol12Month");
            node.appendChild(document.createTextNode(String.valueOf(stats.getAvgVol12Month())));
            statsNode.appendChild(node);
        }
        if (security.getSplits() != null) {
            for (Split split : security.getSplits()) {
                node = document.createElement("split");
                node.setAttribute("date", this.dateTimeFormat.format(split.getDate()));
                node.setAttribute("fromQuantity", String.valueOf(split.getFromQuantity()));
                node.setAttribute("toQuantity", String.valueOf(split.getToQuantity()));
                element.appendChild(node);
            }
            if (security.getDividends() != null) {
                for (Dividend dividend : security.getDividends()) {
                    node = document.createElement("dividend");
                    node.setAttribute("date", this.dateTimeFormat.format(dividend.getDate()));
                    node.setAttribute("value", String.valueOf(dividend.getValue()));
                    element.appendChild(node);
                }
            }
        }
    }

    private JsonObject securityToJson(Security security) {
        JsonObject json = new JsonObject();
        json.addProperty("id", String.valueOf(security.getId()));
        if (security.getExchange() != null) {
            json.addProperty("exchange", security.getExchange());
        }
        if (security.getSymbol() != null) {
            json.addProperty("symbol", security.getSymbol());
        }
        if (security.getMarket() != null) {
            json.addProperty("market", security.getMarket());
        }
        if (security.getDescription() != null) {
            json.addProperty("description", security.getDescription());
        }
        if (security.getCurrency() != null) {
            json.addProperty("currency", security.getCurrency().getCurrencyCode());
        }
        if (security.getSector() != null) {
            json.addProperty("sector", security.getSector());
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMinimumIntegerDigits(2);
        nf.setMinimumFractionDigits(0);
        nf.setMaximumFractionDigits(0);
        json.addProperty("sector", security.getSector());
        json.addProperty("comment", security.getComment());
        JsonObject jsonDatacollector = new JsonObject();
        jsonDatacollector.addProperty("enable", String.valueOf(security.isEnableDataCollector()));
        String beginTime = String.valueOf(String.valueOf(nf.format(security.getBeginTime() / 60))) + ":" + nf.format(security.getBeginTime() % 60);
        jsonDatacollector.addProperty("begin", beginTime);
        String endTime = String.valueOf(String.valueOf(nf.format(security.getEndTime() / 60))) + ":" + nf.format(security.getEndTime() % 60);
        jsonDatacollector.addProperty("end", endTime);
        jsonDatacollector.addProperty("weekdays", String.valueOf(security.getWeekDays()));
        jsonDatacollector.addProperty("keepdays", String.valueOf(security.getKeepDays()));
        json.add("dataCollector", (JsonElement)jsonDatacollector);
        if (security.getQuoteFeed() != null || security.getLevel2Feed() != null || security.getHistoryFeed() != null) {
            JsonObject jsonfeeds = new JsonObject();
            if (security.getQuoteFeed() != null) {
                JsonObject jsonQuote = new JsonObject();
                jsonQuote.addProperty("id", security.getQuoteFeed().getId());
                if (security.getQuoteFeed().getExchange() != null) {
                    jsonQuote.addProperty("exchange", security.getQuoteFeed().getExchange());
                }
                jsonQuote.addProperty("symbol", security.getQuoteFeed().getSymbol());
                jsonfeeds.add("quote", (JsonElement)jsonQuote);
            }
            if (security.getLevel2Feed() != null) {
                JsonObject jsonLevel2 = new JsonObject();
                jsonLevel2.addProperty("id", security.getLevel2Feed().getId());
                if (security.getLevel2Feed().getExchange() != null) {
                    jsonLevel2.addProperty("exchange", security.getLevel2Feed().getExchange());
                }
                jsonLevel2.addProperty("symbol", security.getLevel2Feed().getSymbol());
                jsonfeeds.add("level2", (JsonElement)jsonLevel2);
            }
            if (security.getHistoryFeed() != null) {
                JsonObject jsonHistory = new JsonObject();
                jsonHistory.addProperty("id", security.getHistoryFeed().getId());
                if (security.getHistoryFeed().getExchange() != null) {
                    jsonHistory.addProperty("exchange", security.getHistoryFeed().getExchange());
                }
                jsonHistory.addProperty("symbol", security.getHistoryFeed().getSymbol());
                jsonfeeds.add("history", (JsonElement)jsonHistory);
            }
            json.add("feeds", (JsonElement)jsonfeeds);
        }
        if (security.getTradeSource() != null) {
            JsonObject jsonTradeSource = new JsonObject();
            TradeSource source = security.getTradeSource();
            jsonTradeSource.addProperty("id", source.getTradingProviderId());
            if (source.getExchange() != null) {
                jsonTradeSource.addProperty("exchange", source.getExchange());
            }
            if (!source.getSymbol().equals("")) {
                jsonTradeSource.addProperty("symbol", source.getSymbol());
            }
            if (source.getAccountId() != null) {
                jsonTradeSource.addProperty("account", (Number)source.getAccountId());
            }
            jsonTradeSource.addProperty("quantity", (Number)source.getQuantity());
            json.add("tradeSource", (JsonElement)jsonTradeSource);
        }
        if (security.getQuote() != null) {
            JsonObject jsonQuote = new JsonObject();
            Quote quote = security.getQuote();
            if (quote.getDate() != null) {
                jsonQuote.addProperty("date", this.dateTimeFormat.format(quote.getDate()));
            }
            jsonQuote.addProperty("last", String.valueOf(quote.getLast()));
            jsonQuote.addProperty("bid", String.valueOf(quote.getBid()));
            jsonQuote.addProperty("ask", String.valueOf(quote.getAsk()));
            jsonQuote.addProperty("bidSize", String.valueOf(quote.getBidSize()));
            jsonQuote.addProperty("askSize", String.valueOf(quote.getAskSize()));
            jsonQuote.addProperty("volume", String.valueOf(quote.getVolume()));
            json.add("quote", (JsonElement)jsonQuote);
        }
        JsonObject jsonData = new JsonObject();
        if (security.getOpen() != null) {
            jsonData.addProperty("open", String.valueOf(security.getOpen()));
        }
        if (security.getHigh() != null) {
            jsonData.addProperty("high", String.valueOf(security.getHigh()));
        }
        if (security.getLow() != null) {
            jsonData.addProperty("low", String.valueOf(security.getLow()));
        }
        if (security.getClose() != null) {
            jsonData.addProperty("close", String.valueOf(security.getClose()));
        }
        if (security.getCurrentIndex() != null) {
            jsonData.addProperty("currentIndex", String.valueOf(security.getCurrentIndex()));
        }
        jsonData.addProperty("up", String.valueOf(security.getUp()));
        jsonData.addProperty("down", String.valueOf(security.getDown()));
        jsonData.addProperty("equal", String.valueOf(security.getEqual()));
        jsonData.addProperty("totalTrades", String.valueOf(security.getTotalTrades()));
        jsonData.addProperty("totalTurnover", String.valueOf(security.getTotalTurnover()));
        jsonData.addProperty("monetaryValue", String.valueOf(security.getMonetaryValue()));
        jsonData.addProperty("lotSize", String.valueOf(security.getLotSize()));
        jsonData.addProperty("maximumVolume", String.valueOf(security.getMaximumVolume()));
        jsonData.addProperty("maximumValue", String.valueOf(security.getMaximumValue()));
        jsonData.addProperty("change", String.valueOf(security.getChange()));
        jsonData.addProperty("changePercent", String.valueOf(security.getChangePerc()));
        jsonData.addProperty("spot", XMLRepository.getValueOrDefaultString(security.getSpot(), "0"));
        if (security.getSpotFrom() != null) {
            jsonData.addProperty("spotFrom", this.dateFormat.format(security.getSpotFrom()));
        }
        if (security.getSpotTo() != null) {
            jsonData.addProperty("spotTo", this.dateFormat.format(security.getSpotTo()));
        }
        jsonData.addProperty("average", String.valueOf(security.getAverage()));
        if (security.getComment() != null) {
            jsonData.addProperty("comment", security.getComment());
        }
        jsonData.addProperty("up", String.valueOf(security.getUp()));
        json.add("data", (JsonElement)jsonData);
        if (security.getSymbolStatistics() != null) {
            JsonObject jsonStats = new JsonObject();
            SymbolStatisticsData stats = security.getSymbolStatistics();
            jsonStats.addProperty("LastPricePrev", String.valueOf(stats.getPrevClose()));
            jsonStats.addProperty("ChangePrev", String.valueOf(stats.getPrevChange()));
            jsonStats.addProperty("TurnOverPrev", String.valueOf(stats.getPrevTurnover()));
            jsonStats.addProperty("LowPrev", String.valueOf(stats.getPrevLow()));
            jsonStats.addProperty("HighPrev", String.valueOf(stats.getPrevHigh()));
            if (stats.getPrevDate() != null) {
                jsonStats.addProperty("DatePrev", this.dateFormat.format(stats.getPrevDate()));
            }
            jsonStats.addProperty("Low1Month", String.valueOf(stats.getLow1Month()));
            jsonStats.addProperty("High1Month", String.valueOf(stats.getHigh1Month()));
            jsonStats.addProperty("Low3Month", String.valueOf(stats.getLow3Month()));
            jsonStats.addProperty("High3Month", String.valueOf(stats.getHigh3Month()));
            jsonStats.addProperty("Low6Month", String.valueOf(stats.getLow6Month()));
            jsonStats.addProperty("High6Month", String.valueOf(stats.getHigh6Month()));
            jsonStats.addProperty("Low12Month", String.valueOf(stats.getLow12Month()));
            jsonStats.addProperty("High12Month", String.valueOf(stats.getHigh12Month()));
            jsonStats.addProperty("AvgPrice1Month", String.valueOf(stats.getAvgPrice1Month()));
            jsonStats.addProperty("AvgPrice3Month", String.valueOf(stats.getAvgPrice3Month()));
            jsonStats.addProperty("AvgPrice6Month", String.valueOf(stats.getAvgPrice6Month()));
            jsonStats.addProperty("AvgPrice12Month", String.valueOf(stats.getAvgPrice12Month()));
            jsonStats.addProperty("AvgVol1Month", String.valueOf(stats.getAvgVol1Month()));
            jsonStats.addProperty("AvgVol3Month", String.valueOf(stats.getAvgVol3Month()));
            jsonStats.addProperty("AvgVol6Month", String.valueOf(stats.getAvgVol6Month()));
            jsonStats.addProperty("AvgVol12Month", String.valueOf(stats.getAvgVol12Month()));
            json.add("SymbolStats", (JsonElement)jsonStats);
        }
        if (security.getSplits() != null) {
            JsonObject jsonSplit;
            for (Split split : security.getSplits()) {
                jsonSplit = new JsonObject();
                jsonSplit.addProperty("date", this.dateTimeFormat.format(split.getDate()));
                jsonSplit.addProperty("fromQuantity", this.dateTimeFormat.format(split.getFromQuantity()));
                jsonSplit.addProperty("toQuantity", this.dateTimeFormat.format(split.getToQuantity()));
                json.add("split", (JsonElement)jsonSplit);
            }
            if (security.getDividends() != null) {
                for (Dividend dividend : security.getDividends()) {
                    jsonSplit = new JsonObject();
                    jsonSplit.addProperty("date", this.dateTimeFormat.format(dividend.getDate()));
                    jsonSplit.addProperty("value", String.valueOf(dividend.getValue()));
                    json.add("split", (JsonElement)jsonSplit);
                }
            }
        }
        return json;
    }

    public void saveSecuritiesMapDb() {
        try {
            JsonArray jsonArray = new JsonArray();
            for (Security security : this.allSecurities()) {
                JsonObject tempJson = this.securityToJson(security);
                jsonArray.add((JsonElement)tempJson);
            }
            if (jsonArray != null && jsonArray.size() > 0) {
                UUID uuid = WokspaceFilesUUID.get((Object)WokspaceFilesEnum.SEC);
                MapDb instance = new MapDb(uuid);
                instance.init();
                JsonObject json = new JsonObject();
                json.addProperty("nextId", String.valueOf(this.securitiesNextId));
                json.addProperty("nextGroupId", String.valueOf(this.securitiesGroupNextId));
                json.add("securities", (JsonElement)jsonArray);
                instance.add(json.toString());
                instance.close();
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception: " + ex.getMessage()));
        }
    }

    public void saveSecurities() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setErrorHandler(this.errorHandler);
            Document document = builder.getDOMImplementation().createDocument(null, "data", null);
            Element root = document.getDocumentElement();
            root.setAttribute("nextId", String.valueOf(this.securitiesNextId));
            root.setAttribute("nextGroupId", String.valueOf(this.securitiesGroupNextId));
            for (Security security : this.allSecurities()) {
                if (security.getGroup() != null) continue;
                this.saveSecurity(security, document, root);
            }
            if (Resources.PRODUCT_NAME == ProductNames.BMA || Resources.PRODUCT_NAME == ProductNames.FOUNDATION) {
                this.saveDocumentWithParse(document, "", "securities.xml");
            } else {
                this.saveDocument(document, "", "securities.xml");
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.toString(), (Throwable)e);
        }
    }

    private Watchlist loadWatchlist(NodeList node) {
        int itemIndex = 1;
        Watchlist watchlist = new Watchlist(((Node)((Object)node)).getAttributes().getNamedItem("id").getNodeValue());
        try {
            int type = Integer.parseInt(((Node)((Object)node)).getAttributes().getNamedItem("type").getNodeValue());
            watchlist.setWatchlistType(type);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        int i = 0;
        while (i < node.getLength()) {
            int c;
            ArrayList<Object> list;
            Node item = node.item(i);
            String nodeName = item.getNodeName();
            Node value = item.getFirstChild();
            if (value != null) {
                if (nodeName.equalsIgnoreCase("title")) {
                    watchlist.setDescription(value.getNodeValue());
                } else if (nodeName.equalsIgnoreCase("style")) {
                    watchlist.setStyle(Integer.parseInt(value.getNodeValue()));
                } else if (nodeName.equalsIgnoreCase("defaultCurrency")) {
                    watchlist.setUseDefaultCurrency(Boolean.valueOf(value.getNodeValue()));
                } else if (nodeName.equalsIgnoreCase("feed")) {
                    watchlist.setDefaultFeed(value.getNodeValue());
                } else if (nodeName.equals("currency")) {
                    watchlist.setCurrency(Currency.getInstance(value.getNodeValue()));
                }
            }
            if (nodeName.equalsIgnoreCase("columns")) {
                list = new ArrayList<Object>();
                NodeList columnList = item.getChildNodes();
                c = 0;
                while (c < columnList.getLength()) {
                    item = columnList.item(c);
                    nodeName = item.getNodeName();
                    if (nodeName.equalsIgnoreCase("column")) {
                        WatchlistColumn column = new WatchlistColumn();
                        if (item.getAttributes().getNamedItem("id") != null) {
                            column.setId(item.getAttributes().getNamedItem("id").getNodeValue());
                        } else if (item.getAttributes().getNamedItem("class") != null) {
                            String id = item.getAttributes().getNamedItem("class").getNodeValue();
                            id = id.substring(id.lastIndexOf(46) + 1);
                            column.setId("watchlist." + id.substring(0, 1).toLowerCase() + id.substring(1));
                        }
                        list.add(column);
                    }
                    ++c;
                }
                watchlist.setColumns(list);
            } else if (nodeName.equalsIgnoreCase("items")) {
                list = new ArrayList();
                NodeList itemList = item.getChildNodes();
                c = 0;
                while (c < itemList.getLength()) {
                    item = itemList.item(c);
                    nodeName = item.getNodeName();
                    if (nodeName.equalsIgnoreCase("security")) {
                        String id = item.getAttributes().getNamedItem("id").getNodeValue();
                        Security security = (Security)this.load(Security.class, id);
                        if (security == null) {
                            this.log.warn((Object)("Cannot load security (id=" + id + ")"));
                        } else {
                            WatchlistItem watchlistItem = new WatchlistItem(new Integer(itemIndex++).toString());
                            watchlistItem.setParent(watchlist);
                            watchlistItem.setSecurity(security);
                            int alertIndex = 1;
                            NodeList quoteList = item.getChildNodes();
                            int q = 0;
                            while (q < quoteList.getLength()) {
                                item = quoteList.item(q);
                                nodeName = item.getNodeName();
                                value = item.getFirstChild();
                                if (value != null) {
                                    if (nodeName.equalsIgnoreCase("position")) {
                                        watchlistItem.setPosition(Integer.parseInt(value.getNodeValue()));
                                    } else if (nodeName.equalsIgnoreCase("paid")) {
                                        watchlistItem.setPaidPrice(Double.parseDouble(value.getNodeValue()));
                                    }
                                }
                                if (nodeName.equalsIgnoreCase("alert")) {
                                    Alert alert = new Alert(new Integer(alertIndex++).toString());
                                    alert.setPluginId(item.getAttributes().getNamedItem("pluginId").getNodeValue());
                                    if (item.getAttributes().getNamedItem("lastSeen") != null) {
                                        try {
                                            alert.setLastSeen(this.dateTimeFormat.parse(item.getAttributes().getNamedItem("lastSeen").getNodeValue()));
                                        }
                                        catch (Exception e) {
                                            this.log.warn((Object)e.toString());
                                        }
                                    }
                                    if (item.getAttributes().getNamedItem("popup") != null) {
                                        alert.setPopup(new Boolean(item.getAttributes().getNamedItem("popup").getNodeValue()));
                                    }
                                    if (item.getAttributes().getNamedItem("hilight") != null) {
                                        alert.setHilight(new Boolean(item.getAttributes().getNamedItem("hilight").getNodeValue()));
                                    }
                                    NodeList paramList = item.getChildNodes();
                                    int p = 0;
                                    while (p < paramList.getLength()) {
                                        item = paramList.item(p);
                                        nodeName = item.getNodeName();
                                        value = item.getFirstChild();
                                        if (value != null && nodeName.equalsIgnoreCase("param")) {
                                            String key = item.getAttributes().getNamedItem("key").getNodeValue();
                                            alert.getParameters().put(key, value.getNodeValue());
                                        }
                                        ++p;
                                    }
                                    watchlistItem.getAlerts().add(alert);
                                }
                                ++q;
                            }
                            list.add(watchlistItem);
                        }
                    }
                    ++c;
                }
                watchlist.setItems(list);
            }
            ++i;
        }
        watchlist.clearChanged();
        return watchlist;
    }

    private void loadWatchlistFromJSON(JsonObject item, int watchType) {
        block42: {
            int itemIndex = 1;
            try {
                try {
                    this.watchlistsNextId = item.get("nextId").getAsInt();
                }
                catch (Exception exception) {}
                JsonArray watches = item.get("watches").getAsJsonArray();
                if (watches == null || watches.size() <= 0) break block42;
                for (JsonElement jsonElemt : watches) {
                    Watchlist watchlist;
                    block43: {
                        JsonObject watch = jsonElemt.getAsJsonObject();
                        String id = watch.get("id").getAsString();
                        watchlist = new Watchlist(id);
                        try {
                            String title = watch.get("title").getAsString();
                            watchlist.setDescription(title);
                        }
                        catch (Exception exception) {}
                        try {
                            int type = watch.get("type").getAsInt();
                            watchlist.setWatchlistType(type);
                        }
                        catch (Exception exception) {}
                        try {
                            int style = watch.get("style").getAsInt();
                            watchlist.setStyle(style);
                        }
                        catch (Exception exception) {}
                        try {
                            String defaultCurrency = watch.get("defaultCurrency").getAsString();
                            watchlist.setUseDefaultCurrency(Boolean.valueOf(defaultCurrency));
                        }
                        catch (Exception exception) {}
                        try {
                            String feed = watch.get("feed").getAsString();
                            watchlist.setDefaultFeed(feed);
                        }
                        catch (Exception exception) {}
                        try {
                            String currency = watch.get("currency").getAsString();
                            watchlist.setCurrency(Currency.getInstance(currency));
                        }
                        catch (Exception exception) {}
                        try {
                            JsonArray columns = watch.get("columns").getAsJsonArray();
                            if (columns != null && columns.size() > 0) {
                                ArrayList<WatchlistColumn> columnlist = new ArrayList<WatchlistColumn>();
                                for (JsonElement jsonElemtCol : columns) {
                                    JsonObject columnJson = jsonElemtCol.getAsJsonObject();
                                    WatchlistColumn column = new WatchlistColumn();
                                    String colId = columnJson.get("id").getAsString();
                                    column.setId(colId);
                                    columnlist.add(column);
                                }
                                watchlist.setColumns(columnlist);
                            }
                        }
                        catch (Exception exception) {}
                        try {
                            JsonArray items = watch.get("watchItems").getAsJsonArray();
                            if (items == null || items.size() <= 0) break block43;
                            ArrayList<WatchlistItem> list = new ArrayList<WatchlistItem>();
                            for (JsonElement jsonElemItem : items) {
                                JsonObject itemsJson = jsonElemItem.getAsJsonObject();
                                String itemId = itemsJson.get("id").getAsString();
                                if (itemId == null || "".equalsIgnoreCase(itemId)) continue;
                                Security security = (Security)this.load(Security.class, itemId);
                                if (security == null) {
                                    this.log.warn((Object)("Cannot load security (id=" + id + ")"));
                                    continue;
                                }
                                WatchlistItem watchlistItem = new WatchlistItem(new Integer(itemIndex++).toString());
                                watchlistItem.setParent(watchlist);
                                watchlistItem.setSecurity(security);
                                try {
                                    int itemPos = itemsJson.get("position").getAsInt();
                                    watchlistItem.setPosition(itemPos);
                                }
                                catch (Exception exception) {}
                                try {
                                    double itemPaid = itemsJson.get("paid").getAsDouble();
                                    watchlistItem.setPaidPrice(itemPaid);
                                }
                                catch (Exception exception) {}
                                int alertIndex = 1;
                                JsonArray itemAlerts = itemsJson.get("alerts").getAsJsonArray();
                                if (itemAlerts != null && itemAlerts.size() > 0) {
                                    for (JsonElement jsonElemAlert : itemAlerts) {
                                        JsonObject jsonAlert = jsonElemAlert.getAsJsonObject();
                                        jsonAlert.get("id").getAsString();
                                        if (itemId == null || "".equalsIgnoreCase(itemId)) continue;
                                        Alert alert = new Alert(new Integer(alertIndex++).toString());
                                        try {
                                            String pluginId = jsonAlert.get("pluginId").getAsString();
                                            alert.setPluginId(pluginId);
                                        }
                                        catch (Exception exception) {}
                                        try {
                                            String lastSeen = jsonAlert.get("lastSeen").getAsString();
                                            alert.setLastSeen(this.dateTimeFormat.parse(lastSeen));
                                        }
                                        catch (Exception exception) {}
                                        try {
                                            boolean popup = jsonAlert.get("popup").getAsBoolean();
                                            alert.setPopup(popup);
                                        }
                                        catch (Exception exception) {}
                                        try {
                                            boolean hilight = jsonAlert.get("hilight").getAsBoolean();
                                            alert.setHilight(hilight);
                                        }
                                        catch (Exception exception) {}
                                        JsonArray jsonParams = jsonAlert.get("params").getAsJsonArray();
                                        if (jsonParams != null && jsonParams.size() > 0) {
                                            for (JsonElement jsonElemAlertParam : jsonParams) {
                                                JsonObject param = jsonElemAlertParam.getAsJsonObject();
                                                String key = param.get("key").getAsString();
                                                if (key == null || "".equalsIgnoreCase(key)) continue;
                                                alert.getParameters().put(key, key);
                                            }
                                        }
                                        watchlistItem.getAlerts().add(alert);
                                    }
                                }
                                list.add(watchlistItem);
                            }
                            watchlist.setItems(list);
                        }
                        catch (Exception exception) {}
                    }
                    watchlist.clearChanged();
                    Resources.isDefaultCurrency = watchlist.isUseDefaultCurrency();
                    watchlist.setRepository(this);
                    this.watchlistsMap.put(watchlist.getId(), watchlist);
                    if (watchType == 1) {
                        this.allSystemWatchlists().add(watchlist);
                        continue;
                    }
                    this.allWatchlists().add(watchlist);
                }
            }
            catch (Exception exception) {}
        }
    }

    public void saveWatchListsMapDb(int watchType) {
        try {
            JsonArray jsonArr = new JsonArray();
            for (Watchlist watchlist : this.watchlistsMap.values()) {
                if (watchlist.getWatchlistType() != watchType) continue;
                JsonObject jsonWatch = new JsonObject();
                jsonWatch.addProperty("id", String.valueOf(watchlist.getId()));
                jsonWatch.addProperty("type", String.valueOf(watchlist.getWatchlistType()));
                jsonWatch.addProperty("title", watchlist.getDescription());
                jsonWatch.addProperty("style", String.valueOf(watchlist.getStyle()));
                jsonWatch.addProperty("defaultCurrency", Boolean.toString(watchlist.isUseDefaultCurrency()));
                if (watchlist.getCurrency() != null) {
                    jsonWatch.addProperty("currency", watchlist.getCurrency().getCurrencyCode());
                }
                if (watchlist.getDefaultFeed() != null) {
                    jsonWatch.addProperty("feed", watchlist.getDefaultFeed());
                }
                new JsonObject();
                JsonArray jsonArrColumn = new JsonArray();
                for (WatchlistColumn column : watchlist.getColumns()) {
                    JsonObject temp = new JsonObject();
                    temp.addProperty("id", column.getId());
                    jsonArrColumn.add((JsonElement)temp);
                }
                jsonWatch.add("columns", (JsonElement)jsonArrColumn);
                JsonArray jsonArrItems = new JsonArray();
                int itemIndex = 1;
                Iterator itemIter = watchlist.getItems().iterator();
                while (itemIter.hasNext()) {
                    JsonObject tem = new JsonObject();
                    JsonArray temArr = new JsonArray();
                    WatchlistItem item = (WatchlistItem)itemIter.next();
                    item.setId(new Integer(itemIndex++).toString());
                    item.setParent(watchlist);
                    item.setRepository(this);
                    String symbol = String.valueOf(item.getSecurity().getId());
                    tem.addProperty("id", symbol);
                    if (item.getPosition() != null && item.getPosition() != 0) {
                        tem.addProperty("position", String.valueOf(item.getPosition()));
                    }
                    if (item.getPurchasePrice() != null && item.getPurchasePrice() != 0.0) {
                        tem.addProperty("paid", String.valueOf(item.getPurchasePrice()));
                    }
                    int alertIndex = 1;
                    Iterator alertIter = item.getAlerts().iterator();
                    while (alertIter.hasNext()) {
                        JsonObject temN1 = new JsonObject();
                        JsonArray temN1Arr = new JsonArray();
                        Alert alert = (Alert)alertIter.next();
                        alert.setId(new Integer(alertIndex++).toString());
                        temN1.addProperty("pluginId", alert.getPluginId());
                        if (alert.getLastSeen() != null) {
                            temN1.addProperty("lastSeen", this.dateTimeFormat.format(alert.getLastSeen()));
                        }
                        temN1.addProperty("popup", String.valueOf(alert.isPopup()));
                        temN1.addProperty("hilight", String.valueOf(alert.isHilight()));
                        Iterator paramIter = alert.getParameters().keySet().iterator();
                        while (paramIter.hasNext()) {
                            JsonObject temN2 = new JsonObject();
                            String key = (String)paramIter.next();
                            temN2.addProperty("key", key);
                            temN1Arr.add((JsonElement)temN2);
                        }
                        temN1.add("params", (JsonElement)temN1Arr);
                        temArr.add((JsonElement)temN1);
                    }
                    tem.add("alerts", (JsonElement)temArr);
                    jsonArrItems.add((JsonElement)tem);
                }
                jsonWatch.add("watchItems", (JsonElement)jsonArrItems);
                jsonArr.add((JsonElement)jsonWatch);
            }
            if (jsonArr != null && jsonArr.size() > 0) {
                JsonObject json = new JsonObject();
                UUID uuid = null;
                uuid = watchType == 1 ? WokspaceFilesUUID.get((Object)WokspaceFilesEnum.SYS_WATCH_LIST) : WokspaceFilesUUID.get((Object)WokspaceFilesEnum.WATCH_LIST);
                MapDb instance = new MapDb(uuid);
                instance.init();
                json.addProperty("nextId", String.valueOf(this.watchlistsNextId));
                json.add("watches", (JsonElement)jsonArr);
                String str = json.toString();
                instance.add(str);
                instance.close();
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception: " + ex.getMessage()));
        }
    }

    public void saveWatchlists(int watchType) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setErrorHandler(this.errorHandler);
            Document document = builder.getDOMImplementation().createDocument(null, "data", null);
            Element root = document.getDocumentElement();
            root.setAttribute("nextId", String.valueOf(this.watchlistsNextId));
            for (Watchlist watchlist : this.watchlistsMap.values()) {
                if (watchlist.getWatchlistType() != watchType) continue;
                Element element = document.createElement("watchlist");
                element.setAttribute("id", String.valueOf(watchlist.getId()));
                root.appendChild(element);
                element.setAttribute("type", String.valueOf(watchlist.getWatchlistType()));
                root.appendChild(element);
                Element node = document.createElement("title");
                node.appendChild(document.createTextNode(watchlist.getDescription()));
                element.appendChild(node);
                node = document.createElement("style");
                node.appendChild(document.createTextNode(String.valueOf(watchlist.getStyle())));
                element.appendChild(node);
                node = document.createElement("defaultCurrency");
                node.appendChild(document.createTextNode(Boolean.toString(watchlist.isUseDefaultCurrency())));
                element.appendChild(node);
                if (watchlist.getCurrency() != null) {
                    node = document.createElement("currency");
                    node.appendChild(document.createTextNode(watchlist.getCurrency().getCurrencyCode()));
                    element.appendChild(node);
                }
                if (watchlist.getDefaultFeed() != null) {
                    node = document.createElement("feed");
                    node.appendChild(document.createTextNode(watchlist.getDefaultFeed()));
                    element.appendChild(node);
                }
                Element columnsNode = document.createElement("columns");
                element.appendChild(columnsNode);
                for (WatchlistColumn column : watchlist.getColumns()) {
                    Element columnNode = document.createElement("column");
                    columnNode.setAttribute("id", column.getId());
                    columnsNode.appendChild(columnNode);
                }
                Element itemsNode = document.createElement("items");
                element.appendChild(itemsNode);
                int itemIndex = 1;
                for (WatchlistItem item : watchlist.getItems()) {
                    item.setId(new Integer(itemIndex++).toString());
                    item.setParent(watchlist);
                    item.setRepository(this);
                    Element itemNode = document.createElement("security");
                    itemNode.setAttribute("id", String.valueOf(item.getSecurity().getId()));
                    itemsNode.appendChild(itemNode);
                    if (item.getPosition() != null && item.getPosition() != 0) {
                        node = document.createElement("position");
                        node.appendChild(document.createTextNode(String.valueOf(item.getPosition())));
                        itemNode.appendChild(node);
                    }
                    if (item.getPurchasePrice() != null && item.getPurchasePrice() != 0.0) {
                        node = document.createElement("paid");
                        node.appendChild(document.createTextNode(String.valueOf(item.getPurchasePrice())));
                        itemNode.appendChild(node);
                    }
                    int alertIndex = 1;
                    for (Alert alert : item.getAlerts()) {
                        alert.setId(new Integer(alertIndex++).toString());
                        Element alertNode = document.createElement("alert");
                        alertNode.setAttribute("pluginId", alert.getPluginId());
                        if (alert.getLastSeen() != null) {
                            alertNode.setAttribute("lastSeen", this.dateTimeFormat.format(alert.getLastSeen()));
                        }
                        alertNode.setAttribute("popup", String.valueOf(alert.isPopup()));
                        alertNode.setAttribute("hilight", String.valueOf(alert.isHilight()));
                        itemNode.appendChild(alertNode);
                        for (String key : alert.getParameters().keySet()) {
                            node = document.createElement("param");
                            node.setAttribute("key", key);
                            node.appendChild(document.createTextNode((String)alert.getParameters().get(key)));
                            alertNode.appendChild(node);
                        }
                    }
                }
            }
            String watchListXml = this.docToString(document);
            if (watchListXml != null && watchListXml.length() > 500) {
                if (watchType == 1) {
                    this.saveDocument(document, "", "syswatchlists.xml");
                } else {
                    this.saveDocument(document, "", "watchlists.xml");
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
    }

    private String docToString(Document doc) {
        try {
            StringWriter sw = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(doc), new StreamResult(sw));
            return sw.toString();
        }
        catch (Exception ex) {
            this.log.error((Object)ex.toString(), (Throwable)ex);
            return "";
        }
    }

    private NewsItem loadNews(NodeList node) {
        Security security;
        NewsItem news = new NewsItem();
        if (((Node)((Object)node)).getAttributes().getNamedItem("security") != null && (security = this.getSecurity(((Node)((Object)node)).getAttributes().getNamedItem("security").getNodeValue())) != null) {
            news.addSecurity(security);
        }
        if (((Node)((Object)node)).getAttributes().getNamedItem("readed") != null) {
            news.setReaded(new Boolean(((Node)((Object)node)).getAttributes().getNamedItem("readed").getNodeValue()));
        }
        int i = 0;
        while (i < node.getLength()) {
            Node item = node.item(i);
            String nodeName = item.getNodeName();
            Node value = item.getFirstChild();
            if (value != null) {
                Security security2;
                if (nodeName.equalsIgnoreCase("date")) {
                    try {
                        news.setDate(this.dateTimeFormat.parse(value.getNodeValue()));
                    }
                    catch (Exception e) {
                        this.log.warn((Object)e.toString());
                    }
                } else if (nodeName.equals("description")) {
                    news.setTitle(value.getNodeValue());
                } else if (nodeName.equals("source")) {
                    news.setSource(value.getNodeValue());
                } else if (nodeName.equals("url")) {
                    news.setUrl(value.getNodeValue());
                } else if (nodeName.equals("security") && (security2 = this.getSecurity(value.getNodeValue())) != null) {
                    news.addSecurity(security2);
                }
            }
            ++i;
        }
        news.clearChanged();
        return news;
    }

    public void saveNewsMapDb() {
        try {
            JsonArray jsonArr = new JsonArray();
            for (NewsItem news : this.allNews()) {
                JsonObject jsonT = new JsonObject();
                jsonT.addProperty("readed", Boolean.valueOf(news.isReaded()));
                jsonT.addProperty("date", this.dateTimeFormat.format(news.getDate()));
                jsonT.addProperty("description", news.getTitle());
                jsonT.addProperty("source", news.getSource());
                jsonT.addProperty("url", news.getUrl());
                JsonArray jsonTArr1 = new JsonArray();
                Object[] o = news.getSecurities().toArray();
                int i = 0;
                while (i < o.length) {
                    JsonObject jsonT1 = new JsonObject();
                    jsonT1.addProperty("security", ((Security)o[i]).getId());
                    jsonTArr1.add((JsonElement)jsonT1);
                    ++i;
                }
                jsonT.add("securities", (JsonElement)jsonTArr1);
                JsonObject jsonNews = new JsonObject();
                jsonNews.add("news", (JsonElement)jsonT);
                jsonArr.add((JsonElement)jsonNews);
            }
            if (jsonArr != null && jsonArr.size() > 0) {
                UUID uuid = WokspaceFilesUUID.get((Object)WokspaceFilesEnum.NEWS);
                MapDb instance = new MapDb(uuid);
                instance.init();
                JsonObject json = new JsonObject();
                json.add("data", (JsonElement)jsonArr);
                instance.add(json.toString());
                instance.close();
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception: " + ex.getMessage()));
        }
    }

    public void saveNews() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setErrorHandler(this.errorHandler);
            Document document = builder.getDOMImplementation().createDocument(null, "data", null);
            Element root = document.getDocumentElement();
            for (NewsItem news : this.allNews()) {
                Element element = document.createElement("news");
                element.setAttribute("readed", String.valueOf(news.isReaded()));
                root.appendChild(element);
                Element node = document.createElement("date");
                node.appendChild(document.createTextNode(this.dateTimeFormat.format(news.getDate())));
                element.appendChild(node);
                node = document.createElement("description");
                node.appendChild(document.createTextNode(news.getTitle()));
                element.appendChild(node);
                node = document.createElement("source");
                node.appendChild(document.createTextNode(news.getSource()));
                element.appendChild(node);
                node = document.createElement("url");
                node.appendChild(document.createTextNode(news.getUrl()));
                element.appendChild(node);
                Object[] o = news.getSecurities().toArray();
                int i = 0;
                while (i < o.length) {
                    node = document.createElement("security");
                    node.appendChild(document.createTextNode(String.valueOf(((Security)o[i]).getId())));
                    element.appendChild(node);
                    ++i;
                }
            }
            this.saveDocument(document, "", "news.xml");
        }
        catch (Exception e) {
            this.log.error((Object)e.toString(), (Throwable)e);
        }
    }

    public void saveAlertsMapDb() {
        try {
            JsonArray jsonArr = new JsonArray();
            int alertIndex = 1;
            for (Alert alert : this.allAlerts()) {
                alert.setId(new Integer(alertIndex++).toString());
                JsonObject josnT1 = new JsonObject();
                JsonArray josnT1Arr = new JsonArray();
                josnT1.addProperty("pluginId", alert.getPluginId());
                if (alert.getLastSeen() != null) {
                    josnT1.addProperty("lastseen", this.dateTimeFormat.format(alert.getLastSeen()));
                }
                josnT1.addProperty("popup", Boolean.valueOf(alert.isPopup()));
                josnT1.addProperty("hilight", Boolean.valueOf(alert.isHilight()));
                josnT1.addProperty("security", alert.getSecurity().getId());
                josnT1.addProperty("hilight", Boolean.valueOf(alert.isHilight()));
                josnT1.addProperty("hilight", Boolean.valueOf(alert.isHilight()));
                for (String key : alert.getParameters().keySet()) {
                    JsonObject josnT2 = new JsonObject();
                    josnT2.addProperty("key", key);
                    josnT2.addProperty("value", (String)alert.getParameters().get(key));
                    josnT1Arr.add((JsonElement)josnT2);
                }
                josnT1.add("parmas", (JsonElement)josnT1Arr);
                jsonArr.add((JsonElement)josnT1);
            }
            if (jsonArr != null && jsonArr.size() > 0) {
                UUID uuid = WokspaceFilesUUID.get((Object)WokspaceFilesEnum.ALERTS);
                MapDb instance = new MapDb(uuid);
                instance.init();
                JsonObject json = new JsonObject();
                json.addProperty("nextId", String.valueOf(this.alertNextId));
                json.add("data", (JsonElement)jsonArr);
                instance.add(json.toString());
                instance.close();
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception: " + ex.getMessage()));
        }
    }

    public void saveAlerts() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setErrorHandler(this.errorHandler);
            Document document = builder.getDOMImplementation().createDocument(null, "data", null);
            Element root = document.getDocumentElement();
            root.setAttribute("nextId", String.valueOf(this.alertNextId));
            int alertIndex = 1;
            for (Alert alert : this.allAlerts()) {
                alert.setId(new Integer(alertIndex++).toString());
                Element alertNode = document.createElement("alert");
                alertNode.setAttribute("pluginId", alert.getPluginId());
                root.appendChild(alertNode);
                Element node1 = document.createElement("lastseen");
                if (alert.getLastSeen() != null) {
                    node1.appendChild(document.createTextNode(this.dateTimeFormat.format(alert.getLastSeen())));
                }
                alertNode.appendChild(node1);
                node1 = document.createElement("popup");
                node1.appendChild(document.createTextNode(String.valueOf(alert.isPopup())));
                alertNode.appendChild(node1);
                node1 = document.createElement("hilight");
                node1.appendChild(document.createTextNode(String.valueOf(alert.isHilight())));
                alertNode.appendChild(node1);
                node1 = document.createElement("security");
                node1.appendChild(document.createTextNode(String.valueOf(alert.getSecurity().getId())));
                alertNode.appendChild(node1);
                for (String key : alert.getParameters().keySet()) {
                    node1 = document.createElement("param");
                    node1.setAttribute("key", key);
                    node1.appendChild(document.createTextNode((String)alert.getParameters().get(key)));
                    alertNode.appendChild(node1);
                }
            }
            this.saveDocument(document, "", "alerts.xml");
        }
        catch (Exception e) {
            this.log.error((Object)e.toString(), (Throwable)e);
        }
    }

    public void saveAnnouncements() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setErrorHandler(this.errorHandler);
            Document document = builder.getDOMImplementation().createDocument(null, "data", null);
            Element root = document.getDocumentElement();
            for (AnnouncementItem news : this.allAnnouncements()) {
                Element element = document.createElement("announcement");
                element.setAttribute("readed", String.valueOf(news.isReaded()));
                root.appendChild(element);
                Element node = document.createElement("date");
                node.appendChild(document.createTextNode(this.dateTimeFormat.format(news.getDate())));
                element.appendChild(node);
                node = document.createElement("subject");
                node.appendChild(document.createTextNode(news.getTitle()));
                element.appendChild(node);
                node = document.createElement("source");
                node.appendChild(document.createTextNode(news.getSource()));
                element.appendChild(node);
                node = document.createElement("url");
                node.appendChild(document.createTextNode(news.getUrl()));
                element.appendChild(node);
            }
            this.saveDocument(document, "", "announcements.xml");
        }
        catch (Exception e) {
            this.log.error((Object)e.toString(), (Throwable)e);
        }
    }

    private AnnouncementItem loadAnnouncement(NodeList node) {
        AnnouncementItem news = new AnnouncementItem();
        if (((Node)((Object)node)).getAttributes().getNamedItem("readed") != null) {
            news.setReaded(new Boolean(((Node)((Object)node)).getAttributes().getNamedItem("readed").getNodeValue()));
        }
        int i = 0;
        while (i < node.getLength()) {
            Node item = node.item(i);
            String nodeName = item.getNodeName();
            Node value = item.getFirstChild();
            if (value != null) {
                if (nodeName.equalsIgnoreCase("date")) {
                    try {
                        news.setDate(this.dateTimeFormat.parse(value.getNodeValue()));
                    }
                    catch (Exception e) {
                        this.log.warn((Object)e.toString());
                    }
                } else if (nodeName.equals("subject")) {
                    news.setTitle(value.getNodeValue());
                } else if (nodeName.equals("source")) {
                    news.setSource(value.getNodeValue());
                } else if (nodeName.equals("url")) {
                    news.setUrl(value.getNodeValue());
                }
            }
            ++i;
        }
        news.clearChanged();
        return news;
    }

    private AccountGroup loadAccountGroup(NodeList node, AccountGroup parent) {
        AccountGroup group = new AccountGroup(((Node)((Object)node)).getAttributes().getNamedItem("id").getNodeValue());
        if (parent != null) {
            group.setParent(parent);
            parent.getGroups().add(group);
        }
        int i = 0;
        while (i < node.getLength()) {
            Node item = node.item(i);
            String nodeName = item.getNodeName();
            Node value = item.getFirstChild();
            if (value != null && nodeName.equals("description")) {
                group.setDescription(value.getNodeValue());
            }
            if (nodeName.equals("account")) {
                this.loadAccount(item.getChildNodes(), group);
            }
            ++i;
        }
        group.clearChanged();
        this.accountGroupMap.put(group.getId(), group);
        this.allAccountGroups().add(group);
        return group;
    }

    private Account loadAccount(NodeList node, AccountGroup group) {
        Integer id = new Integer(Integer.parseInt(((Node)((Object)node)).getAttributes().getNamedItem("id").getNodeValue()));
        String pluginId = "";
        if (((Node)((Object)node)).getAttributes().getNamedItem("pluginId") != null) {
            pluginId = ((Node)((Object)node)).getAttributes().getNamedItem("pluginId").getNodeValue();
        }
        if (pluginId.equals("")) {
            pluginId = "pk.com.softech.tradingterminal.accounts.simple";
        }
        PersistentPreferenceStore preferenceStore = new PersistentPreferenceStore();
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        int i = 0;
        while (i < node.getLength()) {
            Node item = node.item(i);
            String nodeName = item.getNodeName();
            Node value = item.getFirstChild();
            if (nodeName.equals("transaction")) {
                Transaction transaction = new Transaction(item.getAttributes().getNamedItem("id").getNodeValue());
                NodeList childs = item.getChildNodes();
                int ii = 0;
                while (ii < childs.getLength()) {
                    block28: {
                        item = childs.item(ii);
                        nodeName = item.getNodeName();
                        value = item.getFirstChild();
                        if (value != null) {
                            if (nodeName.equals("date")) {
                                try {
                                    transaction.setDate(this.dateTimeFormat.parse(value.getNodeValue()));
                                    break block28;
                                }
                                catch (Exception e) {
                                    this.log.error((Object)e.toString(), (Throwable)e);
                                    break;
                                }
                            }
                            if (nodeName.equals("security")) {
                                transaction.setSecurity((Security)this.load(Security.class, value.getNodeValue()));
                                if (transaction.getSecurity() == null) {
                                    this.log.warn((Object)("Cannot load security (id=" + value.getNodeValue() + ")"));
                                }
                            } else if (nodeName.equals("price")) {
                                transaction.setPrice(Double.parseDouble(value.getNodeValue()));
                            } else if (nodeName.equals("quantity")) {
                                transaction.setQuantity(Integer.parseInt(value.getNodeValue()));
                            } else if (nodeName.equals("expenses")) {
                                transaction.setExpenses(Double.parseDouble(value.getNodeValue()));
                            }
                        }
                    }
                    if (nodeName.equalsIgnoreCase("param")) {
                        NamedNodeMap map = item.getAttributes();
                        transaction.getParams().put(map.getNamedItem("key").getNodeValue(), map.getNamedItem("value").getNodeValue());
                    }
                    ++ii;
                }
                if (transaction.getSecurity() != null) {
                    transactions.add(transaction);
                }
            } else if (!(value == null || nodeName.equals("description") || nodeName.equals("currency") || nodeName.equals("initialBalance"))) {
                preferenceStore.setValue(nodeName, value.getNodeValue());
            }
            ++i;
        }
        Collections.sort(transactions, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((Transaction)arg0).getDate().compareTo(((Transaction)arg1).getDate());
            }
        });
        Account account = CorePlugin.createAccount(pluginId, preferenceStore, transactions);
        account.setId(id.toString());
        account.setPluginId(pluginId);
        account.setGroup(group);
        int i2 = 0;
        while (i2 < node.getLength()) {
            Node item = node.item(i2);
            String nodeName = item.getNodeName();
            Node value = item.getFirstChild();
            if (value != null) {
                if (nodeName.equals("description")) {
                    account.setDescription(value.getNodeValue());
                } else if (nodeName.equals("currency")) {
                    account.setCurrency(Currency.getInstance(value.getNodeValue()));
                } else if (nodeName.equals("initialBalance")) {
                    account.setInitialBalance(Double.parseDouble(value.getNodeValue()));
                }
            }
            ++i2;
        }
        return account;
    }

    private void saveGroup(AccountGroup group, Document document, Element root) {
    }

    private void saveAccount(Account account, Document document, Element root) {
        Element element = document.createElement("account");
        element.setAttribute("id", String.valueOf(account.getId()));
        element.setAttribute("pluginId", String.valueOf(account.getPluginId()));
        root.appendChild(element);
        Element node = document.createElement("description");
        node.appendChild(document.createTextNode(account.getDescription()));
        element.appendChild(node);
        if (account.getCurrency() != null) {
            node = document.createElement("currency");
            node.appendChild(document.createTextNode(account.getCurrency().getCurrencyCode()));
            element.appendChild(node);
        }
        node = document.createElement("initialBalance");
        node.appendChild(document.createTextNode(String.valueOf(account.getInitialBalance())));
        element.appendChild(node);
        String[] names = account.getPreferenceStore().preferenceNames();
        int i = 0;
        while (i < names.length) {
            node = document.createElement(names[i]);
            node.appendChild(document.createTextNode(account.getPreferenceStore().getString(names[i])));
            element.appendChild(node);
            ++i;
        }
        int transactionId = 0;
        for (Transaction transaction : account.getTransactions()) {
            if (transaction.getId() == null) continue;
            transactionId = Math.max(transactionId, XMLRepository.parseInt(transaction.getId(), -1));
        }
        for (Transaction transaction : account.getTransactions()) {
            if (transaction.getId() == null) {
                transaction.setId(new Integer(++transactionId).toString());
            }
            this.saveTransaction(transaction, document, element);
        }
    }

    private void saveTransaction(Transaction transaction, Document document, Element root) {
    }

    public void saveAccounts() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setErrorHandler(this.errorHandler);
            Document document = builder.getDOMImplementation().createDocument(null, "data", null);
            Element root = document.getDocumentElement();
            root.setAttribute("nextId", String.valueOf(this.accountNextId));
            root.setAttribute("nextGroupId", String.valueOf(this.accountGroupNextId));
            for (AccountGroup group : this.accountGroupMap.values()) {
                if (group.getParent() != null) continue;
                this.saveGroup(group, document, root);
            }
            for (Account account : this.accountMap.values()) {
                if (account.getGroup() != null) continue;
                this.saveAccount(account, document, root);
            }
            this.saveDocument(document, "", "accounts.xml");
        }
        catch (Exception e) {
            this.log.error((Object)e.toString(), (Throwable)e);
        }
    }

    private Event loadEvent(NodeList node) {
        Event event = new Event();
        if (((Node)((Object)node)).getAttributes().getNamedItem("security") != null) {
            Security security = this.getSecurityById(((Node)((Object)node)).getAttributes().getNamedItem("security").getNodeValue());
            event.setSecurity(security);
        }
        if (((Node)((Object)node)).getAttributes().getNamedItem("user") != null) {
            String userId = ((Node)((Object)node)).getAttributes().getNamedItem("user").getNodeValue();
            event.setUserId(userId);
        }
        int i = 0;
        while (i < node.getLength()) {
            Node item = node.item(i);
            String nodeName = item.getNodeName();
            Node value = item.getFirstChild();
            if (value != null) {
                if (nodeName.equalsIgnoreCase("date")) {
                    try {
                        event.setDate(this.dateTimeFormat.parse(value.getNodeValue()));
                    }
                    catch (Exception e) {
                        this.log.warn((Object)e.toString());
                    }
                } else if (nodeName.equals("message")) {
                    event.setMessage(value.getNodeValue());
                } else if (nodeName.equals("longMessage")) {
                    event.setLongMessage(value.getNodeValue());
                } else if (nodeName.equals("eventType")) {
                    event.setEvent_type(Integer.parseInt(value.getNodeValue()));
                }
            }
            ++i;
        }
        event.clearChanged();
        return event;
    }

    private Order loadOrder(NodeList node) {
        Order order = new Order(((Node)((Object)node)).getAttributes().getNamedItem("id").getNodeValue());
        order.setSecurity(this.getSecurity(((Node)((Object)node)).getAttributes().getNamedItem("symbol").getNodeValue()));
        if (order.getSecurity() == null) {
            this.log.warn((Object)("Cannot load security (id=" + ((Node)((Object)node)).getAttributes().getNamedItem("security").getNodeValue() + ")"));
        }
        order.setMarket(((Node)((Object)node)).getAttributes().getNamedItem("market").getNodeValue());
        String pluginId = ((Node)((Object)node)).getAttributes().getNamedItem("pluginId").getNodeValue();
        order.setProvider(CorePlugin.createTradeSourcePlugin(pluginId));
        if (order.getProvider() == null) {
            this.log.warn((Object)("Cannot load trade source '" + pluginId + "' for order (id=" + String.valueOf(order.getId()) + ")"));
        }
        order.setPluginId(pluginId);
        int i = 0;
        while (i < node.getLength()) {
            Node item = node.item(i);
            String nodeName = item.getNodeName();
            Node value = item.getFirstChild();
            if (value != null) {
                if (nodeName.equalsIgnoreCase("date")) {
                    try {
                        order.setDate(this.dateTimeFormat.parse(value.getNodeValue()));
                    }
                    catch (Exception e) {
                        this.log.warn((Object)e.toString());
                    }
                } else if (nodeName.equals("exchange")) {
                    order.setExchange(new OrderRoute(item.getAttributes().getNamedItem("id").getNodeValue(), value.getNodeValue()));
                } else if (nodeName.equals("orderId")) {
                    order.setOrderId(value.getNodeValue());
                } else if (nodeName.equals("side")) {
                    order.setSide(new OrderSide(Integer.parseInt(value.getNodeValue())));
                } else if (nodeName.equals("type")) {
                    order.setType(new OrderType(Integer.parseInt(value.getNodeValue())));
                } else if (nodeName.equals("quantity")) {
                    order.setQuantity(Integer.parseInt(value.getNodeValue()));
                } else if (nodeName.equals("price")) {
                    order.setPrice(new Float(value.getNodeValue()).floatValue());
                } else if (nodeName.equals("stopPrice")) {
                    order.setStopPrice(new Float(value.getNodeValue()).floatValue());
                } else if (nodeName.equals("filledQuantity")) {
                    order.setFilledQuantity(Integer.parseInt(value.getNodeValue()));
                } else if (nodeName.equals("averagePrice")) {
                    order.setAveragePrice(new Double(value.getNodeValue()));
                } else if (nodeName.equals("validity")) {
                    order.setValidity(new OrderValidity(Integer.parseInt(value.getNodeValue())));
                } else if (nodeName.equals("status")) {
                    order.setStatus(new OrderStatus(Integer.parseInt(value.getNodeValue())));
                } else if (nodeName.equals("account")) {
                    Account ac = (Account)this.accountMap.get(new Integer(value.getNodeValue()).toString());
                    order.setAccount(ac);
                    if (order.getAccount() == null) {
                        this.log.warn((Object)("Cannot load account (id=" + value.getNodeValue() + ")"));
                    }
                } else if (nodeName.equals("text")) {
                    order.setText(value.getNodeValue());
                } else if (nodeName.equals("message")) {
                    order.setMessage(value.getNodeValue());
                }
            }
            if (nodeName.equalsIgnoreCase("param")) {
                NamedNodeMap map = item.getAttributes();
                order.getParams().put(map.getNamedItem("key").getNodeValue(), map.getNamedItem("value").getNodeValue());
            }
            ++i;
        }
        order.clearChanged();
        return order;
    }

    private void saveOrders() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setErrorHandler(this.errorHandler);
            Document document = builder.getDOMImplementation().createDocument(null, "data", null);
            Element root = document.getDocumentElement();
            root.setAttribute("nextId", String.valueOf(this.orderNextId));
            for (Order order : this.allOrders()) {
                Element element = document.createElement("order");
                element.setAttribute("id", String.valueOf(order.getId()));
                element.setAttribute("pluginId", order.getPluginId());
                element.setAttribute("market", String.valueOf(order.getSecurity().getMarket()));
                element.setAttribute("symbol", String.valueOf(order.getSecurity().getSymbol()));
                root.appendChild(element);
                Element node = document.createElement("date");
                node.appendChild(document.createTextNode(this.dateTimeFormat.format(order.getDate())));
                element.appendChild(node);
                if (order.getExchange() != null) {
                    node = document.createElement("exchange");
                    node.setAttribute("id", order.getExchange().getId());
                    node.appendChild(document.createTextNode(order.getExchange().toString()));
                    element.appendChild(node);
                }
                node = document.createElement("orderId");
                node.appendChild(document.createTextNode(order.getOrderId()));
                element.appendChild(node);
                node = document.createElement("side");
                node.appendChild(document.createTextNode(String.valueOf(order.getSide())));
                element.appendChild(node);
                node = document.createElement("type");
                node.appendChild(document.createTextNode(String.valueOf(order.getType())));
                element.appendChild(node);
                node = document.createElement("quantity");
                node.appendChild(document.createTextNode(String.valueOf(order.getQuantity())));
                element.appendChild(node);
                node = document.createElement("price");
                node.appendChild(document.createTextNode(String.valueOf(order.getPrice())));
                element.appendChild(node);
                node = document.createElement("stopPrice");
                node.appendChild(document.createTextNode(String.valueOf(order.getStopPrice())));
                element.appendChild(node);
                node = document.createElement("filledQuantity");
                node.appendChild(document.createTextNode(String.valueOf(order.getFilledQuantity())));
                element.appendChild(node);
                node = document.createElement("averagePrice");
                node.appendChild(document.createTextNode(String.valueOf(order.getAveragePrice())));
                element.appendChild(node);
                if (order.getValidity() != null) {
                    node = document.createElement("validity");
                    node.appendChild(document.createTextNode(String.valueOf(order.getValidity())));
                    element.appendChild(node);
                }
                node = document.createElement("status");
                node.appendChild(document.createTextNode(String.valueOf(order.getStatus())));
                element.appendChild(node);
                if (order.getAccount() != null) {
                    node = document.createElement("account");
                    node.appendChild(document.createTextNode(String.valueOf(order.getAccount().getId())));
                    element.appendChild(node);
                }
                if (order.getText() != null) {
                    node = document.createElement("text");
                    node.appendChild(document.createTextNode(order.getText()));
                    element.appendChild(node);
                }
                if (order.getMessage() != null) {
                    node = document.createElement("message");
                    node.appendChild(document.createTextNode(order.getMessage()));
                    element.appendChild(node);
                }
                for (String key : order.getParams().keySet()) {
                    node = document.createElement("param");
                    node.setAttribute("key", key);
                    node.setAttribute("value", (String)order.getParams().get(key));
                    element.appendChild(node);
                }
            }
            this.saveDocument(document, "", "orders.xml");
        }
        catch (Exception e) {
            this.log.error((Object)e.toString(), (Throwable)e);
        }
    }

    public void saveEvents() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setErrorHandler(this.errorHandler);
            Document document = builder.getDOMImplementation().createDocument(null, "data", null);
            Element root = document.getDocumentElement();
            for (Event event : this.allEvents()) {
                Element element = document.createElement("event");
                if (event.getSecurity() != null) {
                    element.setAttribute("security", String.valueOf(event.getSecurity().getId()));
                }
                element.setAttribute("user", Resources.userId);
                root.appendChild(element);
                element.setAttribute("id", event.getId());
                root.appendChild(element);
                Element node = document.createElement("date");
                node.appendChild(document.createTextNode(this.dateTimeFormat.format(event.getDate())));
                element.appendChild(node);
                node = document.createElement("message");
                node.appendChild(document.createTextNode(event.getMessage()));
                element.appendChild(node);
                node = document.createElement("longMessage");
                node.appendChild(document.createTextNode(event.getLongMessage()));
                element.appendChild(node);
                node = document.createElement("eventType");
                node.appendChild(document.createTextNode("" + event.getEvent_type()));
                element.appendChild(node);
            }
            this.saveDocument(document, "", "events.xml");
        }
        catch (Exception e) {
            this.log.error((Object)e.toString(), (Throwable)e);
        }
    }

    private void removeExtraSpaces(File file) throws Exception {
        OutputStreamWriter fileWriter = null;
        try {
            try {
                String dirtyXMLString = new Scanner(file).useDelimiter("\\Z").next();
                String cleanXMLString = null;
                cleanXMLString = dirtyXMLString.replaceAll("[^\\x20-\\x7e]", "");
                fileWriter = new FileWriter(file);
                fileWriter.write(cleanXMLString);
            }
            catch (IOException ex) {
                this.log.error((Object)("removeExtraSpaces " + ex.toString()), (Throwable)ex);
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                fileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private File writeOrifinalFile(File file, String type) {
        OutputStreamWriter fileWriter = null;
        File newFile = null;
        try {
            try {
                String cleanXMLString = new Scanner(file).useDelimiter("\\Z").next();
                newFile = new File(Platform.getLocation().toFile(), type);
                fileWriter = new FileWriter(newFile);
                fileWriter.write(cleanXMLString);
            }
            catch (IOException ex) {
                this.log.error((Object)ex.toString(), (Throwable)ex);
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                fileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return newFile;
    }

    void saveDocumentWithParse(Document document, String path, String name) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            try {
                factory.setAttribute("indent-number", new Integer(4));
            }
            catch (Exception exception) {}
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(document);
            File file = new File(Platform.getLocation().toFile(), path);
            File fileTemp = new File(Platform.getLocation().toFile(), String.valueOf(String.valueOf(path)) + "/temp");
            file.mkdirs();
            fileTemp.mkdirs();
            fileTemp = new File(fileTemp, "temp_" + name);
            file = new File(file, name);
            FileWriter fw = new FileWriter(fileTemp);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            transformer.transform(source, result);
            fw.write(sw.toString());
            fw.close();
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            dBuilder.parse(file);
            fileTemp.delete();
            fw = new FileWriter(file);
            fw.write(sw.toString());
            fw.close();
            this.log.info((Object)("Actual File is Replaced: " + name));
        }
        catch (TransformerException ex) {
            this.log.error((Object)("Exception Parsing: " + ex.getMessage()));
        }
        catch (Exception e) {
            this.log.error((Object)("Exception In Saving Document: " + e.getMessage()));
        }
    }

    void saveDocument(Document document, String path, String name) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            try {
                factory.setAttribute("indent-number", new Integer(4));
            }
            catch (Exception exception) {}
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(document);
            File file = new File(Platform.getLocation().toFile(), path);
            file.mkdirs();
            file = new File(file, name);
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.log.error((Object)e.toString(), (Throwable)e);
        }
    }

    static int parseInt(String value, int defaultVal) {
        value = value.replaceAll(",", "");
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    static String getValueOrDefaultString(String value, String defaultValue) {
        if (value == null || value.equalsIgnoreCase("") || value.equalsIgnoreCase(" ")) {
            return defaultValue;
        }
        return value;
    }

    public TradingSystemRepository getTradingRepository() {
        return this.tradingRepository;
    }

    public Map<String, Security> getAllSecuritiesMap() {
        return this.allSecuritiesMap;
    }

    public void setAllSecuritiesMap(Map<String, Security> allSecuritiesMap) {
        this.allSecuritiesMap = allSecuritiesMap;
    }

    public static enum WokspaceFilesEnum {
        SEC("securities"),
        WATCH_LIST("watchlists"),
        SYS_WATCH_LIST("syswatchlists"),
        ALERTS("alerts"),
        NEWS("news");

        private String arg;

        private WokspaceFilesEnum(String arg) {
            this.arg = arg;
        }

        public String getArg() {
            return this.arg;
        }
    }
}

