/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.internal;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pk.com.softech.tradingterminal.core.db.Account;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.trading.TradingSystem;
import pk.com.softech.tradingterminal.core.db.trading.TradingSystemGroup;
import pk.com.softech.tradingterminal.core.internal.XMLRepository;

public class TradingSystemRepository {
    XMLRepository repository;
    private Integer tsGroupNextId = new Integer(1);
    Map tsGroupMap = new HashMap();
    private Integer tsNextId = new Integer(1);
    Map tsMap = new HashMap();
    private Log logger = LogFactory.getLog(this.getClass());
    private SimpleDateFormat dateTimeFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

    public TradingSystemRepository(XMLRepository repository) {
        this.repository = repository;
        File file = new File(Platform.getLocation().toFile(), "ts.xml");
        if (file.exists()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(file);
                Node firstNode = document.getFirstChild();
                this.tsNextId = new Integer(firstNode.getAttributes().getNamedItem("nextId").getNodeValue());
                this.tsGroupNextId = new Integer(firstNode.getAttributes().getNamedItem("nextGroupId").getNodeValue());
                NodeList childNodes = firstNode.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node item = childNodes.item(i);
                    String nodeName = item.getNodeName();
                    if (nodeName.equalsIgnoreCase("system")) {
                        TradingSystem obj = this.loadSystem(item.getChildNodes());
                        obj.setRepository(this.repository);
                    } else if (nodeName.equalsIgnoreCase("group")) {
                        TradingSystemGroup group = this.loadGroup(item.getChildNodes());
                        group.setRepository(this.repository);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e.toString(), (Throwable)e);
            }
        }
    }

    void clear() {
        File file = new File(Platform.getLocation().toFile(), "ts.xml");
        if (file.exists()) {
            file.delete();
        }
        this.tsGroupNextId = new Integer(1);
        this.tsGroupMap = new HashMap();
        this.tsNextId = new Integer(1);
        this.tsMap = new HashMap();
    }

    public void save(TradingSystemGroup object) {
        if (object.getId() == null) {
            object.setId(this.tsGroupNextId.toString());
            this.tsGroupNextId = this.getNextId(this.tsGroupNextId);
        }
        this.tsGroupMap.put(object.getId(), object);
        if (!this.repository.getTradingSystemGroups().contains(object)) {
            this.repository.getTradingSystemGroups().add(object);
        }
        if (object.getParent() != null && !object.getParent().getGroups().contains(object)) {
            object.getParent().getGroups().add(object);
        }
    }

    public void save(TradingSystem object) {
        if (object.getId() == null) {
            object.setId(this.tsNextId.toString());
            this.tsNextId = this.getNextId(this.tsNextId);
        }
        this.tsMap.put(object.getId(), object);
        if (!this.repository.getTradingSystems().contains(object)) {
            this.repository.getTradingSystems().add(object);
        }
        if (object.getGroup() != null && !object.getGroup().getTradingSystems().contains(object)) {
            object.getGroup().getTradingSystems().add(object);
        }
    }

    public void saveTradingSystems() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.getDOMImplementation().createDocument(null, "data", null);
            Element root = document.getDocumentElement();
            root.setAttribute("nextId", String.valueOf(this.tsNextId));
            root.setAttribute("nextGroupId", String.valueOf(this.tsGroupNextId));
            for (TradingSystemGroup group : this.tsGroupMap.values()) {
                if (group.getParent() != null) continue;
                this.saveGroup(group, document, root);
            }
            for (TradingSystem system : this.tsMap.values()) {
                if (system.getGroup() != null) continue;
                this.saveSystem(system, document, root);
            }
            this.repository.saveDocument(document, "", "ts.xml");
        }
        catch (Exception e) {
            this.logger.error((Object)e.toString(), (Throwable)e);
        }
    }

    private TradingSystemGroup loadGroup(NodeList node) {
        TradingSystemGroup group = new TradingSystemGroup(((Node)((Object)node)).getAttributes().getNamedItem("id").getNodeValue());
        int i = 0;
        while (i < node.getLength()) {
            Node item = node.item(i);
            String nodeName = item.getNodeName();
            Node value = item.getFirstChild();
            if (value != null && nodeName.equals("description")) {
                group.setDescription(value.getNodeValue());
            }
            if (nodeName.equals("system")) {
                TradingSystem system = this.loadSystem(item.getChildNodes());
                system.setGroup(group);
                group.getTradingSystems().add(system);
            } else if (nodeName.equals("group")) {
                TradingSystemGroup grp = this.loadGroup(item.getChildNodes());
                grp.setParent(group);
                group.getGroups().add(grp);
            }
            ++i;
        }
        group.clearChanged();
        this.tsGroupMap.put(group.getId(), group);
        this.repository.getTradingSystemGroups().add(group);
        return group;
    }

    private void saveGroup(TradingSystemGroup group, Document document, Element root) {
        Element element = document.createElement("group");
        element.setAttribute("id", String.valueOf(group.getId()));
        root.appendChild(element);
        Element node = document.createElement("description");
        node.appendChild(document.createTextNode(group.getDescription()));
        element.appendChild(node);
        for (TradingSystemGroup grp : group.getGroups()) {
            this.saveGroup(grp, document, element);
        }
        for (TradingSystem system : group.getTradingSystems()) {
            this.saveSystem(system, document, element);
        }
    }

    private void saveSystem(TradingSystem system, Document document, Element root) {
        Element element = document.createElement("system");
        element.setAttribute("id", String.valueOf(system.getId()));
        element.setAttribute("pluginId", system.getPluginId());
        root.appendChild(element);
        Element node = document.createElement("security");
        node.appendChild(document.createTextNode(String.valueOf(system.getSecurity().getId())));
        element.appendChild(node);
        node = document.createElement("account");
        node.appendChild(document.createTextNode(String.valueOf(system.getAccount().getId())));
        element.appendChild(node);
        node = document.createElement("max_exposure");
        node.appendChild(document.createTextNode(String.valueOf(system.getMaxExposure())));
        element.appendChild(node);
        node = document.createElement("min_amount");
        node.appendChild(document.createTextNode(String.valueOf(system.getMinAmount())));
        element.appendChild(node);
        node = document.createElement("max_amount");
        node.appendChild(document.createTextNode(String.valueOf(system.getMaxAmount())));
        element.appendChild(node);
        if (system.getDate() != null) {
            node = document.createElement("date");
            node.appendChild(document.createTextNode(this.dateTimeFormat.format(system.getDate())));
            element.appendChild(node);
        }
        node = document.createElement("signal");
        node.appendChild(document.createTextNode(String.valueOf(system.getSignal())));
        element.appendChild(node);
        for (String key : system.getParameters().keySet()) {
            node = document.createElement("param");
            node.setAttribute("key", key);
            node.appendChild(document.createTextNode((String)system.getParameters().get(key)));
            element.appendChild(node);
        }
    }

    private TradingSystem loadSystem(NodeList node) {
        TradingSystem system = new TradingSystem(((Node)((Object)node)).getAttributes().getNamedItem("id").getNodeValue());
        system.setPluginId(((Node)((Object)node)).getAttributes().getNamedItem("pluginId").getNodeValue());
        int i = 0;
        while (i < node.getLength()) {
            Node item = node.item(i);
            String nodeName = item.getNodeName();
            Node value = item.getFirstChild();
            if (value != null) {
                if (nodeName.equals("security")) {
                    system.setSecurity((Security)this.repository.load(Security.class, value.getNodeValue()));
                } else if (nodeName.equals("account")) {
                    system.setAccount((Account)this.repository.load(Account.class, value.getNodeValue()));
                } else if (nodeName.equalsIgnoreCase("date")) {
                    try {
                        system.setDate(this.dateTimeFormat.parse(value.getNodeValue()));
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)e.toString(), (Throwable)e);
                    }
                } else if (nodeName.equalsIgnoreCase("signal")) {
                    system.setSignal(Integer.parseInt(value.getNodeValue()));
                } else if (nodeName.equalsIgnoreCase("max_exposure")) {
                    system.setMaxExposure(Double.parseDouble(value.getNodeValue()));
                } else if (nodeName.equalsIgnoreCase("min_amount")) {
                    system.setMinAmount(Double.parseDouble(value.getNodeValue()));
                } else if (nodeName.equalsIgnoreCase("max_amount")) {
                    system.setMaxAmount(Double.parseDouble(value.getNodeValue()));
                } else if (nodeName.equalsIgnoreCase("param")) {
                    String key = item.getAttributes().getNamedItem("key").getNodeValue();
                    system.getParameters().put(key, value.getNodeValue());
                }
            }
            ++i;
        }
        system.clearChanged();
        this.tsMap.put(system.getId(), system);
        this.repository.getTradingSystems().add(system);
        return system;
    }

    private Integer getNextId(Integer id) {
        return new Integer(id + 1);
    }
}

