/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.internal;

import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.util.FIFOQueue;

public class FeedSubscriptionHandler
implements ICollectionObserver,
Runnable {
    public FIFOQueue queue;
    Logger logger = Logger.getLogger(FeedSubscriptionHandler.class);

    public FeedSubscriptionHandler() {
        this.queue = new FIFOQueue();
        CorePlugin.getRepository().allProfilingSymbols().addCollectionObserver(this);
    }

    @Override
    public void itemAdded(Object o) {
        if (o instanceof Security) {
            Security security = (Security)o;
            this.queue.add(security);
            this.logger.info((Object)("Queue Security Added for Subscription:" + security.getSymbol()));
        }
    }

    public void itemAddedByType(Object o, String type) {
        if (o instanceof Security) {
            Security security = (Security)o;
            final String symbol = String.valueOf(security.getExchange()) + security.getMarket() + security.getSymbol() + type;
            if (!Resources.profilingSet.contains(symbol)) {
                Resources.profilingSet.add(symbol);
                Resources.profilingCountMap.put(symbol, 1);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (Resources.feedLink != null) {
                            Resources.feedLink.subscribeSymbol(symbol);
                            FeedSubscriptionHandler.this.logger.info((Object)("Queue Security Subscribe:" + symbol));
                        }
                    }
                });
            } else {
                Integer count = Resources.profilingCountMap.get(symbol);
                count = count + 1;
                Resources.profilingCountMap.put(symbol, count);
                this.logger.info((Object)("Queue Security Repeat:" + symbol));
            }
        }
    }

    @Override
    public void itemRemoved(Object o) {
        Security security;
        String symbol;
        if (o instanceof Security && Resources.profilingSet.contains(symbol = String.valueOf((security = (Security)o).getExchange()) + security.getMarket() + security.getSymbol())) {
            Integer count = Resources.profilingCountMap.get(symbol);
            if (count == null) {
                return;
            }
            if (count == 1) {
                Resources.profilingSet.remove(symbol);
                Resources.feedLink.unSubscribeSymbol(symbol);
                this.logger.info((Object)("Queue Security Remove:" + symbol));
            } else if (count > 1) {
                count = count - 1;
                Resources.profilingCountMap.put(symbol, count);
            }
        }
    }

    public void initialSymbolSubsriber() throws InterruptedException {
        if (!this.queue.isEmpty()) {
            while (!this.queue.isEmpty()) {
                Security sec = null;
                try {
                    sec = (Security)this.queue.remove();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!(sec instanceof Security) || sec == null) continue;
                String symbol = String.valueOf(sec.getExchange()) + sec.getMarket() + sec.getSymbol();
                if (!Resources.profilingSet.contains(symbol)) {
                    Resources.profilingCountMap.put(symbol, 1);
                    Resources.profilingSet.add(symbol);
                    continue;
                }
                Integer count = Resources.profilingCountMap.get(symbol);
                count = count + 1;
                Resources.profilingCountMap.put(symbol, count);
            }
            if (Resources.feedLink != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (Resources.feedLink != null) {
                            Resources.feedLink.subscribeSymbol(Resources.profilingSet);
                        }
                    }
                });
            }
        } else {
            Thread.sleep(5000L);
        }
    }

    public void keepSubscribing() {
        try {
            Thread.sleep(3500L);
            if (Resources.isServerConnected("", false, true)) {
                this.initialSymbolSubsriber();
            }
            this.keepSubscribing();
        }
        catch (Exception exception) {
            this.keepSubscribing();
        }
    }

    public void getActiveViewsSymbols() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
    }

    @Override
    public void run() {
        try {
            this.keepSubscribing();
        }
        catch (Exception exception) {
            this.keepSubscribing();
        }
    }
}

