/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.internal.MenuBar;
import pk.com.softech.tradingterminal.core.internal.MenuItem;

public class AccessSourceProvider
extends AbstractSourceProvider {
    public static final AccessSourceProvider INSTANCE = new AccessSourceProvider();
    Map<String, String> currentState = new HashMap<String, String>();
    public static final String CAN_SEE = "enable";
    public static final String CANOT_SEE = "disable";
    public static MenuBar bar = new MenuBar();
    private static final String LOGGED_IN = "LOGGED_IN";
    private static final String LOGGED_OUT = "LOGGED_OUT";
    public static final String LOGIN_STATUS = "LOGIN_STATUS";
    public static StringBuffer trnCode = new StringBuffer();

    public String[] getProvidedSourceNames() {
        String sourceNames = String.valueOf(bar.getAllTrnCodes()) + "," + LOGIN_STATUS;
        return sourceNames.split(",");
    }

    private AccessSourceProvider() {
    }

    public void dispose() {
    }

    public void register() {
        IEvaluationService eService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        eService.addSourceProvider((ISourceProvider)this);
    }

    public Map<String, String> getCurrentState() {
        return this.currentState;
    }

    public void setLoggedIn(boolean loggedIn) {
        this.currentState = new HashMap<String, String>();
        this.currentState.put(LOGIN_STATUS, loggedIn ? LOGGED_IN : LOGGED_OUT);
        this.fireSourceChanged(0, LOGIN_STATUS, loggedIn ? LOGGED_IN : LOGGED_OUT);
        if (!Resources.loginStatus) {
            return;
        }
        String trn = Resources.trnCode.toString().replaceAll("\\[", "").replaceAll("\\]", "");
        Resources.buyOrderOption = trn.contains("OO01");
        Resources.sellOrderOption = trn.contains("OO02");
        if (trn.contains("OO03") && !Resources.modifyOrderOption) {
            Resources.trnCode.remove("OO03");
        } else if (!trn.contains("OO03") && Resources.modifyOrderOption) {
            Resources.modifyOrderOption = false;
        }
        Resources.cancelOrderOption = trn.contains("OO04");
        Resources.shortSellAllow = trn.contains("OO08");
        Resources.mboAllow = trn.contains("OV06") && Resources.level2feed;
        Resources.mbpAllow = trn.contains("OV07") && Resources.level2feed;
        Resources.kseAnnouncement = trn.contains("OV20");
        if (trn.contains("OV28") && Resources.systemClient != 9 && Resources.systemClient != 29 && Resources.systemClient != 12 && Resources.systemClient != 32 && Resources.systemClient != 16 && Resources.systemClient != 3 && Resources.systemClient != 1 && Resources.systemClient != 23 && Resources.systemClient != 31) {
            Resources.trnCode.remove("OV28");
        }
        for (MenuItem menu : MenuBar.rootMenus) {
            int i = 0;
            while (i < menu.subMenus.size()) {
                MenuItem subMenu = menu.subMenus.get(i);
                subMenu.setEnabled(trn.contains(subMenu.getTrnCode()));
                this.currentState.put(subMenu.getTrnCode(), subMenu.isEnabled() ? CAN_SEE : CANOT_SEE);
                ++i;
            }
            this.currentState.put(menu.getTrnCode(), menu.isEnabled() ? CAN_SEE : CANOT_SEE);
        }
        this.fireSourceChanged(0, this.currentState);
        this.disableViews();
    }

    public void disableViews() {
        if (Resources.loginStatus) {
            for (MenuItem menu : MenuBar.rootMenus) {
                int i = 0;
                while (i < menu.subMenus.size()) {
                    MenuItem subMenu = menu.subMenus.get(i);
                    if (!subMenu.isEnabled()) {
                        String viewId = subMenu.getViewID();
                        String secId = subMenu.getSecodaryId();
                        if (viewId != null && viewId.length() > 0) {
                            try {
                                IViewReference view = null;
                                view = secId != null && secId.length() > 0 ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(viewId, secId) : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(viewId);
                                if (viewId != "pk.com.softech.tradingterminal.ext.views.SymbolTickerView" && view != null) {
                                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView(view);
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                    ++i;
                }
            }
        }
    }
}

