/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.db.mapdb;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.eclipse.core.runtime.Platform;
import org.mapdb20.BTreeMap;
import org.mapdb20.DB;
import org.mapdb20.DBException;
import org.mapdb20.DBMaker;

public class MapDb
implements Closeable {
    private DB dbase;
    private BTreeMap ds;
    public UUID uuid = null;
    private boolean isRead = false;

    public MapDb(UUID uud) {
        this.uuid = uud;
    }

    public MapDb(UUID uud, boolean isRead) {
        this.isRead = isRead;
        this.uuid = uud;
    }

    public void init() {
        this.dbase = this.ensureDatabasePresent(this.uuid);
        this.ds = this.createStroageSet(this.dbase, this.uuid);
    }

    private BTreeMap createStroageSet(DB db, UUID uuid) {
        BTreeMap res = db.treeMap(uuid.toString());
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ensureFilesPresent(UUID uuid) {
        File root = MapDb.mapDbRoot();
        Class<MapDb> clazz = MapDb.class;
        synchronized (MapDb.class) {
            boolean exists = root.exists();
            if (exists) {
                File file = new File(root, uuid.toString());
                exists = file.exists();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return exists;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DB ensureDatabasePresent(UUID uuid) {
        File root = MapDb.mapDbRoot();
        Class<MapDb> clazz = MapDb.class;
        synchronized (MapDb.class) {
            DB db;
            if (!root.exists()) {
                root.mkdirs();
            }
            File file = new File(root, uuid.toString());
            try {
                db = this.isRead ? DBMaker.fileDB((File)file).asyncWriteEnable().closeOnJvmShutdown().fileMmapEnable().fileMmapEnableIfSupported().fileMmapPreclearDisable().make() : DBMaker.fileDB((File)file).asyncWriteEnable().closeOnJvmShutdown().fileMmapEnable().fileMmapEnableIfSupported().fileMmapPreclearDisable().asyncWriteEnable().make();
            }
            catch (DBException.DataCorruption dataCorruption) {
                throw new Error();
            }
            return db;
        }
    }

    public MapDb add(String item) {
        if (this.dbase.isClosed()) {
            throw new IllegalStateException("DB is closed");
        }
        this.ds.put((Object)this.uuid, (Object)item);
        return this;
    }

    public BTreeMap getDataSet() {
        return this.ds;
    }

    @Override
    public void close() throws IOException {
        try {
            this.dbase.commit();
        }
        finally {
            this.dbase.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapDb delete(UUID uuid) {
        Class<MapDb> clazz = MapDb.class;
        synchronized (MapDb.class) {
            File root = MapDb.mapDbRoot();
            if (root.exists() && !this.dbase.isClosed()) {
                try {
                    this.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                File file = new File(root, uuid.toString());
                if (file.exists()) {
                    file.delete();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this;
        }
    }

    private static File mapDbRoot() {
        return new File(Platform.getLocation().toPortableString(), "mapdb");
    }
}

