/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.db.feed;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Quote {
    public static final String IN_TIME_FORMAT = "HH:mm:ss";
    private Date date;
    private double last = 0.0;
    private double lastDayClose = 0.0;
    private double bid = 0.0;
    private int bidSize = 0;
    private double ask = 0.0;
    private int askSize = 0;
    private long volume = 0L;
    public static final String LLM = "LLM";
    public static final String LLT = "LLT";
    private String quoteType = "LLM";
    double inavValue = 0.0;
    long inavVolume = 0L;
    private Date navCalculationTime;

    public Quote() {
    }

    public Quote(Quote quote) {
        if (quote != null) {
            this.date = quote.date;
            this.last = quote.last;
            this.bid = quote.bid;
            this.bidSize = quote.bidSize;
            this.ask = quote.ask;
            this.askSize = quote.askSize;
            this.volume = quote.volume;
            this.lastDayClose = quote.lastDayClose;
        }
    }

    public Quote(double last, double bid, double ask) {
        this.last = last;
        this.bid = bid;
        this.ask = ask;
    }

    public Quote(Date date, double last, double bid, double ask) {
        this.date = date;
        this.last = last;
        this.bid = bid;
        this.ask = ask;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public double getAsk() {
        return this.ask;
    }

    public void setAsk(double ask) {
        this.ask = ask;
    }

    public double getBid() {
        return this.bid;
    }

    public void setBid(double bid) {
        this.bid = bid;
    }

    public double getLast() {
        return this.last;
    }

    public void setLast(double last) {
        this.last = last;
    }

    public double getLastDayClose() {
        return this.lastDayClose;
    }

    public void setLastDayClose(double lastDayClose) {
        this.lastDayClose = lastDayClose;
    }

    public int getAskSize() {
        return this.askSize;
    }

    public void setAskSize(int askSize) {
        this.askSize = askSize;
    }

    public int getBidSize() {
        return this.bidSize;
    }

    public void setBidSize(int bidSize) {
        this.bidSize = bidSize;
    }

    public long getVolume() {
        return this.volume;
    }

    public void setVolume(long volume) {
        this.volume = volume;
    }

    public void setQuoteType(String quoteType) {
        this.quoteType = quoteType;
    }

    public String getQuoteType() {
        return this.quoteType;
    }

    public double getInavValue() {
        return this.inavValue;
    }

    public void setInavValue(double inavValue) {
        this.inavValue = inavValue;
    }

    public long getInavVolume() {
        return this.inavVolume;
    }

    public void setInavVolume(long inavVolume) {
        this.inavVolume = inavVolume;
    }

    public Date getInavCalculationTime() {
        return this.navCalculationTime;
    }

    public void setInavCalculationTime(String navCalculationTime) {
        this.navCalculationTime = this.formatPSXTime(navCalculationTime);
    }

    public void setInavCalculationTime(Date navCalculationTime) {
        this.navCalculationTime = navCalculationTime;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Quote)) {
            return false;
        }
        Quote that = (Quote)obj;
        return this.getLast() == that.getLast() && this.getBid() == that.getBid() && this.getAsk() == that.getAsk() && this.getBidSize() == that.getBidSize() && this.getAskSize() == that.getAskSize() && this.getVolume() == that.getVolume() && this.getInavValue() == that.getInavValue() && this.getInavVolume() == that.getInavVolume();
    }

    public boolean checkETFEquals(Object obj) {
        if (obj == null || !(obj instanceof Quote)) {
            return false;
        }
        Quote that = (Quote)obj;
        return this.getInavValue() == that.getInavValue() && this.getInavVolume() == that.getInavVolume();
    }

    public String toString() {
        return "Quote [date=" + this.date + ", last=" + this.last + ", bid=" + this.bid + ", bidSize=" + this.bidSize + ", ask=" + this.ask + ", askSize=" + this.askSize + ", volume=" + this.volume + "]";
    }

    public Date formatPSXTime(String date) {
        SimpleDateFormat df;
        block3: {
            try {
                df = new SimpleDateFormat(IN_TIME_FORMAT);
                df.setLenient(false);
                if (!date.equals(" ") && !date.equals("")) break block3;
                return null;
            }
            catch (ParseException pe) {
                System.out.println("Unable to parse date:'" + date + "' " + pe.getMessage());
                return null;
            }
        }
        return df.parse(date);
    }

    public static Quote getQuoteShallow(Quote temp) {
        Quote quote = new Quote();
        try {
            quote.setLast(temp.getLast());
        }
        catch (Exception exception) {}
        try {
            quote.setVolume(temp.getVolume());
        }
        catch (Exception exception) {}
        try {
            quote.setBid(temp.getBid());
        }
        catch (Exception exception) {}
        try {
            quote.setAsk(temp.getAsk());
        }
        catch (Exception exception) {}
        try {
            quote.setBidSize(temp.getBidSize());
        }
        catch (Exception exception) {}
        try {
            quote.setAskSize(temp.getAskSize());
        }
        catch (Exception exception) {}
        try {
            quote.setQuoteType(temp.getQuoteType());
        }
        catch (Exception exception) {}
        try {
            quote.setDate(temp.getDate());
        }
        catch (Exception exception) {}
        try {
            quote.setLastDayClose(temp.getLastDayClose());
        }
        catch (Exception exception) {}
        return quote;
    }
}

