/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.db;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.Watchlist;

public class WatchlistItem
extends PersistentObject
implements Observer {
    Security security;
    List alerts = new ArrayList();
    Watchlist parent;
    Integer position;
    Double purchasePrice;

    public WatchlistItem() {
    }

    public WatchlistItem(String id) {
        super(id);
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        if (this.security != null) {
            this.security.deleteObserver(this);
            this.security.getQuoteMonitor().deleteObserver(this);
        }
        this.security = security;
        if (this.security != null) {
            this.security.addObserver(this);
            this.security.getQuoteMonitor().addObserver(this);
        }
        if (this.getId() == null) {
            this.setId(security.getId());
        }
    }

    public Watchlist getParent() {
        return this.parent;
    }

    public void setParent(Watchlist parent) {
        this.parent = parent;
    }

    public List getAlerts() {
        return this.alerts;
    }

    public void setAlerts(List alerts) {
        this.alerts = alerts;
    }

    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
        this.setChanged();
    }

    public void setPosition(int position) {
        this.position = new Integer(position);
        this.setChanged();
    }

    public void setPosition(Number position) {
        this.position = new Integer(position.intValue());
        this.setChanged();
    }

    public Double getPurchasePrice() {
        return this.purchasePrice;
    }

    public void setPaidPrice(Double paidPrice) {
        this.purchasePrice = paidPrice;
        this.setChanged();
    }

    public void setPaidPrice(double paidPrice) {
        this.purchasePrice = new Double(paidPrice);
        this.setChanged();
    }

    public void setPurchasePrice(Number paidPrice) {
        this.purchasePrice = new Double(paidPrice.doubleValue());
        this.setChanged();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.security == null ? 0 : this.security.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WatchlistItem other = (WatchlistItem)obj;
        if (this.security == null) {
            if (other.security != null) {
                return false;
            }
        } else {
            if (!this.security.equals(other.security)) {
                return false;
            }
            if (this.getParent() == null || other.getParent() == null || !this.getParent().getId().equals(other.getParent().getId())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public synchronized void setChanged() {
        super.setChanged();
        if (this.getParent() != null && this.getParent().getTotals() != this) {
            this.getParent().getTotals().setChanged();
        }
    }

    @Override
    public void notifyObservers() {
        super.notifyObservers();
        if (this.getParent() != null && this.getParent().getTotals() != this) {
            this.getParent().getTotals().notifyObservers();
        }
    }
}

