/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.db;

import java.util.ArrayList;
import java.util.Currency;
import java.util.Iterator;
import java.util.List;
import pk.com.softech.messages.MarketData;
import pk.com.softech.messages.WatchlistSymbol;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ObservableList;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.WatchlistItem;

public class Watchlist
extends PersistentObject {
    private int style = 0;
    private String description = "";
    private Currency currency;
    private String defaultFeed;
    private boolean useDefaultCurrency = false;
    public static final int CUSTOM = 0;
    public static final int SYSTEM = 1;
    private int watchlistType = 0;
    private List columns = new ArrayList();
    private ObservableList items = new ObservableList();
    private WatchlistItem totals = new WatchlistItem();
    private String exchange = "";
    private String market = "";

    public Watchlist() {
        this.totals.setParent(this);
    }

    public Watchlist(String id) {
        super(id);
        this.totals.setParent(this);
        if (Resources.exchangeNames != null && Resources.exchangeNames.size() > 0) {
            this.exchange = "" + Resources.exchangeNames.get(0);
        }
        if (Resources.marketTypes != null && Resources.marketTypes.size() > 0) {
            this.market = MarketData.marketNames[MarketData.REGULAR];
        }
    }

    public String getExchange() {
        return this.exchange;
    }

    public String getMarket() {
        return this.market;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
        this.totals.setChanged();
        this.totals.notifyObservers();
    }

    public void setMarket(String market) {
        this.market = market;
        this.totals.setChanged();
        this.totals.notifyObservers();
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.setChanged();
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
        this.setChanged();
    }

    public String getDefaultFeed() {
        return this.defaultFeed;
    }

    public void setDefaultFeed(String defaultFeed) {
        this.defaultFeed = defaultFeed;
    }

    public List getColumns() {
        return this.columns;
    }

    public void setColumns(List columns) {
        this.columns = columns;
        this.setChanged();
    }

    public ObservableList getItems() {
        return this.items;
    }

    public boolean isExists(Security security) {
        int i = 0;
        while (i < this.items.size()) {
            WatchlistItem item = (WatchlistItem)this.items.get(i);
            if (item.getSecurity().getId().equals(security.getId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setSymbols(List items) {
        ObservableList newItems = new ObservableList();
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            try {
                WatchlistSymbol temp = (WatchlistSymbol)iter.next();
                String exchange = "" + Resources.exchangeNames.get(Resources.exchangeCodes.indexOf(temp.getExchCode()));
                String market = "" + Resources.marketTypes.get(Resources.marketTypeCodes.indexOf(temp.getMarketType()));
                Security sec = CorePlugin.getRepository().getSecurity(exchange, market, temp.getSymbol());
                if (sec == null) continue;
                WatchlistItem watchListItem = new WatchlistItem();
                watchListItem.setSecurity(sec);
                newItems.add(watchListItem);
            }
            catch (Exception e) {
                System.err.println("Exception setSymbols : " + e.getMessage());
            }
        }
        this.setItems(newItems);
    }

    public void setItems(List items) {
        this.items.clear();
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            ((WatchlistItem)iter.next()).setParent(this);
        }
        this.items.addAll(items);
        this.setChanged();
    }

    public boolean isUseDefaultCurrency() {
        return this.useDefaultCurrency;
    }

    public void setUseDefaultCurrency(boolean useDefaultCurrency) {
        this.useDefaultCurrency = useDefaultCurrency;
        this.setChanged();
    }

    public WatchlistItem getTotals() {
        return this.totals;
    }

    public void setWatchlistType(int watchlistType) {
        this.watchlistType = watchlistType;
    }

    public int getWatchlistType() {
        return this.watchlistType;
    }

    @Override
    public synchronized void setChanged() {
        super.setChanged();
        this.totals.setChanged();
    }

    @Override
    public synchronized void clearChanged() {
        super.clearChanged();
        this.totals.clearChanged();
    }

    @Override
    public void notifyObservers() {
        super.notifyObservers();
        this.totals.notifyObservers();
    }
}

