/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.db;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Security;

public class Transaction
extends PersistentObject {
    private Date date;
    private Security security;
    private double price = 0.0;
    private int quantity = 0;
    private double expenses = 0.0;
    Map params = new HashMap();

    public Transaction() {
    }

    public Transaction(String id) {
        super(id);
    }

    public Transaction(Date date, Security security, int quantity, double price) {
        this.date = date;
        this.security = security;
        this.quantity = quantity;
        this.price = price;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
        this.setChanged();
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
        this.setChanged();
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
        this.setChanged();
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        this.security = security;
        this.setChanged();
    }

    public double getExpenses() {
        return this.expenses;
    }

    public void setExpenses(double expenses) {
        this.expenses = expenses;
        this.setChanged();
    }

    public double getAmount() {
        double amount = Math.abs((double)this.getQuantity() * this.getPrice());
        if (this.getQuantity() >= 0) {
            return -(amount + this.getExpenses());
        }
        return amount - this.getExpenses();
    }

    public Map getParams() {
        return this.params;
    }

    public void setParams(Map params) {
        this.params = params;
    }

    public void setParam(String key, String value) {
        this.params.put(key, value);
    }

    public String getParam(String key) {
        return (String)this.params.get(key);
    }
}

