/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.db;

import java.util.ArrayList;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import org.eclipsetrader.core.feed.IFeedIdentifier;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.instruments.IUserProperties;
import pk.com.softech.messages.SymbolStatisticsData;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.History;
import pk.com.softech.tradingterminal.core.db.IntradayHistory;
import pk.com.softech.tradingterminal.core.db.Level2;
import pk.com.softech.tradingterminal.core.db.Level2Ask;
import pk.com.softech.tradingterminal.core.db.Level2Bid;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.SecurityGroup;
import pk.com.softech.tradingterminal.core.db.feed.FeedSource;
import pk.com.softech.tradingterminal.core.db.feed.Quote;
import pk.com.softech.tradingterminal.core.db.feed.TradeSource;
import pk.com.softech.tradingterminal.core.internal.CObservable;

public class Security
extends PersistentObject
implements ISecurity {
    public static final int SUN = 1;
    public static final int MON = 2;
    public static final int TUE = 4;
    public static final int WED = 8;
    public static final int THU = 16;
    public static final int FRI = 32;
    public static final int SAT = 64;
    String exchange = "";
    String symbol = "";
    String market = "";
    String description = "";
    String spot = "";
    Date spotFrom = null;
    Date spotTo = null;
    Currency currency;
    SecurityGroup group;
    FeedSource quoteFeed;
    FeedSource level2Feed;
    FeedSource historyFeed;
    TradeSource tradeSource;
    Level2Bid level2BidMBO;
    Quote quote;
    Level2Ask level2AskMBO;
    Level2Bid level2BidMBP;
    Level2Ask level2AskMBP;
    Double close;
    Double open;
    Double low;
    Double high;
    double maximumValue;
    int maximumVolume;
    long totalTrades;
    long totalTurnover;
    double upperLimit;
    double lowerLimit;
    int lotSize;
    float average;
    private String sector = "";
    long up;
    long down;
    long equal;
    double currentIndex;
    private long monetaryValue;
    double change;
    double changePerc;
    double highPerc;
    double lowPerc;
    protected long faceValue;
    protected double dividend;
    protected double bonusShare;
    protected double rightShare;
    protected double premium;
    long denominator = 0L;
    long multiplier = 0L;
    private String direction = "";
    CObservable quoteMonitor = new CObservable();
    CObservable level2Monitor = new CObservable();
    boolean enableDataCollector = false;
    int beginTime = 0;
    int endTime = 0;
    int weekDays = 62;
    int keepDays = 1;
    List splits = new ArrayList();
    List dividends = new ArrayList();
    String comment = "";
    private SymbolStatisticsData symbolStatistics = null;

    public void updateValues(Security that) {
        this.setExchange(that.getExchange());
        this.setMarket(that.getMarket());
        this.setSymbol(that.getSymbol());
        this.setDescription(that.getDescription());
        this.setSector(that.getSector());
        this.setLotSize(that.getLotSize());
        this.setCurrency(that.getCurrency());
        Quote quote = new Quote();
        quote.setLast(that.getQuote().getLast());
        quote.setLastDayClose(that.getQuote().getLastDayClose());
        quote.setBid(that.getQuote().getBid());
        quote.setAsk(that.getQuote().getAsk());
        quote.setBidSize(that.getQuote().getBidSize());
        quote.setAskSize(that.getQuote().getAskSize());
        quote.setDate(that.getQuote().getDate());
        quote.setVolume(that.getQuote().getVolume());
        quote.setInavValue(this.getQuote().getInavValue());
        quote.setInavVolume(this.getQuote().getInavVolume());
        quote.setInavCalculationTime(this.getQuote().getInavCalculationTime());
        this.setQuote(quote);
        this.setOpen(that.getOpen());
        this.setClose(that.getClose());
        this.setTotalTurnover(that.getTotalTurnover());
        this.setHigh(that.getHigh());
        this.setLow(that.getLow());
        this.setAverage(that.getAverage());
        this.setChange(that.getChange());
        this.setChangePerc(that.getChangePerc());
        this.setHighPerc(that.highPerc);
        this.setLowPerc(that.lowPerc);
        this.setSpot(that.getSpot());
        this.setSpotFrom(that.getSpotFrom());
        this.setSpotTo(that.getSpotTo());
        this.setTotalTrades(that.getTotalTrades());
        this.setMonetaryValue(that.getMonetaryValue());
        this.setDirection(that.getDirection());
        this.symbolStatistics = that.getSymbolStatistics();
        this.setUpperLimit(that.getUpperLimit());
        this.setLowerLimit(that.getLowerLimit());
        this.setDenominator(that.getDenominator());
        this.setMultiplier(that.getMultiplier());
        this.quoteMonitor.notifyObservers();
    }

    public Security() {
    }

    public Security(String id) {
        super(id);
    }

    public String getExchange() {
        return this.exchange;
    }

    public void setExchange(String exchange) {
        if (!this.exchange.equals(exchange)) {
            this.setChanged();
        }
        this.exchange = exchange;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String code) {
        if (!this.symbol.equals(code)) {
            this.setChanged();
        }
        this.symbol = code;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        if (!this.market.equals(market)) {
            this.setChanged();
        }
        this.market = market;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (!this.description.equals(description)) {
            this.setChanged();
        }
        this.description = description;
    }

    public Currency getCurrency() {
        if (this.currency == null && this.group != null) {
            return this.group.getCurrency();
        }
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        if (currency != null && !currency.equals(this.currency)) {
            this.setChanged();
        } else if (currency == null && this.currency != null) {
            this.setChanged();
        }
        this.currency = currency;
    }

    public SecurityGroup getGroup() {
        return this.group;
    }

    public void setGroup(SecurityGroup group) {
        if (group != null && !group.equals(this.group)) {
            this.setChanged();
        } else if (group == null && this.group != null) {
            this.setChanged();
        }
        this.group = group;
    }

    public FeedSource getHistoryFeed() {
        return this.historyFeed;
    }

    public void setHistoryFeed(FeedSource historyFeed) {
        if (this.historyFeed != null && !this.historyFeed.equals(historyFeed)) {
            this.setChanged();
        }
        if (this.historyFeed == null && historyFeed != null) {
            this.setChanged();
        }
        this.historyFeed = historyFeed;
    }

    public void setLimit(Double close) {
        this.setClose(close);
    }

    public FeedSource getQuoteFeed() {
        return this.quoteFeed;
    }

    public void setQuoteFeed(FeedSource quoteFeed) {
        if (this.quoteFeed != null && !this.quoteFeed.equals(quoteFeed)) {
            this.setChanged();
        }
        if (this.quoteFeed == null && quoteFeed != null) {
            this.setChanged();
        }
        this.quoteFeed = quoteFeed;
    }

    public FeedSource getLevel2Feed() {
        return this.level2Feed;
    }

    public void setLevel2Feed(FeedSource level2Feed) {
        if (this.level2Feed != null && !this.level2Feed.equals(level2Feed)) {
            this.setChanged();
        }
        if (this.level2Feed == null && level2Feed != null) {
            this.setChanged();
        }
        this.level2Feed = level2Feed;
    }

    public TradeSource getTradeSource() {
        return this.tradeSource;
    }

    public void setTradeSource(TradeSource tradeSource) {
        if (this.tradeSource != null && !this.tradeSource.equals(tradeSource)) {
            this.setChanged();
        }
        if (this.tradeSource == null && tradeSource != null) {
            this.setChanged();
        }
        this.tradeSource = tradeSource;
    }

    public History getHistory() {
        return (History)this.getRepository().load(History.class, this.getId());
    }

    public IntradayHistory getIntradayHistory() {
        return (IntradayHistory)this.getRepository().load(IntradayHistory.class, this.getId());
    }

    public void deleteHistory() {
        this.getRepository().delete(this.getHistory());
    }

    public void deleteIntradayHistory() {
        this.getRepository().delete(this.getIntradayHistory());
    }

    public Quote getQuote() {
        return this.quote;
    }

    public void setQuote(Quote quote) {
        if (this.quote != null && !this.quote.equals(quote)) {
            this.quoteMonitor.setChanged();
        } else if (this.quote == null && quote != null) {
            this.quoteMonitor.setChanged();
        }
        this.quote = quote;
    }

    public void setETFQuote(Quote quote) {
        if (this.quote != null && !this.quote.checkETFEquals(quote)) {
            this.quoteMonitor.setChanged();
        } else if (this.quote == null && quote != null) {
            this.quoteMonitor.setChanged();
        }
        this.quote = quote;
    }

    public void setQuote(Quote quote, Double open, Double high, Double low, Double close) {
        this.setQuote(quote);
        if (this.open != null && !this.open.equals(open)) {
            this.quoteMonitor.setChanged();
        } else if (this.open == null && open != null) {
            this.quoteMonitor.setChanged();
        }
        this.open = open;
        if (this.high != null && !this.high.equals(high)) {
            this.quoteMonitor.setChanged();
        } else if (this.high == null && high != null) {
            this.quoteMonitor.setChanged();
        }
        this.high = high;
        if (this.low != null && !this.low.equals(low)) {
            this.quoteMonitor.setChanged();
        } else if (this.low == null && low != null) {
            this.quoteMonitor.setChanged();
        }
        this.low = low;
    }

    public void setQuote(Quote quote, Double high, Double low) {
        this.setQuote(quote);
        if (this.high != null && !this.high.equals(high)) {
            this.quoteMonitor.setChanged();
        } else if (this.high == null && high != null) {
            this.quoteMonitor.setChanged();
        }
        this.high = high;
        if (this.low != null && !this.low.equals(low)) {
            this.quoteMonitor.setChanged();
        } else if (this.low == null && low != null) {
            this.quoteMonitor.setChanged();
        }
        this.low = low;
    }

    public void setQuote(Quote quote, Double open) {
        this.setQuote(quote);
        if (this.open != null && !this.open.equals(open)) {
            this.quoteMonitor.setChanged();
        } else if (this.open == null && open != null) {
            this.quoteMonitor.setChanged();
        }
        this.open = open;
    }

    public Double getHigh() {
        return this.high;
    }

    public void setHigh(Double high) {
        if (this.high != null && !this.high.equals(high)) {
            this.quoteMonitor.setChanged();
        } else if (this.high == null && high != null) {
            this.quoteMonitor.setChanged();
        }
        this.high = high;
    }

    public Double getLow() {
        return this.low;
    }

    public void setLow(Double low) {
        if (this.low != null && !this.low.equals(low)) {
            this.quoteMonitor.setChanged();
        } else if (this.low == null && low != null) {
            this.quoteMonitor.setChanged();
        }
        this.low = low;
    }

    public Double getOpen() {
        return this.open;
    }

    public void setOpen(Double open) {
        if (this.open != null && !this.open.equals(open)) {
            this.quoteMonitor.setChanged();
        } else if (this.open == null && open != null) {
            this.quoteMonitor.setChanged();
        }
        this.open = open;
    }

    public void setCurrentIndex(Double currentIndex) {
        if (this.currentIndex != currentIndex) {
            this.quoteMonitor.setChanged();
        }
        this.currentIndex = currentIndex;
    }

    public Double getCurrentIndex() {
        return this.currentIndex;
    }

    public void setUp(long up) {
        if (this.up != up) {
            this.quoteMonitor.setChanged();
        }
        this.up = up;
    }

    public long getUp() {
        return this.up;
    }

    public void setDown(long down) {
        if (this.down != down) {
            this.quoteMonitor.setChanged();
        }
        this.down = down;
    }

    public long getDown() {
        return this.down;
    }

    public void setEqual(long equal) {
        if (this.equal != equal) {
            this.quoteMonitor.setChanged();
        }
        this.equal = equal;
    }

    public long getEqual() {
        return this.equal;
    }

    public void setTotalTrades(long totalTrades) {
        if (this.totalTrades != totalTrades) {
            this.quoteMonitor.setChanged();
        }
        this.totalTrades = totalTrades;
    }

    public long getTotalTrades() {
        return this.totalTrades;
    }

    public void setTotalTurnover(long totalTurnover) {
        if (this.totalTurnover != totalTurnover) {
            this.quoteMonitor.setChanged();
        }
        this.totalTurnover = totalTurnover;
    }

    public long getTotalTurnover() {
        return this.totalTurnover;
    }

    public void setClose(Double close) {
        boolean calcLimits = false;
        if (this.close != null && !this.close.equals(close)) {
            this.quoteMonitor.setChanged();
            calcLimits = true;
        } else if (this.close == null && close != null) {
            this.quoteMonitor.setChanged();
            calcLimits = true;
        }
        this.close = close;
        if (calcLimits) {
            Resources.getLowerLimit(this);
            this.setLowerLimit(Resources.getLowerLimit(this));
            this.setUpperLimit(Resources.getUpperlimit(this));
        }
    }

    public Double getClose() {
        return this.close;
    }

    public void setChange(Double change) {
        if (this.change != change) {
            this.quoteMonitor.setChanged();
        }
        this.change = Double.isNaN(change) ? 0.0 : change;
    }

    public Double getChange() {
        return this.change;
    }

    public void setChangePerc(Double changePerc) {
        if (this.changePerc != changePerc) {
            this.quoteMonitor.setChanged();
        }
        this.changePerc = Double.isNaN(changePerc) ? 0.0 : changePerc;
    }

    public Double getChangePerc() {
        return this.changePerc;
    }

    public void setHighPerc(Double highPerc) {
        if (this.highPerc != highPerc) {
            this.quoteMonitor.setChanged();
        }
        this.highPerc = Double.isNaN(this.highPerc) ? 0.0 : highPerc;
    }

    public Double getHighPerc() {
        return this.highPerc;
    }

    public void setLowPerc(Double lowPerc) {
        if (this.lowPerc != lowPerc) {
            this.quoteMonitor.setChanged();
        }
        this.lowPerc = Double.isNaN(this.lowPerc) ? 0.0 : lowPerc;
    }

    public Double getLowPerc() {
        return this.lowPerc;
    }

    public void setAverage(float average) {
        if (this.average != average) {
            this.quoteMonitor.setChanged();
        }
        this.average = average;
    }

    public float getAverage() {
        return this.average;
    }

    public double getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(double maximumValue) {
        if (this.maximumValue != maximumValue) {
            this.quoteMonitor.setChanged();
        }
        this.maximumValue = maximumValue;
    }

    public int getMaximumVolume() {
        return this.maximumVolume;
    }

    public void setMaximumVolume(int maximumVolume) {
        if (this.maximumVolume != maximumVolume) {
            this.quoteMonitor.setChanged();
        }
        this.maximumVolume = maximumVolume;
    }

    public String getSpot() {
        return this.spot.trim();
    }

    public void setSpot(String spot) {
        if (this.spot != (spot = spot.replaceAll("[^\\x00-\\x7F]", ""))) {
            this.quoteMonitor.setChanged();
        }
        this.spot = spot;
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimit(double upperLimit) {
        if (this.upperLimit != upperLimit) {
            this.quoteMonitor.setChanged();
        }
        this.upperLimit = upperLimit;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(double lowerLimit) {
        if (this.lowerLimit != lowerLimit) {
            this.quoteMonitor.setChanged();
        }
        this.lowerLimit = lowerLimit;
    }

    public int getLotSize() {
        return this.lotSize;
    }

    public void setLotSize(int lotSize) {
        if (this.lotSize != lotSize) {
            this.quoteMonitor.setChanged();
        }
        this.lotSize = lotSize;
    }

    public void setSector(String sector) {
        if (this.sector != sector) {
            this.setChanged();
        }
        this.sector = sector;
        this.notifyObservers(this);
    }

    public String getSector() {
        return this.sector;
    }

    public void setMonetaryValue(long monetaryValue) {
        if (this.monetaryValue != monetaryValue) {
            this.quoteMonitor.setChanged();
        }
        this.monetaryValue = monetaryValue;
        this.notifyObservers(this);
    }

    public long getMonetaryValue() {
        return this.monetaryValue;
    }

    public Level2 getLevel2BidMBO() {
        return this.level2BidMBO;
    }

    public void setLevel2MBOBid(Level2Bid level2Bid) {
        this.level2BidMBO = level2Bid;
        this.level2Monitor.setChanged();
        this.level2Monitor.notifyObservers(this.level2BidMBO);
    }

    public Level2 getLevel2AskMBO() {
        return this.level2AskMBO;
    }

    public void setLevel2MBOAsk(Level2Ask level2Ask) {
        this.level2AskMBO = level2Ask;
        this.level2Monitor.setChanged();
        this.level2Monitor.notifyObservers(this.level2AskMBO);
    }

    public void setLevel2MBO(Level2Bid level2Bid, Level2Ask level2Ask) {
        this.level2BidMBO = level2Bid;
        this.level2AskMBO = level2Ask;
        this.level2Monitor.setChanged();
        this.level2Monitor.notifyObservers();
    }

    public Level2 getLevel2BidMBP() {
        return this.level2BidMBP;
    }

    public void setLevel2MBPBid(Level2Bid level2Bid) {
        this.level2BidMBP = level2Bid;
        this.level2Monitor.setChanged();
        this.level2Monitor.notifyObservers(this.level2BidMBP);
    }

    public Level2 getLevel2AskMBP() {
        return this.level2AskMBP;
    }

    public void setLevel2MBPAsk(Level2Ask level2Ask) {
        this.level2AskMBP = level2Ask;
        this.level2Monitor.setChanged();
        this.level2Monitor.notifyObservers(this.level2AskMBP);
    }

    public void setLevel2MBP(Level2Bid level2Bid, Level2Ask level2Ask) {
        this.level2BidMBP = level2Bid;
        this.level2AskMBP = level2Ask;
        this.level2Monitor.setChanged();
        this.level2Monitor.notifyObservers();
    }

    public CObservable getLevel2Monitor() {
        return this.level2Monitor;
    }

    public CObservable getQuoteMonitor() {
        return this.quoteMonitor;
    }

    public int getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(int beginTime) {
        this.beginTime = beginTime;
    }

    public boolean isEnableDataCollector() {
        return this.enableDataCollector;
    }

    public void setEnableDataCollector(boolean enableDataCollector) {
        this.enableDataCollector = enableDataCollector;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public void setEndTime(int endTime) {
        this.endTime = endTime;
    }

    public int getWeekDays() {
        return this.weekDays;
    }

    public void setWeekDays(int weekDays) {
        this.weekDays = weekDays;
    }

    public int getKeepDays() {
        return this.keepDays;
    }

    public void setKeepDays(int keepDays) {
        this.keepDays = keepDays;
    }

    public List getDividends() {
        return this.dividends;
    }

    public void setDividends(List dividends) {
        this.dividends = dividends;
    }

    public List getSplits() {
        return this.splits;
    }

    public void setSplits(List splits) {
        this.splits = splits;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setSpotFrom(Date spotFrom) {
        if (this.spotFrom != spotFrom) {
            this.quoteMonitor.setChanged();
        }
        this.spotFrom = spotFrom;
    }

    public Date getSpotFrom() {
        return this.spotFrom;
    }

    public void setSpotTo(Date spotTo) {
        if (this.spotTo != spotTo) {
            this.quoteMonitor.setChanged();
        }
        this.spotTo = spotTo;
    }

    public Date getSpotTo() {
        return this.spotTo;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setSymbolStatistics(SymbolStatisticsData symbolStatistics) {
        if (this.symbol.equals("PSO")) {
            System.out.println("symbol data received " + symbolStatistics);
        }
        this.symbolStatistics = symbolStatistics;
    }

    public SymbolStatisticsData getSymbolStatistics() {
        return this.symbolStatistics;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public String getName() {
        return this.description;
    }

    @Override
    public IFeedIdentifier getIdentifier() {
        return null;
    }

    @Override
    public IUserProperties getProperties() {
        return null;
    }

    public void setFaceValue(long faceValue) {
        this.faceValue = faceValue;
    }

    public long getFaceValue() {
        return this.faceValue;
    }

    public void setDividend(double dividend) {
        this.dividend = dividend;
    }

    public double getDividend() {
        return this.dividend;
    }

    public void setBonusShare(double bonusShare) {
        this.bonusShare = bonusShare;
    }

    public double getBonusShare() {
        return this.bonusShare;
    }

    public void setRightShare(double rightShare) {
        this.rightShare = rightShare;
    }

    public double getRightShare() {
        return this.rightShare;
    }

    public void setPremium(double premium) {
        this.premium = premium;
    }

    public double getPremium() {
        return this.premium;
    }

    public void setDenominator(long denominator) {
        if (this.denominator != denominator) {
            this.quoteMonitor.setChanged();
        }
        this.denominator = denominator;
        this.notifyObservers(this);
    }

    public long getDenominator() {
        return this.denominator;
    }

    public void setMultiplier(long multiplier) {
        if (this.multiplier != multiplier) {
            this.quoteMonitor.setChanged();
        }
        this.multiplier = multiplier;
        this.notifyObservers(this);
    }

    public long getMultiplier() {
        return this.multiplier;
    }
}

