/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.db;

import pk.com.softech.tradingterminal.core.db.Account;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.feed.Quote;

public class PortfolioPosition {
    private Account account;
    private Security security;
    private int quantity;
    private double price;

    public PortfolioPosition(Account account, Security security, int quantity, double amount) {
        this.account = account;
        this.security = security;
        this.quantity = quantity;
        this.price = amount == 0.0 ? 0.0 : Math.abs(amount / (double)quantity);
    }

    public void add(int quantity, double amount) {
        double total = (double)this.quantity * this.price - amount;
        this.quantity += quantity;
        this.price = this.quantity == 0 ? 0.0 : Math.abs(total / (double)this.quantity);
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        this.security = security;
    }

    public double getValue() {
        return (double)Math.abs(this.quantity) * this.price;
    }

    public double getMarketValue() {
        double result = 0.0;
        Quote quote = this.security.getQuote();
        if (quote != null) {
            result = (double)Math.abs(this.quantity) * quote.getLast();
            result -= this.account.getExpenses(this.security, this.quantity, this.price);
        }
        return result;
    }
}

