/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;

public class PersistentPreferenceStore
implements IPreferenceStore {
    private ListenerList listeners = new ListenerList();
    private Map properties = new HashMap();
    private Map defaultProperties = new HashMap();
    private boolean dirty = false;

    public PersistentPreferenceStore() {
    }

    public PersistentPreferenceStore(PersistentPreferenceStore preferenceStore) {
        this.properties.putAll(preferenceStore.properties);
        this.defaultProperties.putAll(preferenceStore.defaultProperties);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public boolean contains(String name) {
        return this.properties.containsKey(name) || this.defaultProperties.containsKey(name);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        Object[] finalListeners = this.listeners.getListeners();
        if (!(finalListeners.length <= 0 || oldValue != null && oldValue.equals(newValue))) {
            final PropertyChangeEvent pe = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
            int i = 0;
            while (i < finalListeners.length) {
                final IPropertyChangeListener l = (IPropertyChangeListener)finalListeners[i];
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(JFaceResources.getString((String)"PreferenceStore.changeError")){

                    public void run() {
                        l.propertyChange(pe);
                    }
                });
                ++i;
            }
        }
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(this.properties, name);
    }

    private boolean getBoolean(Map p, String name) {
        String value = (String)p.get(name);
        if (value == null) {
            return false;
        }
        return value.equals("true");
    }

    public boolean getDefaultBoolean(String name) {
        return this.getBoolean(this.defaultProperties, name);
    }

    public double getDefaultDouble(String name) {
        return this.getDouble(this.defaultProperties, name);
    }

    public float getDefaultFloat(String name) {
        return this.getFloat(this.defaultProperties, name);
    }

    public int getDefaultInt(String name) {
        return this.getInt(this.defaultProperties, name);
    }

    public long getDefaultLong(String name) {
        return this.getLong(this.defaultProperties, name);
    }

    public String getDefaultString(String name) {
        return this.getString(this.defaultProperties, name);
    }

    public double getDouble(String name) {
        return this.getDouble(this.properties, name);
    }

    private double getDouble(Map p, String name) {
        String value = (String)p.get(name);
        if (value == null) {
            return 0.0;
        }
        double ival = 0.0;
        try {
            ival = new Double(value);
        }
        catch (NumberFormatException numberFormatException) {}
        return ival;
    }

    public float getFloat(String name) {
        return this.getFloat(this.properties, name);
    }

    private float getFloat(Map p, String name) {
        String value = (String)p.get(name);
        if (value == null) {
            return 0.0f;
        }
        float ival = 0.0f;
        try {
            ival = new Float(value).floatValue();
        }
        catch (NumberFormatException numberFormatException) {}
        return ival;
    }

    public int getInt(String name) {
        return this.getInt(this.properties, name);
    }

    private int getInt(Map p, String name) {
        String value = (String)p.get(name);
        if (value == null) {
            return 0;
        }
        int ival = 0;
        try {
            ival = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {}
        return ival;
    }

    public long getLong(String name) {
        return this.getLong(this.properties, name);
    }

    private long getLong(Map p, String name) {
        String value = (String)p.get(name);
        if (value == null) {
            return 0L;
        }
        long ival = 0L;
        try {
            ival = Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {}
        return ival;
    }

    public String getString(String name) {
        return this.getString(this.properties, name);
    }

    private String getString(Map p, String name) {
        String value = (String)p.get(name);
        if (value == null) {
            return "";
        }
        return value;
    }

    public boolean isDefault(String name) {
        return !this.properties.containsKey(name) && this.defaultProperties.containsKey(name);
    }

    public boolean needsSaving() {
        return this.dirty;
    }

    public String[] preferenceNames() {
        ArrayList list = new ArrayList();
        Iterator it = this.properties.keySet().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list.toArray(new String[list.size()]);
    }

    public void putValue(String name, String value) {
        String oldValue = this.getString(name);
        if (oldValue == null || !oldValue.equals(value)) {
            this.setValue(this.properties, name, value);
            this.dirty = true;
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void setDefault(String name, double value) {
        this.setValue(this.defaultProperties, name, value);
    }

    public void setDefault(String name, float value) {
        this.setValue(this.defaultProperties, name, value);
    }

    public void setDefault(String name, int value) {
        this.setValue(this.defaultProperties, name, value);
    }

    public void setDefault(String name, long value) {
        this.setValue(this.defaultProperties, name, value);
    }

    public void setDefault(String name, String value) {
        this.setValue(this.defaultProperties, name, value);
    }

    public void setDefault(String name, boolean value) {
        this.setValue(this.defaultProperties, name, value);
    }

    public void setToDefault(String name) {
        Object oldValue = this.properties.get(name);
        this.properties.remove(name);
        this.dirty = true;
        Object newValue = null;
        if (this.defaultProperties != null) {
            newValue = this.defaultProperties.get(name);
        }
        this.firePropertyChangeEvent(name, oldValue, newValue);
    }

    public void setValue(String name, double value) {
        double oldValue = this.getDouble(name);
        if (oldValue != value) {
            this.setValue(this.properties, name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, new Double(oldValue), new Double(value));
        }
    }

    public void setValue(String name, float value) {
        float oldValue = this.getFloat(name);
        if (oldValue != value) {
            this.setValue(this.properties, name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, new Float(oldValue), new Float(value));
        }
    }

    public void setValue(String name, int value) {
        int oldValue = this.getInt(name);
        if (oldValue != value) {
            this.setValue(this.properties, name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, new Integer(oldValue), new Integer(value));
        }
    }

    public void setValue(String name, long value) {
        long oldValue = this.getLong(name);
        if (oldValue != value) {
            this.setValue(this.properties, name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, new Long(oldValue), new Long(value));
        }
    }

    public void setValue(String name, String value) {
        String oldValue = this.getString(name);
        if (oldValue == null || !oldValue.equals(value)) {
            this.setValue(this.properties, name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    public void setValue(String name, boolean value) {
        boolean oldValue = this.getBoolean(name);
        if (oldValue != value) {
            this.setValue(this.properties, name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, new Boolean(oldValue), new Boolean(value));
        }
    }

    private void setValue(Map p, String name, double value) {
        p.put(name, Double.toString(value));
    }

    private void setValue(Map p, String name, float value) {
        p.put(name, Float.toString(value));
    }

    private void setValue(Map p, String name, int value) {
        p.put(name, Integer.toString(value));
    }

    private void setValue(Map p, String name, long value) {
        p.put(name, Long.toString(value));
    }

    private void setValue(Map p, String name, String value) {
        Assert.isTrue((value != null ? 1 : 0) != 0);
        p.put(name, value);
    }

    private void setValue(Map p, String name, boolean value) {
        p.put(name, value ? "true" : "false");
    }
}

