/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.db;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import pk.com.softech.tradingterminal.core.ITradingProvider;
import pk.com.softech.tradingterminal.core.db.Account;
import pk.com.softech.tradingterminal.core.db.OrderRoute;
import pk.com.softech.tradingterminal.core.db.OrderSide;
import pk.com.softech.tradingterminal.core.db.OrderStatus;
import pk.com.softech.tradingterminal.core.db.OrderType;
import pk.com.softech.tradingterminal.core.db.OrderValidity;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Security;

public class Order
extends PersistentObject {
    String pluginId = "";
    ITradingProvider provider;
    Account account;
    String subAccount = "";
    OrderRoute exchange;
    String orderId = "";
    Date date = Calendar.getInstance().getTime();
    Security security;
    String market;
    OrderSide side;
    OrderType type;
    int quantity;
    float price;
    float stopPrice;
    int filledQuantity;
    double averagePrice;
    Date expire;
    OrderValidity validity;
    OrderStatus status = OrderStatus.NEW;
    String text;
    String message;
    String orderClient;
    String tradeNumber;
    int afterHour;
    int gtc;
    int orderProperty;
    int discVol;
    String refNumber;
    String orderSource;
    String userId = "";
    String orderNature;
    Map params = new HashMap();

    public Order() {
    }

    public Order(String id) {
        super(id);
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public ITradingProvider getProvider() {
        return this.provider;
    }

    public void setProvider(ITradingProvider source) {
        this.provider = source;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public void setSubAccount(String subAccount) {
        if (subAccount != null) {
            this.subAccount = subAccount;
        }
    }

    public String getSubAccount() {
        return this.subAccount;
    }

    public double getAveragePrice() {
        return this.averagePrice;
    }

    public void setAveragePrice(double averagePrice) {
        if (this.averagePrice != averagePrice) {
            this.setChanged();
        }
        this.averagePrice = averagePrice;
    }

    public String getOrderClient() {
        return this.orderClient;
    }

    public void setOrderClient(String orderClient) {
        if (this.orderClient != orderClient) {
            this.setChanged();
        }
        this.orderClient = orderClient;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        if (this.date != date) {
            this.setChanged();
        }
        this.date = date;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        if (this.orderId != orderId) {
            this.setChanged();
        }
        this.orderId = orderId;
    }

    public float getPrice() {
        return this.price;
    }

    public void setPrice(float price) {
        if (this.price != price) {
            this.setChanged();
        }
        this.price = price;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        if (this.quantity != quantity) {
            this.setChanged();
        }
        this.quantity = quantity;
    }

    public int getFilledQuantity() {
        return this.filledQuantity;
    }

    public void setFilledQuantity(int filledQuantity) {
        if (this.filledQuantity != filledQuantity) {
            this.setChanged();
        }
        this.filledQuantity = filledQuantity;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        if (this.security != security) {
            this.setChanged();
        }
        this.security = security;
    }

    public OrderSide getSide() {
        return this.side;
    }

    public void setSide(OrderSide side) {
        this.side = side;
    }

    public OrderStatus getStatus() {
        return this.status;
    }

    public void setStatus(OrderStatus status) {
        if (!this.status.equals(status)) {
            this.setChanged();
        }
        this.status = status;
    }

    public float getStopPrice() {
        return this.stopPrice;
    }

    public void setStopPrice(float stopPrice) {
        if (this.stopPrice != stopPrice) {
            this.setChanged();
        }
        this.stopPrice = stopPrice;
    }

    public OrderType getType() {
        return this.type;
    }

    public void setType(OrderType type) {
        if (this.type != type) {
            this.setChanged();
        }
        this.type = type;
    }

    public OrderRoute getExchange() {
        return this.exchange;
    }

    public void setExchange(OrderRoute exchange) {
        this.exchange = exchange;
    }

    public Date getExpire() {
        return this.expire;
    }

    public void setExpire(Date expire) {
        this.expire = expire;
    }

    public OrderValidity getValidity() {
        return this.validity;
    }

    public void setValidity(OrderValidity validity) {
        this.validity = validity;
    }

    public Map getParams() {
        return this.params;
    }

    public void setParams(Map params) {
        this.params = params;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void sendNew() {
        if (this.provider == null) {
            throw new RuntimeException("Invalid argument");
        }
        this.provider.sendNew(this);
    }

    public void cancelRequest() throws RuntimeException {
        if (this.provider == null) {
            throw new RuntimeException("Invalid argument(provider is null)");
        }
        this.provider.sendCancelRequest(this);
    }

    public void replaceRequest() {
        if (this.provider == null) {
            throw new RuntimeException("Invalid argument");
        }
        this.provider.sendReplaceRequest(this);
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public void setTradeNumber(String tradeNumber) {
        this.tradeNumber = tradeNumber;
    }

    public String getTradeNumber() {
        return this.tradeNumber;
    }

    public int getAfterHour() {
        return this.afterHour;
    }

    public void setAfterHour(int afterHour) {
        this.afterHour = afterHour;
    }

    public int getGTC() {
        return this.gtc;
    }

    public void setGTC(int gtc) {
        this.gtc = gtc;
    }

    public int getOrderProperty() {
        return this.orderProperty;
    }

    public void setOrderProperty(int orderProperty) {
        this.orderProperty = orderProperty;
    }

    public int getDiscVol() {
        return this.discVol;
    }

    public String getOrderNature() {
        return this.orderNature;
    }

    public void setOrderNature(String orderNature) {
        this.orderNature = orderNature;
    }

    public void setDiscVol(int discVol) {
        this.discVol = discVol;
    }

    public String getRefNumber() {
        return this.refNumber == null ? "" : this.refNumber;
    }

    public void setRefNumber(String refNumber) {
        if (refNumber == null) {
            refNumber = "";
        }
        this.refNumber = refNumber;
    }

    public String getOrderSource() {
        return this.orderSource;
    }

    public void setOrderSource(String orderSource) {
        this.orderSource = orderSource;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        if (this.userId != userId) {
            this.setChanged();
        }
        this.userId = userId;
    }

    public String toString() {
        return "Order [pluginId=" + this.pluginId + ", provider=" + this.provider + ", account=" + this.account + ", exchange=" + this.exchange + ", orderId=" + this.orderId + ", date=" + this.date + ", security=" + this.security + ", market=" + this.market + ", side=" + this.side + ", type=" + this.type + ", quantity=" + this.quantity + ", price=" + this.price + ", stopPrice=" + this.stopPrice + ", filledQuantity=" + this.filledQuantity + ", averagePrice=" + this.averagePrice + ", expire=" + this.expire + ", validity=" + this.validity + ", status=" + this.status + ", text=" + this.text + ", message=" + this.message + ", orderClient=" + this.orderClient + ", tradeNumber=" + this.tradeNumber + ", afterHour=" + this.afterHour + ", orderProperty=" + this.orderProperty + ", discVol=" + this.discVol + ", refNumber=" + this.refNumber + ", params=" + this.params + "]";
    }
}

