/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import pk.com.softech.tradingterminal.core.db.Bar;
import pk.com.softech.tradingterminal.core.db.PersistentObject;

public class History
extends PersistentObject {
    List list = new ArrayList();
    Comparator dateSearchComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            Date d2;
            Date d1 = o1 instanceof Bar ? ((Bar)o1).getDate() : (Date)o1;
            Date date = d2 = o2 instanceof Bar ? ((Bar)o2).getDate() : (Date)o2;
            if (d1.after(d2)) {
                return 1;
            }
            if (d1.before(d2)) {
                return -1;
            }
            return 0;
        }
    };
    Comparator sortComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            Bar d1 = (Bar)o1;
            Bar d2 = (Bar)o2;
            if (d1.getDate().after(d2.getDate())) {
                return 1;
            }
            if (d1.getDate().before(d2.getDate())) {
                return -1;
            }
            return 0;
        }
    };

    public History() {
    }

    public History(String id) {
        super(id);
    }

    public int add(Bar obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        int index = Collections.binarySearch(this.list, obj.getDate(), this.dateSearchComparator);
        if (index < 0) {
            index = -(index + 1);
        }
        this.list.add(index, obj);
        this.setChanged();
        return index;
    }

    public void addAll(Collection collection) {
        for (Object obj : collection) {
            if (!(obj instanceof Bar)) continue;
            this.add((Bar)obj);
        }
    }

    public Bar remove(int index) {
        Bar result = (Bar)this.list.remove(index);
        this.setChanged();
        return result;
    }

    public boolean remove(Bar obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        boolean result = this.list.remove(obj);
        if (result) {
            this.setChanged();
        }
        return result;
    }

    public void clear() {
        this.list.clear();
        this.setChanged();
    }

    public int size() {
        return this.list.size();
    }

    public Bar get(int index) {
        return (Bar)this.list.get(index);
    }

    public Bar getFirst() {
        return this.list.size() == 0 ? null : (Bar)this.list.get(0);
    }

    public Bar getLast() {
        return this.list.size() == 0 ? null : (Bar)this.list.get(this.list.size() - 1);
    }

    public Bar get(Date date) {
        Bar bar;
        if (date == null) {
            throw new IllegalArgumentException();
        }
        int index = Collections.binarySearch(this.list, date, this.dateSearchComparator);
        Bar bar2 = bar = index >= 0 && index < this.list.size() ? (Bar)this.list.get(index) : null;
        if (bar != null && !bar.getDate().equals(date)) {
            bar = null;
        }
        return bar;
    }

    public int indexOf(Date date) {
        Bar bar;
        if (date == null) {
            throw new IllegalArgumentException();
        }
        int index = Collections.binarySearch(this.list, date, this.dateSearchComparator);
        Bar bar2 = bar = index >= 0 && index < this.list.size() ? (Bar)this.list.get(index) : null;
        if (bar == null || !bar.getDate().equals(date)) {
            index = -1;
        }
        return index;
    }

    public Iterator iterator() {
        return new ArrayList(this.list).iterator();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public List getList() {
        return Collections.unmodifiableList(this.list);
    }

    public Bar[] toArray() {
        return this.list.toArray(new Bar[this.list.size()]);
    }
}

