/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.db;

import java.util.Iterator;
import pk.com.softech.tradingterminal.core.ObservableList;
import pk.com.softech.tradingterminal.core.db.ChartIndicator;
import pk.com.softech.tradingterminal.core.db.ChartObject;
import pk.com.softech.tradingterminal.core.db.ChartRow;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.visitors.IChartVisitor;

public class ChartTab
extends PersistentObject {
    private ChartRow parent;
    private String label = "";
    private ObservableList indicators = new ObservableList();
    private ObservableList objects = new ObservableList();

    public ChartTab() {
    }

    public ChartTab(String id) {
        super(id);
    }

    public ChartRow getParent() {
        return this.parent;
    }

    public void setParent(ChartRow chartRow) {
        this.parent = chartRow;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (!this.label.equals(label)) {
            this.setChanged();
        }
        this.label = label;
    }

    public ObservableList getIndicators() {
        return this.indicators;
    }

    public void setIndicators(ObservableList rows) {
        this.indicators = rows;
    }

    public ObservableList getObjects() {
        return this.objects;
    }

    public void setObjects(ObservableList objects) {
        this.objects = objects;
    }

    @Override
    public synchronized void clearChanged() {
        Iterator iter = this.getIndicators().iterator();
        while (iter.hasNext()) {
            ((ChartIndicator)iter.next()).clearChanged();
        }
        super.clearChanged();
    }

    @Override
    public synchronized void setChanged() {
        super.setChanged();
        if (this.getParent() != null) {
            this.getParent().setChanged();
        }
    }

    @Override
    public void notifyObservers() {
        Iterator iter = this.getIndicators().iterator();
        while (iter.hasNext()) {
            ((ChartIndicator)iter.next()).notifyObservers();
        }
        super.notifyObservers();
    }

    public void accept(IChartVisitor visitor) {
        visitor.visit(this);
        ChartIndicator[] indicators = this.getIndicators().toArray(new ChartIndicator[this.getIndicators().size()]);
        int i = 0;
        while (i < indicators.length) {
            visitor.visit(indicators[i]);
            ++i;
        }
        ChartObject[] objects = this.getObjects().toArray(new ChartObject[this.getObjects().size()]);
        int i2 = 0;
        while (i2 < objects.length) {
            visitor.visit(objects[i2]);
            ++i2;
        }
    }
}

