/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.db;

import java.util.Iterator;
import pk.com.softech.tradingterminal.core.ObservableList;
import pk.com.softech.tradingterminal.core.db.Chart;
import pk.com.softech.tradingterminal.core.db.ChartTab;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.visitors.IChartVisitor;

public class ChartRow
extends PersistentObject {
    private Chart parent;
    private ObservableList tabs = new ObservableList();

    public ChartRow() {
    }

    public ChartRow(String id) {
        super(id);
    }

    public Chart getParent() {
        return this.parent;
    }

    public void setParent(Chart chart) {
        this.parent = chart;
    }

    public ObservableList getTabs() {
        return this.tabs;
    }

    public void setTabs(ObservableList rows) {
        this.tabs = rows;
    }

    public void add(ChartTab tab) {
        tab.setParent(this);
        this.getTabs().add(tab);
    }

    @Override
    public synchronized void clearChanged() {
        Iterator iter = this.getTabs().iterator();
        while (iter.hasNext()) {
            ((ChartTab)iter.next()).clearChanged();
        }
        super.clearChanged();
    }

    @Override
    public synchronized void setChanged() {
        super.setChanged();
        if (this.getParent() != null) {
            this.getParent().setChanged();
        }
    }

    @Override
    public void notifyObservers() {
        Iterator iter = this.getTabs().iterator();
        while (iter.hasNext()) {
            ((ChartTab)iter.next()).notifyObservers();
        }
        super.notifyObservers();
    }

    public void accept(IChartVisitor visitor) {
        visitor.visit(this);
        ChartTab[] tabs = this.getTabs().toArray(new ChartTab[this.getTabs().size()]);
        int i = 0;
        while (i < tabs.length) {
            tabs[i].accept(visitor);
            ++i;
        }
    }
}

