/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.db;

import java.util.Date;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import pk.com.softech.tradingterminal.core.ObservableList;
import pk.com.softech.tradingterminal.core.db.ChartRow;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.visitors.IChartVisitor;

public class Chart
extends PersistentObject
implements Observer {
    private String title = "";
    private Security security;
    private int compression = 8;
    private int period = 0;
    private Date beginDate;
    private Date endDate;
    private boolean autoScale = true;
    private ObservableList rows = new ObservableList();

    public Chart() {
    }

    public Chart(String id) {
        super(id);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String label) {
        this.title = label;
        this.setChanged();
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        if (security != null && !security.equals(this.security)) {
            this.setChanged();
        } else if (security == null && this.security != null) {
            this.setChanged();
        }
        if (this.security != null) {
            this.security.deleteObserver(this);
        }
        this.security = security;
        if (this.security != null) {
            this.security.addObserver(this);
        }
    }

    public int getCompression() {
        return this.compression;
    }

    public void setCompression(int compression) {
        this.compression = compression;
        this.setChanged();
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
        this.setChanged();
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
        this.setChanged();
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
        this.setChanged();
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
    }

    public ObservableList getRows() {
        return this.rows;
    }

    public void setRows(ObservableList rows) {
        this.rows = rows;
    }

    public void add(ChartRow row) {
        row.setParent(this);
        this.getRows().add(row);
    }

    public void add(int index, ChartRow row) {
        row.setParent(this);
        this.getRows().add(index, row);
        ChartRow[] rows = this.getRows().toArray(new ChartRow[this.getRows().size()]);
        int i = 0;
        while (i < rows.length) {
            rows[i].setId("" + i);
            ++i;
        }
    }

    @Override
    public synchronized void clearChanged() {
        Iterator iter = this.getRows().iterator();
        while (iter.hasNext()) {
            ((ChartRow)iter.next()).clearChanged();
        }
        super.clearChanged();
    }

    @Override
    public void notifyObservers() {
        Iterator iter = this.getRows().iterator();
        while (iter.hasNext()) {
            ((ChartRow)iter.next()).notifyObservers();
        }
        super.notifyObservers();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setChanged();
        this.notifyObservers();
    }

    public void accept(IChartVisitor visitor) {
        visitor.visit(this);
        ChartRow[] rows = this.getRows().toArray(new ChartRow[this.getRows().size()]);
        int i = 0;
        while (i < rows.length) {
            rows[i].accept(visitor);
            ++i;
        }
    }

    public String toString() {
        return "Chart [title=" + this.title + ", security=" + this.security + ", compression=" + this.compression + ", period=" + this.period + ", beginDate=" + this.beginDate + ", endDate=" + this.endDate + ", autoScale=" + this.autoScale + ", rows=" + this.rows.size() + "]";
    }
}

