/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.db;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import pk.com.softech.tradingterminal.core.db.Bar;

public class BarData {
    public static final int OPEN = 0;
    public static final int HIGH = 1;
    public static final int LOW = 2;
    public static final int CLOSE = 3;
    public static final int VOLUME = 4;
    public static final int INTERVAL_MINUTE1 = 1;
    public static final int INTERVAL_MINUTE2 = 2;
    public static final int INTERVAL_MINUTE5 = 3;
    public static final int INTERVAL_MINUTE10 = 4;
    public static final int INTERVAL_MINUTE15 = 5;
    public static final int INTERVAL_MINUTE30 = 6;
    public static final int INTERVAL_MINUTE60 = 7;
    public static final int INTERVAL_DAILY = 8;
    public static final int INTERVAL_WEEKLY = 9;
    public static final int INTERVAL_MONTHLY = 10;
    private List barList = new ArrayList();
    private double max = -9.9999999E7;
    private double min = 9.9999999E7;
    private int compression = 8;
    private Date begin;
    private Date end;

    public BarData() {
    }

    public BarData(List barList) {
        Bar[] bar = new Bar[barList.size()];
        barList.toArray(bar);
        this.addAll(bar);
    }

    public BarData(List barList, Date begin, Date end) {
        Bar[] bar = new Bar[barList.size()];
        barList.toArray(bar);
        int i = 0;
        while (i < bar.length) {
            if (!(begin != null && bar[i].getDate().before(begin) || end != null && bar[i].getDate().after(end))) {
                this.append(bar[i]);
            }
            ++i;
        }
        this.begin = begin;
        this.end = end;
    }

    public BarData(List list, int compression) {
        this(list, compression, null, null);
    }

    public BarData(List list, int compression, Date begin, Date end) {
        this.barList = this.getCompressedBars(list, compression, begin, end);
        int i = 0;
        while (i < this.barList.size()) {
            Bar bar = (Bar)this.barList.get(i);
            if (bar.getHigh() > this.max) {
                this.max = bar.getHigh();
            }
            if (bar.getLow() < this.min) {
                this.min = bar.getLow();
            }
            ++i;
        }
        this.compression = compression;
        this.begin = begin;
        this.end = end;
    }

    public boolean append(Bar obj) {
        if (this.barList.contains(obj)) {
            return false;
        }
        if (obj.getHigh() == 0.0 || obj.getLow() == 0.0) {
            return false;
        }
        if (obj.getHigh() > this.max) {
            this.max = obj.getHigh();
        }
        if (obj.getLow() < this.min) {
            this.min = obj.getLow();
        }
        if (this.begin == null || obj.getDate().before(this.begin)) {
            this.begin = obj.getDate();
        }
        if (this.end == null || obj.getDate().after(this.end)) {
            this.end = obj.getDate();
        }
        return this.barList.add(obj);
    }

    public void prepend(Bar obj) {
        if (this.barList.contains(obj)) {
            return;
        }
        if (obj.getHigh() == 0.0 || obj.getLow() == 0.0) {
            return;
        }
        if (obj.getHigh() > this.max) {
            this.max = obj.getHigh();
        }
        if (obj.getLow() < this.min) {
            this.min = obj.getLow();
        }
        if (this.begin == null || obj.getDate().before(this.begin)) {
            this.begin = obj.getDate();
        }
        if (this.end == null || obj.getDate().after(this.end)) {
            this.end = obj.getDate();
        }
        this.barList.add(0, obj);
    }

    public void addAll(Bar[] data) {
        int i = 0;
        while (i < data.length) {
            this.append(data[i]);
            ++i;
        }
    }

    public boolean remove(Bar arg0) {
        return this.barList.remove(arg0);
    }

    public Bar get(int index) {
        return (Bar)this.barList.get(index);
    }

    public int size() {
        return this.barList.size();
    }

    public Iterator iterator() {
        return this.barList.iterator();
    }

    public int indexOf(Bar obj) {
        return this.barList.indexOf(obj);
    }

    public void clear() {
        this.barList.clear();
        this.max = -9.9999999E7;
        this.min = 9.9999999E7;
        this.end = null;
        this.begin = null;
    }

    public Date getBegin() {
        return this.begin;
    }

    public Date getEnd() {
        return this.end;
    }

    public int getCompression() {
        return this.compression;
    }

    public void setCompression(int compression) {
        this.compression = compression;
    }

    public double getClose(int index) {
        return this.get(index).getClose();
    }

    public double getOpen(int index) {
        return this.get(index).getOpen();
    }

    public double getHigh(int index) {
        return this.get(index).getHigh();
    }

    public double getLow(int index) {
        return this.get(index).getLow();
    }

    public Date getDate(int x) {
        return this.get(x).getDate();
    }

    public long getVolume(int x) {
        return this.get(x).getVolume();
    }

    public int getX(Date date) {
        if (date == null) {
            return -1;
        }
        int i = 0;
        while (i < this.size()) {
            if (this.get(i).getDate().equals(date) || this.get(i).getDate().after(date)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public List getBars() {
        return this.barList;
    }

    public BarData getPeriod(Date begin, Date end) {
        BarData barData = new BarData();
        barData.compression = this.compression;
        for (Bar bar : this.barList) {
            if (bar.getDate().before(begin) || bar.getDate().after(end)) continue;
            barData.append(bar);
        }
        return barData;
    }

    public BarData getCompressed(int interval) {
        return this.getCompressed(interval, null, null);
    }

    public BarData getCompressed(int interval, Date begin, Date end) {
        BarData barData = new BarData(this.getCompressedBars(this.barList, interval, begin, end));
        barData.compression = interval;
        barData.begin = begin;
        barData.end = end;
        return barData;
    }

    List getCompressedBars(List list, int interval, Date begin, Date end) {
        ArrayList<Bar> bars = new ArrayList<Bar>();
        if (interval < 8) {
            int minutes = 1;
            Bar currentBar = null;
            Calendar nextBarTime = Calendar.getInstance();
            Calendar barTime = Calendar.getInstance();
            switch (interval) {
                case 1: {
                    minutes = 1;
                    break;
                }
                case 2: {
                    minutes = 2;
                    break;
                }
                case 3: {
                    minutes = 5;
                    break;
                }
                case 4: {
                    minutes = 10;
                    break;
                }
                case 5: {
                    minutes = 15;
                    break;
                }
                case 6: {
                    minutes = 30;
                    break;
                }
                case 7: {
                    minutes = 60;
                    break;
                }
                default: {
                    minutes = 1;
                }
            }
            for (Bar bar : list) {
                if (currentBar != null && currentBar.getDate() != null) {
                    barTime.setTime(bar.getDate());
                    if (barTime.after(nextBarTime) || barTime.equals(nextBarTime)) {
                        bars.add(currentBar);
                        currentBar = null;
                    }
                }
                if (currentBar == null) {
                    currentBar = new Bar();
                    currentBar.setOpen(bar.getOpen());
                    barTime.setTime(bar.getDate());
                    barTime.set(14, 0);
                    barTime.add(12, -(barTime.get(12) % minutes));
                    currentBar.setDate(barTime.getTime());
                    nextBarTime.setTime(currentBar.getDate());
                    nextBarTime.add(12, minutes);
                }
                currentBar.update(bar);
            }
            if (currentBar != null) {
                bars.add(currentBar);
            }
        } else if (interval == 9) {
            Bar currentBar = null;
            Calendar nextBarTime = Calendar.getInstance();
            Calendar barTime = Calendar.getInstance();
            for (Bar bar : list) {
                if (begin != null && bar.getDate().before(begin) || end != null && bar.getDate().after(end)) continue;
                if (currentBar != null && currentBar.getDate() != null) {
                    barTime.setTime(bar.getDate());
                    if (barTime.after(nextBarTime) || barTime.equals(nextBarTime)) {
                        bars.add(currentBar);
                        currentBar = null;
                    }
                }
                if (currentBar == null) {
                    currentBar = new Bar();
                    currentBar.setOpen(bar.getOpen());
                    barTime.setTime(bar.getDate());
                    barTime.set(14, 0);
                    barTime.set(13, 0);
                    barTime.set(12, 0);
                    barTime.set(10, 0);
                    barTime.add(5, -(barTime.get(7) - 2));
                    currentBar.setDate(barTime.getTime());
                    nextBarTime.setTime(currentBar.getDate());
                    nextBarTime.add(5, 7);
                }
                currentBar.update(bar);
            }
            if (currentBar != null) {
                bars.add(currentBar);
            }
        } else if (interval == 10) {
            Bar currentBar = null;
            Calendar nextBarTime = Calendar.getInstance();
            Calendar barTime = Calendar.getInstance();
            for (Bar bar : list) {
                if (begin != null && bar.getDate().before(begin) || end != null && bar.getDate().after(end)) continue;
                if (currentBar != null && currentBar.getDate() != null) {
                    barTime.setTime(bar.getDate());
                    if (barTime.after(nextBarTime) || barTime.equals(nextBarTime)) {
                        bars.add(currentBar);
                        currentBar = null;
                    }
                }
                if (currentBar == null) {
                    currentBar = new Bar();
                    currentBar.setOpen(bar.getOpen());
                    barTime.setTime(bar.getDate());
                    barTime.set(14, 0);
                    barTime.set(13, 0);
                    barTime.set(12, 0);
                    barTime.set(10, 0);
                    barTime.add(5, -(barTime.get(5) - 1));
                    currentBar.setDate(barTime.getTime());
                    nextBarTime.setTime(currentBar.getDate());
                    nextBarTime.add(2, 1);
                }
                currentBar.update(bar);
            }
            if (currentBar != null) {
                bars.add(currentBar);
            }
        } else {
            for (Bar bar : list) {
                if (begin != null && bar.getDate().before(begin) || end != null && bar.getDate().after(end)) continue;
                bars.add(bar);
            }
        }
        return bars;
    }

    public Bar[] toArray() {
        Bar[] result = new Bar[this.barList.size()];
        this.barList.toArray(result);
        return result;
    }

    public Bar[] toArray(int startIndex) {
        Bar[] result = new Bar[this.barList.size() - startIndex];
        int i = startIndex;
        while (i < this.barList.size()) {
            result[i - startIndex] = (Bar)this.barList.get(i);
            ++i;
        }
        return result;
    }

    public Bar[] toArray(int startIndex, int stopIndex) {
        Bar[] result = new Bar[stopIndex - startIndex];
        int i = startIndex;
        while (i < stopIndex) {
            result[i - startIndex] = (Bar)this.barList.get(i);
            ++i;
        }
        return result;
    }
}

