/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import pk.com.softech.tradingterminal.core.CurrencyConverter;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.ObservableList;
import pk.com.softech.tradingterminal.core.db.AccountGroup;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.PersistentPreferenceStore;
import pk.com.softech.tradingterminal.core.db.PortfolioPosition;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.Transaction;

public abstract class Account
extends PersistentObject
implements Cloneable {
    private String pluginId = "";
    private String description = "";
    private Currency currency = null;
    private double initialBalance = 0.0;
    private AccountGroup group = null;
    private PersistentPreferenceStore preferenceStore = new PersistentPreferenceStore();
    private ObservableList transactions = new ObservableList();
    private ICollectionObserver transactionsObserver = new ICollectionObserver(){

        @Override
        public void itemAdded(Object o) {
            Account.this.setChanged();
        }

        @Override
        public void itemRemoved(Object o) {
            Account.this.setChanged();
        }
    };
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            Account.this.setChanged();
        }
    };

    public Account() {
        this.transactions.addCollectionObserver(this.transactionsObserver);
        this.preferenceStore.addPropertyChangeListener(this.propertyChangeListener);
    }

    public Account(String id) {
        super(id);
        this.transactions.addCollectionObserver(this.transactionsObserver);
        this.preferenceStore.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected Account(Account account) {
        this.setDescription(account.getDescription());
        this.setCurrency(account.getCurrency());
        this.setInitialBalance(account.getBalance());
        this.setGroup(account.getGroup());
        this.setPreferenceStore(new PersistentPreferenceStore(account.getPreferenceStore()));
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String serviceId) {
        Assert.isNotNull((Object)serviceId);
        this.pluginId = serviceId;
        this.setChanged();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.setChanged();
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
        this.setChanged();
    }

    public double getInitialBalance() {
        return this.initialBalance;
    }

    public void setInitialBalance(double initbalance) {
        this.initialBalance = initbalance;
        this.setChanged();
    }

    public AccountGroup getGroup() {
        return this.group;
    }

    public void setGroup(AccountGroup group) {
        this.group = group;
        this.setChanged();
    }

    public PersistentPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public void setPreferenceStore(PersistentPreferenceStore preferenceStore) {
        Assert.isNotNull((Object)preferenceStore);
        this.preferenceStore.removePropertyChangeListener(this.propertyChangeListener);
        this.preferenceStore = preferenceStore;
        this.preferenceStore.addPropertyChangeListener(this.propertyChangeListener);
    }

    public ObservableList getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List transactions) {
        Assert.isNotNull((Object)transactions);
        if (this.transactions != null) {
            this.transactions.removeCollectionObserver(this.transactionsObserver);
        }
        this.transactions = new ObservableList(transactions);
        this.transactions.addCollectionObserver(this.transactionsObserver);
    }

    public double getBalance() {
        double result = this.getInitialBalance();
        Object[] objs = this.getTransactions().toArray();
        int i = 0;
        while (i < objs.length) {
            Transaction transaction = (Transaction)objs[i];
            double amount = transaction.getAmount();
            if (this.getCurrency() != null && !this.getCurrency().equals(transaction.getSecurity().getCurrency())) {
                amount = CurrencyConverter.getInstance().convert(transaction.getDate(), amount, transaction.getSecurity().getCurrency(), this.getCurrency());
            }
            result += amount;
            ++i;
        }
        return result;
    }

    public int getPosition(Security security) {
        int result = 0;
        Object[] objs = this.getTransactions().toArray();
        int i = 0;
        while (i < objs.length) {
            Transaction transaction = (Transaction)objs[i];
            if (transaction.getSecurity().equals(security)) {
                result += transaction.getQuantity();
            }
            ++i;
        }
        return result;
    }

    public List getPortfolio() {
        ArrayList<PortfolioPosition> result = new ArrayList<PortfolioPosition>();
        HashMap<Security, PortfolioPosition> map = new HashMap<Security, PortfolioPosition>();
        for (Transaction transaction : this.getTransactions()) {
            PortfolioPosition position = (PortfolioPosition)map.get(transaction.getSecurity());
            if (position == null) {
                map.put(transaction.getSecurity(), new PortfolioPosition(this, transaction.getSecurity(), transaction.getQuantity(), transaction.getAmount()));
                continue;
            }
            position.add(transaction.getQuantity(), transaction.getAmount());
        }
        ArrayList list = new ArrayList(map.keySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((Security)arg0).getDescription().compareTo(((Security)arg1).getDescription());
            }
        });
        for (Security security : list) {
            PortfolioPosition position = (PortfolioPosition)map.get(security);
            if (position.getQuantity() == 0) continue;
            result.add(position);
        }
        return result;
    }

    public PortfolioPosition getPortfolio(Security security) {
        PortfolioPosition position = new PortfolioPosition(this, security, 0, 0.0);
        for (Transaction transaction : this.getTransactions()) {
            if (!position.getSecurity().equals(transaction.getSecurity())) continue;
            position.add(transaction.getQuantity(), transaction.getAmount());
        }
        return position;
    }

    public double getExpenses(Security security, int quantity, double price) {
        return 0.0;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public String toString() {
        return "Account [pluginId=" + this.pluginId + ", description=" + this.description + ", currency=" + this.currency + ", initialBalance=" + this.initialBalance + "]";
    }
}

