/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core;

import com.hexapixel.articles.paperclips.core.GridPrinter;
import com.hexapixel.articles.paperclips.test.PrintHandler;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import net.sf.paperclips.DefaultGridLook;
import net.sf.paperclips.GridLook;
import net.sf.paperclips.GridPrint;
import net.sf.paperclips.ImagePrint;
import net.sf.paperclips.PaperClips;
import net.sf.paperclips.Print;
import net.sf.paperclips.PrintJob;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import pk.com.softech.tradingterminal.core.CorePlugin;

public class Utility {
    public static int clientPort = -1;

    public static String captureStackTrace(Throwable exception) {
        StringBuffer stackTrace = new StringBuffer();
        stackTrace.append("Exception in thread \"");
        stackTrace.append(Thread.currentThread());
        stackTrace.append("\" ");
        stackTrace.append(exception);
        stackTrace.append("\n");
        StackTraceElement[] elements = exception.getStackTrace();
        int x = 0;
        while (x < elements.length) {
            stackTrace.append(elements[x].toString());
            stackTrace.append("\n");
            ++x;
        }
        return stackTrace.toString();
    }

    public static String formatInt(int number) {
        if (number == 0) {
            return " ";
        }
        return "" + number;
    }

    public static Long getLong(String str) {
        Long lng = null;
        try {
            lng = new Long(Long.parseLong(str));
        }
        catch (NumberFormatException numberFormatException) {
            lng = null;
        }
        return lng;
    }

    public static Long getLong(long l) {
        Long lng = null;
        try {
            lng = new Long(l);
        }
        catch (NumberFormatException numberFormatException) {
            lng = null;
        }
        return lng;
    }

    public static Long getLong(int i) {
        Long lng = null;
        try {
            lng = new Long(i);
        }
        catch (NumberFormatException numberFormatException) {
            lng = null;
        }
        return lng;
    }

    public static Float getFloat(String str) {
        Float fl = null;
        try {
            fl = new Float(Float.parseFloat(str));
        }
        catch (NumberFormatException numberFormatException) {
            fl = null;
        }
        return fl;
    }

    public static Print createPrint(ImagePrint image) {
        GridPrint grid = new GridPrint("r:72, p, d, r:d:g(3), r:d:g", (GridLook)new DefaultGridLook(5, 5));
        image.setDPI(170, 170);
        grid.add(0x1000000, (Print)image, -1);
        GridPrint child = new GridPrint("d:g, d:g", (GridLook)new DefaultGridLook(10, 10));
        grid.add(16384, (Print)child, -1);
        return grid;
    }

    public static Print createPrintCropped(ImageData src, Printer printer, int scaleFactor) {
        PaletteData srcPal = src.palette;
        Rectangle printablebounds = PaperClips.getPaperBounds((Printer)printer);
        PaletteData destPal = srcPal.isDirect ? new PaletteData(srcPal.redMask, srcPal.greenMask, srcPal.blueMask) : new PaletteData(srcPal.getRGBs());
        System.out.println("parintablebounds : " + printer.getBounds().height / scaleFactor + " src bounds" + src.height);
        int destheight = printablebounds.height / scaleFactor;
        ImageData dest = new ImageData(src.width, destheight, src.depth, destPal);
        if (destheight < src.height) {
            System.out.println("parintablebounds 2 : " + printablebounds.height / scaleFactor + " src bounds" + src.height);
            int i = 0;
            while (i < src.width) {
                int j = 0;
                while (j < destheight) {
                    int pixel = src.getPixel(i, j);
                    dest.setPixel(i, j, pixel);
                    ++j;
                }
                ++i;
            }
        }
        ImagePrint image = new ImagePrint(dest);
        GridPrint grid = new GridPrint("r:72, p, d, r:d:g(3), r:d:g", (GridLook)new DefaultGridLook(5, 5));
        image.setDPI(100, 100);
        grid.add(0x1000000, (Print)image, -1);
        GridPrint child = new GridPrint("d:g, d:g", (GridLook)new DefaultGridLook(10, 10));
        grid.add(16384, (Print)child, -1);
        return grid;
    }

    public static void print(Composite content, String fileName, Table table, int width) {
        GridPrinter gp = new GridPrinter(new PrintHandler());
        Rectangle parentBounds = content.getBounds();
        Image parentImage = new Image((Device)Display.getDefault(), width, parentBounds.height);
        GC gc1 = new GC((Drawable)parentImage);
        content.print(gc1);
        gc1.dispose();
        ImageData src = parentImage.getImageData();
        gp.printImage(true, fileName, content.getShell(), src);
    }

    public static void printold(Composite content, String fileName) {
        PrintDialog dialog = new PrintDialog(content.getShell(), 0);
        PrinterData data = dialog.open();
        Printer printer = new Printer(data);
        if (data == null) {
            return;
        }
        Rectangle parentBounds = content.getBounds();
        Image parentImage = new Image((Device)content.getDisplay(), parentBounds.width, parentBounds.height);
        new ImageLoader();
        GC gc1 = new GC((Drawable)parentImage);
        content.print(gc1);
        ImageData src = parentImage.getImageData();
        int scaleFactor = printer.getDPI().y / content.getDisplay().getDPI().y;
        Print print = Utility.createPrintCropped(src, printer, scaleFactor);
        PrintJob printjob = new PrintJob(fileName, print).setMargins(36);
        printjob.setOrientation(256);
        PaperClips.print((PrintJob)printjob, (PrinterData)data);
    }

    public static Float getFloat(float f) {
        Float fl = null;
        try {
            fl = new Float(f);
        }
        catch (NumberFormatException numberFormatException) {
            fl = null;
        }
        return fl;
    }

    public static String formatFloat(float number) {
        if (number == 0.0f) {
            return " ";
        }
        return "" + number;
    }

    public static String getString(Date date) {
        String str = null;
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            str = String.valueOf(cal.get(5)) + "/" + (cal.get(2) + 1) + "/" + cal.get(1);
        }
        catch (Exception exception) {
            str = null;
        }
        return str;
    }

    public static String getTimeString(Date date) {
        String str = null;
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            str = String.valueOf(cal.get(5)) + "/" + (cal.get(2) + 1) + "/" + cal.get(1) + " " + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13);
        }
        catch (Exception exception) {
            str = null;
        }
        return str;
    }

    public static Date getDate(String strDate) {
        Date date = null;
        try {
            SimpleDateFormat sdf = CorePlugin.getDateParse();
            sdf.setLenient(false);
            date = sdf.parse(strDate);
        }
        catch (Exception exception) {
            date = null;
        }
        return date;
    }

    public static String getCurrentDate() {
        SimpleDateFormat dateFormat = CorePlugin.getDateFormat();
        Date date = new Date();
        String sysDate = dateFormat.format(date);
        return sysDate;
    }

    public static Date getTime(String strTime) {
        Date date = null;
        try {
            SimpleDateFormat sdf = CorePlugin.getTimeParse();
            sdf.setLenient(false);
            date = sdf.parse(strTime);
        }
        catch (Exception exception) {
            date = null;
        }
        return date;
    }

    public static String getCurrentTime() {
        SimpleDateFormat dateFormat = CorePlugin.getTimeFormat();
        Date date = new Date();
        String sysDate = dateFormat.format(date);
        return sysDate;
    }

    public static String getCurrentDateTime() {
        SimpleDateFormat dateFormat = CorePlugin.getDateTimeFormat();
        Date date = new Date();
        String sysDate = dateFormat.format(date);
        return sysDate;
    }

    public static int generateFeedPort() {
        Random ran = new Random();
        clientPort = ran.nextInt(3000) + 2064;
        return clientPort;
    }

    public static String getMillionString(double value, NumberFormat nf) {
        if (value > 1000000.0) {
            return String.valueOf(CorePlugin.getPriceFormatter().format(value / 1000000.0)) + " M";
        }
        return nf.format(value);
    }

    public static String getMillionString(Long value) {
        if (value > 1000000L) {
            BigDecimal b = new BigDecimal(value).divide(new BigDecimal(1000000));
            if (b.stripTrailingZeros().scale() <= 0) {
                return b + " M";
            }
            return String.valueOf(CorePlugin.getNumberFormattrTwoDecimal().format(b)) + " M";
        }
        return CorePlugin.getNumberFormattrTwoDecimal().format(value);
    }

    public static <T> T getValueOrDefault(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static String[] getTokens(String str, String delimiter) {
        String[] tokenArray = null;
        StringTokenizer st = new StringTokenizer(str, delimiter);
        int tokenCount = st.countTokens();
        tokenArray = new String[tokenCount];
        int i = 0;
        while (i < tokenCount) {
            tokenArray[i] = st.nextToken();
            ++i;
        }
        return tokenArray;
    }

    public static String getClientExchanges(Vector exchangeCodes) {
        String exchanges = "";
        if (exchangeCodes != null) {
            int i = 0;
            while (i < exchangeCodes.size()) {
                exchanges = String.valueOf(exchanges) + "'" + exchangeCodes.get(i) + "'";
                if (i < exchangeCodes.size() - 1) {
                    exchanges = String.valueOf(exchanges) + ",";
                }
                ++i;
            }
        }
        return exchanges;
    }

    public static List getTimeZones() {
        String[] ids = TimeZone.getAvailableIDs();
        ArrayList<TimeZoneID> list = new ArrayList<TimeZoneID>();
        Date today = new Date();
        int i = 0;
        while (i < ids.length) {
            list.add(new TimeZoneID(TimeZone.getTimeZone(ids[i]).getOffset(today.getTime()), TimeZone.getTimeZone(ids[i]).getID()));
            ++i;
        }
        Collections.sort(list);
        i = 0;
        while (i < list.size()) {
            TimeZoneID cfr_ignored_0 = (TimeZoneID)list.get(i);
            ++i;
        }
        return list;
    }

    public static class TimeZoneID
    implements Comparable {
        public Integer offset;
        public String id;

        public TimeZoneID(int offset, String id) {
            this.offset = offset;
            this.id = id;
        }

        public int compareTo(Object arg0) {
            TimeZoneID that = (TimeZoneID)arg0;
            return this.offset.compareTo(that.offset);
        }

        public String toString() {
            return String.valueOf(this.formate()) + " : " + this.id;
        }

        public boolean equals(Object obj) {
            return this.id.equals(((TimeZoneID)obj).id);
        }

        private String formate() {
            int time = this.offset;
            int hour = time / 3600000;
            int minute = time / 60000 % 60;
            String hString = String.valueOf(Math.abs(hour));
            String mString = String.valueOf(Math.abs(minute));
            if (hour > -10 && hour < 10) {
                if (hour > 0) {
                    hString = "+0" + hString;
                } else if (hour < 0) {
                    hString = "-0" + hString;
                }
            } else if (hour > 9) {
                hString = "+" + hString;
            } else if (hour < -9) {
                hString = "-" + hString;
            }
            if (minute > -10 && minute < 10) {
                mString = "0" + mString;
            }
            return String.valueOf(hString) + ":" + mString;
        }
    }
}

