/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pk.com.softech.messages.Message;
import pk.com.softech.messages.OrderMessage;
import pk.com.softech.tradingterminal.core.ITradingProvider;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.Order;
import pk.com.softech.tradingterminal.core.db.OrderStatus;
import pk.com.softech.util.Utility;

public class TradingProvider
implements ITradingProvider {
    private Log logger = LogFactory.getLog(this.getClass());

    @Override
    public List getSides() {
        return new ArrayList();
    }

    @Override
    public List getTypes() {
        return new ArrayList();
    }

    @Override
    public List getValidity() {
        return new ArrayList();
    }

    @Override
    public List getRoutes() {
        return new ArrayList();
    }

    @Override
    public void sendNew(Order order) {
    }

    @Override
    public void sendCancelRequest(Order order) throws RuntimeException {
        if (!OrderStatus.CANCELED.equals(order.getStatus())) {
            int remainingVol = order.getQuantity() - order.getFilledQuantity();
            String buyClient = "";
            String sellClient = "";
            int buyOrderNumber = 0;
            int sellOrderNumber = 0;
            int side = -1;
            String type = "";
            String symbol = order.getSecurity().getSymbol();
            String exCode = "";
            String marketTypeCode = "";
            try {
                exCode = Resources.exchangeCodes.get(Resources.exchangeNames.indexOf(order.getSecurity().getExchange())).toString();
                marketTypeCode = Resources.marketTypeCodes.get(Resources.marketTypes.indexOf(order.getSecurity().getMarket())).toString();
            }
            catch (Exception e) {
                this.logger.error((Object)("Error while setting ExchCode/MarketCode = " + order.getSecurity().getExchange() + "/" + order.getSecurity().getMarket()));
                this.logger.error((Object)"Error while setting ExchCode/MarketCode", (Throwable)e);
            }
            int afterHour = order.getAfterHour();
            int gtc = order.getGTC();
            type = order.getType().toString();
            if (order.getSide().getValue() == 0) {
                buyClient = order.getOrderClient();
                buyOrderNumber = Utility.parseInt(order.getId(), 0);
                side = 0;
            }
            if (order.getSide().getValue() == 1) {
                sellClient = order.getOrderClient();
                sellOrderNumber = Utility.parseInt(order.getId(), 0);
                side = 1;
            }
            OrderMessage orderMsg = new OrderMessage(Resources.userId, 2, 0, marketTypeCode, symbol, Resources.memberId, Resources.traderId, order.getPrice(), order.getPrice(), 0.0f, order.getExpire(), buyClient, buyOrderNumber, sellClient, sellOrderNumber, 0, Integer.parseInt(type), order.getQuantity(), remainingVol, 0, side, "0", 0, afterHour, gtc);
            orderMsg.setStExCode(exCode);
            this.logger.info((Object)(String.valueOf(Resources.getServerTime().toString()) + " sending cancel order " + exCode + "." + marketTypeCode + "." + symbol));
            if (Resources.isServerConnected(side == 0 ? buyClient : sellClient, true, false)) {
                Resources.getServerLink(side == 0 ? buyClient : sellClient, true, false).writeData(orderMsg);
            }
        }
    }

    @Override
    public void sendReplaceRequest(Order order) {
    }

    @Override
    public boolean send(Message message) {
        return true;
    }

    public String toString() {
        return "TradingProvider [getSides()=" + this.getSides().size() + ", getTypes()=" + this.getTypes().size() + ", getValidity()=" + this.getValidity().size() + ", getRoutes()=" + this.getRoutes().size() + "]";
    }
}

