/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pk.com.softech.messages.MarketData;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ObservableList;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.Account;
import pk.com.softech.tradingterminal.core.db.AccountGroup;
import pk.com.softech.tradingterminal.core.db.Alert;
import pk.com.softech.tradingterminal.core.db.Chart;
import pk.com.softech.tradingterminal.core.db.Event;
import pk.com.softech.tradingterminal.core.db.History;
import pk.com.softech.tradingterminal.core.db.NewsItem;
import pk.com.softech.tradingterminal.core.db.Order;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.SecurityGroup;
import pk.com.softech.tradingterminal.core.db.Trade;
import pk.com.softech.tradingterminal.core.db.Watchlist;
import pk.com.softech.tradingterminal.core.db.WatchlistItem;
import pk.com.softech.tradingterminal.core.db.trading.TradingSystem;

public class Repository {
    private ObservableList securityGroups;
    private ObservableList securities;
    private ObservableList watchlists;
    private ObservableList systemWatches;
    private ObservableList systemWatchesData;
    private ObservableList charts;
    private ObservableList news;
    private ObservableList accounts;
    private ObservableList accountGroups;
    private ObservableList events;
    private ObservableList tradingSystems;
    private ObservableList tradingSystemGroups;
    private ObservableList orders;
    private ObservableList trades;
    private ObservableList miscMessages;
    private ObservableList reportList;
    private ObservableList orderFormList;
    private ObservableList allAlerts;
    private ObservableList allPortfolioData;
    private ObservableList allSecurityPortfolio;
    private ObservableList allPortfolioPositionData;
    private ObservableList allSecurityPositionPortfolio;
    private ObservableList clearingTypes;
    private ObservableList lockedSymbols;
    private ObservableList allAnnouncements;
    private ObservableList clientList;
    private ObservableList allProfilingSymbols;
    private ObservableList reportConfigTypes;
    private Map newsMap = new HashMap();
    public static final int HISTORY = 0;
    public static final int INTRADAY = 1;
    private Log logger = LogFactory.getLog(this.getClass());

    public void dispose() {
    }

    public void clear() {
        this.securityGroups = null;
        this.securities = null;
        this.charts = null;
        this.watchlists = null;
        this.systemWatches = null;
        this.systemWatchesData = null;
        this.news = null;
        this.accounts = null;
        this.accountGroups = null;
        this.events = null;
        this.tradingSystems = null;
        this.tradingSystemGroups = null;
        this.orders = null;
        this.trades = null;
        this.miscMessages = null;
        this.reportList = null;
        this.newsMap = new HashMap();
        this.orderFormList = null;
        this.allAlerts = null;
        this.clearingTypes = null;
        this.lockedSymbols = null;
        this.allAnnouncements = null;
        this.allProfilingSymbols = null;
        this.clientList = null;
    }

    public ObservableList allSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new ObservableList();
        }
        return this.securityGroups;
    }

    public ObservableList allSecurities() {
        if (this.securities == null) {
            this.securities = new ObservableList();
        }
        return this.securities;
    }

    public ObservableList allWatchlists() {
        if (this.watchlists == null) {
            this.watchlists = new ObservableList();
        }
        return this.watchlists;
    }

    public ObservableList allSystemWatchlists() {
        if (this.systemWatches == null) {
            this.systemWatches = new ObservableList();
        }
        return this.systemWatches;
    }

    public ObservableList allSystemWatchlistsData() {
        if (this.systemWatchesData == null) {
            this.systemWatchesData = new ObservableList();
        }
        return this.systemWatchesData;
    }

    public ObservableList allProfilingSymbols() {
        if (this.allProfilingSymbols == null) {
            this.allProfilingSymbols = new ObservableList();
        }
        return this.allProfilingSymbols;
    }

    public ObservableList allReportConfigTypes() {
        if (this.reportConfigTypes == null) {
            this.reportConfigTypes = new ObservableList();
        }
        return this.reportConfigTypes;
    }

    public ObservableList allCharts() {
        if (this.charts == null) {
            this.charts = new ObservableList();
        }
        return this.charts;
    }

    public ObservableList allReportList() {
        if (this.reportList == null) {
            this.reportList = new ObservableList();
        }
        if (this.reportList.size() > 5) {
            this.reportList.clear();
        }
        return this.reportList;
    }

    public ObservableList allOrderFormList() {
        if (this.orderFormList == null) {
            this.orderFormList = new ObservableList();
        }
        return this.orderFormList;
    }

    public ObservableList allAlerts() {
        if (this.allAlerts == null) {
            this.allAlerts = new ObservableList();
        }
        return this.allAlerts;
    }

    public ObservableList allNews() {
        if (this.news == null) {
            this.news = new ObservableList();
        }
        return this.news;
    }

    public ObservableList getTradingSystems() {
        if (this.tradingSystems == null) {
            this.tradingSystems = new ObservableList();
        }
        return this.tradingSystems;
    }

    public ObservableList getTradingSystemGroups() {
        if (this.tradingSystemGroups == null) {
            this.tradingSystemGroups = new ObservableList();
        }
        return this.tradingSystemGroups;
    }

    public TradingSystem getTradingSystem(String pluginId) {
        for (TradingSystem system : this.getTradingSystems()) {
            if (!system.getPluginId().equals(pluginId)) continue;
            return system;
        }
        return null;
    }

    public ObservableList allNews(Security security) {
        ObservableList list = (ObservableList)this.newsMap.get(security);
        if (list == null) {
            list = new ObservableList();
            for (NewsItem news : this.allNews()) {
                if (!news.isSecurity(security)) continue;
                list.add(news);
            }
            this.newsMap.put(security, list);
        }
        return list;
    }

    public ObservableList allAccounts() {
        if (this.accounts == null) {
            this.accounts = new ObservableList();
        }
        return this.accounts;
    }

    public ObservableList allAccountGroups() {
        if (this.accountGroups == null) {
            this.accountGroups = new ObservableList();
        }
        return this.accountGroups;
    }

    public ObservableList allOrders() {
        if (this.orders == null) {
            this.orders = new ObservableList();
        }
        return this.orders;
    }

    public ObservableList allTrades() {
        if (this.trades == null) {
            this.trades = new ObservableList();
        }
        return this.trades;
    }

    public ObservableList miscMessagesList() {
        if (this.miscMessages == null) {
            this.miscMessages = new ObservableList();
        }
        if (this.miscMessages.size() > 5) {
            this.miscMessages.clear();
        }
        return this.miscMessages;
    }

    public ObservableList allLockedSymbols() {
        if (this.lockedSymbols == null) {
            this.lockedSymbols = new ObservableList();
        }
        return this.lockedSymbols;
    }

    public ObservableList allAnnouncements() {
        if (this.allAnnouncements == null) {
            this.allAnnouncements = new ObservableList();
        }
        return this.allAnnouncements;
    }

    public ObservableList allClientList() {
        if (this.clientList == null) {
            this.clientList = new ObservableList();
        }
        return this.clientList;
    }

    public synchronized Order getOrderById(String id) {
        for (Order ord : this.allOrders()) {
            if (ord == null || !ord.getOrderId().equals(id)) continue;
            return ord;
        }
        return null;
    }

    public Security getSecurityById(String id) {
        for (Security security : this.allSecurities()) {
            if (!security.getId().equals(id)) continue;
            return security;
        }
        return null;
    }

    public Security getSecurity(String symbol) {
        try {
            for (Security security : this.allSecurities()) {
                MarketData marketData = (MarketData)Resources.marketsData.get(MarketData.marketNames[MarketData.REGULAR]);
                String mkt = Resources.marketTypes.get(Resources.marketTypeCodes.indexOf(marketData.getCode())).toString();
                if (!security.getSymbol().equals(symbol) || !security.getMarket().equals(mkt)) continue;
                return security;
            }
            for (Security security : this.allSecurities()) {
                if (!security.getSymbol().equals(symbol)) continue;
                return security;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info((Object)("Exception in getSecurity " + e));
        }
        return null;
    }

    public Security getSecurity(String symbol, String exch) {
        for (Security security : this.allSecurities()) {
            String mkt = exch;
            if (!security.getSymbol().equals(symbol) || !security.getMarket().equals(mkt)) continue;
            return security;
        }
        for (Security security : this.allSecurities()) {
            if (!security.getSymbol().equals(symbol)) continue;
            return security;
        }
        return null;
    }

    public synchronized Security getSecurity(String exchange, String market, String symbol) {
        for (Security security : this.allSecurities()) {
            if (!security.getSymbol().equals(symbol) || !security.getMarket().equals(market) || !security.getExchange().equals(exchange)) continue;
            return security;
        }
        return null;
    }

    public synchronized Security getETFSecurity(String exchange, String symbol) {
        for (Security security : this.allSecurities()) {
            if (!security.getSymbol().equals(symbol) || !security.getExchange().equals(exchange)) continue;
            return security;
        }
        return null;
    }

    public void loadEvents(String userId) {
    }

    public synchronized ObservableList allEvents() {
        if (this.events == null) {
            this.events = new ObservableList();
        }
        return this.events;
    }

    public ObservableList allClearingTypes() {
        if (this.clearingTypes == null) {
            this.clearingTypes = new ObservableList();
        }
        return this.clearingTypes;
    }

    public PersistentObject load(Class clazz, String id) {
        if (clazz.equals(Security.class)) {
            for (PersistentObject obj : this.allSecurities()) {
                if (!id.equals(obj.getId())) continue;
                return obj;
            }
        }
        if (clazz.equals(Watchlist.class)) {
            for (PersistentObject obj : this.allWatchlists()) {
                if (!id.equals(obj.getId())) continue;
                return obj;
            }
            for (PersistentObject obj : this.allSystemWatchlists()) {
                if (!id.equals(obj.getId())) continue;
                return obj;
            }
        }
        return null;
    }

    public void save(PersistentObject obj) {
        try {
            obj.setRepository(this);
            if (obj instanceof Observable) {
                obj.notifyObservers();
            }
            if (obj instanceof Event && !this.allEvents().contains(obj)) {
                if (CorePlugin.getDefault().getPreferenceStore().getBoolean("ENABLE_EVENTS_LIMITS")) {
                    int limit = CorePlugin.getDefault().getPreferenceStore().getInt("EVENTS_LIMITS");
                    if (this.allEvents().size() >= limit) {
                        this.allEvents().remove(0);
                    }
                }
                this.allEvents().add(obj);
            }
            if (obj instanceof SecurityGroup && !this.allSecurityGroups().contains(obj)) {
                this.allSecurityGroups().add(obj);
            }
            if (obj instanceof Security && !this.allSecurities().contains(obj)) {
                this.allSecurities().add(obj);
            }
            if (obj instanceof Chart && !this.allCharts().contains(obj)) {
                this.allCharts().add(obj);
            }
            if (obj instanceof Watchlist) {
                Watchlist w = (Watchlist)obj;
                if (w.getWatchlistType() == 0 && !this.allWatchlists().contains(obj)) {
                    this.allWatchlists().add(obj);
                }
                if (w.getWatchlistType() == 1) {
                    try {
                        if (!this.allSystemWatchlists().contains(obj)) {
                            this.allSystemWatchlists().add(obj);
                        }
                    }
                    catch (Exception e) {
                        this.logger.info((Object)("Exception while saving System watchlist " + e));
                    }
                }
            }
            if (obj instanceof NewsItem) {
                NewsItem news = (NewsItem)obj;
                Calendar limit = Calendar.getInstance();
                limit.add(5, -CorePlugin.getDefault().getPreferenceStore().getInt("PREFS_NEWS_DATE_RANGE"));
                if (news.getDate().before(limit.getTime())) {
                    return;
                }
                int index = this.allNews().indexOf(news);
                if (index == -1) {
                    this.allNews().add(news);
                    Object[] o = news.getSecurities().toArray();
                    int i = 0;
                    while (i < o.length) {
                        List list = (List)this.newsMap.get(o[i]);
                        if (list != null && !list.contains(news)) {
                            list.add(news);
                        }
                        ++i;
                    }
                } else {
                    NewsItem existing = (NewsItem)this.allNews().get(index);
                    existing.addSecurities(news.getSecurities());
                    existing.notifyObservers();
                    Object[] o = existing.getSecurities().toArray();
                    int i = 0;
                    while (i < o.length) {
                        List list = (List)this.newsMap.get(o[i]);
                        if (list != null && !list.contains(existing)) {
                            list.add(existing);
                        }
                        ++i;
                    }
                }
            }
            if (obj instanceof AccountGroup) {
                AccountGroup parent;
                AccountGroup group = (AccountGroup)obj;
                if (!this.allAccountGroups().contains(group)) {
                    this.allAccountGroups().add(group);
                }
                if (group.getParent() != null && !(parent = group.getParent()).getGroups().contains(group)) {
                    parent.getGroups().add(group);
                }
            }
            if (obj instanceof Account) {
                AccountGroup group;
                Account account = (Account)obj;
                if (!this.allAccounts().contains(account)) {
                    this.allAccounts().add(account);
                }
                if (account.getGroup() != null && !(group = account.getGroup()).getAccounts().contains(account)) {
                    group.getAccounts().add(account);
                }
            }
            if (obj instanceof Order) {
                Order order = (Order)obj;
                if (!this.allOrders().contains(order)) {
                    this.allOrders().add(order);
                }
            }
            if (obj instanceof Trade) {
                Trade trade = (Trade)obj;
                if (!this.allTrades().contains(trade)) {
                    this.allTrades().add(trade);
                }
            }
            boolean cfr_ignored_0 = obj instanceof History;
            if (obj instanceof Alert) {
                Alert order = (Alert)obj;
                if (!this.allAlerts().contains(order)) {
                    this.allAlerts().add(order);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception while saving repository " + e);
        }
    }

    public void removeSecuritiesByOnlySymbol(String symbol) {
        Security oldSec = null;
        do {
            if ((oldSec = CorePlugin.getRepository().getSecurity(symbol)) == null) continue;
            this.removeFromAllSecurities(oldSec);
        } while (oldSec != null);
    }

    public void delete(PersistentObject obj) {
        int i;
        PersistentObject group;
        if (obj instanceof Event) {
            this.allEvents().remove((Event)obj);
        }
        if (obj instanceof SecurityGroup) {
            group = (SecurityGroup)obj;
            Iterator iter = ((SecurityGroup)group).getSecurities().iterator();
            while (iter.hasNext()) {
                this.delete((Security)iter.next());
            }
            iter = ((SecurityGroup)group).getGroups().iterator();
            while (iter.hasNext()) {
                this.delete((SecurityGroup)iter.next());
            }
            if (((SecurityGroup)group).getGroup() != null) {
                ((SecurityGroup)group).getGroup().getGroups().remove(group);
            }
            this.allSecurityGroups().remove(obj);
        }
        if (obj instanceof Security) {
            this.removeSecurity(obj);
        }
        if (obj instanceof Chart) {
            Chart chart = (Chart)obj;
            this.allCharts().remove(chart);
        }
        if (obj instanceof Watchlist) {
            this.allWatchlists().remove(obj);
            this.allSystemWatchlists().remove(obj);
        }
        if (obj instanceof NewsItem) {
            NewsItem news = (NewsItem)obj;
            this.allNews().remove(news);
            Object[] o = news.getSecurities().toArray();
            i = 0;
            while (i < o.length) {
                ObservableList list = (ObservableList)this.newsMap.get(o[i]);
                if (list != null && !list.contains(news)) {
                    list.remove(news);
                }
                ++i;
            }
        }
        if (obj instanceof Account) {
            TradingSystem[] systems = this.getTradingSystems().toArray(new TradingSystem[0]);
            int i2 = 0;
            while (i2 < systems.length) {
                if (obj.equals(systems[i2].getAccount())) {
                    this.delete(systems[i2]);
                }
                ++i2;
            }
            this.allAccounts().remove(obj);
            if (((Account)obj).getGroup() != null) {
                ((Account)obj).getGroup().getAccounts().remove(obj);
            }
        }
        if (obj instanceof AccountGroup) {
            group = (AccountGroup)obj;
            Object[] accounts = ((AccountGroup)group).getAccounts().toArray();
            i = 0;
            while (i < accounts.length) {
                this.delete((Account)accounts[i]);
                ++i;
            }
            Object[] groups = ((AccountGroup)group).getAccounts().toArray();
            int i3 = 0;
            while (i3 < groups.length) {
                this.delete((AccountGroup)groups[i3]);
                ++i3;
            }
            if (((AccountGroup)group).getParent() != null) {
                ((AccountGroup)group).getParent().getGroups().remove(group);
            }
            this.allAccountGroups().remove(group);
        }
        if (obj instanceof Order) {
            this.allOrders().remove(obj);
        }
        if (obj instanceof Trade) {
            this.allTrades().remove(obj);
        }
        if (obj instanceof TradingSystem) {
            this.getTradingSystems().remove(obj);
        }
    }

    private void removeFromAllSecurities(PersistentObject obj) {
        try {
            this.allSecurities().remove(obj);
        }
        catch (Exception exception) {}
    }

    private void removeSecurity(PersistentObject obj) {
        WatchlistItem item;
        int i;
        Object[] items;
        Security security = (Security)obj;
        try {
            if (security.getGroup() != null) {
                security.getGroup().getSecurities().remove(security);
            }
        }
        catch (Exception exception) {}
        try {
            for (Watchlist watchlist : this.allWatchlists()) {
                items = watchlist.getItems().toArray();
                i = 0;
                while (i < items.length) {
                    item = (WatchlistItem)items[i];
                    if (item.getSecurity().equals(obj)) {
                        watchlist.getItems().remove(item);
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
        try {
            for (Watchlist watchlist : this.allSystemWatchlists()) {
                items = watchlist.getItems().toArray();
                i = 0;
                while (i < items.length) {
                    item = (WatchlistItem)items[i];
                    if (item.getSecurity().equals(obj)) {
                        watchlist.getItems().remove(item);
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
        try {
            Chart[] charts = this.allCharts().toArray(new Chart[0]);
            int i2 = 0;
            while (i2 < charts.length) {
                if (charts[i2].getSecurity().equals(obj)) {
                    this.delete(charts[i2]);
                }
                ++i2;
            }
        }
        catch (Exception exception) {}
        try {
            TradingSystem[] systems = this.getTradingSystems().toArray(new TradingSystem[0]);
            int i3 = 0;
            while (i3 < systems.length) {
                if (obj.equals(systems[i3].getSecurity())) {
                    this.delete(systems[i3]);
                }
                ++i3;
            }
        }
        catch (Exception exception) {}
        try {
            Order[] orders = this.allOrders().toArray(new Order[0]);
            int i4 = 0;
            while (i4 < orders.length) {
                if (obj.equals(orders[i4].getSecurity())) {
                    this.delete(orders[i4]);
                }
                ++i4;
            }
        }
        catch (Exception exception) {}
        try {
            this.allSecurities().remove(obj);
        }
        catch (Exception exception) {}
    }

    public ObservableList allPortfolioData() {
        if (this.allPortfolioData == null) {
            this.allPortfolioData = new ObservableList();
        }
        return this.allPortfolioData;
    }

    public ObservableList allSecurityPortfolio() {
        if (this.allSecurityPortfolio == null) {
            this.allSecurityPortfolio = new ObservableList();
        }
        return this.allSecurityPortfolio;
    }

    public ObservableList allPortfolioPositionData() {
        if (this.allPortfolioPositionData == null) {
            this.allPortfolioPositionData = new ObservableList();
        }
        return this.allPortfolioPositionData;
    }

    public ObservableList allSecurityPositionPortfolio() {
        if (this.allSecurityPositionPortfolio == null) {
            this.allSecurityPositionPortfolio = new ObservableList();
        }
        return this.allSecurityPositionPortfolio;
    }
}

