/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import pk.com.softech.tradingterminal.core.ICollectionObserver;

public class ObservableList<E>
extends ArrayList {
    private static final long serialVersionUID = 7282371672763711235L;
    private List originalList;
    private ListenerList observers = new ListenerList(1);

    public ObservableList() {
    }

    public ObservableList(List list) {
        super(list);
        this.originalList = list;
    }

    public ObservableList(int initialCapacity) {
        super(initialCapacity);
    }

    public Collection getOriginalList() {
        return this.originalList;
    }

    public void addCollectionObserver(ICollectionObserver observer) {
        this.observers.add((Object)observer);
    }

    public void removeCollectionObserver(ICollectionObserver observer) {
        this.observers.remove((Object)observer);
    }

    protected void notifyItemAdded(Object o) {
        Object[] obs = this.observers.getListeners();
        int i = 0;
        while (i < obs.length) {
            ((ICollectionObserver)obs[i]).itemAdded(o);
            ++i;
        }
    }

    protected void notifyItemRemoved(Object o) {
        Object[] obs = this.observers.getListeners();
        int i = 0;
        while (i < obs.length) {
            ((ICollectionObserver)obs[i]).itemRemoved(o);
            ++i;
        }
    }

    @Override
    public boolean add(Object o) {
        boolean result = super.add(o);
        if (this.originalList != null) {
            this.originalList.add(o);
        }
        this.notifyItemAdded(o);
        return result;
    }

    @Override
    public void add(int index, Object element) {
        super.add(index, element);
        if (this.originalList != null) {
            this.originalList.add(index, element);
        }
        this.notifyItemAdded(element);
    }

    @Override
    public boolean remove(Object o) {
        boolean result = super.remove(o);
        if (this.originalList != null) {
            this.originalList.remove(o);
        }
        this.notifyItemRemoved(o);
        return result;
    }

    @Override
    public Object remove(int index) {
        Object result = super.remove(index);
        if (this.originalList != null) {
            this.originalList.remove(index);
        }
        this.notifyItemRemoved(result);
        return result;
    }

    @Override
    public void clear() {
        while (super.size() > 0) {
            this.remove(0);
        }
    }

    public int countObservers() {
        return this.observers.size();
    }

    public Object[] getObservers() {
        return this.observers.getListeners();
    }
}

