/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ILevel2Feed;
import pk.com.softech.tradingterminal.core.db.Security;

public class Level2FeedMonitor {
    private static Map feedMap = new HashMap();
    private static Map securityMap = new HashMap();
    private static Map securityInstances = new HashMap();
    private static Log log = LogFactory.getLog(Level2FeedMonitor.class);

    private Level2FeedMonitor() {
    }

    public static void monitor(Security security) {
        Integer count;
        ILevel2Feed feed;
        String id = (String)securityMap.get(security);
        if (!(id == null || security.getLevel2Feed() != null && id.equals(security.getLevel2Feed().getId()))) {
            feed = (ILevel2Feed)feedMap.get(id);
            if (feed != null) {
                feed.unSubscribeLevel2(security);
            }
            securityInstances.remove(security);
            securityMap.remove(security);
        }
        if (security.getLevel2Feed() == null) {
            return;
        }
        feed = (ILevel2Feed)feedMap.get(security.getLevel2Feed().getId());
        if (feed == null) {
            feed = CorePlugin.createLevel2FeedPlugin(security.getLevel2Feed().getId());
            if (feed == null) {
                return;
            }
            feedMap.put(security.getLevel2Feed().getId(), feed);
        }
        if ((count = (Integer)securityInstances.get(security)) == null) {
            count = new Integer(0);
            feed.subscribeLevel2(security);
            if (CorePlugin.getDefault().getPreferenceStore().getBoolean("FEED_RUNNING")) {
                feed.startLevel2();
            }
        }
        securityInstances.put(security, new Integer(count + 1));
        securityMap.put(security, security.getLevel2Feed().getId());
    }

    public static void cancelMonitor(Security security) {
        Integer count;
        if (security.getLevel2Feed() == null) {
            return;
        }
        ILevel2Feed feed = (ILevel2Feed)feedMap.get(security.getLevel2Feed().getId());
        if (feed == null) {
            feed = CorePlugin.createLevel2FeedPlugin(security.getLevel2Feed().getId());
            if (feed == null) {
                return;
            }
            feedMap.put(security.getLevel2Feed().getId(), feed);
        }
        if ((count = (Integer)securityInstances.get(security)) != null) {
            if (count - 1 == 0) {
                feed.unSubscribeLevel2(security);
                securityInstances.remove(security);
                securityMap.remove(security);
            } else {
                securityInstances.put(security, new Integer(count - 1));
            }
        }
    }

    public static synchronized void start() {
        log.info((Object)"Level2Feed Monitor Started");
        Iterator iter = feedMap.keySet().iterator();
        while (iter.hasNext()) {
            ILevel2Feed feed = (ILevel2Feed)feedMap.get((String)iter.next());
            feed.startLevel2();
        }
    }

    public static synchronized void stop() {
        log.info((Object)"Level2Feed Monitor stoped");
        Iterator iter = feedMap.keySet().iterator();
        while (iter.hasNext()) {
            ILevel2Feed feed = (ILevel2Feed)feedMap.get((String)iter.next());
            feed.stopLevel2();
        }
    }

    public static synchronized void snapshot() {
        Iterator iter = feedMap.keySet().iterator();
        while (iter.hasNext()) {
            ILevel2Feed feed = (ILevel2Feed)feedMap.get((String)iter.next());
            feed.snapshotLevel2();
        }
    }

    public static ILevel2Feed getFeed(String id) {
        return (ILevel2Feed)feedMap.get(id);
    }
}

