/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core;

import com.sun.net.ssl.internal.ssl.Provider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.Security;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.eclipse.jface.preference.IPreferenceStore;
import org.json.JSONObject;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.InvalidCertificateHostVerifier;
import pk.com.softech.tradingterminal.core.InvalidCertificateTrustManager;
import pk.com.softech.tradingterminal.core.Resources;

public class FinnacialDataCommon {
    public static final int CONNECTON_TIMEOUT_MILLISECONDS = 60000;
    private static Logger logger = Logger.getLogger(FinnacialDataCommon.class);

    public static String getFinnancialDataUrl(String name, String password, String ip, String client, String apiURL, boolean announcements) {
        String response = null;
        try {
            String httpRegex = "^(http://www.|http://)?[a-z0-9]+([-.]{1}[a-z0-9]+)*.[a-z]{2,5}(:[0-9]{1,5})?(/.*)?$";
            String httpsRegex = "^(https://www.|https://)?[a-z0-9]+([-.]{1}[a-z0-9]+)*.[a-z]{2,5}(:[0-9]{1,5})?(/.*)?$";
            Pattern httpPattern = Pattern.compile(httpRegex);
            Pattern httpsPattern = Pattern.compile(httpsRegex);
            Matcher httpMatcher = httpPattern.matcher(apiURL);
            Matcher httpsMatcher = httpsPattern.matcher(apiURL);
            URL url = new URL(apiURL.trim());
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("username", name);
            params.put("password", password);
            params.put("ip", ip);
            params.put("client", client);
            if (announcements) {
                params.put("page", "announcement-calendar");
            }
            params.put("isDemoUser", Resources.userType == 2);
            byte[] bytesEncodedStr = Base64.encodeBase64((byte[])Resources.userId.getBytes());
            String brokerUserCode = new String(bytesEncodedStr);
            params.put("brokerUserCode", brokerUserCode);
            StringBuilder postData = new StringBuilder();
            for (Map.Entry param : params.entrySet()) {
                if (postData.length() != 0) {
                    postData.append('&');
                }
                postData.append(URLEncoder.encode((String)param.getKey(), "UTF-8"));
                postData.append('=');
                postData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
            }
            logger.info((Object)("brokerUserCode:  " + brokerUserCode));
            byte[] postDataBytes = postData.toString().getBytes("UTF-8");
            final IPreferenceStore store = CorePlugin.getDefault().getPreferenceStore();
            Proxy proxy = null;
            if (store.getBoolean("ENABLE_HTTP_PROXY")) {
                logger.info((Object)"http proxy enabled : ");
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(store.getString("PROXY_HOST_ADDRESS"), store.getInt("PROXY_PORT_ADDRESS")));
                if (store.getBoolean("ENABLE_PROXY_AUTHENTICATION")) {
                    Authenticator.setDefault(new Authenticator(){

                        @Override
                        public PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(store.getString("PROXY_USER"), store.getString("PROXY_PASSWORD").toCharArray());
                        }
                    });
                } else {
                    Authenticator.setDefault(null);
                }
                logger.info((Object)("Proxy:" + store.getString("PROXY_HOST_ADDRESS") + "Port:" + store.getInt("PROXY_PORT_ADDRESS")));
            }
            if (httpMatcher.find()) {
                logger.info((Object)("Finnancial Http: Url: " + apiURL));
                HttpURLConnection conn = null;
                conn = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
                if (conn != null) {
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
                    conn.setDoOutput(true);
                    conn.getOutputStream().write(postDataBytes);
                    BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                    String responseString = "";
                    StringBuffer buf = new StringBuffer();
                    while ((responseString = in.readLine()) != null) {
                        buf = buf.append(responseString);
                    }
                    JSONObject jsonObj = new JSONObject(buf.toString());
                    response = (String)jsonObj.get("link");
                    response = response.replace("http", "https");
                } else {
                    response = "";
                }
            } else if (httpsMatcher.find()) {
                logger.info((Object)("Finnancial Https: Url: " + apiURL));
                System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                Security.addProvider((java.security.Provider)new Provider());
                System.setProperty("https.protocols", "SSLv3,TLSv1.2");
                SSLContext ctx = SSLContext.getInstance("SSL");
                ctx.init(null, new TrustManager[]{new InvalidCertificateTrustManager()}, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
                HttpsURLConnection.setDefaultHostnameVerifier(new InvalidCertificateHostVerifier());
                HttpsURLConnection conn = proxy != null ? (HttpsURLConnection)url.openConnection(proxy) : (HttpsURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
                conn.setDoOutput(true);
                conn.getOutputStream().write(postDataBytes);
                if (conn != null) {
                    try {
                        String str;
                        logger.info((Object)"****** Connection Established Https ********");
                        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        StringBuffer buf = new StringBuffer();
                        while ((str = rd.readLine()) != null) {
                            buf = buf.append(str);
                        }
                        rd.close();
                        JSONObject jsonObj = new JSONObject(buf.toString());
                        response = (String)jsonObj.get("link");
                    }
                    catch (IOException iOException) {
                        logger.error((Object)"Finnancial Data Connection Https Url Buffering Eception");
                        response = "";
                    }
                }
            } else {
                response = "";
                logger.info((Object)"Finnancial Data Common No Matcher Found");
            }
        }
        catch (Exception e) {
            response = "";
            logger.error((Object)"Exception in getFinnancialDataUrl : ", (Throwable)e);
        }
        return response;
    }
}

