/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.IFeed;
import pk.com.softech.tradingterminal.core.db.Security;

public class FeedMonitor {
    private static Map feedMap = new HashMap();
    private static Map securityMap = new HashMap();
    private static Map securityConunts = new HashMap();
    static Log logger = LogFactory.getLog((String)"FeedMonitor");

    private FeedMonitor() {
        logger.info((Object)"Feed Monitor started");
    }

    public static void clear() {
        feedMap.clear();
        securityMap.clear();
        securityConunts.clear();
    }

    public static void monitor(Security security) {
        Integer count;
        IFeed feed;
        String quoteFeedId = (String)securityMap.get(security);
        if (!(quoteFeedId == null || security.getQuoteFeed() != null && quoteFeedId.equals(security.getQuoteFeed().getId()))) {
            feed = (IFeed)feedMap.get(quoteFeedId);
            if (feed != null) {
                feed.unSubscribe(security);
            }
            securityConunts.remove(security);
            securityMap.remove(security);
        }
        if (security.getQuoteFeed() == null) {
            return;
        }
        feed = (IFeed)feedMap.get(security.getQuoteFeed().getId());
        if (feed == null) {
            feed = CorePlugin.createQuoteFeedPlugin(security.getQuoteFeed().getId());
            if (feed == null) {
                return;
            }
            feedMap.put(security.getQuoteFeed().getId(), feed);
        }
        if ((count = (Integer)securityConunts.get(security)) == null) {
            count = new Integer(0);
            feed.subscribe(security);
            if (CorePlugin.getDefault().getPreferenceStore().getBoolean("FEED_RUNNING")) {
                feed.start();
            }
        }
        count = count + 1;
        securityConunts.put(security, new Integer(count));
        securityMap.put(security, security.getQuoteFeed().getId());
    }

    public static void cancelMonitor(Security security) {
        Integer count;
        if (security.getQuoteFeed() == null) {
            return;
        }
        IFeed feed = (IFeed)feedMap.get(security.getQuoteFeed().getId());
        if (feed == null) {
            feed = CorePlugin.createQuoteFeedPlugin(security.getQuoteFeed().getId());
            if (feed == null) {
                return;
            }
            feedMap.put(security.getQuoteFeed().getId(), feed);
        }
        if ((count = (Integer)securityConunts.get(security)) != null) {
            if (count - 1 == 0) {
                feed.unSubscribe(security);
                securityConunts.remove(security);
                securityMap.remove(security);
                count = null;
            } else {
                count = count - 1;
                securityConunts.put(security, new Integer(count));
            }
        }
    }

    public static int countInstances(Security security) {
        Integer count = (Integer)securityConunts.get(security);
        if (count != null) {
            return count;
        }
        return 0;
    }

    public static synchronized void start() {
        logger.info((Object)"Feed monitor is started");
        Iterator iter = feedMap.keySet().iterator();
        while (iter.hasNext()) {
            IFeed feed = (IFeed)feedMap.get((String)iter.next());
            feed.start();
        }
    }

    public static synchronized void stop() {
        logger.info((Object)"Feed monitor is stoped");
        Iterator iter = feedMap.keySet().iterator();
        while (iter.hasNext()) {
            IFeed feed = (IFeed)feedMap.get((String)iter.next());
            feed.stop();
        }
    }

    public static synchronized void snapshot() {
        Iterator iter = feedMap.keySet().iterator();
        while (iter.hasNext()) {
            IFeed feed = (IFeed)feedMap.get((String)iter.next());
            feed.snapshot();
        }
    }

    public static IFeed getFeed(String id) {
        return (IFeed)feedMap.get(id);
    }
}

