/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import pk.com.softech.parser.Parser;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.FeedMonitor;
import pk.com.softech.tradingterminal.core.Level2FeedMonitor;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.link.TCPFeedLevel2Link;
import pk.com.softech.tradingterminal.core.link.TCPFeedLink;
import pk.com.softech.tradingterminal.core.link.TCPSupportLink;
import pk.com.softech.tradingterminal.core.link.UDPFeedLink;

public class FeedJob
extends Job {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public FeedJob() {
        super("Establishing Connections...");
    }

    protected IStatus run(IProgressMonitor monitor) {
        int totalWork = 1;
        if (Resources.level2feed && !Resources.localFeedOption) {
            ++totalWork;
        }
        if (Resources.userType == 6) {
            ++totalWork;
        }
        this.logger.debug((Object)("Total work for Feed Job is = " + totalWork));
        monitor.beginTask("Establishing Connection", totalWork);
        if (Resources.localFeedOption) {
            this.logger.info((Object)"****************localFeedOption***************");
            monitor.subTask("Connecting Local Feed");
            if (Resources.udpPorts.length == Resources.udpPortsParsers.length && Resources.udpPorts.length > 0) {
                Resources.udpFeedLink = new UDPFeedLink[Resources.udpPorts.length];
                int i = 0;
                while (i < Resources.udpPorts.length) {
                    try {
                        Class<?> parserClass = Class.forName(Resources.udpPortsParsers[i]);
                        Resources.udpFeedLink[i] = new UDPFeedLink(Resources.feedQueue, Resources.udpPorts[i], (Parser)parserClass.newInstance());
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("Unable to load parser " + Resources.udpPortsParsers[i] + " : " + e.getMessage()));
                    }
                    ++i;
                }
            } else {
                this.logger.error((Object)"No of ports != No of Parsers or < 0");
            }
            monitor.worked(1);
        } else {
            monitor.subTask("Connecting Feed");
            if (Resources.feedLink != null) {
                Resources.feedLink.closeTCPFeedLink(false);
            }
            Resources.feedLink = new TCPFeedLink(Resources.feedQueue, Resources.feedServerIP, Resources.feedServerPort, 0);
            monitor.worked(1);
            if (Resources.level2feed) {
                monitor.subTask("Connecting Level 2 Feed ");
                if (Resources.level2feedLink != null) {
                    Resources.level2feedLink.closeTCPFeedLink(false);
                }
                Resources.level2feedLink = new TCPFeedLevel2Link(Resources.MBOQueue, Resources.level2feedIP, Resources.level2feedPort, 1);
                monitor.worked(1);
            } else {
                CorePlugin.updateStausBar("SFS", "");
            }
        }
        FeedMonitor.start();
        Level2FeedMonitor.start();
        if (Resources.userType == 6) {
            monitor.subTask("Connecting Support Server ");
            Resources.supportLink = new TCPSupportLink("Support Link", Resources.tradeQueue, Resources.supportServerIP, Resources.supportServerPort);
            monitor.worked(1);
        }
        monitor.done();
        return Status.OK_STATUS;
    }
}

