/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pk.com.softech.tradingterminal.core.CorePlugin;

public class CurrencyConverter
extends Observable {
    private static CurrencyConverter instance = new CurrencyConverter();
    public static final String DEFAULT_CURRENCY = "PKR";
    List currencies = new ArrayList();
    Map map = new HashMap();
    Map historyMap = new HashMap();
    NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
    SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    Log logger = LogFactory.getLog(this.getClass());
    private static final int NO_OF_ATTEMTS = 5;

    CurrencyConverter() {
        File file = new File(Platform.getLocation().toFile(), "currencies.xml");
        if (file.exists()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(file);
                Node firstNode = document.getFirstChild();
                NodeList childNodes = firstNode.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node item = childNodes.item(i);
                    String nodeName = item.getNodeName();
                    if (nodeName.equalsIgnoreCase("currency")) {
                        Node valueNode = item.getFirstChild();
                        if (valueNode != null) {
                            this.currencies.add(valueNode.getNodeValue());
                        }
                    } else if (nodeName.equalsIgnoreCase("conversion")) {
                        String symbol = item.getAttributes().getNamedItem("symbol").getNodeValue();
                        Node valueNode = null;
                        if (item.getAttributes().getNamedItem("ratio") != null) {
                            valueNode = item.getAttributes().getNamedItem("ratio");
                        }
                        if (valueNode == null) {
                            valueNode = item.getFirstChild();
                        }
                        if (valueNode != null) {
                            Double value = new Double(Double.parseDouble(valueNode.getNodeValue()));
                            this.map.put(symbol, value);
                        }
                        this.readHistory(symbol, item.getChildNodes());
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private void readHistory(String symbol, NodeList nodeList) {
        ArrayList<History> list = new ArrayList<History>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node item = nodeList.item(i);
            String nodeName = item.getNodeName();
            if (nodeName.equalsIgnoreCase("history")) {
                History history = new History();
                try {
                    history.date = this.dateFormat.parse(item.getAttributes().getNamedItem("date").getNodeValue());
                    history.ratio = new Double(item.getAttributes().getNamedItem("ratio").getNodeValue());
                }
                catch (Exception e) {
                    this.logger.warn((Object)e);
                }
                if (history.date != null && history.ratio != null && !list.contains(history)) {
                    list.add(history);
                }
            }
            ++i;
        }
        this.historyMap.put(symbol, list);
    }

    public static CurrencyConverter getInstance() {
        return instance;
    }

    public void clear() {
        File file = new File(Platform.getLocation().toFile(), "currencies.xml");
        if (file.exists()) {
            file.delete();
        }
        this.currencies.clear();
        this.map.clear();
        this.historyMap.clear();
    }

    public void dispose() {
        this.save();
    }

    public List getCurrencies() {
        return this.currencies;
    }

    public void setCurrencies(List currencies) {
        this.currencies = currencies;
    }

    public double convert(double amount, Currency from, Currency to) {
        if (from == null || to == null || from.equals(to) || to.equals("Default")) {
            return amount;
        }
        return this.convert(null, amount, from.getCurrencyCode(), to.getCurrencyCode());
    }

    public double convert(Date date, double amount, Currency from, Currency to) {
        if (from == null || to == null || from.equals(to)) {
            return amount;
        }
        return this.convert(date, amount, from.getCurrencyCode(), to.getCurrencyCode());
    }

    public double convert(Double amount, Currency from, Currency to) {
        if (from == null || to == null || from.equals(to)) {
            return amount;
        }
        return this.convert(null, (double)amount, from.getCurrencyCode(), to.getCurrencyCode());
    }

    public double convert(Date date, Double amount, Currency from, Currency to) {
        if (from == null || to == null || from.equals(to)) {
            return amount;
        }
        return this.convert(date, (double)amount, from.getCurrencyCode(), to.getCurrencyCode());
    }

    public double convert(double amount, String from, String to) {
        return this.convert(null, amount, from, to);
    }

    public double convert(Date date, double amount, String from, String to) {
        Double r;
        double result = amount;
        if (from == null || to == null || from.equals(to)) {
            return result;
        }
        Double ratio = null;
        if (date != null && (ratio = this.getExchangeRatio(date, from, to)) == null && (r = this.getExchangeRatio(date, to, from)) != null) {
            ratio = new Double(1.0 / r);
        }
        if (ratio == null) {
            ratio = this.getExchangeRatio(from, to);
        }
        if (ratio != null) {
            result = amount * ratio;
        }
        if (date != null && ratio != null) {
            this.setExchangeRatio(date, from, to, ratio);
        }
        return result;
    }

    public IStatus updateExchanges(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask("Updating currencies", this.currencies.size() + 1);
        }
        this.map.clear();
        Object[] symbols = this.currencies.toArray();
        int x = 0;
        while (x < symbols.length) {
            int y = 0;
            while (y < symbols.length) {
                if (x != y) {
                    String s = String.valueOf((String)symbols[x]) + (String)symbols[y];
                    Double old = (Double)this.map.get(s);
                    Double quote = this.downloadQuote(s);
                    if (quote != null) {
                        this.map.put(s, quote);
                    } else {
                        this.map.remove(s);
                    }
                    if (old == null && quote != null || old != null && !old.equals(quote)) {
                        this.setChanged();
                    }
                    if (monitor != null && monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                }
                ++y;
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            ++x;
        }
        this.notifyObservers();
        this.save();
        if (monitor != null) {
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public void setExchangeRatio(Currency from, Currency to, double ratio) {
        if (from != null && to != null && !from.equals(to)) {
            this.setExchangeRatio(from.getCurrencyCode(), to.getCurrencyCode(), ratio);
        }
    }

    public void setExchangeRatio(String from, String to, double ratio) {
        Double old = (Double)this.map.get(String.valueOf(from) + to);
        Double quote = new Double(ratio);
        this.map.put(String.valueOf(from) + to, quote);
        if (old == null && quote != null || old != null && !old.equals(quote)) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public Double getExchangeRatio(String from, String to) {
        Double r;
        Double ratio = (Double)this.map.get(String.valueOf(from) + to);
        if (ratio == null && (r = (Double)this.map.get(String.valueOf(to) + from)) != null) {
            ratio = new Double(1.0 / r);
        }
        return ratio;
    }

    public void setExchangeRatio(Date date, String from, String to, double ratio) {
        History history;
        int index;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        ArrayList<History> list = (ArrayList<History>)this.historyMap.get(String.valueOf(from) + to);
        if (list == null) {
            list = new ArrayList<History>();
        }
        if ((index = list.indexOf(history = new History(date, new Double(ratio)))) != -1) {
            History old = (History)list.get(index);
            if (!old.ratio.equals(history.ratio)) {
                list.set(index, history);
                this.setChanged();
            }
        } else {
            list.add(history);
            this.setChanged();
        }
        this.historyMap.put(String.valueOf(from) + to, list);
        this.notifyObservers();
    }

    public Double getExchangeRatio(Date date, String from, String to) {
        Double ratio = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        ArrayList list = (ArrayList)this.historyMap.get(String.valueOf(from) + to);
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                History history = (History)list.get(i);
                if (history.date.equals(date)) {
                    ratio = history.ratio;
                    break;
                }
                ++i;
            }
        }
        return ratio;
    }

    private void save() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.getDOMImplementation().createDocument(null, "data", null);
            Element root = document.getDocumentElement();
            Iterator<Object> iter = this.currencies.iterator();
            while (iter.hasNext()) {
                Element node = document.createElement("currency");
                node.appendChild(document.createTextNode((String)iter.next()));
                root.appendChild(node);
            }
            for (String symbol : this.map.keySet()) {
                Element node = document.createElement("conversion");
                node.setAttribute("symbol", symbol);
                node.setAttribute("ratio", String.valueOf((Double)this.map.get(symbol)));
                this.saveHistory(node, symbol);
                root.appendChild(node);
            }
            TransformerFactory factory = TransformerFactory.newInstance();
            try {
                factory.setAttribute("indent-number", new Integer(4));
            }
            catch (Exception exception) {}
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(document);
            File file = new File(Platform.getLocation().toFile(), "currencies.xml");
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
        }
    }

    private void saveHistory(Node root, String symbol) {
        Document document = root.getOwnerDocument();
        List list = (List)this.historyMap.get(symbol);
        if (list != null) {
            Collections.sort(list, new Comparator(){

                public int compare(Object o1, Object o2) {
                    History d1 = (History)o1;
                    History d2 = (History)o2;
                    if (d1.date.after(d2.date)) {
                        return 1;
                    }
                    if (d1.date.before(d2.date)) {
                        return -1;
                    }
                    return 0;
                }
            });
            for (History history : list) {
                Element node = document.createElement("history");
                node.setAttribute("date", this.dateFormat.format(history.date));
                node.setAttribute("ratio", String.valueOf(history.ratio));
                root.appendChild(node);
            }
        }
    }

    private Double downloadQuote(String symbol) {
        Double result = null;
        StringBuffer url = new StringBuffer("http://finance.yahoo.com/d/quotes.csv?e=.csv&f=sl1d1t1&s=" + symbol + "=X");
        String line = "";
        try {
            HttpClient client = new HttpClient();
            client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
            IPreferenceStore store = CorePlugin.getDefault().getPreferenceStore();
            if (store.getBoolean("ENABLE_HTTP_PROXY")) {
                System.out.println("http proxy enabled : ");
                client.getHostConfiguration().setProxy(store.getString("PROXY_HOST_ADDRESS"), store.getInt("PROXY_PORT_ADDRESS"));
                if (store.getBoolean("ENABLE_PROXY_AUTHENTICATION")) {
                    client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(store.getString("PROXY_USER"), store.getString("PROXY_PASSWORD")));
                }
            }
            GetMethod method = new GetMethod(url.toString());
            HttpMethodRetryHandler myretryhandler = new HttpMethodRetryHandler(){

                public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
                    if (executionCount >= 3) {
                        return false;
                    }
                    if (exception instanceof NoHttpResponseException) {
                        return true;
                    }
                    return !method.isRequestSent();
                }
            };
            method.getParams().setParameter("http.method.retry-handler", (Object)myretryhandler);
            method.setFollowRedirects(true);
            client.executeMethod((HttpMethod)method);
            BufferedReader in = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream()));
            while ((line = in.readLine()) != null) {
                String[] item = line.split(",");
                if (line.indexOf(",") != -1) {
                    item = line.split(",");
                }
                if (item.length <= 0 || item[1].equalsIgnoreCase("N/A")) continue;
                result = new Double(this.numberFormat.parse(item[1]).doubleValue());
            }
            in.close();
            method.releaseConnection();
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
        }
        return result;
    }

    public Double downloadQuote(String symbol, Date date) {
        return null;
    }

    private class History {
        Date date;
        Double ratio;

        public History() {
        }

        public History(Date date, Double ratio) {
            this.date = date;
            this.ratio = ratio;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Date) {
                return this.date.equals((Date)obj);
            }
            if (obj instanceof History) {
                return this.date.equals(((History)obj).date);
            }
            return false;
        }
    }
}

