/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import notification.INotification;
import notification.INotificationService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import pk.com.softech.tradingterminal.core.CurrencyConverter;
import pk.com.softech.tradingterminal.core.FeedMonitor;
import pk.com.softech.tradingterminal.core.IAccountProvider;
import pk.com.softech.tradingterminal.core.IFeed;
import pk.com.softech.tradingterminal.core.IHistoryFeed;
import pk.com.softech.tradingterminal.core.ILevel2Feed;
import pk.com.softech.tradingterminal.core.IPattern;
import pk.com.softech.tradingterminal.core.ITradingProvider;
import pk.com.softech.tradingterminal.core.Level2FeedMonitor;
import pk.com.softech.tradingterminal.core.Repository;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.Account;
import pk.com.softech.tradingterminal.core.db.DefaultAccount;
import pk.com.softech.tradingterminal.core.db.PersistentPreferenceStore;
import pk.com.softech.tradingterminal.core.internal.LogListener;
import pk.com.softech.tradingterminal.core.internal.Messages;
import pk.com.softech.tradingterminal.core.internal.XMLRepository;
import pk.com.softech.tradingterminal.core.link.TCPLink;
import pk.com.softech.tradingterminal.core.link.UDPFeedLink;
import pk.com.softech.tradingterminal.core.notificationimpl.AnnouncementNotification;
import pk.com.softech.tradingterminal.core.notificationimpl.AudioAlertJob;
import pk.com.softech.tradingterminal.core.notificationimpl.LockNotification;
import pk.com.softech.tradingterminal.core.notificationimpl.OrderNotification;
import pk.com.softech.tradingterminal.core.notificationimpl.PopupNotification;
import pk.com.softech.tradingterminal.core.notificationimpl.TradeNotification;
import pk.com.softech.util.ExportChartDataToFile;

public class CorePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "pk.com.softech.tradingterminal.core";
    public static final String FEED_EXTENSION_POINT = "pk.com.softech.tradingterminal.core.feeds";
    public static final String TRADING_PROVIDERS_EXTENSION_POINT = "pk.com.softech.tradingterminal.core.tradingProviders";
    public static final String PATTERN_EXTENSION_POINT = "pk.com.softech.tradingterminal.core.patterns";
    public static final String ACCOUNT_PROVIDERS_EXTENSION_POINT = "pk.com.softech.tradingterminal.core.accountProviders";
    public static final String LABEL_PROVIDERS_EXTENSION_POINT = "pk.com.softech.tradingterminal.core.viewLabelProviders";
    public static final String LOGGER_PREFERENCES_EXTENSION_POINT = "pk.com.softech.tradingterminal.core.loggingPreferences";
    public static final String FEED_RUNNING = "FEED_RUNNING";
    public static final String PREFS_ENABLE_HTTP_PROXY = "ENABLE_HTTP_PROXY";
    public static final String PREFS_PROXY_HOST_ADDRESS = "PROXY_HOST_ADDRESS";
    public static final String PREFS_PROXY_PORT_ADDRESS = "PROXY_PORT_ADDRESS";
    public static final String PREFS_ENABLE_PROXY_AUTHENTICATION = "ENABLE_PROXY_AUTHENTICATION";
    public static final String PREFS_PROXY_USER = "PROXY_USER";
    public static final String PREFS_PROXY_PASSWORD = "PROXY_PASSWORD";
    public static final String PREFS_UPDATE_CURRENCIES = "UPDATE_CURRENCIES";
    public static IStatusLineManager statusManager;
    public static final String MS = "MS";
    public static final String FS = "FS";
    public static final String SFS = "SFS";
    public static final String CLOCK = "CLOCK";
    public static String MS_CONNECTED;
    public static String MS_NOT_CONNECTED;
    public static final String FS_CONNECTED = "Feed Connected";
    public static final String FS_NOT_CONNECTED = "Connecting Feed ...";
    public static final String FS_LOCAL_CONNECTED = "Local Feed Connected";
    public static final String FS_LOCAL_NOT_CONNECTED = "Local Feed Not Connected";
    public static final String SFS_CONNECTED = "Level2Feed Connected";
    public static final String SFS_NOT_CONNECTED = "Connecting Level2Feed...";
    public static final String PREFS_NEWS_DATE_RANGE = "PREFS_NEWS_DATE_RANGE";
    public static final String PREFS_UPDATE_NEWS = "UPDATE_NEWS";
    public static final String PREF_SOCIAL_BROWSER_COUNT = "PREF_SOCIAL_BROWSER_COUNT";
    public static final String PREF_PROMPT_ON_EXIT = "PROMPT_ON_EXIT";
    public static final String PREFS_TIME_ZONE = "TIME_ZONE";
    public static final String PREFS_EVENTS_LIMIT = "EVENTS_LIMITS";
    public static final String PREFS_ENABLE_EVENTS_LIMITS = "ENABLE_EVENTS_LIMITS";
    public static final String PREFS_HISTORICAL_PRICE_RANGE = "HISTORICAL_PRICE_RANGE";
    public static final String PREFS_UPDATE_HISTORY = "UPDATE_HISTORY";
    public static final String PREFS_UPDATE_HISTORY_ONCE = "UPDATE_HISTORY_ONCE";
    public static final String PREFS_UPDATE_HISTORY_LAST = "UPDATE_HISTORY_LAST";
    public static final int PREFS_UPDATE_HISTORY_MAX = 10;
    public static final String PREFS_UPDATE_SECURITY = "PREFS_UPDATE_SECURITY";
    public static final String PREFS_UPDATE_SECURITY_ONCE = "PREFS_UPDATE_SECURITY_ONCE";
    public static final String PREFS_UPDATE_SECURITY_LAST = "PREFS_UPDATE_SECURITY_LAST";
    public static final String PREFS_ADD_NEW_SECURITIES_AUTOMATIC = "ADD_NEW_SECURITIES_AUTOMATIC";
    public static final String MINIMIZE_TO_TRAY = "MINIMIZE_TO_TRAY";
    public static final String ERR_PROVIDER_TITLE = "Provider Error";
    public static final String ERR_PROVIDER_DETAIL = "No provider found for server";
    public static final String PREFS_SHOW_ANNOUNCEMENTS = "PREFS_SHOW_ANNOUNCEMENTS";
    public static final String PREFS_USE_ECLIPSE_BROWSER = "PREFS_USE_ECLIPSE_BROWSER";
    public static final String PREFS_USE_SYSTEM_BROWSER = "PREFS_USE_SYSTEM_BROWSER";
    public static final String ALERT_NOTIFICATION_IMAGE = "icons/alt_window_16.gif";
    public static final String ALERT_NOTIFICATION_AUDIO_FILE = "data/ding.wav";
    public static final String ALERT_ANNOUNCEMENT_AUDIO_FILE = "data/ding.wav";
    public static final String ERR_CONNECTION_TITLE = "Connection Error";
    public static final String ERR_CONNECTION_DETAIL = "You seem to be disconnected from the server. \n Please re-connect again from the file menu.";
    public static String USER_STATUS;
    private static CorePlugin plugin;
    private static Repository repository;
    private static SimpleDateFormat dateTimeFormatLong;
    private static SimpleDateFormat dateTimeFormat;
    private static SimpleDateFormat dateTimeParse;
    private static SimpleDateFormat dateFormat;
    private static SimpleDateFormat dateParse;
    private static SimpleDateFormat timeFormat;
    private static SimpleDateFormat timeParse;
    private static NumberFormat priceFormatter;
    private static NumberFormat priceFormatterLong;
    private static NumberFormat numberFormatter;
    private static NumberFormat percentageFormatter;
    private static NumberFormat numberFormattrTwoDecimal;
    Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private IPropertyChangeListener feedPropertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(CorePlugin.FEED_RUNNING) && CorePlugin.getDefault().getPreferenceStore().getBoolean(CorePlugin.FEED_RUNNING) && CorePlugin.getDefault().getPreferenceStore().getBoolean(CorePlugin.PREFS_UPDATE_CURRENCIES)) {
                Job job = new Job(Messages.CorePlugin_UpdateCurrencies){

                    protected IStatus run(IProgressMonitor monitor) {
                        return CurrencyConverter.getInstance().updateExchanges(monitor);
                    }
                };
                job.setUser(false);
                job.schedule();
            }
            if (event.getProperty().equals(USER_STATUS)) {
                System.out.println("****************  " + event.getProperty());
                CorePlugin.this.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (CorePlugin.getDefault().getPreferenceStore().getBoolean(USER_STATUS)) {
                            Resources.configurer.setTitle(String.valueOf(Resources.applicationTitle) + "   :   " + Resources.userId + " Connected " + Resources.getClientVersion());
                            CorePlugin.updateStausBar(CorePlugin.MS, MS_CONNECTED);
                        } else {
                            Resources.accessControl.setLoggedIn(Resources.loginStatus);
                            Resources.configurer.setTitle(String.valueOf(Resources.applicationTitle) + "   :   " + Resources.userId + " Disconnected " + Resources.getClientVersion());
                            CorePlugin.updateStausBar(CorePlugin.MS, MS_NOT_CONNECTED);
                            CorePlugin.closeSockets();
                        }
                    }
                });
            }
        }
    };
    private IPerspectiveListener perspectiveListener = new IPerspectiveListener(){

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        }

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        }
    };

    static {
        MS_CONNECTED = "Server Connected";
        MS_NOT_CONNECTED = "Server Not Connected";
        USER_STATUS = "USER_CONNECTED";
        dateTimeFormatLong = new SimpleDateFormat(Messages.CorePlugin_DateTimeFormatLong);
        dateTimeFormat = new SimpleDateFormat(Messages.CorePlugin_DateTimeFormat);
        dateTimeParse = new SimpleDateFormat(Messages.CorePlugin_DateTimeParse);
        dateFormat = new SimpleDateFormat(Messages.CorePlugin_DateFormat);
        dateParse = new SimpleDateFormat(Messages.CorePlugin_DateParse);
        timeFormat = new SimpleDateFormat(Messages.CorePlugin_TimeFormat);
        timeParse = new SimpleDateFormat(Messages.CorePlugin_TimeParse);
        priceFormatter = NumberFormat.getInstance();
        priceFormatterLong = NumberFormat.getInstance();
        numberFormatter = NumberFormat.getInstance();
        percentageFormatter = NumberFormat.getPercentInstance();
        numberFormattrTwoDecimal = new DecimalFormat("#.00");
    }

    public CorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        preferenceStore.setDefault(PREFS_TIME_ZONE, "Asia/Karachi");
        Resources.timeZone = preferenceStore.getString(PREFS_TIME_ZONE);
        try {
            Integer.parseInt(Resources.timeZone);
            Resources.timeZone = "Asia/Karachi";
        }
        catch (Exception exception) {}
        TimeZone.setDefault(TimeZone.getTimeZone(Resources.timeZone));
        numberFormatter.setGroupingUsed(true);
        numberFormatter.setMinimumIntegerDigits(1);
        numberFormatter.setMinimumFractionDigits(0);
        numberFormatter.setMaximumFractionDigits(0);
        priceFormatter.setGroupingUsed(true);
        priceFormatter.setMinimumIntegerDigits(1);
        priceFormatter.setMinimumFractionDigits(2);
        priceFormatter.setMaximumFractionDigits(2);
        priceFormatterLong.setGroupingUsed(true);
        priceFormatterLong.setMinimumIntegerDigits(1);
        priceFormatterLong.setMinimumFractionDigits(2);
        priceFormatterLong.setMaximumFractionDigits(4);
        percentageFormatter.setGroupingUsed(true);
        percentageFormatter.setMinimumIntegerDigits(1);
        percentageFormatter.setMinimumFractionDigits(2);
        percentageFormatter.setMaximumFractionDigits(2);
        System.setProperty("workspace_loc", Platform.getLocation().toPortableString());
        this.configureLogging();
        LogListener logListener = new LogListener();
        Platform.addLogListener((ILogListener)logListener);
        this.getLog().addLogListener((ILogListener)logListener);
        preferenceStore.addPropertyChangeListener(this.feedPropertyListener);
        Resources.eclipseVersion = CorePlugin.getDefault().getBundle().getVersion().toString();
        this.log.info((Object)("** Plugin Version " + Resources.eclipseVersion));
        this.copyWorkspaceFile("data/ding.wav");
    }

    public void configureLogging() {
        try {
            PreferenceStore preferences = new PreferenceStore();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(LOGGER_PREFERENCES_EXTENSION_POINT);
            IConfigurationElement[] members = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement element = members[i];
                if (element.getName().equals("logger") && element.getAttribute("defaultValue") != null) {
                    String[] item = element.getAttribute("name").split(";");
                    int n = 0;
                    while (n < item.length) {
                        preferences.setDefault("log4j.logger." + item[n], element.getAttribute("defaultValue"));
                        ++n;
                    }
                }
                ++i;
            }
            try {
                URL url = CorePlugin.getDefault().getBundle().getResource("log4j.properties");
                Properties properties = new Properties();
                properties.load(url.openStream());
                for (String string : properties.keySet()) {
                    preferences.setDefault(string, (String)properties.get(string));
                }
                File file = CorePlugin.getDefault().getStateLocation().append("log4j.properties").toFile();
                if (file.exists()) {
                    preferences.load((InputStream)new FileInputStream(file));
                }
            }
            catch (Exception e) {
                CorePlugin.logException(e);
            }
            Properties properties = new Properties();
            String[] names = preferences.preferenceNames();
            int i2 = 0;
            while (i2 < names.length) {
                if (Resources.IS_MAC && names[i2].equals("log4j.appender.file.File")) {
                    preferences.setValue(names[i2], preferences.getString(names[i2]).replace(".metadata", "metadata"));
                }
                properties.put(names[i2], preferences.getString(names[i2]));
                ++i2;
            }
            PropertyConfigurator.configure((Properties)properties);
        }
        catch (Exception e) {
            BasicConfigurator.configure();
            CorePlugin.logException(e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (repository != null) {
            repository.dispose();
        }
        CorePlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.feedPropertyListener);
        CurrencyConverter.getInstance().dispose();
        try {
            CorePlugin.closeSockets();
        }
        catch (Exception exception) {}
        this.log.info((Object)(String.valueOf(Resources.userId) + " : logged off"));
        super.stop(context);
        plugin = null;
    }

    public static void closeSockets() {
        System.out.println("close sockets");
        try {
            if (Resources.tcpLink) {
                for (String ipPort : Resources.msLinks.keySet()) {
                    try {
                        TCPLink link = Resources.msLinks.get(ipPort);
                        if (link != null) {
                            link.closeTCPLink();
                        }
                        Resources.msLinks.put(ipPort, null);
                        Resources.tcpLink = false;
                    }
                    catch (Exception e) {
                        CorePlugin.logException("Error in closing TCP links : " + e.getMessage());
                    }
                }
            }
            if (Resources.localFeedOption && Resources.udpFeedLink != null) {
                int i = 0;
                while (i < Resources.udpFeedLink.length) {
                    UDPFeedLink udpFeedLink = Resources.udpFeedLink[i];
                    if (udpFeedLink != null) {
                        udpFeedLink.closeUDPFeedLink(false);
                    }
                    ++i;
                }
                FeedMonitor.stop();
                Level2FeedMonitor.stop();
            }
            if (Resources.feedLink != null) {
                Resources.feedLink.stopTCPFeedThread();
                Resources.feedLink.closeTCPFeedLink(false);
                Resources.feedLink = null;
                FeedMonitor.stop();
            }
            if (Resources.level2feedLink != null) {
                Resources.level2feedLink.stopTCPFeedThread();
                Resources.level2feedLink.closeTCPFeedLink(false);
                Resources.level2feedLink = null;
                Level2FeedMonitor.stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateStausBar(final String bar, final String message) {
        try {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    StatusLineContributionItem item = (StatusLineContributionItem)statusManager.find(bar);
                    item.setText(message);
                }
            });
        }
        catch (Exception exception) {}
    }

    public static CorePlugin getDefault() {
        return plugin;
    }

    public static Repository getRepository() {
        if (repository == null) {
            try {
                Class<?> clazz = Class.forName("pk.com.softech.tradingterminal.core.RepositoryImpl");
                repository = (Repository)clazz.newInstance();
            }
            catch (Exception exception) {
                repository = new XMLRepository();
            }
        }
        return repository;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static IHistoryFeed createHistoryFeedPlugin(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(FEED_EXTENSION_POINT);
        if (extensionPoint != null) {
            IConfigurationElement[] members = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement item = members[i];
                if (item.getAttribute("id").equals(id)) {
                    members = item.getChildren();
                    int ii = 0;
                    while (ii < members.length) {
                        if (members[ii].getName().equals("history")) {
                            try {
                                Object obj = members[ii].createExecutableExtension("class");
                                return (IHistoryFeed)obj;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        ++ii;
                    }
                    break;
                }
                ++i;
            }
        }
        return null;
    }

    public static IFeed createQuoteFeedPlugin(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(FEED_EXTENSION_POINT);
        if (extensionPoint != null) {
            IConfigurationElement[] members = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement item = members[i];
                if (item.getAttribute("id").equals(id)) {
                    members = item.getChildren();
                    int ii = 0;
                    while (ii < members.length) {
                        if (members[ii].getName().equals("quote")) {
                            try {
                                Object obj = members[ii].createExecutableExtension("class");
                                return (IFeed)obj;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        ++ii;
                    }
                    break;
                }
                ++i;
            }
        }
        return null;
    }

    public static ILevel2Feed createLevel2FeedPlugin(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(FEED_EXTENSION_POINT);
        if (extensionPoint != null) {
            IConfigurationElement[] members = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement item = members[i];
                if (item.getAttribute("id").equals(id)) {
                    members = item.getChildren();
                    int ii = 0;
                    while (ii < members.length) {
                        if (members[ii].getName().equals("level2")) {
                            try {
                                Object obj = members[ii].createExecutableExtension("class");
                                return (ILevel2Feed)obj;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        ++ii;
                    }
                    break;
                }
                ++i;
            }
        }
        return null;
    }

    public static List getAllPatternPlugins() {
        ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(PATTERN_EXTENSION_POINT);
        if (extensionPoint != null) {
            IConfigurationElement[] members = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                list.add(members[i]);
                ++i;
            }
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String s0 = ((IConfigurationElement)arg0).getAttribute("name");
                String s1 = ((IConfigurationElement)arg1).getAttribute("name");
                return s0.compareTo(s1);
            }
        });
        return list;
    }

    public static IPattern createPatternPlugin(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(PATTERN_EXTENSION_POINT);
        if (extensionPoint != null) {
            IConfigurationElement[] members = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement item = members[i];
                if (item.getAttribute("id").equals(id)) {
                    try {
                        Object obj = members[i].createExecutableExtension("class");
                        return (IPattern)obj;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static ITradingProvider createTradeSourcePlugin(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(TRADING_PROVIDERS_EXTENSION_POINT);
        if (extensionPoint != null) {
            IConfigurationElement[] members = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement item = members[i];
                if (item.getAttribute("id").equals(id)) {
                    try {
                        return (ITradingProvider)members[i].createExecutableExtension("class");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static ITradingProvider getTradingSystemTradingPlugin(String id) throws Exception {
        IExtensionRegistry registry;
        IExtensionPoint extensionPoint;
        if (id.equals("")) {
            id = Resources.softechTradingProvider;
        }
        if ((extensionPoint = (registry = Platform.getExtensionRegistry()).getExtensionPoint(TRADING_PROVIDERS_EXTENSION_POINT)) != null) {
            IConfigurationElement[] members = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement item = members[i];
                try {
                    if (item.getAttribute("id").equals(id)) {
                        return (ITradingProvider)item.createExecutableExtension("class");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        throw new RuntimeException("No providor found against id = " + id);
    }

    public static Account createAccount(String pluginId, PersistentPreferenceStore preferenceStore, List transactions) {
        Account account = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(ACCOUNT_PROVIDERS_EXTENSION_POINT);
        if (extensionPoint != null) {
            IConfigurationElement[] members = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement item = members[i];
                if (item.getAttribute("id").equals(pluginId)) {
                    try {
                        IAccountProvider provider = (IAccountProvider)members[i].createExecutableExtension("class");
                        account = provider.createAccount(preferenceStore, transactions);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                ++i;
            }
        }
        if (account == null) {
            account = new DefaultAccount();
            account.setPreferenceStore(preferenceStore);
            account.setTransactions(transactions);
        }
        return account;
    }

    public static String getPluginName(String extensionPointId, String pluginId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionPointId);
        if (extensionPoint != null) {
            IConfigurationElement[] members = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement item = members[i];
                if (item.getAttribute("id").equals(pluginId)) {
                    return item.getAttribute("name");
                }
                ++i;
            }
        }
        return null;
    }

    public static ExportChartDataToFile getExportChartDataInstance() {
        return ExportChartDataToFile.getInstance();
    }

    public void triggerNofication(INotification notification) {
        IPreferenceStore preference = CorePlugin.getDefault().getPreferenceStore();
        boolean soundEnabled = false;
        String soundFile = "";
        boolean notificationEnabled = false;
        boolean closeable = false;
        int time = 0;
        if (notification instanceof TradeNotification) {
            soundEnabled = preference.getBoolean("TRADE_SOUND_ALERT_BOOL");
            soundFile = preference.getString("TRADE_SOUND_ALERT_FILE_PATH");
            notificationEnabled = preference.getBoolean("TRADE_NOTIFICATION_ALERT_BOOL");
            closeable = preference.getBoolean("TRADE_NOTIFICATION_CLOSEABLE_BOOL");
            time = preference.getInt("TRADE_NOTIFICATION_TIME");
        } else if (notification instanceof OrderNotification) {
            soundEnabled = preference.getBoolean("ORDER_SOUND_ALERT_BOOL");
            soundFile = preference.getString("ORDER_SOUND_ALERT_FILE_PATH");
            notificationEnabled = preference.getBoolean("ORDER_NOTIFICATION_ALERT_BOOL");
            closeable = preference.getBoolean("ORDER_NOTIFICATION_CLOSEABLE_BOOL");
            time = preference.getInt("ORDER_NOTIFICATION_TIME");
        } else if (notification instanceof LockNotification) {
            soundEnabled = preference.getBoolean("LOCKED_SOUND_ALERT_BOOL");
            soundFile = preference.getString("LOCKED_SOUND_ALERT_FILE_PATH");
            notificationEnabled = preference.getBoolean("LOCKED_NOTIFICATION_ALERT_BOOL");
            closeable = preference.getBoolean("LOCKED_NOTIFICATION_CLOSEABLE_BOOL");
            time = preference.getInt("LOCKED_NOTIFICATION_TIME");
        } else if (notification instanceof AnnouncementNotification) {
            soundEnabled = preference.getBoolean("ANNOUNCEMENT_SOUND_ALERT_BOOL");
            soundFile = preference.getString("ANNOUNCEMENT_SOUND_ALERT_FILE_PATH");
            notificationEnabled = preference.getBoolean("ANNOUNCEMENT_NOTIFICATION_ALERT_BOOL");
            closeable = preference.getBoolean("ANNOUNCEMENT_NOTIFICATION_CLOSEABLE_BOOL");
            time = preference.getInt("ANNOUNCEMENT_NOTIFICATION_TIME");
        } else if (notification instanceof PopupNotification) {
            soundEnabled = preference.getBoolean("ORDER_SOUND_ALERT_BOOL");
            soundFile = preference.getString("ORDER_SOUND_ALERT_FILE_PATH");
            notificationEnabled = preference.getBoolean("ORDER_NOTIFICATION_ALERT_BOOL");
            closeable = preference.getBoolean("ORDER_NOTIFICATION_CLOSEABLE_BOOL");
            time = preference.getInt("ORDER_NOTIFICATION_TIME");
        }
        if (soundEnabled) {
            File f = new File(Platform.getLocation().toFile(), soundFile);
            new AudioAlertJob(20, f.getPath());
        }
        if (notificationEnabled) {
            notification.setCloseable(closeable);
            notification.setTime(time);
            this.alert(notification);
        }
    }

    private void alert(INotification notification) {
        INotification[] array = new INotification[]{notification};
        BundleContext context = CorePlugin.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(INotificationService.class.getName());
        if (serviceReference != null) {
            INotificationService notificationService = (INotificationService)context.getService(serviceReference);
            notificationService.popupNotification(array);
        }
        context.ungetService(serviceReference);
    }

    private void copyWorkspaceFile(String file) {
        File f = new File(Platform.getLocation().toFile(), file);
        if (!f.exists()) {
            f.getParentFile().mkdirs();
            try {
                byte[] buffer = new byte[10240];
                FileOutputStream os = new FileOutputStream(f);
                InputStream is = FileLocator.openStream((Bundle)this.getBundle(), (IPath)new Path(file), (boolean)false);
                int readed = 0;
                do {
                    readed = is.read(buffer);
                    ((OutputStream)os).write(buffer, 0, readed);
                } while (readed == buffer.length);
                ((OutputStream)os).close();
                is.close();
            }
            catch (Exception e) {
                CorePlugin.logException(e);
            }
        }
    }

    public static SimpleDateFormat getDateFormat() {
        dateFormat.setTimeZone(TimeZone.getTimeZone(Resources.timeZone));
        return dateFormat;
    }

    public static SimpleDateFormat getDateParse() {
        dateParse.setTimeZone(TimeZone.getTimeZone(Resources.timeZone));
        return dateParse;
    }

    public static SimpleDateFormat getDateTimeFormat() {
        dateTimeFormat.setTimeZone(TimeZone.getTimeZone(Resources.timeZone));
        return dateTimeFormat;
    }

    public static SimpleDateFormat getDateTimeFormatLong() {
        dateTimeFormatLong.setTimeZone(TimeZone.getTimeZone(Resources.timeZone));
        return dateTimeFormatLong;
    }

    public static SimpleDateFormat getDateTimeParse() {
        dateTimeParse.setTimeZone(TimeZone.getTimeZone(Resources.timeZone));
        return dateTimeParse;
    }

    public static SimpleDateFormat getTimeFormat() {
        timeFormat.setTimeZone(TimeZone.getTimeZone(Resources.timeZone));
        return timeFormat;
    }

    public static SimpleDateFormat getTimeParse() {
        timeParse.setTimeZone(TimeZone.getTimeZone(Resources.timeZone));
        return timeParse;
    }

    public static NumberFormat getPriceFormatter() {
        return priceFormatter;
    }

    public static NumberFormat getPriceFormatterLong() {
        return priceFormatterLong;
    }

    public static NumberFormat getNumberFormatter() {
        return numberFormatter;
    }

    public static NumberFormat getPercentageFormatter() {
        return percentageFormatter;
    }

    public static NumberFormat getNumberFormattrTwoDecimal() {
        return numberFormattrTwoDecimal;
    }

    public static int getWebBrowserCount() {
        int count = CorePlugin.getDefault().getPreferenceStore().getInt(PREF_SOCIAL_BROWSER_COUNT);
        CorePlugin.getDefault().getPreferenceStore().setValue(PREF_SOCIAL_BROWSER_COUNT, count + 1);
        return count;
    }

    public static void logException(Exception e) {
        String msg = e.getMessage() == null ? e.toString() : e.getMessage();
        CorePlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, msg, (Throwable)e));
    }

    public static void logException(String e) {
        CorePlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, e));
    }

    public static void logWarning(String e) {
        CorePlugin.getDefault().getLog().log((IStatus)new Status(2, PLUGIN_ID, e));
    }
}

