/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.parser;

import java.text.SimpleDateFormat;
import java.util.Date;
import pk.com.softech.messages.ExchangeData;
import pk.com.softech.messages.FeedData;
import pk.com.softech.messages.MBO;
import pk.com.softech.messages.MBP;
import pk.com.softech.messages.MarketData;
import pk.com.softech.messages.SymbolFeedData;
import pk.com.softech.parser.FeedParser;
import pk.com.softech.util.Utility;

public class YahooFinFeedParser
extends FeedParser {
    public static final String FEED_TIME_FORMAT = "MM/dd/yyyy h:mma";
    public static final String FEED_IDENTIFIER = "FEED";
    public static final String EXCHANGE_IDENTIFIER = "EXG-STAT";
    private static final String FEED_DELIMITER = ",";
    private static final String SEMI_COLON_DELIMITER = ";";
    private static final String QUOTE_DELIMITER = "\"";
    public static final String DOLLAR_DELIMITER = "$";
    public static final String BAR_DELIMITER = "|";
    private static final String NOT_APPLICABLE_TAG = "N/A";
    private static final String DEFAULT_ZERO = "0";
    private static final String DEFAULT_EMPTY = "";
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy h:mma");

    @Override
    public FeedData parseFeed(String message) {
        return null;
    }

    @Override
    public FeedData[] parseAllFeed(String sData) {
        FeedData[] feedDataArray;
        block10: {
            String[] feedMsg;
            MBP mbp;
            MBO mbo;
            ExchangeData exchangeData;
            SymbolFeedData symbolData;
            block9: {
                symbolData = null;
                exchangeData = null;
                feedDataArray = null;
                mbo = null;
                mbp = null;
                feedMsg = Utility.getTokens(sData, BAR_DELIMITER);
                if (!feedMsg[0].equals(FEED_IDENTIFIER)) break block9;
                String[] symbolMsg = Utility.getTokens(feedMsg[1], DOLLAR_DELIMITER);
                feedDataArray = new FeedData[symbolMsg.length];
                int i = 0;
                while (i < symbolMsg.length) {
                    Date date = null;
                    String symbol_Code = DEFAULT_EMPTY;
                    String exchange = DEFAULT_EMPTY;
                    String rate = DEFAULT_ZERO;
                    String quantity = DEFAULT_ZERO;
                    String market = null;
                    String bid_Price = DEFAULT_ZERO;
                    String offer_Price = DEFAULT_ZERO;
                    String buy_Volume = DEFAULT_ZERO;
                    String sell_Volume = DEFAULT_ZERO;
                    String open = DEFAULT_ZERO;
                    String turnOver = DEFAULT_ZERO;
                    String high = DEFAULT_ZERO;
                    String low = DEFAULT_ZERO;
                    String average = DEFAULT_ZERO;
                    String change = DEFAULT_ZERO;
                    String[] item = Utility.getTokens(symbolMsg[i], FEED_DELIMITER);
                    if (symbolMsg[i].indexOf(SEMI_COLON_DELIMITER) != -1) {
                        item = symbolMsg[i].split(SEMI_COLON_DELIMITER);
                    }
                    try {
                        String d = this.stripQuotes(item[2]);
                        String t = this.stripQuotes(item[3]);
                        date = this.simpleDateFormat.parse(String.valueOf(d) + " " + t);
                    }
                    catch (Exception e) {
                        System.out.println("@@@" + symbolMsg[i].toString());
                        System.err.println(e.getMessage());
                        date = new Date();
                    }
                    market = MarketData.getName(MarketData.REGULAR);
                    symbol_Code = this.stripQuotes(item[0]);
                    buy_Volume = DEFAULT_ZERO;
                    bid_Price = item[9].equals(NOT_APPLICABLE_TAG) ? DEFAULT_ZERO : item[9];
                    offer_Price = item[10].equals(NOT_APPLICABLE_TAG) ? DEFAULT_ZERO : item[10];
                    sell_Volume = DEFAULT_ZERO;
                    rate = item[1].equals(NOT_APPLICABLE_TAG) ? DEFAULT_ZERO : item[1];
                    quantity = item[13].equals(NOT_APPLICABLE_TAG) ? DEFAULT_ZERO : item[13];
                    average = DEFAULT_ZERO;
                    high = item[6].equals(NOT_APPLICABLE_TAG) ? DEFAULT_ZERO : item[6];
                    turnOver = item[8].equals(NOT_APPLICABLE_TAG) ? DEFAULT_ZERO : item[8];
                    low = item[7].equals(NOT_APPLICABLE_TAG) ? DEFAULT_ZERO : item[7];
                    change = item[4].equals(NOT_APPLICABLE_TAG) ? DEFAULT_ZERO : item[4];
                    open = item[5].equals(NOT_APPLICABLE_TAG) ? DEFAULT_ZERO : item[5];
                    exchange = this.stripQuotes(item[12]);
                    if (market != null) {
                        symbolData = new SymbolFeedData(2, "PK", exchange, date, market, symbol_Code, Utility.parseFloat(bid_Price, 0.0f), Utility.parseInt(buy_Volume, 0), Utility.parseFloat(offer_Price, 0.0f), Utility.parseInt(sell_Volume, 0), Utility.parseFloat(rate, 0.0f), Utility.parseInt(quantity, 0), Utility.parseInt(turnOver, 0), Utility.parseFloat(open, 0.0f), Utility.parseFloat(high, 0.0f), Utility.parseFloat(low, 0.0f), Utility.parseFloat(average, 0.0f), Utility.parseFloat(change, 0.0f));
                    }
                    feedDataArray[i] = new FeedData(exchangeData, symbolData, mbo, mbp);
                    ++i;
                }
                break block10;
            }
            if (!feedMsg[0].equals(EXCHANGE_IDENTIFIER)) break block10;
            String[] exchangeMsg = Utility.getTokens(feedMsg[1], DOLLAR_DELIMITER);
            feedDataArray = new FeedData[exchangeMsg.length];
            int i = 0;
            while (i < exchangeMsg.length) {
                Date date = null;
                String symbol_Code = DEFAULT_EMPTY;
                String exchange = DEFAULT_EMPTY;
                String current_Index = DEFAULT_ZERO;
                String high_Index = DEFAULT_ZERO;
                String low_Index = DEFAULT_ZERO;
                String last_Index = DEFAULT_ZERO;
                String total_Trades = DEFAULT_ZERO;
                String total_Turnover = DEFAULT_ZERO;
                String monitory_Volume = DEFAULT_ZERO;
                String up = DEFAULT_ZERO;
                String down = DEFAULT_ZERO;
                String equal = DEFAULT_ZERO;
                String net_Change = DEFAULT_ZERO;
                String[] item = Utility.getTokens(exchangeMsg[i], FEED_DELIMITER);
                if (exchangeMsg[i].indexOf(SEMI_COLON_DELIMITER) != -1) {
                    item = exchangeMsg[i].split(SEMI_COLON_DELIMITER);
                }
                try {
                    String d = this.stripQuotes(item[2]);
                    String t = this.stripQuotes(item[3]);
                    date = this.simpleDateFormat.parse(String.valueOf(d) + " " + t);
                }
                catch (Exception e) {
                    System.out.println("@@@" + exchangeMsg[i].toString());
                    System.err.println(e.getMessage());
                    date = new Date();
                }
                symbol_Code = this.stripQuotes(item[0]);
                current_Index = item[1].equals(NOT_APPLICABLE_TAG) ? DEFAULT_ZERO : item[1];
                net_Change = item[4].equals(NOT_APPLICABLE_TAG) ? DEFAULT_ZERO : item[4];
                high_Index = item[6].equals(NOT_APPLICABLE_TAG) ? DEFAULT_ZERO : item[6];
                low_Index = item[7].equals(NOT_APPLICABLE_TAG) ? DEFAULT_ZERO : item[7];
                total_Turnover = item[8].equals(NOT_APPLICABLE_TAG) ? DEFAULT_ZERO : item[8];
                last_Index = item[11].equals(NOT_APPLICABLE_TAG) ? DEFAULT_ZERO : item[11];
                float curIndex = Utility.parseFloat(current_Index, 0.0f);
                float lastIndex = Utility.parseFloat(last_Index, 0.0f);
                exchange = this.stripQuotes(item[12]);
                exchangeData = new ExchangeData("PK", exchange, date, curIndex, Utility.parseFloat(high_Index, 0.0f), Utility.parseFloat(low_Index, 0.0f), lastIndex, Utility.parseLong(total_Trades, 0), Utility.parseLong(total_Turnover, 0), (long)Utility.parseFloat(monitory_Volume, 0.0f), Utility.parseLong(up, 0), Utility.parseLong(down, 0), Utility.parseLong(equal, 0), Utility.parseFloat(net_Change, 0.0f));
                exchangeData.setSymbol(symbol_Code);
                feedDataArray[i] = new FeedData(exchangeData, symbolData, mbo, mbp);
                ++i;
            }
        }
        return feedDataArray;
    }

    private String stripQuotes(String s) {
        if (s.startsWith(QUOTE_DELIMITER)) {
            s = s.substring(1);
        }
        if (s.endsWith(QUOTE_DELIMITER)) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }
}

