/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.parser;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import pk.com.softech.messages.SupportServerData;

public class SupportMessageParser {
    public static final String CALL_INITIATION_MESSAGE_IDENTIFIER = "NCI";
    public static final String CALL_INITIATION_ACK_MESSAGE_IDENTIFIER = "CIA";
    public static final String CALL_TERMINATION_MESSAGE_IDENTIFIER = "NCT";
    public static final String CALL_TERMINATION_ACK_MESSAGE_IDENTIFIER = "CTA";
    public static final String HEARTBEAT_MESSAGE_IDENTIFIER = "HBT";
    protected static final int MSG_LENGHT_BEG_INDEX = 0;
    protected static final int MSG_LENGHT_END_INDEX = 3;
    protected static final int MSG_IDENTIFIER_BEG_INDEX = 4;
    protected static final int MSG_IDENTIFIER_END_INDEX = 6;
    protected static final int MSG_SESSIONID_BEG_INDEX = 7;
    protected static final int MSG_SESSIONID_END_INDEX = 21;
    protected static final int MSG_TIMESTAMP_BEG_INDEX = 22;
    protected static final int MSG_TIMESTAMP_END_INDEX = 35;
    protected static final int MSG_CALLERID_BEG_INDEX = 36;
    protected static final int MSG_CALLERID_END_INDEX = 50;
    protected static final int MSG_RECIVERID_BEG_INDEX = 51;
    protected static final String CALL_INITIATION_ACK_MSG_LENGHT = "0038";
    protected static final String CALL_TERMINATION_ACK_MSG_LENGHT = "0037";
    public static final String TRAILOR = "|";
    public String messageType;
    private DateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
    private Date timeStamp;
    private String strTimeStamp;
    private String callerId;
    private String receiverId;
    private char action;
    private int length;
    private String sessionId;
    private String type;

    public SupportServerData handleSupportServerMessages(String message) {
        try {
            this.length = Integer.parseInt(message.substring(0, 4));
            this.type = message.substring(4, 7);
            this.sessionId = message.substring(7, 22);
            try {
                this.timeStamp = this.formatter.parse(message.substring(22, 36));
            }
            catch (ParseException ex) {
                this.timeStamp = new Date();
                ex.printStackTrace();
            }
            if (this.type.equals(CALL_INITIATION_MESSAGE_IDENTIFIER)) {
                return this.buildCallInitiationMessage(message);
            }
            if (this.type.equals(CALL_TERMINATION_MESSAGE_IDENTIFIER)) {
                return this.buildCallTerminationMessage(message);
            }
            if (this.type.equals(HEARTBEAT_MESSAGE_IDENTIFIER)) {
                return this.buildHeartbeatMessage(message);
            }
            System.out.println("Unknow Message Identifier. ");
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private SupportServerData buildCallInitiationMessage(String message) {
        this.callerId = message.substring(36, 51).trim();
        this.receiverId = message.substring(51, message.length());
        System.out.println(String.valueOf(this.length) + "  " + this.type + "  " + this.sessionId + "  " + this.timeStamp + "  " + this.callerId + "  " + this.receiverId);
        return new SupportServerData(SupportServerData.CALL_INITIATION, this.callerId, this.receiverId, this.sessionId);
    }

    private SupportServerData buildCallTerminationMessage(String message) {
        this.callerId = message.substring(36, 51).trim();
        this.receiverId = message.substring(51, message.length());
        System.out.println(String.valueOf(this.length) + "  " + this.type + "  " + this.sessionId + "  " + this.timeStamp + "  " + this.callerId + "  " + this.receiverId);
        return new SupportServerData(SupportServerData.CALL_TERMINATION, this.callerId, this.receiverId, this.sessionId);
    }

    private SupportServerData buildHeartbeatMessage(String message) {
        System.out.println(String.valueOf(this.length) + "  " + this.type + "  " + this.sessionId + "  " + this.timeStamp);
        return new SupportServerData(SupportServerData.HEART_BEAT, "", "", this.sessionId);
    }

    public String handleTerminalMessages(SupportServerData data) {
        try {
            this.sessionId = data.getSessionId();
            this.action = data.getAction();
            this.strTimeStamp = this.formatter.format(new Date());
            if (data.getMsgType() == SupportServerData.CALL_INITIATION) {
                String initAckMsg = "0038CIA" + this.sessionId + this.strTimeStamp + this.action + TRAILOR;
                System.out.println("Initation Ack : " + initAckMsg);
                return initAckMsg;
            }
            if (data.getMsgType() == SupportServerData.CALL_TERMINATION) {
                String terAckMsg = "0037CTA" + this.sessionId + this.strTimeStamp + TRAILOR;
                System.out.println("Termination Ack : " + terAckMsg);
                return terAckMsg;
            }
            return "";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }
}

