/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.parser;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.logging.Logger;
import pk.com.softech.messages.ExchangeData;
import pk.com.softech.messages.FeedData;
import pk.com.softech.messages.MBO;
import pk.com.softech.messages.MBP;
import pk.com.softech.messages.SymbolFeedData;
import pk.com.softech.parser.DualHashTable;
import pk.com.softech.parser.Strangleable;
import pk.com.softech.util.Utility;

public class Strangle {
    protected float delay;
    protected Strangleable processor;
    protected boolean consolidate;
    protected boolean intervalUpdate;
    public static final String INDEX_KEY = "INDEX:";
    public static final String MBO_KEY = "MBO";
    public static final String MBP_KEY = "MBP";
    protected Hashtable hash;
    protected DualHashTable table;
    protected Logger log;
    protected String name;
    protected Strangler throttle;

    public Strangle(String name, Strangleable receiver, float timeLapse, Logger log) {
        this(name, receiver, timeLapse, log, false, false);
    }

    public Strangle(String name, Strangleable receiver, float timeLapse, Logger log, boolean intUpdate) {
        this(name, receiver, timeLapse, log, false, intUpdate);
    }

    public Strangle(String name, Strangleable receiver, float timeLapse, Logger log, boolean cons, boolean intUpdate) {
        this.name = name;
        this.processor = receiver;
        this.setDelay(timeLapse);
        this.log = log;
        this.consolidate = cons;
        this.intervalUpdate = intUpdate;
        this.table = new DualHashTable(1024);
        this.hash = new Hashtable(1024);
        this.throttle = new Strangler();
        this.throttle.start();
    }

    protected void setDelay(float timeLapse) {
        if ((double)timeLapse >= 0.0) {
            this.delay = timeLapse;
        } else {
            this.delay = 1.0f;
            this.log.info("Setting throttling time to one second.");
        }
    }

    public void strangulate(FeedData feedData) {
        if (this.delay == 0.0f) {
            this.processor.whenStrangled(this.name, feedData);
        } else if (feedData != null) {
            SymbolFeedData symbolData = feedData.getSymbolData();
            ExchangeData exchangeData = feedData.getExchangeData();
            MBO mbo = feedData.getMBO();
            MBP mbp = feedData.getMBP();
            if (symbolData != null) {
                symbolData = this.updateSymbol(symbolData);
                this.table.put(String.valueOf(symbolData.getExchange()) + symbolData.getMarket() + symbolData.getSymbol(), symbolData);
            }
            if (feedData.getExchangeData() != null) {
                exchangeData = this.updateExchange(exchangeData);
                this.table.put(String.valueOf(exchangeData.getExchange()) + INDEX_KEY + exchangeData.getSymbol(), exchangeData);
            }
            if (feedData.getMBO() != null) {
                this.updateMBO(mbo);
                this.table.put(String.valueOf(mbo.getExchange()) + mbo.getMarketType() + mbo.getSymbol() + MBO_KEY, mbo);
            }
            if (feedData.getMBP() != null) {
                this.updateMBP(mbp);
                this.table.put(String.valueOf(mbp.getExchange()) + mbp.getMarketType() + mbp.getSymbol() + MBP_KEY, mbp);
            }
        }
    }

    public SymbolFeedData updateSymbol(SymbolFeedData feed) {
        SymbolFeedData old = (SymbolFeedData)this.hash.get(String.valueOf(feed.getExchange()) + feed.getMarket() + feed.getSymbol());
        if (old == null) {
            this.hash.put(String.valueOf(feed.getExchange()) + feed.getMarket() + feed.getSymbol(), feed);
            return feed;
        }
        old.update(feed, this.intervalUpdate);
        this.hash.put(String.valueOf(old.getExchange()) + old.getMarket() + old.getSymbol(), old);
        return old;
    }

    public ExchangeData updateExchange(ExchangeData feed) {
        ExchangeData old = (ExchangeData)this.hash.get(String.valueOf(feed.getExchange()) + INDEX_KEY + feed.getSymbol());
        if (old == null) {
            this.hash.put(String.valueOf(feed.getExchange()) + INDEX_KEY + feed.getSymbol(), feed);
            return feed;
        }
        old.update(feed);
        this.hash.put(String.valueOf(old.getExchange()) + INDEX_KEY + feed.getSymbol(), old);
        return old;
    }

    public void updateMBO(MBO mbo) {
        this.hash.put(String.valueOf(mbo.getExchange()) + mbo.getMarketType() + mbo.getSymbol() + MBO_KEY, mbo);
    }

    public void updateMBP(MBP mbp) {
        this.hash.put(String.valueOf(mbp.getExchange()) + mbp.getMarketType() + mbp.getSymbol() + MBP_KEY, mbp);
    }

    public MBO getMbo(String key) {
        return (MBO)this.hash.get(key);
    }

    public MBP getMbp(String key) {
        return (MBP)this.hash.get(key);
    }

    class Strangler
    extends Thread {
        Strangler() {
        }

        @Override
        public void run() {
            while (true) {
                this.updateFeed();
            }
        }

        public synchronized void updateFeed() {
            Object element;
            Iterator<Object> iterator = Strangle.this.table.values().iterator();
            Vector<FeedData> list = new Vector<FeedData>();
            while (iterator.hasNext()) {
                try {
                    element = iterator.next();
                    if (element instanceof SymbolFeedData) {
                        if (Strangle.this.consolidate) {
                            list.add(new FeedData(null, (SymbolFeedData)element, null, null));
                            continue;
                        }
                        Strangle.this.processor.whenStrangled(Strangle.this.name, new FeedData(null, (SymbolFeedData)element, null, null));
                        continue;
                    }
                    if (element instanceof ExchangeData) {
                        if (Strangle.this.consolidate) {
                            list.add(new FeedData((ExchangeData)element, null, null, null));
                            continue;
                        }
                        Strangle.this.processor.whenStrangled(Strangle.this.name, new FeedData((ExchangeData)element, null, null, null));
                        continue;
                    }
                    if (element instanceof MBO) {
                        if (Strangle.this.consolidate) {
                            list.add(new FeedData(null, null, (MBO)element, null));
                            continue;
                        }
                        Strangle.this.processor.whenStrangled(Strangle.this.name, new FeedData(null, null, (MBO)element, null));
                        continue;
                    }
                    if (!(element instanceof MBP)) continue;
                    if (Strangle.this.consolidate) {
                        list.add(new FeedData(null, null, null, (MBP)element));
                        continue;
                    }
                    Strangle.this.processor.whenStrangled(Strangle.this.name, new FeedData(null, null, null, (MBP)element));
                }
                catch (NoSuchElementException noSuchElementException) {
                    break;
                }
                catch (Exception e) {
                    Strangle.this.log.warning(Utility.captureStackTrace(e));
                }
            }
            if (Strangle.this.intervalUpdate) {
                iterator = Strangle.this.hash.values().iterator();
                while (iterator.hasNext()) {
                    try {
                        element = iterator.next();
                        if (!(element instanceof SymbolFeedData)) continue;
                        ((SymbolFeedData)element).clearIntervalFeedOnUpdate();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        break;
                    }
                    catch (Exception e) {
                        Strangle.this.log.warning(Utility.captureStackTrace(e));
                    }
                }
            }
            if (Strangle.this.consolidate && list.size() > 0) {
                Strangle.this.processor.whenStrangled(Strangle.this.name, list);
            }
            Strangle.this.table.clear();
            this.snooze();
        }

        public void snooze() {
            float delayTime = Strangle.this.delay * 1000.0f;
            try {
                Strangler.sleep((int)delayTime);
            }
            catch (Exception exception) {}
        }
    }
}

