/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.parser;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import pk.com.softech.messages.COTConfirmation;
import pk.com.softech.messages.COTData;
import pk.com.softech.messages.COTPositionRequest;
import pk.com.softech.messages.COTPositionResponse;
import pk.com.softech.messages.ChangePasswordRequest;
import pk.com.softech.messages.ChangePasswordResponse;
import pk.com.softech.messages.CustodyData;
import pk.com.softech.messages.CustodyRequest;
import pk.com.softech.messages.CustodyResponse;
import pk.com.softech.messages.ExchangeList;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.LoginMessage;
import pk.com.softech.messages.LogoutMessage;
import pk.com.softech.messages.MarginData;
import pk.com.softech.messages.MarginRequest;
import pk.com.softech.messages.MarginResponse;
import pk.com.softech.messages.MarketData;
import pk.com.softech.messages.MarketRequest;
import pk.com.softech.messages.MarketResponse;
import pk.com.softech.messages.MobileGraphRequest;
import pk.com.softech.messages.MobileGraphResponse;
import pk.com.softech.messages.MobileImageRequest;
import pk.com.softech.messages.MobilePortfolioData;
import pk.com.softech.messages.MobilePortfolioRequest;
import pk.com.softech.messages.MobilePortfolioResponse;
import pk.com.softech.messages.MobileSymbolGraphRequest;
import pk.com.softech.messages.MobileSymbolGraphResponse;
import pk.com.softech.messages.NewsData;
import pk.com.softech.messages.NewsRequest;
import pk.com.softech.messages.NewsResponse;
import pk.com.softech.messages.OrderConfirmation;
import pk.com.softech.messages.OrderMessage;
import pk.com.softech.messages.OrderStatusData;
import pk.com.softech.messages.OrderStatusRequest;
import pk.com.softech.messages.OrderStatusResponse;
import pk.com.softech.messages.QuoteRequest;
import pk.com.softech.messages.QuoteResponse;
import pk.com.softech.messages.SubscriptionListData;
import pk.com.softech.messages.SubscriptionListRequest;
import pk.com.softech.messages.SubscriptionListResponse;
import pk.com.softech.messages.SubscriptionRequest;
import pk.com.softech.messages.SubscriptionResponse;
import pk.com.softech.messages.SymbolGraphData;
import pk.com.softech.messages.TRNCodeList;
import pk.com.softech.messages.TextMessage;
import pk.com.softech.messages.TopGainers;
import pk.com.softech.messages.TopGainersData;
import pk.com.softech.messages.TopSymbols;
import pk.com.softech.messages.TopSymbolsData;
import pk.com.softech.messages.TradeConfirmation;
import pk.com.softech.util.Utility;

public class MobileMessageParser {
    public static final String LOGIN_MESSAGE_IDENTIFIER = "LOGN";
    public static final String LOGIN_CONFIRMATION_IDENTIFIER = "LCNF";
    public static final String LOGOUT_MESSAGE_IDENTIFIER = "LOGT";
    public static final String SUBSCRIPTION_LIST_REQUEST_IDENTIFIER = "SLRQ";
    public static final String SUBSCRIPTION_LIST_RESPONSE_IDENTIFIER = "SLRS";
    public static final String ORDER_STATUS_REQUEST_IDENTIFIER = "OSRQ";
    public static final String ORDER_STATUS_RESPONSE_IDENTIFIER = "OSRS";
    public static final String ORDER_MESSAGE_IDENTIFIER = "ORDR";
    public static final String ORDER_CONFIRMATION_IDENTIFIER = "OCNF";
    public static final String TRADE_CONFIRMATION_IDENTIFIER = "TCNF";
    public static final String QUOTE_REQUEST_IDENTIFIER = "QREQ";
    public static final String QUOTE_RESPONSE_IDENTIFIER = "QRES";
    public static final String SUBSCRIPTION_REQUEST_IDENTIFIER = "SREQ";
    public static final String SUBSCRIPTION_RESPONSE_IDENTIFIER = "SRES";
    public static final String MARGIN_REQUEST_IDENTIFIER = "MREQ";
    public static final String MARGIN_RESPONSE_IDENTIFIER = "MRES";
    public static final String FEED_LOGIN_MESSAGE_IDENTIFIER = "FLGN";
    public static final String FEED_LOGIN_CONFIRMATION_IDENTIFIER = "FCNF";
    public static final String PRICE_ALERT_REQUEST_IDENTIFIER = "PARQ";
    public static final String PRICE_ALERT_RESPONSE_IDENTIFIER = "PARS";
    public static final String TEXT_MESSAGE_IDENTIFIER = "TEXT";
    public static final String CUSTODY_REQUEST_IDENTIFIER = "CREQ";
    public static final String CUSTODY_RESPONSE_IDENTIFIER = "CRES";
    public static final String DELIVERY_REQUEST_IDENTIFIER = "DREQ";
    public static final String DELIVERY_RESPONSE_IDENTIFIER = "DRES";
    public static final String COT_CONFIRMATION_IDENTIFIER = "CCNF";
    public static final String TRN_REQUEST_IDENTIFIER = "TRNR";
    public static final String TRN_RESPONSE_IDENTIFIER = "TRNS";
    public static final String TOP_SYMBOL_REQ_IDENTIFIER = "TSRQ";
    public static final String TOP_SYMBOL_RES_IDENTIFIER = "TSRS";
    public static final String TOP_GAINERS_REQ_IDENTIFIER = "TGRQ";
    public static final String TOP_GAINERS_RES_IDENTIFIER = "TGRS";
    public static final String GRAPH_REQUEST_IDENTIFIER = "GREQ";
    public static final String GRAPH_RESPONSE_IDENTIFIER = "GRES";
    public static final String SYMBOL_GRAPH_REQUEST_IDENTIFIER = "SGRQ";
    public static final String SYMBOL_GRAPH_RESPONSE_IDENTIFIER = "SGRS";
    public static final String AVAILABLE_EXCHANGES_REQ_IDENTIFIER = "AERQ";
    public static final String AVAILABLE_EXCHANGES_RES_IDENTIFIER = "AERP";
    public static final String CHANGE_PASSWORD_REQ_IDENTIFIER = "CPRQ";
    public static final String CHANGE_PASSWORD_RES_IDENTIFIER = "CPRS";
    public static final String TEST_IMAGE_REQUEST_IDENTIFIER = "TIRQ";
    public static final String TEST_IMAGE_RESPONSE_IDENTIFIER = "TIRS";
    public static final String MARKETS_REQ_IDENTIFIER = "MSRQ";
    public static final String MARKETS_RES_IDENTIFIER = "MSRS";
    public static final String NEWS_REQUEST_IDENTIFIER = "NREQ";
    public static final String NEWS_RESPONSE_IDENTIFIER = "NRES";
    public static final String PORTFOLIO_REQUEST_IDENTIFIER = "PREQ";
    public static final String PORTFOLIO_RESPONSE_IDENTIFIER = "PRES";
    public static final String ACCEPT = "ACPT";
    public static final String REJECT = "REJT";
    public static final String BUY_TAG = "B";
    public static final String SELL_TAG = "S";
    public static final String NEW_TAG = "NEW";
    public static final String CANCEL_TAG = "CNL";
    public static final String BAR_IDENTIFIER = "|";
    public static final String COMMA_IDENTIFIER = ",";
    public static final String SEMICOLON_IDENTIFIER = ";";
    public static final String DOLLAR_IDENTIFIER = "$";
    public static final String EMPTY_IDENTIFIER = " ";
    public static final int IDENTIFIER_INDEX = 0;
    public static final int USER_ID_INDEX = 0;
    public static final int USER_PASSWORD_INDEX = 1;
    public static final int USER_NAME_INDEX = 0;
    public static final int EXCHANGE_CODE_INDEX = 1;
    public static final int MOBILE_USER_NAME_INDEX = 0;
    public static final int USER_OLD_PASSWORD_INDEX = 1;
    public static final int USER_NEW_PASSWORD_INDEX = 2;
    public static final int MOBILE_IMAGE_WIDTH_INDEX = 0;
    public static final int MOBILE_IMAGE_HEIGHT_INDEX = 1;
    public static final int ORDER_SYMBOL_INDEX = 0;
    public static final int ORDER_PRICE_INDEX = 1;
    public static final int ORDER_VOLUME_INDEX = 2;
    public static final int ORDER_SIDE_INDEX = 3;
    public static final int ORDER_ORDER_NO_INDEX = 4;
    public static final int ORDER_ACTION_INDEX = 5;
    public static final int ORDER_REM_VOL_INDEX = 6;
    public static final int ORDER_EXCHANGE_INDEX = 7;
    public static final int ORDER_MARKET_INDEX = 8;
    public static final int SUBSCRIPTION_REQUEST_TYPE_INDEX = 0;
    public static final int SUBSCRIPTION_REQUEST_SYMBOL_INDEX = 1;
    public static final int SUBSCRIPTION_REQUEST_EXCHANGE_INDEX = 2;
    public static final int QUOTE_REQUEST_SYMBOL_INDEX = 0;
    public static final int QUOTE_REQUEST_EXCHANGE_INDEX = 1;
    public static final int NEWS_REQUEST_SYMBOL_INDEX = 0;
    public static final int NEWS_REQUEST_EXCHANGE_INDEX = 1;
    public static final int MARGIN_REQUEST_ID_INDEX = 0;
    public static final int GRAPH_REQUEST_SYMBOL_INDEX = 0;
    public static final int GRAPH_REQUEST_HEIGHT_INDEX = 1;
    public static final int GRAPH_REQUEST_WIDTH_INDEX = 2;
    public static final int SG_REQUEST_SYMBOL_INDEX = 0;
    public static final int SG_EXCHANGE_SYMBOL_INDEX = 1;
    public static final int SG_REQUEST_DELAY_INDEX = 2;
    public static final int TOP_SYMBOLS_EXCHANGE_INDEX = 0;
    public static final int GAINERS_LOSERS_EXCHANGE_INDEX = 0;
    public static final int COT_TYPE_INDEX = 0;
    public static String MARKET_REGULAR = "REG";
    private int userType;
    private String userId;
    private String client;
    private String trader;
    private String member;
    private String feedIP;
    private String feedPort;
    private DecimalFormat decimalFormat;
    private String ExchangeCodes;
    private boolean custody = false;

    public MobileMessageParser() {
        this.decimalFormat = new DecimalFormat("0.00");
    }

    public MobileMessageParser(int userType, String userId, String client, String trader, String member, String feedIP, String feedPort) {
        this.userId = userId;
        this.userType = userType;
        this.client = client;
        this.trader = trader;
        this.member = member;
        this.feedIP = feedIP;
        this.feedPort = feedPort;
        this.decimalFormat = new DecimalFormat("0.00");
    }

    public void initialize(int userType, String userId, String client, String trader, String member, String feedIP, String feedPort) {
        this.userId = userId;
        this.userType = userType;
        this.client = client;
        this.trader = trader;
        this.member = member;
        this.feedIP = feedIP;
        this.feedPort = feedPort;
    }

    public String parseMessage(Object message, Logger log) {
        if (message instanceof LoginConfirmation) {
            StringBuffer msg = new StringBuffer(LOGIN_CONFIRMATION_IDENTIFIER);
            msg.append(BAR_IDENTIFIER);
            if (((LoginConfirmation)message).getAction() == 0 && ((LoginConfirmation)message).getMobileApplicable() && (((LoginConfirmation)message).getUserType() == 1 || ((LoginConfirmation)message).getUserType() == 2)) {
                msg.append(ACCEPT);
            } else {
                msg.append(REJECT);
            }
            msg.append(COMMA_IDENTIFIER);
            msg.append(this.feedIP);
            msg.append(COMMA_IDENTIFIER);
            msg.append(this.feedPort);
            msg.append(COMMA_IDENTIFIER);
            msg.append(this.getCurrentTime());
            msg.append(COMMA_IDENTIFIER);
            msg.append(((LoginConfirmation)message).getMobileAppVersion());
            msg.append(COMMA_IDENTIFIER);
            msg.append(((LoginConfirmation)message).getMobileAppUpdateLink());
            msg.append(COMMA_IDENTIFIER);
            String exchanges = ((LoginConfirmation)message).getApplicableStockExchanges();
            System.out.println("exchanges " + exchanges);
            int index = exchanges.indexOf(SEMICOLON_IDENTIFIER);
            if (index != -1) {
                msg.append(true);
            } else {
                msg.append(false);
            }
            msg.append(COMMA_IDENTIFIER);
            msg.append(((LoginConfirmation)message).getMobileAdvEnabled());
            msg.append(COMMA_IDENTIFIER);
            if (((LoginConfirmation)message).getMobileAdvLink() == null) {
                msg.append(EMPTY_IDENTIFIER);
            } else {
                msg.append(((LoginConfirmation)message).getMobileAdvLink());
            }
            msg.append(COMMA_IDENTIFIER);
            msg.append(((LoginConfirmation)message).getRemarks());
            msg.append(BAR_IDENTIFIER);
            return msg.toString();
        }
        if (message instanceof SubscriptionListResponse) {
            SubscriptionListData[] exchanges = ((SubscriptionListResponse)message).getExchs();
            SubscriptionListData[] symbols = ((SubscriptionListResponse)message).getRows();
            StringBuffer msg = new StringBuffer(SUBSCRIPTION_LIST_RESPONSE_IDENTIFIER);
            msg.append(BAR_IDENTIFIER);
            try {
                int i;
                if (exchanges != null) {
                    i = 0;
                    while (i < exchanges.length) {
                        msg.append(exchanges[i].getSymbol());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(this.decimalFormat.format(exchanges[i].getCurrent()));
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(this.decimalFormat.format(exchanges[i].getChange()));
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(this.decimalFormat.format(exchanges[i].getBuyPrice()));
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(this.decimalFormat.format(exchanges[i].getSellPrice()));
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(symbols[i].getTurnOver());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(exchanges[i].geExchangeCode());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(exchanges[i].getIndicator());
                        if (i < exchanges.length - 1) {
                            msg.append(SEMICOLON_IDENTIFIER);
                        }
                        ++i;
                    }
                }
                msg.append(DOLLAR_IDENTIFIER);
                if (symbols != null) {
                    i = 0;
                    while (i < symbols.length) {
                        msg.append(symbols[i].getSymbol());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(this.decimalFormat.format(symbols[i].getCurrent()));
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(this.decimalFormat.format(symbols[i].getChange()));
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(this.decimalFormat.format(symbols[i].getBuyPrice()));
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(this.decimalFormat.format(symbols[i].getSellPrice()));
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(symbols[i].getTurnOver());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(symbols[i].geExchangeCode());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(symbols[i].getIndicator());
                        if (i < symbols.length - 1) {
                            msg.append(SEMICOLON_IDENTIFIER);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                log.warning(String.valueOf(message.toString()) + " : " + e.getMessage());
                e.printStackTrace();
                return "";
            }
            msg.append(BAR_IDENTIFIER);
            return msg.toString();
        }
        if (message instanceof MobileGraphResponse) {
            StringBuffer msg = new StringBuffer(GRAPH_RESPONSE_IDENTIFIER);
            msg.append(BAR_IDENTIFIER);
            msg.append(((MobileGraphResponse)message).getSymbol());
            msg.append(COMMA_IDENTIFIER);
            msg.append(((MobileGraphResponse)message).getBytes());
            msg.append(BAR_IDENTIFIER);
            return msg.toString();
        }
        if (message instanceof MobileSymbolGraphResponse) {
            try {
                StringBuffer msg = new StringBuffer(SYMBOL_GRAPH_RESPONSE_IDENTIFIER);
                msg.append(BAR_IDENTIFIER);
                SymbolGraphData[] rows = ((MobileSymbolGraphResponse)message).getrows();
                msg.append(((MobileSymbolGraphResponse)message).getSymbol());
                msg.append(COMMA_IDENTIFIER);
                msg.append(((MobileSymbolGraphResponse)message).getExchange());
                msg.append(COMMA_IDENTIFIER);
                msg.append(((MobileSymbolGraphResponse)message).getMax());
                msg.append(COMMA_IDENTIFIER);
                msg.append(((MobileSymbolGraphResponse)message).getMin());
                msg.append(COMMA_IDENTIFIER);
                msg.append(((MobileSymbolGraphResponse)message).getDelay());
                if (rows.length > 0) {
                    msg.append(SEMICOLON_IDENTIFIER);
                }
                if (((MobileSymbolGraphResponse)message).getDelay() >= 0) {
                    int i = 0;
                    while (i < rows.length) {
                        String time = String.valueOf(rows[i].getTimeStamp().getHours()) + ":" + rows[i].getTimeStamp().getMinutes();
                        msg.append(time);
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(rows[i].getPrice());
                        if (i < rows.length - 1) {
                            msg.append(SEMICOLON_IDENTIFIER);
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < rows.length) {
                        String time = String.valueOf(rows[i].getTimeStamp().getDate()) + "-" + (rows[i].getTimeStamp().getMonth() + 1) + "-" + rows[i].getTimeStamp().getYear() % 100;
                        msg.append(time);
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(rows[i].getPrice());
                        if (i < rows.length - 1) {
                            msg.append(SEMICOLON_IDENTIFIER);
                        }
                        ++i;
                    }
                }
                msg.append(BAR_IDENTIFIER);
                return msg.toString();
            }
            catch (Exception exception) {
                log.warning(message.toString());
                return "";
            }
        }
        if (message instanceof QuoteResponse) {
            StringBuffer msg = new StringBuffer(QUOTE_RESPONSE_IDENTIFIER);
            msg.append(BAR_IDENTIFIER);
            msg.append(((QuoteResponse)message).getSymbol());
            msg.append(COMMA_IDENTIFIER);
            msg.append(this.decimalFormat.format(((QuoteResponse)message).getCurrPrice()));
            msg.append(COMMA_IDENTIFIER);
            msg.append(this.decimalFormat.format(((QuoteResponse)message).getPrevPrice()));
            msg.append(COMMA_IDENTIFIER);
            msg.append(this.decimalFormat.format(((QuoteResponse)message).getChange()));
            msg.append(COMMA_IDENTIFIER);
            msg.append(((QuoteResponse)message).getTurnover());
            msg.append(COMMA_IDENTIFIER);
            msg.append(this.decimalFormat.format(((QuoteResponse)message).getOfferPrice()));
            msg.append(COMMA_IDENTIFIER);
            msg.append(((QuoteResponse)message).getOfferVolume());
            msg.append(COMMA_IDENTIFIER);
            msg.append(this.decimalFormat.format(((QuoteResponse)message).getBidPrice()));
            msg.append(COMMA_IDENTIFIER);
            msg.append(((QuoteResponse)message).getBidVolume());
            msg.append(COMMA_IDENTIFIER);
            msg.append(this.decimalFormat.format(((QuoteResponse)message).getHighPrice()));
            msg.append(COMMA_IDENTIFIER);
            msg.append(this.decimalFormat.format(((QuoteResponse)message).getLowPrice()));
            msg.append(COMMA_IDENTIFIER);
            msg.append(this.decimalFormat.format(((QuoteResponse)message).getAveragePrice()));
            msg.append(COMMA_IDENTIFIER);
            msg.append(((QuoteResponse)message).getName());
            msg.append(COMMA_IDENTIFIER);
            msg.append(this.decimalFormat.format(((QuoteResponse)message).getPerc_change()));
            msg.append(BAR_IDENTIFIER);
            return msg.toString();
        }
        if (message instanceof SubscriptionResponse) {
            StringBuffer msg = new StringBuffer(SUBSCRIPTION_RESPONSE_IDENTIFIER);
            msg.append(BAR_IDENTIFIER);
            msg.append(((SubscriptionResponse)message).getResponse());
            msg.append(COMMA_IDENTIFIER);
            msg.append(((SubscriptionResponse)message).getRequestType());
            msg.append(COMMA_IDENTIFIER);
            msg.append(((SubscriptionResponse)message).getSymbol());
            msg.append(COMMA_IDENTIFIER);
            msg.append(((SubscriptionResponse)message).getTradePrice());
            msg.append(COMMA_IDENTIFIER);
            msg.append(((SubscriptionResponse)message).getChange());
            msg.append(COMMA_IDENTIFIER);
            msg.append(((SubscriptionResponse)message).getBuyPrice());
            msg.append(COMMA_IDENTIFIER);
            msg.append(((SubscriptionResponse)message).getSellPrice());
            msg.append(COMMA_IDENTIFIER);
            msg.append(((SubscriptionResponse)message).getTurnover());
            msg.append(COMMA_IDENTIFIER);
            msg.append(((SubscriptionResponse)message).getExchange());
            msg.append(COMMA_IDENTIFIER);
            msg.append(((SubscriptionResponse)message).getIndicator());
            msg.append(BAR_IDENTIFIER);
            return msg.toString();
        }
        if (message instanceof MarginResponse) {
            try {
                if (this.custody) {
                    StringBuffer msg = new StringBuffer(CUSTODY_RESPONSE_IDENTIFIER);
                    msg.append(BAR_IDENTIFIER);
                    MarginData[] rows = ((MarginResponse)message).getrows();
                    int i = 0;
                    while (i < rows.length) {
                        msg.append(rows[i].getSymbol());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(rows[i].getAvailableBalance());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(rows[i].getBilledBalance());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(rows[i].getTodayReceivedDelivery());
                        if (i < rows.length - 1) {
                            msg.append(SEMICOLON_IDENTIFIER);
                        }
                        ++i;
                    }
                    msg.append(BAR_IDENTIFIER);
                    this.custody = false;
                    return msg.toString();
                }
                StringBuffer msg = new StringBuffer(MARGIN_RESPONSE_IDENTIFIER);
                msg.append(BAR_IDENTIFIER);
                msg.append(this.decimalFormat.parse(this.decimalFormat.format(((MarginResponse)message).getCashBalance())));
                msg.append(COMMA_IDENTIFIER);
                msg.append(this.decimalFormat.parse(this.decimalFormat.format(((MarginResponse)message).getCustody())));
                msg.append(COMMA_IDENTIFIER);
                msg.append(this.decimalFormat.parse(this.decimalFormat.format(((MarginResponse)message).getAvailableMargin())));
                msg.append(COMMA_IDENTIFIER);
                msg.append(this.decimalFormat.parse(this.decimalFormat.format(((MarginResponse)message).getExposureAllowed())));
                msg.append(COMMA_IDENTIFIER);
                msg.append(this.decimalFormat.parse(this.decimalFormat.format(((MarginResponse)message).getCOT())));
                msg.append(COMMA_IDENTIFIER);
                msg.append(this.decimalFormat.parse(this.decimalFormat.format(((MarginResponse)message).getFuture())));
                msg.append(COMMA_IDENTIFIER);
                msg.append(this.decimalFormat.parse(this.decimalFormat.format(((MarginResponse)message).getProvisional())));
                msg.append(COMMA_IDENTIFIER);
                msg.append(this.decimalFormat.parse(this.decimalFormat.format(((MarginResponse)message).getTotalOpen())));
                msg.append(COMMA_IDENTIFIER);
                msg.append(this.decimalFormat.parse(this.decimalFormat.format(((MarginResponse)message).getMarginPercentage())));
                msg.append(BAR_IDENTIFIER);
                return msg.toString();
            }
            catch (Exception exception) {
                log.warning(message.toString());
                return "";
            }
        }
        if (message instanceof CustodyResponse) {
            try {
                StringBuffer msg = new StringBuffer(CUSTODY_RESPONSE_IDENTIFIER);
                msg.append(BAR_IDENTIFIER);
                CustodyData[] rows = ((CustodyResponse)message).getrows();
                int i = 0;
                while (i < rows.length) {
                    msg.append(rows[i].getSymbol());
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(rows[i].getVolume());
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(rows[i].getCurrency());
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(rows[i].getPrice());
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(rows[i].getValue());
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(rows[i].getExchange());
                    if (i < rows.length - 1) {
                        msg.append(SEMICOLON_IDENTIFIER);
                    }
                    ++i;
                }
                msg.append(BAR_IDENTIFIER);
                return msg.toString();
            }
            catch (Exception exception) {
                log.warning(message.toString());
                return "";
            }
        }
        if (message instanceof MobilePortfolioResponse) {
            try {
                StringBuffer msg = new StringBuffer(PORTFOLIO_RESPONSE_IDENTIFIER);
                msg.append(BAR_IDENTIFIER);
                MobilePortfolioData[] rows = ((MobilePortfolioResponse)message).getrows();
                int i = 0;
                while (i < rows.length) {
                    if (i == 0) {
                        msg.append(rows[i].getExchange());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(rows[i].getCashBalance());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(rows[i].getPortfolioSold());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(rows[i].getPortfolioValue());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(rows[i].getProfitLoss());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(rows[i].getTotalPortfolio());
                    } else {
                        msg.append(rows[i].getExchange());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(rows[i].getAvailableMargin());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(rows[i].getCurrentExposure());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(rows[i].getRequiredMargin());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(rows[i].getCashRequired());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(rows[i].getExcessShortMargin());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(rows[i].getMarginPerc());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(rows[i].getWithdrawableCashinProgress());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(rows[i].getWithdrawableCash());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(rows[i].getCashMarginCall());
                        msg.append(COMMA_IDENTIFIER);
                        msg.append(rows[i].getNetMarginCall());
                    }
                    if (i < rows.length - 1) {
                        msg.append(SEMICOLON_IDENTIFIER);
                    }
                    ++i;
                }
                msg.append(BAR_IDENTIFIER);
                return msg.toString();
            }
            catch (Exception exception) {
                log.warning(message.toString());
                return "";
            }
        }
        if (message instanceof NewsResponse) {
            try {
                StringBuffer msg = new StringBuffer(NEWS_RESPONSE_IDENTIFIER);
                msg.append(BAR_IDENTIFIER);
                NewsData[] rows = ((NewsResponse)message).getrows();
                int i = 0;
                while (i < rows.length) {
                    msg.append(rows[i].getSpotDate());
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(rows[i].getDividend());
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(rows[i].getBonusShare());
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(rows[i].getRightShare());
                    if (i < rows.length - 1) {
                        msg.append(SEMICOLON_IDENTIFIER);
                    }
                    ++i;
                }
                msg.append(BAR_IDENTIFIER);
                return msg.toString();
            }
            catch (Exception exception) {
                log.warning(message.toString());
                return "";
            }
        }
        if (message instanceof OrderConfirmation) {
            StringBuffer msg = new StringBuffer(ORDER_CONFIRMATION_IDENTIFIER);
            msg.append(BAR_IDENTIFIER);
            if (((OrderConfirmation)message).getAction() == OrderConfirmation.REJECT) {
                msg.append(REJECT);
            } else {
                msg.append(ACCEPT);
            }
            msg.append(COMMA_IDENTIFIER);
            msg.append(((OrderConfirmation)message).getOrder().getNumber());
            msg.append(COMMA_IDENTIFIER);
            if (((OrderConfirmation)message).getOrder().getSide() == 0) {
                msg.append(BUY_TAG);
            } else {
                msg.append(SELL_TAG);
            }
            msg.append(COMMA_IDENTIFIER);
            msg.append(((OrderConfirmation)message).getOrder().getSymbol());
            msg.append(COMMA_IDENTIFIER);
            msg.append(((OrderConfirmation)message).getOrder().getPrice());
            msg.append(COMMA_IDENTIFIER);
            msg.append(((OrderConfirmation)message).getOrder().getVolume());
            msg.append(COMMA_IDENTIFIER);
            msg.append(((OrderConfirmation)message).getOrder().getStExCode());
            msg.append(COMMA_IDENTIFIER);
            System.out.println("Order Response Exchange is : " + ((OrderConfirmation)message).getOrder().getStExCode());
            String remarks = ((OrderConfirmation)message).getRemarks();
            while (remarks.indexOf(44) != -1) {
                remarks = String.valueOf(remarks.substring(0, remarks.indexOf(44))) + remarks.substring(remarks.indexOf(44) + 1);
            }
            msg.append(remarks);
            msg.append(COMMA_IDENTIFIER);
            if (((OrderConfirmation)message).getAction() == OrderConfirmation.RECEIVED) {
                msg.append("true");
            } else {
                msg.append("false");
            }
            msg.append(BAR_IDENTIFIER);
            return msg.toString();
        }
        if (message instanceof OrderStatusResponse) {
            if (((OrderStatusResponse)message).getFilled() == 0) {
                StringBuffer msg = new StringBuffer(ORDER_STATUS_RESPONSE_IDENTIFIER);
                msg.append(BAR_IDENTIFIER);
                msg.append(BAR_IDENTIFIER);
                return msg.toString();
            }
            OrderStatusData[] orderData = ((OrderStatusResponse)message).getRows();
            StringBuffer msg = new StringBuffer(ORDER_STATUS_RESPONSE_IDENTIFIER);
            msg.append(BAR_IDENTIFIER);
            int i = 0;
            while (i < orderData.length) {
                msg.append(orderData[i].getExchangeCode());
                msg.append(COMMA_IDENTIFIER);
                msg.append(orderData[i].getIdentifier());
                if (orderData[i].getIdentifier().equals("TRD")) {
                    msg.append('(');
                    msg.append(orderData[i].getSymbol());
                    msg.append(')');
                }
                msg.append(COMMA_IDENTIFIER);
                msg.append(orderData[i].getBuyOrSell());
                msg.append(COMMA_IDENTIFIER);
                if (orderData[i].getIdentifier().equals("ORD")) {
                    msg.append(orderData[i].getSymbol());
                    msg.append(COMMA_IDENTIFIER);
                }
                msg.append(orderData[i].getPrice());
                msg.append(COMMA_IDENTIFIER);
                msg.append(orderData[i].getVolume());
                if (orderData[i].getIdentifier().equals("ORD")) {
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(orderData[i].getExecVolume());
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(orderData[i].getOrderNo());
                }
                msg.append(COMMA_IDENTIFIER);
                msg.append(orderData[i].getMarketCode());
                msg.append(SEMICOLON_IDENTIFIER);
                ++i;
            }
            msg.append(BAR_IDENTIFIER);
            return msg.toString();
        }
        if (message instanceof TradeConfirmation) {
            StringBuffer msg = new StringBuffer(TRADE_CONFIRMATION_IDENTIFIER);
            msg.append(BAR_IDENTIFIER);
            String remarks = ((TradeConfirmation)message).getRemarks();
            while (remarks.indexOf(44) != -1) {
                remarks = String.valueOf(remarks.substring(0, remarks.indexOf(44))) + remarks.substring(remarks.indexOf(44) + 1);
            }
            msg.append(remarks);
            msg.append(BAR_IDENTIFIER);
            return msg.toString();
        }
        if (message instanceof COTPositionResponse) {
            StringBuffer msg = new StringBuffer(DELIVERY_RESPONSE_IDENTIFIER);
            msg.append(BAR_IDENTIFIER);
            if (((COTPositionResponse)message).getFilled() == 0) {
                msg.append(BAR_IDENTIFIER);
                return msg.toString();
            }
            COTData[] rows = ((COTPositionResponse)message).getRows();
            int i = 0;
            while (i < rows.length) {
                msg.append(rows[i].getSymbol());
                msg.append(COMMA_IDENTIFIER);
                msg.append(rows[i].getTotalVolume());
                msg.append(COMMA_IDENTIFIER);
                msg.append(rows[i].getDeliveryVolume());
                msg.append(COMMA_IDENTIFIER);
                msg.append(rows[i].getSettlementDate());
                if (i < rows.length - 1) {
                    msg.append(SEMICOLON_IDENTIFIER);
                }
                ++i;
            }
            msg.append(BAR_IDENTIFIER);
            return msg.toString();
        }
        if (message instanceof COTConfirmation) {
            StringBuffer msg = new StringBuffer(COT_CONFIRMATION_IDENTIFIER);
            msg.append(BAR_IDENTIFIER);
            if (((COTConfirmation)message).getAction() == COTConfirmation.ACCEPT) {
                msg.append(ACCEPT);
            } else {
                msg.append(REJECT);
            }
            msg.append(COMMA_IDENTIFIER);
            msg.append(((COTConfirmation)message).getRemarks());
            msg.append(BAR_IDENTIFIER);
            return msg.toString();
        }
        if (message instanceof TextMessage) {
            StringBuffer msg = new StringBuffer(TEXT_MESSAGE_IDENTIFIER);
            msg.append(BAR_IDENTIFIER);
            msg.append(((TextMessage)message).getText());
            msg.append(BAR_IDENTIFIER);
            return msg.toString();
        }
        if (message instanceof TRNCodeList) {
            StringBuffer msg = new StringBuffer(TRN_RESPONSE_IDENTIFIER);
            msg.append(BAR_IDENTIFIER);
            ArrayList trnCodes = ((TRNCodeList)message).getTrnCodes();
            int i = 0;
            while (i < trnCodes.size()) {
                msg.append(trnCodes.get(i));
                if (i < trnCodes.size() - 1) {
                    msg.append(COMMA_IDENTIFIER);
                }
                ++i;
            }
            msg.append(BAR_IDENTIFIER);
            System.out.println("TRN Code List *" + msg + "*");
            return msg.toString();
        }
        if (message instanceof ExchangeList) {
            StringBuffer msg = new StringBuffer(AVAILABLE_EXCHANGES_RES_IDENTIFIER);
            msg.append(BAR_IDENTIFIER);
            ArrayList exchanges = ((ExchangeList)message).getExchanges();
            int i = 0;
            while (i < exchanges.size()) {
                String str = (String)exchanges.get(i);
                String code = str.substring(0, str.indexOf(COMMA_IDENTIFIER));
                String name = str.substring(str.indexOf(COMMA_IDENTIFIER) + 1, str.length());
                msg.append(code);
                msg.append(COMMA_IDENTIFIER);
                msg.append(name);
                if (1 != exchanges.size()) {
                    msg.append(SEMICOLON_IDENTIFIER);
                }
                ++i;
            }
            msg.append(BAR_IDENTIFIER);
            return msg.toString();
        }
        if (message instanceof TopSymbols) {
            StringBuffer msg = new StringBuffer(TOP_SYMBOL_RES_IDENTIFIER);
            msg.append(BAR_IDENTIFIER);
            TopSymbolsData[] rows = ((TopSymbols)message).getRows();
            if (rows != null) {
                int i = 0;
                while (i < rows.length) {
                    msg.append(rows[i].getSymbol());
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(rows[i].getTurnOver());
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(rows[i].getLastPrice());
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(rows[i].getChange());
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(rows[i].getIndicator());
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(rows[i].getPerc_change());
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(rows[i].getSymbol_name());
                    if (i != rows.length - 1) {
                        msg.append(SEMICOLON_IDENTIFIER);
                    }
                    ++i;
                }
            }
            msg.append(BAR_IDENTIFIER);
            return msg.toString();
        }
        if (message instanceof TopGainers) {
            StringBuffer msg = new StringBuffer(TOP_GAINERS_RES_IDENTIFIER);
            msg.append(BAR_IDENTIFIER);
            TopGainersData[] rows = ((TopGainers)message).getRows();
            if (rows != null) {
                int i = 0;
                while (i < rows.length) {
                    msg.append(rows[i].getSymbol());
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(rows[i].getLastPrice());
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(rows[i].getABSChange());
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(rows[i].getPercChange());
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(rows[i].getTurnOver());
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(rows[i].getSymbol_name());
                    if (i != rows.length - 1) {
                        msg.append(SEMICOLON_IDENTIFIER);
                    }
                    ++i;
                }
            }
            msg.append(BAR_IDENTIFIER);
            return msg.toString();
        }
        if (message instanceof ChangePasswordResponse) {
            StringBuffer msg = new StringBuffer(CHANGE_PASSWORD_RES_IDENTIFIER);
            ChangePasswordResponse changePassResponse = (ChangePasswordResponse)message;
            msg.append(BAR_IDENTIFIER);
            String remarks = changePassResponse.buildMessage();
            msg.append(remarks);
            msg.append(COMMA_IDENTIFIER);
            if (changePassResponse.getAction() == 0) {
                msg.append(ACCEPT);
            } else {
                msg.append(REJECT);
            }
            msg.append(BAR_IDENTIFIER);
            return msg.toString();
        }
        if (message instanceof MobileImageRequest) {
            StringBuffer msg = new StringBuffer(TEST_IMAGE_RESPONSE_IDENTIFIER);
            msg.append(BAR_IDENTIFIER);
            try {
                msg.append(((MobileImageRequest)message).SendURL());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            msg.append(BAR_IDENTIFIER);
            System.out.println("msg" + msg.toString());
            return msg.toString();
        }
        if (message instanceof LogoutMessage) {
            StringBuffer msg = new StringBuffer(LOGOUT_MESSAGE_IDENTIFIER);
            msg.append(BAR_IDENTIFIER);
            msg.append("CLOSE ALL CONNECTIONS");
            msg.append(BAR_IDENTIFIER);
            return msg.toString();
        }
        if (message instanceof MarketResponse) {
            StringBuffer msg = new StringBuffer(MARKETS_RES_IDENTIFIER);
            msg.append(BAR_IDENTIFIER);
            MarketData[] rows = ((MarketResponse)message).getrows();
            if (rows != null) {
                int i = 0;
                while (i < rows.length) {
                    msg.append(rows[i].getCode());
                    msg.append(COMMA_IDENTIFIER);
                    msg.append(rows[i].getName());
                    if (i != rows.length - 1) {
                        msg.append(SEMICOLON_IDENTIFIER);
                    }
                    ++i;
                }
            }
            msg.append(BAR_IDENTIFIER);
            return msg.toString();
        }
        log.warning(message.toString());
        return "";
    }

    public Object parseToMessage(String message, Logger log) {
        String[] allTokens = Utility.getTokens(message, BAR_IDENTIFIER);
        if (allTokens.length != 2) {
            log.warning("Unable to parse message : " + message);
            return null;
        }
        String[] messageTokens = Utility.getTokens(allTokens[1], COMMA_IDENTIFIER);
        if (allTokens[0].equals(LOGIN_MESSAGE_IDENTIFIER)) {
            return new LoginMessage(messageTokens[0], messageTokens[1], "", -1, true);
        }
        if (allTokens[0].equals(CHANGE_PASSWORD_REQ_IDENTIFIER)) {
            int i = 0;
            while (i < messageTokens.length) {
                System.err.println("messageTokens" + messageTokens[i]);
                ++i;
            }
            return new ChangePasswordRequest(messageTokens[0], messageTokens[1], messageTokens[2]);
        }
        if (allTokens[0].equals(ORDER_MESSAGE_IDENTIFIER)) {
            float oldPrice;
            int action;
            int orderSide = messageTokens[3].equals(BUY_TAG) ? 0 : 1;
            if (messageTokens[5].equals(NEW_TAG)) {
                action = 0;
                oldPrice = 0.0f;
            } else {
                action = 2;
                oldPrice = Utility.parseFloat(messageTokens[1], 0.0f);
            }
            OrderMessage ordermessage = new OrderMessage(this.userId, action, 0, MARKET_REGULAR, messageTokens[0], this.member, this.trader, Utility.parseFloat(messageTokens[1], 0.0f), oldPrice, 0.0f, new Date(), this.client, Utility.parseInt(messageTokens[4], 0), this.client, Utility.parseInt(messageTokens[4], 0), 0, 4, Utility.parseInt(messageTokens[2], 0), Utility.parseInt(messageTokens[6], 0), 0, orderSide);
            ordermessage.setStExCode(messageTokens[7]);
            if (action != 2) {
                ordermessage.setMarket(messageTokens[8]);
            }
            System.out.println("Order for Exchange " + messageTokens[7] + "In market " + ordermessage.getMarket());
            return ordermessage;
        }
        if (allTokens[0].equals(SUBSCRIPTION_REQUEST_IDENTIFIER)) {
            return new SubscriptionRequest(messageTokens[1], messageTokens[0], messageTokens[2]);
        }
        if (allTokens[0].equals(QUOTE_REQUEST_IDENTIFIER)) {
            return new QuoteRequest(messageTokens[0], messageTokens[1]);
        }
        if (allTokens[0].equals(NEWS_REQUEST_IDENTIFIER)) {
            return new NewsRequest(messageTokens[0], messageTokens[1]);
        }
        if (allTokens[0].equals(GRAPH_REQUEST_IDENTIFIER)) {
            return new MobileGraphRequest(messageTokens[0], Utility.parseInt(messageTokens[1], 0), Utility.parseInt(messageTokens[2], 0));
        }
        if (allTokens[0].equals(SYMBOL_GRAPH_REQUEST_IDENTIFIER)) {
            return new MobileSymbolGraphRequest(messageTokens[0], messageTokens[1], Utility.parseInt(messageTokens[2], 3));
        }
        if (allTokens[0].equals(MARGIN_REQUEST_IDENTIFIER)) {
            return new MarginRequest(1, this.client, 1);
        }
        if (allTokens[0].equals(CUSTODY_REQUEST_IDENTIFIER)) {
            this.custody = true;
            return new CustodyRequest(this.client);
        }
        if (allTokens[0].equals(PORTFOLIO_REQUEST_IDENTIFIER)) {
            return new MobilePortfolioRequest(this.client);
        }
        if (allTokens[0].equals(SUBSCRIPTION_LIST_REQUEST_IDENTIFIER)) {
            messageTokens = Utility.getTokens(message, BAR_IDENTIFIER);
            int i = 0;
            while (i < messageTokens.length) {
                this.ExchangeCodes = messageTokens[i].replaceAll(SUBSCRIPTION_LIST_REQUEST_IDENTIFIER, "");
                System.out.println("MessageTokens : " + messageTokens[i]);
                ++i;
            }
            System.out.println("=-=-=-==-=-=--=-=-=-Exchange Code " + this.ExchangeCodes + " -=-=-=-=-=-=-=-=-=-=-=-=- ");
            return new SubscriptionListRequest(this.client, this.ExchangeCodes);
        }
        if (allTokens[0].equals(ORDER_STATUS_REQUEST_IDENTIFIER)) {
            messageTokens = Utility.getTokens(message, BAR_IDENTIFIER);
            int i = 0;
            while (i < messageTokens.length) {
                this.ExchangeCodes = messageTokens[i].replaceAll(ORDER_STATUS_REQUEST_IDENTIFIER, "");
                System.out.println("MessageTokens : " + messageTokens[i]);
                ++i;
            }
            System.out.println("=-=-=-==-=-=--=-=-=-Exchange Codes for Order status " + this.ExchangeCodes + " -=-=-=-=-=-=-=-=-=-=-=-=- ");
            return new OrderStatusRequest(this.ExchangeCodes);
        }
        if (allTokens[0].equals(DELIVERY_REQUEST_IDENTIFIER)) {
            return new COTPositionRequest(Utility.parseInt(messageTokens[0], 0), this.client);
        }
        if (allTokens[0].equals(DELIVERY_RESPONSE_IDENTIFIER)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
            String[] allRows = Utility.getTokens(allTokens[1], SEMICOLON_IDENTIFIER);
            COTData[] cotDataRows = new COTData[allRows.length];
            int i = 0;
            while (i < allRows.length) {
                String[] singleRow = Utility.getTokens(allRows[i], COMMA_IDENTIFIER);
                try {
                    cotDataRows[i] = new COTData(singleRow[0], this.client, dateFormat.parse(singleRow[3]), Utility.parseInt(singleRow[1], 0), Utility.parseInt(singleRow[2], 0));
                }
                catch (Exception e) {
                    log.warning("Exception in date formating...........");
                    e.printStackTrace();
                }
                ++i;
            }
            return new COTPositionResponse(cotDataRows);
        }
        if (allTokens[0].equals(LOGOUT_MESSAGE_IDENTIFIER)) {
            log.info("Log out message received ..................");
            return new LogoutMessage();
        }
        if (allTokens[0].equals(TRN_REQUEST_IDENTIFIER)) {
            log.info("TRN Code request received ..................");
            return new TRNCodeList();
        }
        if (allTokens[0].equals(AVAILABLE_EXCHANGES_REQ_IDENTIFIER)) {
            log.info("Exchange List request received ..................");
            return new ExchangeList();
        }
        if (allTokens[0].equals(TOP_SYMBOL_REQ_IDENTIFIER)) {
            return new TopSymbols(0, messageTokens[0]);
        }
        if (allTokens[0].equals(TOP_GAINERS_REQ_IDENTIFIER)) {
            return new TopGainers(0, messageTokens[0]);
        }
        if (allTokens[0].equals(TEST_IMAGE_REQUEST_IDENTIFIER)) {
            int i = 0;
            while (i < messageTokens.length) {
                System.err.println("messageTokens For Image : " + messageTokens[i]);
                ++i;
            }
            return new MobileImageRequest(Utility.parseInt(messageTokens[0], 0), Utility.parseInt(messageTokens[1], 0));
        }
        if (allTokens[0].equals(MARKETS_REQ_IDENTIFIER)) {
            return new MarketRequest();
        }
        log.warning("Invalid Identifier ........." + message);
        return null;
    }

    public Date getCurrentTime() {
        Date currentTime = new Date(System.currentTimeMillis());
        return currentTime;
    }
}

