/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.parser;

import pk.com.softech.messages.ExchangeData;
import pk.com.softech.messages.FeedData;
import pk.com.softech.messages.MarketData;
import pk.com.softech.messages.SymbolFeedData;
import pk.com.softech.parser.FeedParser;
import pk.com.softech.util.Utility;

public class LSEFeedParser
extends FeedParser {
    protected String TRADE_MSG = "LLT";
    protected String MARKET_MSG = "LLM";
    protected String REG_MKT = "REG";
    protected String COT_MKT = "CO";
    protected String COMMA = ",";
    protected int COUNT_BEFORE_EXCHANGE_MSG = 15;
    protected int LSE_IDX_IDENTIFIER = 0;
    protected int LSE_IDX_TIMESTAMP = 1;
    protected int LSE_IDX_SYMBOL = 2;
    protected int LSE_IDX_LAST_TRADE_PRICE = 3;
    protected int LSE_IDX_LAST_TRADE_VOLUME = 4;
    protected int LSE_IDX_MARKET = 5;
    protected int LSE_IDX_BUY_PRICE = 6;
    protected int LSE_IDX_SELL_PRICE = 7;
    protected int LSE_IDX_BUY_VOLUME = 8;
    protected int LSE_IDX_SELL_VOLUME = 9;
    protected int LSE_IDX_OPEN_PRICE = 10;
    protected int LSE_IDX_TURNOVER_IN_SYMBOL = 11;
    protected int LSE_IDX_HIGH_PRICE = 12;
    protected int LSE_IDX_LOW_PRICE = 13;
    protected int LSE_IDX_AVERAGE_PRICE = 14;
    protected int LSE_IDX_TOTAL_TRADES_IN_SYMBOL = 15;
    protected int LSE_IDX_CHANGE_IN_PRICE = 16;
    protected int LSE_IDX_CURRENT_INDEX = 17;
    protected int LSE_IDX_HIGH_INDEX = 18;
    protected int LSE_IDX_LOW_INDEX = 19;
    protected int LSE_IDX_LAST_INDEX = 20;
    protected int LSE_IDX_TOTAL_TRADES_IN_EXCHANGE = 21;
    protected int LSE_IDX_TURNOVER_IN_EXCHANGE = 22;
    protected int LSE_IDX_MONITORY_VOLUME = 23;
    protected int LSE_IDX_UP = 24;
    protected int LSE_IDX_DOWN = 25;
    protected int LSE_IDX_EQUAL = 26;
    protected int msgCount;

    protected String getTradeIdentifier() {
        return this.TRADE_MSG;
    }

    protected String getMarketIdentifier() {
        return this.MARKET_MSG;
    }

    @Override
    public FeedData[] parseAllFeed(String data) {
        FeedData[] feedDataArray = new FeedData[]{this.parseFeed(data)};
        return feedDataArray;
    }

    @Override
    public FeedData parseFeed(String data) {
        String market = null;
        SymbolFeedData symbolData = null;
        ExchangeData exchangeData = null;
        try {
            String[] dataArray;
            if (data != null && !data.equals("") && (dataArray = Utility.getTokens(data, this.COMMA)).length == 27) {
                int messageType;
                ++this.msgCount;
                if (dataArray[this.LSE_IDX_IDENTIFIER].equals(this.getTradeIdentifier())) {
                    messageType = 2;
                } else if (dataArray[this.LSE_IDX_IDENTIFIER].equals(this.getMarketIdentifier())) {
                    messageType = 1;
                } else {
                    return new FeedData(exchangeData, symbolData);
                }
                if (dataArray[this.LSE_IDX_MARKET].equals(this.REG_MKT)) {
                    market = MarketData.getName(MarketData.REGULAR);
                } else if (dataArray[this.LSE_IDX_MARKET].equals(this.COT_MKT)) {
                    market = MarketData.getName(MarketData.COT);
                } else {
                    return new FeedData(exchangeData, symbolData);
                }
                symbolData = new SymbolFeedData(messageType, "PK", "LSE", this.dateFormat.parse(dataArray[this.LSE_IDX_TIMESTAMP]), market, dataArray[this.LSE_IDX_SYMBOL], Utility.parseFloat(dataArray[this.LSE_IDX_BUY_PRICE], 0.0f), Utility.parseInt(dataArray[this.LSE_IDX_BUY_VOLUME], 0), Utility.parseFloat(dataArray[this.LSE_IDX_SELL_PRICE], 0.0f), Utility.parseInt(dataArray[this.LSE_IDX_SELL_VOLUME], 0), Utility.parseFloat(dataArray[this.LSE_IDX_LAST_TRADE_PRICE], 0.0f), Utility.parseInt(dataArray[this.LSE_IDX_LAST_TRADE_VOLUME], 0), Utility.parseInt(dataArray[this.LSE_IDX_TURNOVER_IN_SYMBOL], 0), Utility.parseFloat(dataArray[this.LSE_IDX_OPEN_PRICE], 0.0f), Utility.parseFloat(dataArray[this.LSE_IDX_HIGH_PRICE], 0.0f), Utility.parseFloat(dataArray[this.LSE_IDX_LOW_PRICE], 0.0f), Utility.parseFloat(dataArray[this.LSE_IDX_AVERAGE_PRICE], 0.0f), Utility.parseFloat(dataArray[this.LSE_IDX_CHANGE_IN_PRICE], 0.0f));
                if (this.msgCount >= this.COUNT_BEFORE_EXCHANGE_MSG && Utility.parseFloat(dataArray[this.LSE_IDX_CURRENT_INDEX], 0.0f) > 0.0f) {
                    this.msgCount = 0;
                    float currIndex = Utility.parseFloat(dataArray[this.LSE_IDX_CURRENT_INDEX], 0.0f);
                    float lastIndex = Utility.parseFloat(dataArray[this.LSE_IDX_LAST_INDEX], 0.0f);
                    exchangeData = new ExchangeData("PK", "LSE", this.dateFormat.parse(dataArray[this.LSE_IDX_TIMESTAMP]), currIndex, Utility.parseFloat(dataArray[this.LSE_IDX_HIGH_INDEX], 0.0f), Utility.parseFloat(dataArray[this.LSE_IDX_LOW_INDEX], 0.0f), lastIndex, Utility.parseLong(dataArray[this.LSE_IDX_TOTAL_TRADES_IN_EXCHANGE], 0), Utility.parseLong(dataArray[this.LSE_IDX_TURNOVER_IN_EXCHANGE], 0), Utility.parseLong(dataArray[this.LSE_IDX_MONITORY_VOLUME], 0), Utility.parseLong(dataArray[this.LSE_IDX_UP], 0), Utility.parseLong(dataArray[this.LSE_IDX_DOWN], 0), Utility.parseLong(dataArray[this.LSE_IDX_EQUAL], 0), currIndex - lastIndex);
                }
            }
        }
        catch (Exception e) {
            this.log.warning(e.getMessage());
        }
        return new FeedData(exchangeData, symbolData);
    }
}

