/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.parser;

import java.util.Date;
import pk.com.softech.messages.ExchangeData;
import pk.com.softech.messages.FeedData;
import pk.com.softech.messages.MBO;
import pk.com.softech.messages.MBP;
import pk.com.softech.messages.MarketData;
import pk.com.softech.messages.SymbolFeedData;
import pk.com.softech.parser.FeedParser;
import pk.com.softech.util.Utility;

public class KSEGWFeedParser
extends FeedParser {
    private static final String REGULAR_MARKET_CODE = "REG";
    private static final String FUTURE_MARKET_CODE = "FUT";
    private static final String PROVISIONAL_MARKET_CODE = "IPO";
    private static final String CASH_FUTURE_MARKET_CODE = "CSF";
    private static final String STOCK_INDEX_FUTURE_MARKET_CODE = "SIF";
    private static final String ODD_LOT_MARKET_CODE = "ODL";
    private static final int RECORD_IDENTIFIER_INDEX = 0;
    private static final int MARKET_FEED_SYMBOL_CODE_INDEX = 0;
    private static final int MARKET_FEED_MARKET_CODE_INDEX = 1;
    private static final int MARKET_FEED_SYMBOL_STATE_INDEX = 2;
    private static final int MARKET_FEED_SYMBOL_FLAG_INDEX = 3;
    private static final int MARKET_FEED_BID_VOLUME_INDEX = 4;
    private static final int MARKET_FEED_BID_PRICE_INDEX = 5;
    private static final int MARKET_FEED_ASK_PRICE_INDEX = 6;
    private static final int MARKET_FEED_ASK_VOLUME_INDEX = 7;
    private static final int MARKET_FEED_LAST_TRADE_PRICE_INDEX = 8;
    private static final int MARKET_FEED_LAST_TRADE_VOLUME_INDEX = 9;
    private static final int MARKET_FEED_LAST_TRADE_TIME_INDEX = 10;
    private static final int MARKET_FEED_LAST_DAY_CLOSE_PRICE_INDEX = 11;
    private static final int MARKET_FEED_SYMBOL_DIRECTION_INDEX = 12;
    private static final int MARKET_FEED_AVERAGE_PRICE_INDEX = 13;
    private static final int MARKET_FEED_HIGH_PRICE_INDEX = 14;
    private static final int MARKET_FEED_LOW_PRICE_INDEX = 15;
    private static final int MARKET_FEED_NET_CHANGE_INDEX = 16;
    private static final int MARKET_FEED_TOTAL_TRADED_VOLUME_INDEX = 17;
    private static final int MARKET_FEED_TOTAL_TRADES_INDEX = 18;
    private static final int MARKET_FEED_OPEN_PRICE_INDEX = 19;
    private static final int EXCHG_STATS_SYMBOLS_ADVANCE_INDEX = 0;
    private static final int EXCHG_STATS_SYMBOLS_DECLINE_INDEX = 1;
    private static final int EXCHG_STATS_SYMBOLS_UNCHANGED_INDEX = 2;
    private static final int EXCHG_STATS_TOTAL_SYMBOLS_INDEX = 3;
    private static final int EXCHG_STATS_INDEX_CODE_INDEX = 0;
    private static final int EXCHG_STATS_CURRENT_INDEX_INDEX = 1;
    private static final int EXCHG_STATS_VOLUME_TRADED_INDEX = 2;
    private static final int EXCHG_STATS_VALUE_TRADED_INDEX = 3;
    private static final int EXCHG_STATS_HIGHT_INDEX_INDEX = 4;
    private static final int EXCHG_STATS_LOW_INDEX_INDEX = 5;
    private static final int EXCHG_STATS_NET_CHANGE_INDEX = 6;
    private static final int SYMBOL_CLOSE_PRICE_SYMBOL_INDEX = 0;
    private static final int SYMBOL_CLOSE_PRICE_MARKET_INDEX = 1;
    private static final int SYMBOL_CLOSE_PRICE_CLOSE_PRICE_INDEX = 2;
    private static final String MARKET_FEED = "FEED";
    private static final String EXCHG_STATS = "EXG-STAT";
    private static final String SYMBOL_CLOSE_PRICE = "CLP";
    private static final String DEFAULT_ZERO = "0";
    private static final String SEMI_COLON_DELIMITER = ";";
    private static final String DOLLAR_DELIMITER = "$";
    private static final int MBO_HEADER_INDEX = 0;
    private static final String MARKET_BY_ORDER = "MBO";
    private static final int MBP_HEADER_INDEX = 0;
    private static final String MARKET_BY_PRICE = "MBP";
    public static final String DATE_FORMAT = "yyyyMMddHHmmss";

    @Override
    public FeedData parseFeed(String message) {
        return null;
    }

    @Override
    public FeedData[] parseAllFeed(String sData) {
        SymbolFeedData symbolData = null;
        ExchangeData exchangeData = null;
        MBO mbo = null;
        MBP mbp = null;
        String[] messageTokens = Utility.getTokens(sData = sData.trim().substring(0, sData.indexOf("|*")), "|");
        if (messageTokens[0].equals(MARKET_FEED)) {
            KSEGWFeedParser.getTimeStamp();
            String symbol_Code = "";
            String spot = "";
            String dir = "";
            String rate = DEFAULT_ZERO;
            String quantity = DEFAULT_ZERO;
            String market = null;
            String bid_Price = DEFAULT_ZERO;
            String offer_Price = DEFAULT_ZERO;
            String buy_Volume = DEFAULT_ZERO;
            String sell_Volume = DEFAULT_ZERO;
            String prevDayClosing = DEFAULT_ZERO;
            String tradeTimeStamp = null;
            String turnOver = DEFAULT_ZERO;
            String high = DEFAULT_ZERO;
            String low = DEFAULT_ZERO;
            String average = DEFAULT_ZERO;
            String trades = DEFAULT_ZERO;
            String change = DEFAULT_ZERO;
            String open = DEFAULT_ZERO;
            String[] innerMessageTokens = Utility.getTokens(messageTokens[1], SEMI_COLON_DELIMITER);
            symbol_Code = innerMessageTokens[0];
            rate = innerMessageTokens[8];
            quantity = innerMessageTokens[9];
            spot = innerMessageTokens[3];
            if (innerMessageTokens[1].equals(REGULAR_MARKET_CODE) || innerMessageTokens[1].equals(CASH_FUTURE_MARKET_CODE) || innerMessageTokens[1].equals(STOCK_INDEX_FUTURE_MARKET_CODE)) {
                market = MarketData.getName(MarketData.REGULAR);
            } else if (innerMessageTokens[1].equals(ODD_LOT_MARKET_CODE)) {
                market = MarketData.getName(MarketData.ODL);
            } else if (innerMessageTokens[1].equals(FUTURE_MARKET_CODE)) {
                market = MarketData.getName(MarketData.FUTURE);
            } else if (innerMessageTokens[1].equals(PROVISIONAL_MARKET_CODE)) {
                market = MarketData.getName(MarketData.PRV);
            }
            bid_Price = innerMessageTokens[5];
            offer_Price = innerMessageTokens[6];
            if (!innerMessageTokens[4].equals("")) {
                buy_Volume = innerMessageTokens[4];
            }
            if (!innerMessageTokens[7].equals("")) {
                sell_Volume = innerMessageTokens[7];
            }
            if (innerMessageTokens.length == 19 || innerMessageTokens.length > 19) {
                tradeTimeStamp = innerMessageTokens[10];
                prevDayClosing = innerMessageTokens[11];
                dir = innerMessageTokens[12];
                turnOver = innerMessageTokens[17];
                high = innerMessageTokens[14];
                low = innerMessageTokens[15];
                average = innerMessageTokens[13];
                change = innerMessageTokens[16];
                trades = innerMessageTokens[18];
                if (innerMessageTokens.length > 19) {
                    open = innerMessageTokens[19];
                }
            } else if (innerMessageTokens.length == 18) {
                tradeTimeStamp = innerMessageTokens[9];
                prevDayClosing = innerMessageTokens[10];
                dir = innerMessageTokens[11];
                turnOver = innerMessageTokens[16];
                high = innerMessageTokens[13];
                low = innerMessageTokens[14];
                average = innerMessageTokens[12];
                change = innerMessageTokens[15];
                trades = innerMessageTokens[17];
            } else {
                throw new RuntimeException("Too few tokens");
            }
            if (market != null) {
                symbolData = new SymbolFeedData(2, "PK", "KSE", new Date(), market, symbol_Code, Utility.parseFloat(bid_Price, 0.0f), Utility.parseInt(buy_Volume, 0), Utility.parseFloat(offer_Price, 0.0f), Utility.parseInt(sell_Volume, 0), Utility.parseFloat(rate, 0.0f), Utility.parseInt(quantity, 0), Utility.parseInt(turnOver, 0), Utility.parseFloat(prevDayClosing, 0.0f), Utility.parseFloat(high, 0.0f), Utility.parseFloat(low, 0.0f), Utility.parseFloat(average, 0.0f), Utility.parseFloat(change, 0.0f), spot, null, null, this.generateLastTradeTimeStamp(tradeTimeStamp), Utility.parseInt(trades, 0), Utility.parseFloat(open, 0.0f));
                if (dir != "") {
                    symbolData.setDir(dir);
                }
            }
            FeedData[] feedDataArray = new FeedData[]{new FeedData(exchangeData, symbolData, mbo, mbp)};
            return feedDataArray;
        }
        if (messageTokens[0].equals(EXCHG_STATS)) {
            ExchangeData[] exchangeDataArray = this.parseExchangeFeedMessage(messageTokens[1]);
            FeedData[] feedDataArray = new FeedData[exchangeDataArray.length];
            int i = 0;
            while (i < feedDataArray.length) {
                feedDataArray[i] = new FeedData(exchangeDataArray[i], symbolData, mbo, mbp);
                ++i;
            }
            return feedDataArray;
        }
        if (messageTokens[0].equals(SYMBOL_CLOSE_PRICE)) {
            String symbol_Code = "";
            String rate = DEFAULT_ZERO;
            String market = null;
            String[] innerMessageTokens = Utility.getTokens(messageTokens[1], SEMI_COLON_DELIMITER);
            symbol_Code = innerMessageTokens[0];
            rate = innerMessageTokens[2];
            if (innerMessageTokens[1].equals(REGULAR_MARKET_CODE)) {
                market = MarketData.getName(MarketData.REGULAR);
            } else if (innerMessageTokens[1].equals(ODD_LOT_MARKET_CODE)) {
                market = MarketData.getName(MarketData.ODL);
            } else if (innerMessageTokens[1].equals(FUTURE_MARKET_CODE)) {
                market = MarketData.getName(MarketData.FUTURE);
            } else if (innerMessageTokens[1].equals(PROVISIONAL_MARKET_CODE)) {
                market = MarketData.getName(MarketData.PRV);
            } else if (innerMessageTokens[1].equals(CASH_FUTURE_MARKET_CODE)) {
                market = MarketData.getName(MarketData.CSF);
            } else if (innerMessageTokens[1].equals(STOCK_INDEX_FUTURE_MARKET_CODE)) {
                market = MarketData.getName(MarketData.PRV);
            }
            if (market != null) {
                symbolData = new SymbolFeedData(2, "PK", "KSE", new Date(), market, symbol_Code, -1.0f, -1, -1.0f, -1, Utility.parseFloat(rate, 0.0f), 0L, 0L, 0.0f, 0.0f, 0.0f, 0.0f, -99999.0f);
            }
            FeedData[] feedDataArray = new FeedData[]{new FeedData(exchangeData, symbolData, mbo, mbp)};
            return feedDataArray;
        }
        if (messageTokens[0].equals(MARKET_BY_ORDER)) {
            mbo = new MBO("KSE", sData);
            FeedData[] feedDataArray = new FeedData[]{new FeedData(exchangeData, symbolData, mbo, mbp)};
            return feedDataArray;
        }
        if (messageTokens[0].equals(MARKET_BY_PRICE)) {
            mbp = new MBP("KSE", sData);
            FeedData[] feedDataArray = new FeedData[]{new FeedData(exchangeData, symbolData, mbo, mbp)};
            return feedDataArray;
        }
        return null;
    }

    public ExchangeData[] parseExchangeFeedMessage(String message) {
        String[][] TradableIndexTokens = null;
        String[] innerMessageTokens = Utility.getTokens(message, DOLLAR_DELIMITER);
        ExchangeData[] exchangeDataArray = new ExchangeData[innerMessageTokens.length];
        String[] innerMessage1Tokens = Utility.getTokens(innerMessageTokens[0], SEMI_COLON_DELIMITER);
        String[] ALLSHRTokens = Utility.getTokens(innerMessageTokens[1], SEMI_COLON_DELIMITER);
        TradableIndexTokens = new String[innerMessageTokens.length][];
        int i = 2;
        while (i < innerMessageTokens.length) {
            TradableIndexTokens[i] = Utility.getTokens(innerMessageTokens[i], SEMI_COLON_DELIMITER);
            ++i;
        }
        String[] KSE100Tokens = new String[7];
        String[] commonStats = new String[4];
        System.arraycopy(innerMessage1Tokens, 0, commonStats, 0, 4);
        System.arraycopy(innerMessage1Tokens, 4, KSE100Tokens, 0, 7);
        exchangeDataArray[0] = this.getExchangeData(KSE100Tokens, commonStats);
        exchangeDataArray[1] = this.getExchangeData(ALLSHRTokens, commonStats);
        int i2 = 2;
        while (i2 < innerMessageTokens.length) {
            exchangeDataArray[i2] = this.getExchangeData(TradableIndexTokens[i2], commonStats);
            ++i2;
        }
        return exchangeDataArray;
    }

    public ExchangeData getExchangeData(String[] exchangeMessage, String[] commonStats) {
        ExchangeData exchangeData = null;
        KSEGWFeedParser.getTimeStamp();
        String current_Index = DEFAULT_ZERO;
        String high_Index = DEFAULT_ZERO;
        String low_Index = DEFAULT_ZERO;
        String last_Index = DEFAULT_ZERO;
        String total_Trades = DEFAULT_ZERO;
        String total_Turnover = DEFAULT_ZERO;
        String monitory_Volume = DEFAULT_ZERO;
        String up = DEFAULT_ZERO;
        String down = DEFAULT_ZERO;
        String equal = DEFAULT_ZERO;
        String net_Change = DEFAULT_ZERO;
        up = commonStats[0];
        down = commonStats[1];
        equal = commonStats[2];
        current_Index = exchangeMessage[1];
        net_Change = exchangeMessage[6];
        high_Index = exchangeMessage[4];
        low_Index = exchangeMessage[5];
        total_Turnover = exchangeMessage[2];
        monitory_Volume = exchangeMessage[3];
        try {
            last_Index = "" + (Utility.parseDouble(current_Index, 0.0) - Utility.parseDouble(net_Change, 0.0));
        }
        catch (NumberFormatException e) {
            this.log.warning(Utility.captureStackTrace(e));
            last_Index = DEFAULT_ZERO;
        }
        float curIndex = Utility.parseFloat(current_Index, 0.0f);
        float lastIndex = Utility.parseFloat(last_Index, 0.0f);
        exchangeData = new ExchangeData("PK", "KSE", new Date(), curIndex, Utility.parseFloat(high_Index, 0.0f), Utility.parseFloat(low_Index, 0.0f), lastIndex, Utility.parseLong(total_Trades, 0), Utility.parseLong(total_Turnover, 0), (long)Utility.parseFloat(monitory_Volume, 0.0f), Utility.parseLong(up, 0), Utility.parseLong(down, 0), Utility.parseLong(equal, 0), curIndex - lastIndex);
        exchangeData.setSymbol(exchangeMessage[0].trim().toUpperCase());
        return exchangeData;
    }

    public static void main(String[] arg) {
    }
}

