/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.parser;

import java.util.Date;
import pk.com.softech.messages.ExchangeData;
import pk.com.softech.messages.FeedData;
import pk.com.softech.messages.MarketData;
import pk.com.softech.messages.SymbolFeedData;
import pk.com.softech.parser.FeedParser;
import pk.com.softech.util.Utility;

public class KSEFileFeedParser
extends FeedParser {
    @Override
    public FeedData parseFeed(String sData) {
        SymbolFeedData symbolData = null;
        ExchangeData exchangeData = null;
        try {
            if (sData.compareTo("") != 0) {
                StringBuffer sbData = new StringBuffer(sData);
                sbData.deleteCharAt(sbData.length() - 1);
                String[] msgArray = Utility.getTokens(sbData.toString(), "|");
                if (msgArray.length > 1) {
                    String sIdentifier = msgArray[0];
                    KSEFileFeedParser.getTimeStamp();
                    if (sIdentifier.compareTo("K") == 0 || sIdentifier.compareTo("F") == 0) {
                        String symbol = msgArray[2].trim();
                        float tradeRate = Float.parseFloat(this.getNumberValue(msgArray[7]));
                        int tradeVol = Integer.parseInt(msgArray[8]);
                        float open = Float.parseFloat(this.getNumberValue(msgArray[5]));
                        int turnover = Integer.parseInt(KSEFileFeedParser.trimLong(msgArray[6]));
                        float change = tradeRate - open;
                        symbolData = new SymbolFeedData(2, "PK", "KSE", new Date(), MarketData.getName(MarketData.REGULAR), symbol, 0.0f, 0, 0.0f, 0, tradeRate, tradeVol, turnover, open, 0.0f, 0.0f, 0.0f, change);
                    } else if (sIdentifier.compareTo("B") == 0 || sIdentifier.compareTo("P") == 0) {
                        String symbol = msgArray[1].trim();
                        float buyPrice = Float.parseFloat(KSEFileFeedParser.trimDouble(msgArray[5]));
                        float sellPrice = Float.parseFloat(KSEFileFeedParser.trimDouble(msgArray[6]));
                        int buyVol = Integer.parseInt(KSEFileFeedParser.trimLong(msgArray[4]));
                        int sellVol = Integer.parseInt(KSEFileFeedParser.trimLong(msgArray[7]));
                        symbolData = new SymbolFeedData(1, "PK", "KSE", new Date(), MarketData.getName(MarketData.REGULAR), symbol, buyPrice, buyVol, sellPrice, sellVol, 0.0f, 0L, 0L, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                    } else if (sIdentifier.compareTo("S") == 0) {
                        float curIndex = Float.parseFloat(this.getNumberValue(msgArray[4]));
                        float lastIndex = Float.parseFloat(this.getNumberValue(msgArray[3]));
                        long totalTurnover = Long.parseLong(KSEFileFeedParser.trimLong(msgArray[2]));
                        long up = Long.parseLong(KSEFileFeedParser.trimLong(msgArray[5]));
                        long down = Long.parseLong(KSEFileFeedParser.trimLong(msgArray[6]));
                        long equal = Long.parseLong(KSEFileFeedParser.trimLong(msgArray[7]));
                        exchangeData = new ExchangeData("PK", "KSE", new Date(), curIndex, 0.0f, 0.0f, lastIndex, 0L, totalTurnover, 0L, up, down, equal, (float)(Math.round(curIndex - lastIndex) * 100) / 100.0f);
                    }
                }
            }
        }
        catch (NumberFormatException ex) {
            this.log.info(ex + "-" + sData);
        }
        catch (Exception e) {
            this.log.warning(Utility.captureStackTrace(e));
        }
        return new FeedData(exchangeData, symbolData);
    }

    public String getNumberValue(String sNum) {
        long lNumber = Long.parseLong(sNum);
        double dNumber = lNumber;
        return String.valueOf(dNumber /= 100.0);
    }

    public static String trimLong(String sNumber) throws NumberFormatException {
        long lNumber = Long.parseLong(sNumber);
        return String.valueOf(lNumber);
    }

    public static String trimDouble(String sNumber) throws NumberFormatException {
        double dNumber = Double.parseDouble(sNumber);
        return String.valueOf(dNumber);
    }
}

