/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.parser;

import java.util.Date;
import pk.com.softech.messages.FeedData;
import pk.com.softech.messages.MarketData;
import pk.com.softech.messages.SymbolFeedData;
import pk.com.softech.parser.FeedParser;
import pk.com.softech.util.Utility;

public class KATSFeedParser
extends FeedParser {
    private static final String REGULAR_MARKET_CODE = "510";
    private static final String FUTURE_MARKET_CODE = "FUT";
    private static final String PROVISIONAL_MARKET_CODE = "IPO";
    private static final int MARKET_FEED_INDEX = 8;
    private static final int MARKET_FEED_MARKET_CODE_INDEX = 0;
    private static final int MARKET_FEED_SYMBOL_CODE_INDEX = 1;
    private static final int MARKET_FEED_SYMBOL_STATE_INDEX = 2;
    private static final int MARKET_FEED_SYMBOL_FLAG_INDEX = 3;
    private static final int MARKET_FEED_BID_VOLUME_INDEX = 4;
    private static final int MARKET_FEED_BID_PRICE_INDEX = 5;
    private static final int MARKET_FEED_ASK_PRICE_INDEX = 6;
    private static final int MARKET_FEED_ASK_VOLUME_INDEX = 7;
    private static final int MARKET_FEED_LAST_TRADE_PRICE_INDEX = 8;
    private static final int MARKET_FEED_SYMBOL_DIRECTION_INDEX = 9;
    private static final int MARKET_FEED_TOTAL_TRADED_VOLUME_INDEX = 10;
    private static final int MARKET_FEED_AVERAGE_PRICE_INDEX = 11;
    private static final int MARKET_FEED_HIGH_PRICE_INDEX = 12;
    private static final int MARKET_FEED_LOW_PRICE_INDEX = 13;
    private static final int MARKET_FEED_NET_CHANGE_INDEX = 14;
    private static final int MARKET_FEED_MARKET_CAPITALIZATION_INDEX = 15;
    private static final int MARKET_FEED_YIELD_INDEX = 16;
    private static final int MARKET_FEED_PRICE_BOOK_RATIO_INDEX = 17;
    private static final int MARKET_FEED_PE_RATIO_INDEX = 18;
    private static final int MARKET_FEED_LAST_TRADE_TIME_INDEX = 19;
    private static final int MARKET_FEED_LAST_TRADE_VOLUME_INDEX = 20;
    private static final int MARKET_FEED_TOTAL_TRADES_INDEX = 21;
    private static final int MARKET_FEED_LAST_DAY_CLOSE_PRICE_INDEX = 22;
    private static final String DEFAULT_ZERO = "0";
    private static final String SEMI_COLON_DELIMITER = ";";
    private static final String DOLLAR_DELIMITER = "$";
    private static final String BAR_DELIMITER = "|";

    @Override
    public FeedData parseFeed(String sData) {
        SymbolFeedData symbolData = null;
        sData = sData.trim().substring(0, sData.indexOf("|~"));
        String[] allTokens = Utility.getTokens(sData, BAR_DELIMITER);
        String[] innerMessageTokens = Utility.getTokens(allTokens[8], SEMI_COLON_DELIMITER);
        KATSFeedParser.getTimeStamp();
        String symbol_Code = "";
        String rate = DEFAULT_ZERO;
        String quantity = DEFAULT_ZERO;
        String market = null;
        String bid_Price = DEFAULT_ZERO;
        String offer_Price = DEFAULT_ZERO;
        String buy_Volume = DEFAULT_ZERO;
        String sell_Volume = DEFAULT_ZERO;
        String turnOver = DEFAULT_ZERO;
        String high = DEFAULT_ZERO;
        String low = DEFAULT_ZERO;
        String average = DEFAULT_ZERO;
        String change = DEFAULT_ZERO;
        symbol_Code = innerMessageTokens[1];
        rate = innerMessageTokens[8];
        if (innerMessageTokens[0].equals(REGULAR_MARKET_CODE) || innerMessageTokens[0].equals(FUTURE_MARKET_CODE) || innerMessageTokens[0].equals(PROVISIONAL_MARKET_CODE)) {
            market = MarketData.getName(MarketData.REGULAR);
        }
        bid_Price = innerMessageTokens[5];
        offer_Price = innerMessageTokens[6];
        if (!innerMessageTokens[4].equals("")) {
            buy_Volume = innerMessageTokens[4];
        }
        if (!innerMessageTokens[7].equals("")) {
            sell_Volume = innerMessageTokens[7];
        }
        if (innerMessageTokens.length != 23) {
            throw new RuntimeException("Too few tokens");
        }
        turnOver = innerMessageTokens[10];
        high = innerMessageTokens[12];
        low = innerMessageTokens[13];
        average = innerMessageTokens[11];
        String cfr_ignored_0 = innerMessageTokens[21];
        change = innerMessageTokens[14];
        if (market != null) {
            symbolData = new SymbolFeedData(2, "PK", "KSE", new Date(), market, symbol_Code, Utility.parseFloat(bid_Price, 0.0f), Utility.parseInt(buy_Volume, 0), Utility.parseFloat(offer_Price, 0.0f), Utility.parseInt(sell_Volume, 0), Utility.parseFloat(rate, 0.0f), Utility.parseInt(quantity, 0), Utility.parseInt(turnOver, 0), Utility.parseFloat(rate, 0.0f) - Utility.parseFloat(change, 0.0f), Utility.parseFloat(high, 0.0f), Utility.parseFloat(low, 0.0f), Utility.parseFloat(average, 0.0f), Utility.parseFloat(change, 0.0f));
        }
        return new FeedData(null, symbolData, null, null);
    }
}

