/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.parser;

import java.util.Date;
import pk.com.softech.messages.ExchangeData;
import pk.com.softech.messages.Feed;
import pk.com.softech.messages.FeedData;
import pk.com.softech.messages.MBO;
import pk.com.softech.messages.MBP;
import pk.com.softech.messages.MarketData;
import pk.com.softech.messages.SymbolFeedData;
import pk.com.softech.parser.FeedParser;
import pk.com.softech.util.Utility;

public class GlobexFeedParser
extends FeedParser {
    private static final String REGULAR_MARKET_CODE = "REG";
    private static final String FUTURE_MARKET_CODE = "FUT";
    private static final String PROVISIONAL_MARKET_CODE = "IPO";
    private static final String CASH_FUTURE_MARKET_CODE = "CSF";
    private static final String STOCK_INDEX_FUTURE_MARKET_CODE = "SIF";
    private static final String ODD_LOT_MARKET_CODE = "ODL";
    private static final int RECORD_IDENTIFIER_INDEX = 0;
    private static final int MARKET_FEED_SYMBOL_CODE_INDEX = 1;
    private static final int MARKET_FEED_LAST_TRADE_PRICE_INDEX = 2;
    private static final int MARKET_FEED_LAST_TRADE_VOLUME_INDEX = 3;
    private static final int MARKET_FEED_NET_CHANGE_INDEX = 4;
    private static final int MARKET_FEED_NET_CHANGE_PER_INDEX = 5;
    private static final int MARKET_FEED_HIGH_PRICE_INDEX = 6;
    private static final int MARKET_FEED_LOW_PRICE_INDEX = 7;
    private static final int MARKET_FEED_BID_PRICE_INDEX = 8;
    private static final int MARKET_FEED_ASK_PRICE_INDEX = 9;
    private static final int MARKET_FEED_BID_VOLUME_INDEX = 10;
    private static final int MARKET_FEED_ASK_VOLUME_INDEX = 11;
    private static final int MARKET_FEED_LAST_TRADE_TIME_INDEX = 12;
    private static final int MARKET_FEED_OPEN_PRICE_INDEX = 13;
    private static final int MARKET_FEED_TOTAL_TRADED_VOLUME_INDEX = 14;
    private static final int MARKET_FEED_OPEN_INTREST_INDEX = 15;
    private static final String MARKET_FEED = "FEED";
    private static final String MARKET_FEED2 = "\"FEED";
    private static final String DEFAULT_ZERO = "0";
    private static final String SEMI_COLON_DELIMITER = ";";
    private static final String DOLLAR_DELIMITER = "$";
    public static final String DATE_FORMAT = "yyyyMMddHHmmss";

    @Override
    public FeedData parseFeed(String message) {
        return null;
    }

    @Override
    public FeedData[] parseAllFeed(String sData) {
        SymbolFeedData symbolData = null;
        ExchangeData exchangeData = null;
        MBO mbo = null;
        MBP mbp = null;
        try {
            sData = sData.trim().substring(0, sData.indexOf("|*"));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.out.println("Unparse able Message: " + sData.toString());
            return null;
        }
        String[] innerMessageTokens = Utility.getTokens(sData, "|");
        if (innerMessageTokens[0].equals(MARKET_FEED) || innerMessageTokens[0].equals(MARKET_FEED2)) {
            GlobexFeedParser.getTimeStamp();
            String symbol_Code = "";
            String rate = DEFAULT_ZERO;
            String quantity = DEFAULT_ZERO;
            String market = null;
            String bid_Price = DEFAULT_ZERO;
            String offer_Price = DEFAULT_ZERO;
            String buy_Volume = DEFAULT_ZERO;
            String sell_Volume = DEFAULT_ZERO;
            String open = DEFAULT_ZERO;
            String tradeTimeStamp = null;
            String turnOver = DEFAULT_ZERO;
            String high = DEFAULT_ZERO;
            String low = DEFAULT_ZERO;
            String average = DEFAULT_ZERO;
            String trades = DEFAULT_ZERO;
            String change = DEFAULT_ZERO;
            symbol_Code = innerMessageTokens[1];
            rate = innerMessageTokens[2];
            quantity = innerMessageTokens[3];
            market = MarketData.getName(MarketData.REGULAR);
            bid_Price = innerMessageTokens[8];
            offer_Price = innerMessageTokens[9];
            if (!innerMessageTokens[10].equals("")) {
                buy_Volume = innerMessageTokens[10];
            }
            if (!innerMessageTokens[11].equals("")) {
                sell_Volume = innerMessageTokens[11];
            }
            if (innerMessageTokens.length != 16) {
                throw new RuntimeException("Too few tokens.");
            }
            tradeTimeStamp = innerMessageTokens[12];
            open = innerMessageTokens[13];
            turnOver = innerMessageTokens[14];
            high = innerMessageTokens[6];
            low = innerMessageTokens[7];
            change = innerMessageTokens[4];
            if (market != null) {
                symbolData = new SymbolFeedData(2, "PK", Feed.NCEL, new Date(), market, symbol_Code, Utility.parseFloat(bid_Price, 0.0f), Utility.parseInt(buy_Volume, 0), Utility.parseFloat(offer_Price, 0.0f), Utility.parseInt(sell_Volume, 0), Utility.parseFloat(rate, 0.0f), Utility.parseInt(quantity, 0), Utility.parseInt(turnOver, 0), Utility.parseFloat(open, 0.0f), Utility.parseFloat(high, 0.0f), Utility.parseFloat(low, 0.0f), Utility.parseFloat(average, 0.0f), Utility.parseFloat(change, 0.0f), this.generateLastTradeTimeStamp(tradeTimeStamp), Utility.parseInt(trades, 0));
                FeedData[] feedDataArray = new FeedData[]{new FeedData(exchangeData, symbolData, mbo, mbp)};
                return feedDataArray;
            }
        }
        return null;
    }
}

