/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.parser;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Logger;
import pk.com.softech.messages.FeedData;
import pk.com.softech.parser.Parser;
import pk.com.softech.util.Utility;

public abstract class FeedParser
implements Parser {
    public static final String FEED_TIME_FORMAT = "yyyyMMddHHmmss";
    public static final String COMMA = ",";
    public static final String EMPTY = " ";
    public static final String COLON = ":";
    protected Logger log;
    protected NumberFormat numFormat;
    protected SimpleDateFormat dateFormat;

    @Override
    public boolean init(Logger log) {
        this.dateFormat = new SimpleDateFormat(FEED_TIME_FORMAT);
        this.dateFormat.setLenient(false);
        this.numFormat = NumberFormat.getInstance();
        this.numFormat.setMinimumFractionDigits(2);
        this.log = log;
        return true;
    }

    public static String getTimeStamp() {
        return FeedParser.getTimeStamp(new Date());
    }

    public static String getTimeStamp(Date date) {
        String retValue = "";
        SimpleDateFormat dateFormat = new SimpleDateFormat(FEED_TIME_FORMAT);
        dateFormat.setLenient(false);
        retValue = dateFormat.format(date);
        return retValue;
    }

    public Date generateLastTradeTimeStamp(String tradeTimeStamp) {
        block3: {
            try {
                if (!tradeTimeStamp.equals(EMPTY) && !tradeTimeStamp.equals("")) break block3;
                return null;
            }
            catch (Exception ex) {
                System.out.println("Unable to generate last trade time stamp: '" + tradeTimeStamp + "' " + ex.getMessage());
                return null;
            }
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setLenient(false);
        String[] tokens = tradeTimeStamp.split(COLON);
        calendar.setTime(new Date());
        calendar.set(11, Utility.parseInt(tokens[0], 0));
        calendar.set(12, Utility.parseInt(tokens[1], 0));
        calendar.set(13, Utility.parseInt(tokens[2], 0));
        return calendar.getTime();
    }

    public FeedData[] parseAllFeed(String message) {
        return null;
    }
}

